/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views;

import java.awt.AWTException;
import java.awt.Robot;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

abstract class AbstractComboBoxCellEditor
extends CellEditor {
    public static final int DROP_DOWN_ON_MOUSE_ACTIVATION = 1;
    public static final int DROP_DOWN_ON_KEY_ACTIVATION = 2;
    public static final int DROP_DOWN_ON_PROGRAMMATIC_ACTIVATION = 4;
    public static final int DROP_DOWN_ON_TRAVERSE_ACTIVATION = 8;
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    private static final Robot robot;
    private int activationStyle = 0;

    static {
        Robot r = null;
        if (COCOA) {
            try {
                r = new Robot();
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
        }
        robot = r;
    }

    AbstractComboBoxCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    AbstractComboBoxCellEditor() {
    }

    public void activate(ColumnViewerEditorActivationEvent activationEvent) {
        super.activate(activationEvent);
        if (this.activationStyle != 0) {
            boolean dropDown = false;
            if ((activationEvent.eventType == 2 || activationEvent.eventType == 3) && (this.activationStyle & 1) != 0) {
                dropDown = true;
            } else if (activationEvent.eventType == 1 && (this.activationStyle & 2) != 0) {
                dropDown = true;
            } else if (activationEvent.eventType == 4 && (this.activationStyle & 4) != 0) {
                dropDown = true;
            } else if (activationEvent.eventType == 5 && (this.activationStyle & 8) != 0) {
                dropDown = true;
            }
            if (dropDown) {
                this.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (robot != null) {
                            Control control = AbstractComboBoxCellEditor.this.getControl();
                            Rectangle bounds = control.getBounds();
                            Point origLocation = control.getDisplay().getCursorLocation();
                            Point pt = control.toDisplay(bounds.width - 10, bounds.height / 2);
                            robot.mouseRelease(16);
                            robot.mouseMove(pt.x, pt.y);
                            robot.mousePress(16);
                            robot.mouseRelease(16);
                            robot.mouseMove(origLocation.x, origLocation.y);
                        } else if (!COCOA) {
                            ((Combo)AbstractComboBoxCellEditor.this.getControl()).setListVisible(true);
                        }
                    }
                });
            }
        }
    }

    public void setActivationStyle(int activationStyle) {
        this.activationStyle = activationStyle;
    }
}

