/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.EnumLabels;
import ch.kuramo.javie.app.views.ComboBoxViewerCellEditor;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElementDelegate;
import ch.kuramo.javie.core.AnimatableEnum;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableEnumElementDelegate<E extends Enum<E>>
extends AnimatableValueElementDelegate<E> {
    private final Class<E> enumType;
    private final E[] values;
    private final List<String> labels;
    private ComboBoxViewerCellEditor editor;

    public AnimatableEnumElementDelegate(AnimatableValueElement element, String name, AnimatableEnum<E> avalue) {
        super(element, name, avalue);
        this.enumType = avalue.getEnumType();
        this.values = (Enum[])this.enumType.getEnumConstants();
        this.labels = EnumLabels.getLabels(this.enumType);
    }

    @Override
    protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
        this.drawValue(gc, x, y, height, focused, this.labels.get(((Enum)this.value).ordinal()));
    }

    @Override
    protected boolean canDragGestureEdit() {
        return false;
    }

    @Override
    protected E dragGesture(double dx, double dy) {
        throw new UnsupportedOperationException("drag gesture edit is not supported");
    }

    @Override
    public boolean canEdit(int columnIndex) {
        if (columnIndex == 1) {
            return this.canInlineEdit;
        }
        return false;
    }

    @Override
    public CellEditor getCellEditor(int columnIndex) {
        if (columnIndex == 1) {
            if (this.editor == null) {
                this.editor = new ComboBoxViewerCellEditor((Composite)this.element.viewer.getTree(), 8);
                this.editor.setContenProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                this.editor.setActivationStyle(4);
                ((Combo)this.editor.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AnimatableEnumElementDelegate.this.setCellEditorValue(1, AnimatableEnumElementDelegate.this.editor.getValue());
                    }
                });
            }
            this.editor.setInput(null);
            this.editor.setLabelProvider((IBaseLabelProvider)new EnumLabelProvider());
            this.editor.setInput(this.values);
            return this.editor;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue(int columnIndex) {
        if (columnIndex == 1) {
            return this.value;
        }
        return null;
    }

    @Override
    public void setCellEditorValue(int columnIndex, Object value) {
        if (columnIndex == 1) {
            this.modifyValue((Enum)this.enumType.cast(value));
        }
    }

    private class EnumLabelProvider
    extends LabelProvider {
        private EnumLabelProvider() {
        }

        public String getText(Object element) {
            return (String)AnimatableEnumElementDelegate.this.labels.get(((Enum)AnimatableEnumElementDelegate.this.enumType.cast(element)).ordinal());
        }
    }
}

