/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.views.ComboBoxViewerCellEditor;
import ch.kuramo.javie.app.views.layercomp.AnimatableStringElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.services.Font;
import ch.kuramo.javie.core.services.FontList;
import com.google.inject.Inject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

class TextFontElementDelegate
extends AnimatableStringElementDelegate {
    private ComboBoxViewerCellEditor editor;
    @Inject
    private FontList fontList;

    TextFontElementDelegate(AnimatableValueElement element, String name, AnimatableString avalue) {
        super(element, name, avalue);
        InjectorHolder.getInjector().injectMembers((Object)this);
    }

    protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
        Font font = this.fontList.get((String)this.value);
        this.drawValue(gc, x, y, height, focused, font != null ? font.fullName : "      ");
    }

    public CellEditor getCellEditor(int columnIndex) {
        if (columnIndex == 1) {
            if (this.editor == null) {
                this.editor = new ComboBoxViewerCellEditor((Composite)this.element.viewer.getTree(), 8);
                this.editor.setContenProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                this.editor.setLabelProvider((IBaseLabelProvider)new FontLabelProvider());
                this.editor.setActivationStyle(4);
                Combo combo = (Combo)this.editor.getControl();
                combo.setVisibleItemCount(35);
                combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TextFontElementDelegate.this.setCellEditorValue(1, TextFontElementDelegate.this.editor.getValue());
                    }
                });
            }
            this.editor.setInput(this.fontList.list());
            return this.editor;
        }
        return super.getCellEditor(columnIndex);
    }

    public Object getCellEditorValue(int columnIndex) {
        if (columnIndex == 1) {
            return this.fontList.get((String)this.value);
        }
        return super.getCellEditorValue(columnIndex);
    }

    public void setCellEditorValue(int columnIndex, Object value) {
        if (columnIndex == 1) {
            value = value != null ? ((Font)value).psName : "";
        }
        super.setCellEditorValue(columnIndex, value);
    }

    private static class FontLabelProvider
    extends LabelProvider {
        private FontLabelProvider() {
        }

        public String getText(Object element) {
            return ((Font)element).fullName;
        }
    }
}

