/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.mmd2javie;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableVec3d;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.FrameDuration;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.NullLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.TransformableLayer;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import com.google.inject.Inject;
import java.util.Formatter;
import org.mozilla.javascript.Scriptable;

public class AEScriptObjects {
    private final ProjectElementFactory elementFactory;

    public static AEScriptApp createAppObject(Project project) {
        AEScriptObjects aEScriptObjects = (AEScriptObjects)InjectorHolder.getInjector().getInstance(AEScriptObjects.class);
        aEScriptObjects.getClass();
        return aEScriptObjects.new AEScriptApp(project);
    }

    @Inject
    AEScriptObjects(ProjectElementFactory elementFactory) {
        this.elementFactory = elementFactory;
    }

    public class AEScriptAnimatableDouble {
        private final AnimatableDouble adouble;
        private final LayerComposition layerComp;

        private AEScriptAnimatableDouble(AnimatableDouble adouble, LayerComposition layerComp) {
            this.adouble = adouble;
            this.layerComp = layerComp;
        }

        public void setValue(double value) {
            if (this.adouble.hasKeyframe()) {
                throw new IllegalStateException("has Keyframes");
            }
            this.adouble.clearKeyframes((Object)value);
        }

        public void setValueAtTime(double time, double value) {
            int timeScale = this.layerComp.getFrameDuration().timeScale;
            long timeValue = Math.round(time * (double)timeScale);
            this.adouble.putKeyframe(new Time(timeValue, timeScale), (Object)value, this.adouble.getDefaultInterpolation());
        }
    }

    public class AEScriptAnimatableVec3d {
        private final AnimatableVec3d avec3d;
        private final LayerComposition layerComp;

        private AEScriptAnimatableVec3d(AnimatableVec3d avec3d, LayerComposition layerComp) {
            this.avec3d = avec3d;
            this.layerComp = layerComp;
        }

        public void setValue(double[] value) {
            if (this.avec3d.hasKeyframe()) {
                throw new IllegalStateException("has Keyframes");
            }
            this.avec3d.clearKeyframes((Object)new Vec3d(value[0], value[1], value[2]));
        }

        public void setValueAtTime(double time, double[] value) {
            int timeScale = this.layerComp.getFrameDuration().timeScale;
            long timeValue = Math.round(time * (double)timeScale);
            this.avec3d.putKeyframe(new Time(timeValue, timeScale), (Object)new Vec3d(value[0], value[1], value[2]), this.avec3d.getDefaultInterpolation());
        }

        public void setSpatialAutoBezierAtKey(int keyIndex, boolean spatialAutoBezier) {
        }
    }

    public class AEScriptApp {
        public final AEScriptProject project;

        private AEScriptApp(Project project) {
            this.project = new AEScriptProject(project);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AEScriptCameraLayer
    extends AEScriptLayer<CameraLayer> {
        public final AEScriptAnimatableVec3d anchorPoint;
        public final AEScriptAnimatableVec3d position;
        public final AEScriptAnimatableDouble zoom;
        public final AEScriptAnimatableDouble focusDistance;
        public final AEScriptAnimatableDouble aperture;

        private AEScriptCameraLayer(CameraLayer cameraLayer, LayerComposition layerComp) {
            super(AEScriptObjects.this, (Layer)cameraLayer, layerComp);
            this.anchorPoint = new AEScriptAnimatableVec3d(new AnimatableVec3d(Vec3d.ZERO), layerComp);
            this.position = new AEScriptAnimatableVec3d(cameraLayer.getPosition(), layerComp);
            this.zoom = new AEScriptAnimatableDouble(cameraLayer.getZoom(), layerComp);
            this.focusDistance = new AEScriptAnimatableDouble(new AnimatableDouble(Double.valueOf(0.0)), layerComp);
            this.aperture = new AEScriptAnimatableDouble(new AnimatableDouble(Double.valueOf(0.0)), layerComp);
        }

        @Override
        public Object property(String propertyName) {
            if ("zoom".equals(propertyName)) {
                return this.zoom;
            }
            if ("focusDistance".equals(propertyName)) {
                return this.focusDistance;
            }
            if ("aperture".equals(propertyName)) {
                return this.aperture;
            }
            return super.property(propertyName);
        }
    }

    public class AEScriptComp {
        public final AEScriptLayers layers;

        private AEScriptComp(LayerComposition layerComp) {
            this.layers = new AEScriptLayers(layerComp);
        }
    }

    public class AEScriptItems {
        private final Project project;

        private AEScriptItems(Project project) {
            this.project = project;
        }

        public AEScriptComp addComp(String name, int width, int height, double aspectRatio, double duration, double fps) {
            String fpsStr = new Formatter().format("%.3f", fps).toString();
            Time frameDuration = fpsStr.equals("23.976") ? FrameDuration.FPS_23_976 : (fpsStr.equals("24.000") ? FrameDuration.FPS_24 : (fpsStr.equals("25.000") ? FrameDuration.FPS_25 : (fpsStr.equals("29.970") ? FrameDuration.FPS_29_97 : (fpsStr.equals("30.000") ? FrameDuration.FPS_30 : (fpsStr.equals("50.000") ? FrameDuration.FPS_50 : (fpsStr.equals("59.940") ? FrameDuration.FPS_59_94 : (fpsStr.equals("60.000") ? FrameDuration.FPS_60 : new Time((long)((int)(1.0E7 / fps)), 10000000))))))));
            Time dur = new Time((long)((int)(duration * (double)frameDuration.timeScale)), frameDuration.timeScale);
            LayerComposition layerComp = AEScriptObjects.this.elementFactory.newLayerComposition(ColorMode.RGBA8, new Size2i(width, height), frameDuration, dur);
            CompositionItem item = AEScriptObjects.this.elementFactory.newCompositionItem((Composition)layerComp);
            item.setName(name);
            this.project.getCompositions().add(layerComp);
            this.project.getItems().add(item);
            return new AEScriptComp(layerComp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AEScriptLayer<T extends Layer> {
        protected final T layer;
        protected final LayerComposition layerComp;
        final /* synthetic */ AEScriptObjects this$0;

        protected AEScriptLayer(T layer, LayerComposition layerComp) {
            this.this$0 = var1_1;
            this.layer = layer;
            this.layerComp = layerComp;
        }

        public void setParent(AEScriptLayer<?> parent) {
            this.layerComp.setParentLayer(this.layer, parent.layer);
        }

        public void setName(String name) {
            this.layer.setName(name);
        }

        public Object property(String propertyName) {
            return Scriptable.NOT_FOUND;
        }
    }

    public class AEScriptLayers {
        private final LayerComposition layerComp;

        private AEScriptLayers(LayerComposition layerComp) {
            this.layerComp = layerComp;
        }

        private void initLayerTimes(Layer layer) {
            Time time0 = Time.fromFrameNumber((long)0L, (Time)this.layerComp.getFrameDuration());
            layer.setStartTime(time0);
            layer.setInPoint(time0);
            layer.setOutPoint(this.layerComp.getDuration());
        }

        public AEScriptCameraLayer addCamera(String name, double[] centerPoint) {
            CameraLayer cameraLayer = AEScriptObjects.this.elementFactory.newCameraLayer();
            double w = this.layerComp.getSize().width;
            double fovx = 39.6;
            double zoom = w / (2.0 * Math.tan(Math.toRadians(fovx / 2.0)));
            cameraLayer.getZoom().reset((Object)zoom);
            cameraLayer.getNear().reset((Object)(zoom / 2.0));
            cameraLayer.getFar().reset((Object)(zoom * 10.0));
            cameraLayer.setName(name);
            cameraLayer.getPointOfInterest().clearKeyframes((Object)new Vec3d(centerPoint[0], centerPoint[1], 0.0));
            this.initLayerTimes((Layer)cameraLayer);
            this.layerComp.getLayers().add(cameraLayer);
            return new AEScriptCameraLayer(cameraLayer, this.layerComp);
        }

        public AEScriptNullLayer addNull() {
            NullLayer nullLayer = AEScriptObjects.this.elementFactory.newNullLayer();
            this.initLayerTimes((Layer)nullLayer);
            this.layerComp.getLayers().add(nullLayer);
            return new AEScriptNullLayer(nullLayer, this.layerComp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AEScriptNullLayer
    extends AEScriptTransformableLayer<NullLayer> {
        private AEScriptNullLayer(NullLayer nullLayer, LayerComposition layerComp) {
            super(AEScriptObjects.this, (TransformableLayer)nullLayer, layerComp);
        }
    }

    public class AEScriptProject {
        public final AEScriptItems items;

        private AEScriptProject(Project project) {
            this.items = new AEScriptItems(project);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AEScriptTransformableLayer<T extends TransformableLayer>
    extends AEScriptLayer<T> {
        public final AEScriptAnimatableVec3d anchorPoint;
        public final AEScriptAnimatableVec3d position;
        public final AEScriptAnimatableDouble xRotation;
        public final AEScriptAnimatableDouble yRotation;
        public final AEScriptAnimatableDouble zRotation;
        final /* synthetic */ AEScriptObjects this$0;

        private AEScriptTransformableLayer(T transformableLayer, LayerComposition layerComp) {
            this.this$0 = var1_1;
            super((AEScriptObjects)var1_1, transformableLayer, layerComp);
            this.anchorPoint = var1_1.new AEScriptAnimatableVec3d(transformableLayer.getAnchorPoint(), layerComp);
            this.position = var1_1.new AEScriptAnimatableVec3d(transformableLayer.getPosition(), layerComp);
            this.xRotation = var1_1.new AEScriptAnimatableDouble(transformableLayer.getRotationX(), layerComp);
            this.yRotation = var1_1.new AEScriptAnimatableDouble(transformableLayer.getRotationY(), layerComp);
            this.zRotation = var1_1.new AEScriptAnimatableDouble(transformableLayer.getRotationZ(), layerComp);
        }

        public void setThreeDLayer(boolean threeD) {
            ((TransformableLayer)this.layer).setThreeD(threeD);
        }
    }
}

