/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.core.ArithmeticalAnimatableValue;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.exprelems.ColorProperty;
import java.util.Collection;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableColor
extends ArithmeticalAnimatableValue<Color>
implements IAnimatableColor {
    public AnimatableColor(Color staticValue, Collection<Keyframe<Color>> keyframes, String expression) {
        super(staticValue, keyframes, expression, Color.COLORLESS_TRANSPARENT, Color.WHITE);
    }

    public AnimatableColor(Color defaultValue) {
        super(defaultValue, Color.COLORLESS_TRANSPARENT, Color.WHITE);
    }

    @Override
    public Color clamp(Color value) {
        return value;
    }

    @Override
    public Color jsToJava(Object jsValue) {
        if (jsValue instanceof Wrapper) {
            Object javaObj = ((Wrapper)jsValue).unwrap();
            if (javaObj instanceof ColorProperty) {
                javaObj = ((ColorProperty)javaObj).getValue();
            }
            if (javaObj instanceof Color) {
                return (Color)javaObj;
            }
            if (javaObj instanceof Object[]) {
                Object[] value = (Object[])javaObj;
                double[] array = new double[]{0.0, 0.0, 0.0, 1.0};
                int i = 0;
                int n = Math.min(4, value.length);
                while (i < n) {
                    array[i] = (Double)Context.jsToJava((Object)value[i], Double.TYPE);
                    ++i;
                }
                return this.valueOf(array);
            }
        } else {
            if (jsValue instanceof NativeArray) {
                double[] array = (double[])Context.jsToJava((Object)jsValue, double[].class);
                if (array.length < 4) {
                    double[] tmp = array;
                    array = new double[]{0.0, 0.0, 0.0, 1.0};
                    int i = 0;
                    while (i < tmp.length) {
                        array[i] = tmp[i];
                        ++i;
                    }
                }
                return this.valueOf(array);
            }
            if (jsValue == null) {
                return Color.BLACK;
            }
        }
        double d = (Double)Context.jsToJava((Object)jsValue, Double.TYPE);
        return new Color(d, d, d, 1.0);
    }

    @Override
    protected double[] toArray(Color value) {
        return new double[]{value.rawRed, value.rawGreen, value.rawBlue, value.rawAlpha};
    }

    @Override
    protected Color valueOf(double[] d) {
        return new Color(d[0], d[1], d[2], d[3]);
    }

    public Scriptable createExpressionElement(final CoreContext context) {
        ColorProperty cp = new ColorProperty(){

            public Color getValue() {
                return (Color)AnimatableColor.this.value(context);
            }

            public Color valueAtTime(double t) {
                return (Color)AnimatableColor.this.valueAtTime(t, context);
            }
        };
        return context.toNativeJavaObject(cp, null);
    }
}

