/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.MediaInputPlaceholder;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;

class MediaInputPlaceholderImpl
implements MediaInputPlaceholder {
    private final RenderContext _context;
    private final IVideoRenderSupport _support;
    private VideoBounds videoFrameBounds;

    @Inject
    MediaInputPlaceholderImpl(RenderContext context, IVideoRenderSupport support) {
        this._context = context;
        this._support = support;
    }

    public boolean isAudioAvailable() {
        return false;
    }

    public boolean isVideoAvailable() {
        return true;
    }

    public Time getDuration() {
        return null;
    }

    public Time getVideoFrameDuration() {
        return null;
    }

    public VideoBounds getVideoFrameBounds() {
        return this.videoFrameBounds != null ? this.videoFrameBounds : new VideoBounds(0, 0);
    }

    void setVideoFrameBounds(VideoBounds videoFrameBounds) {
        this.videoFrameBounds = videoFrameBounds;
    }

    public IAudioBuffer getAudioChunk(Time mediaTime) {
        throw new UnsupportedOperationException("audio is not available");
    }

    public IVideoBuffer getVideoFrame(Time mediaTime) {
        Resolution resolution = this._context.getVideoResolution();
        VideoBounds bounds = resolution.scale(this.getVideoFrameBounds());
        IVideoBuffer videoBuffer = this._support.createVideoBuffer(bounds);
        videoBuffer.clear(Color.GRAY);
        return videoBuffer;
    }
}

