/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IShaderSourceFactory;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.ShaderType;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IAccumulationSupport;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IConvolutionSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Camera;
import ch.kuramo.javie.core.CastsShadows;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.Light;
import ch.kuramo.javie.core.LightType;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.MotionBlur;
import ch.kuramo.javie.core.Quality;
import ch.kuramo.javie.core.TrackMatte;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.VideoLayerRenderer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;
import javax.media.opengl.glu.GLU;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoLayerComposer {
    private final RenderContext context;
    private final IVideoRenderSupport support;
    private final IAccumulationSupport accumSupport;
    private final IConvolutionSupport convolution;
    private final IBlurSupport blurSupport;
    private final IArrayPools arrayPools;
    private final IShaderRegistry shaders;
    private final GLGlobal glGlobal;
    private final IShaderProgram normalBlend3DProgram;
    private final IShaderProgram normalBlend2DProgram;
    private final IShaderProgram mblur2Accum2Program;
    private final IShaderProgram matteMultiplyProgram;
    private final IShaderProgram diffusionConvolutionProgram;
    private final IShaderProgram shadowMultiplyProgram;
    private final int maxTexImageUnits;
    private final LayerComposition composition;
    private final Camera camera;
    private final Set<Light> lights;
    private final boolean lightsCastShadows;
    private boolean mblurWithShadows;
    private final int ssScale;
    private final VideoBounds bounds;
    private final VideoBounds boundsX;
    private final Time baseTime;
    private final List<ComposeGroup> groups = Util.newList();
    private ComposeGroup currentGroup;
    private final Map<String, VideoLayerRenderer.MatteLayerRenderers> matteLayerRenderers = Util.newMap();
    private final Map<String, IVideoBuffer> matteBufferCache = Util.newMap();
    private final Map<AnimatableValue<?>, Map<Time, ?>> valueCache = Util.newMap();
    private static final int[][] frustumEdgeTable;
    private static final int[][] frustumClipSearchTable;
    @ShaderSource(type=ShaderType.VERTEX_SHADER, program=false)
    public static final String[] normal_blend_3d_vert;
    @ShaderSource(attach={"normal_blend_3d_vert", "read_texture"})
    public static final String[] NORMAL_BLEND_3D;
    @ShaderSource(type=ShaderType.VERTEX_SHADER, program=false)
    public static final String[] normal_blend_2d_vert;
    @ShaderSource(attach={"normal_blend_2d_vert", "read_texture"})
    public static final String[] NORMAL_BLEND_2D;
    @ShaderSource(type=ShaderType.VERTEX_SHADER, program=false)
    public static final String[] mblur2_accum2_vert;
    @ShaderSource(attach={"mblur2_accum2_vert", "read_texture"})
    public static final String[] MBLUR2_ACCUM2;
    @ShaderSource(attach={"read_texture"})
    public static final String[] MATTE_MULTIPLY;
    @ShaderSource
    public static final String[] DIFFUSION_CONVOLUTION;
    @ShaderSource(type=ShaderType.VERTEX_SHADER, program=false)
    public static final String[] shadow_vert;
    @ShaderSource(type=ShaderType.VERTEX_SHADER, program=false)
    public static final String[] light_vert;
    @ShaderSource
    public static final String[] SHADOW_MULTIPLY;
    private static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$core$MotionBlur;

    static {
        int[][] nArrayArray = new int[12][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 6;
        nArrayArray[2] = nArray3;
        nArrayArray[3] = new int[]{1, 3};
        nArrayArray[4] = new int[]{1, 7};
        nArrayArray[5] = new int[]{2, 3};
        nArrayArray[6] = new int[]{2, 4};
        nArrayArray[7] = new int[]{3, 5};
        nArrayArray[8] = new int[]{4, 5};
        nArrayArray[9] = new int[]{4, 6};
        nArrayArray[10] = new int[]{5, 7};
        nArrayArray[11] = new int[]{6, 7};
        frustumEdgeTable = nArrayArray;
        int[][] nArrayArray2 = new int[12][];
        nArrayArray2[0] = new int[]{1, 3, 5, 2, 4, 11};
        int[] nArray4 = new int[6];
        nArray4[1] = 3;
        nArray4[2] = 5;
        nArray4[3] = 2;
        nArray4[4] = 6;
        nArray4[5] = 9;
        nArrayArray2[1] = nArray4;
        int[] nArray5 = new int[6];
        nArray5[0] = 1;
        nArray5[1] = 6;
        nArray5[2] = 9;
        nArray5[4] = 4;
        nArray5[5] = 11;
        nArrayArray2[2] = nArray5;
        int[] nArray6 = new int[6];
        nArray6[1] = 1;
        nArray6[2] = 5;
        nArray6[3] = 4;
        nArray6[4] = 7;
        nArray6[5] = 10;
        nArrayArray2[3] = nArray6;
        int[] nArray7 = new int[6];
        nArray7[1] = 2;
        nArray7[2] = 11;
        nArray7[3] = 3;
        nArray7[4] = 7;
        nArray7[5] = 10;
        nArrayArray2[4] = nArray7;
        int[] nArray8 = new int[6];
        nArray8[1] = 1;
        nArray8[2] = 3;
        nArray8[3] = 6;
        nArray8[4] = 7;
        nArray8[5] = 8;
        nArrayArray2[5] = nArray8;
        nArrayArray2[6] = new int[]{1, 2, 9, 5, 7, 8};
        nArrayArray2[7] = new int[]{3, 4, 10, 5, 6, 8};
        nArrayArray2[8] = new int[]{5, 6, 7, 9, 10, 11};
        nArrayArray2[9] = new int[]{1, 2, 6, 8, 10, 11};
        nArrayArray2[10] = new int[]{3, 4, 7, 8, 9, 11};
        int[] nArray9 = new int[6];
        nArray9[1] = 2;
        nArray9[2] = 4;
        nArray9[3] = 8;
        nArray9[4] = 9;
        nArray9[5] = 10;
        nArrayArray2[11] = nArray9;
        frustumClipSearchTable = nArrayArray2;
        normal_blend_3d_vert = new String[]{"attribute vec3 attr1;", "attribute vec3 attr2;", "", "varying float opacity;", "varying float source;", "varying float matte;", "", "void main(void)", "{", "\tgl_Position = gl_ProjectionMatrix * vec4(attr1, 1.0);", "\topacity = attr2.x;", "\tsource = attr2.y;", "\tmatte = attr2.z;", "}"};
        NORMAL_BLEND_3D = new String[]{"varying float opacity;", "varying float source;", "varying float matte;", "", "uniform vec4 texOffsetAndSize[gl_MaxTextureImageUnits];", "uniform vec2 dstSize;", "", "vec4 readTexture(int i, vec2 coord);", "", "void main(void) {", "\tint srcIndex = int(source);", "\tvec4 offAndSize = texOffsetAndSize[srcIndex];", "\tvec2 coord = (gl_FragCoord.xy + offAndSize.xy) / offAndSize.zw;", "\tvec4 color = readTexture(srcIndex, coord) * opacity;", "\tif (matte > 0.0) {", "\t\tcolor *= readTexture(int(matte), gl_FragCoord.xy / dstSize).a;", "\t}", "\tgl_FragColor = color;", "}"};
        normal_blend_2d_vert = new String[]{"attribute vec3 attr1;", "attribute vec4 attr2;", "", "varying float opacity;", "varying float source;", "varying float matte;", "", "void main(void)", "{", "\tgl_Position = gl_ProjectionMatrix * vec4(attr1.xy, 0.0, 1.0);", "\tgl_TexCoord[0] = vec4(attr2.xy, 0.0, 0.0);", "\topacity = attr1.z;", "\tsource = attr2.z;", "\tmatte = attr2.w;", "}"};
        NORMAL_BLEND_2D = new String[]{"varying float opacity;", "varying float source;", "varying float matte;", "", "uniform vec2 dstSize;", "", "vec4 readTexture(int i, vec2 coord);", "", "void main(void) {", "\tvec4 color = readTexture(int(source), gl_TexCoord[0].st) * opacity;", "\tif (matte > 0.0) {", "\t\tcolor *= readTexture(int(matte), gl_FragCoord.xy / dstSize).a;", "\t}", "\tgl_FragColor = color;", "}"};
        mblur2_accum2_vert = new String[]{"attribute vec3 attr1;", "attribute vec3 attr2;", "", "varying float weight;", "varying float source;", "", "void main(void)", "{", "\tgl_Position = gl_ProjectionMatrix * vec4(attr1.xy, 0.0, 1.0);", "\tgl_TexCoord[0] = vec4(attr2.xy, 0.0, 0.0);", "\tweight = attr1.z;", "\tsource = attr2.z;", "}"};
        MBLUR2_ACCUM2 = new String[]{"varying float weight;", "varying float source;", "", "vec4 readTexture(int i, vec2 coord);", "", "void main(void) {", "\tgl_FragColor = readTexture(int(source), gl_TexCoord[0].st) * weight;", "}"};
        MATTE_MULTIPLY = new String[]{"uniform float trackMattes[gl_MaxTextureImageUnits];", "uniform int numMattes;", "uniform vec2 size;", "", "const vec3 lumaVec = vec3(0.299, 0.587, 0.114);", "", "vec4 readTexture(int i, vec2 coord);", "", "void main(void) {", "\tvec2 coord = gl_FragCoord.xy / size;", "\tfloat a = 1.0;", "\tfor (int i = 0; i < numMattes; ++i) {", "\t\tvec4 color = readTexture(i, coord);", "", "\t\tfloat t = trackMattes[i];", "\t\tif (t > 4.0) {", "\t\t\ta *= 1.0 - dot(color.rgb, lumaVec);", "\t\t} else if (t > 3.0) {", "\t\t\ta *= dot(color.rgb, lumaVec);", "\t\t} else if (t > 2.0) {", "\t\t\ta *= 1.0 - color.a;", "\t\t} else if (t > 1.0) {", "\t\t\ta *= color.a;", "\t\t} else {", "\t\t\ta *= 0.0;", "\t\t}", "", "\t\tif (a == 0.0) {", "\t\t\tbreak;", "\t\t}", "\t}", "\tgl_FragColor = vec4(a);", "}"};
        DIFFUSION_CONVOLUTION = new String[]{"uniform sampler2D texture;", "uniform int ksize;", "uniform float kernel[69];", "uniform vec2 offset[69];", "uniform float lod;", "", "void main(void)", "{", "\tvec2 texCoord = gl_TexCoord[0].st;", "\tvec4 sum = vec4(0.0);", "\tfor (int i = 0; i < ksize; ++i) {", "\t\tsum += kernel[i] * texture2DLod(texture, texCoord + offset[i], lod);", "\t}", "\tgl_FragColor = sum;", "}"};
        shadow_vert = new String[]{"attribute vec4 attr;", "varying vec4 coord;", "varying float caster;", "", "void main(void)", "{", "\tcoord = vec4(attr.xyz, 1.0);", "\tcaster = attr.w;", "\tgl_Position = gl_ProjectionMatrix * coord;", "}"};
        light_vert = new String[]{"varying vec3 coord;", "", "void main(void)", "{", "\tcoord = gl_Vertex.xyz;", "\tgl_Position = gl_ProjectionMatrix * gl_Vertex;", "\tgl_TexCoord[0] = gl_MultiTexCoord0;", "}"};
        SHADOW_MULTIPLY = new String[]{"uniform sampler2D shadow;", "uniform vec2 shadowSize;", "uniform float shadowDarkness;", "", "void main(void)", "{", "\tgl_FragColor = vec4(1.0)-(vec4(1.0)-texture2D(shadow, gl_FragCoord.xy/shadowSize))*shadowDarkness;", "}"};
    }

    @Inject
    VideoLayerComposer(RenderContext context, IVideoRenderSupport support, IAccumulationSupport accumSupport, IConvolutionSupport convolution, IBlurSupport blurSupport, IArrayPools arrayPools, IShaderRegistry shaders, GLGlobal glGlobal) {
        this.context = context;
        this.support = support;
        this.accumSupport = accumSupport;
        this.convolution = convolution;
        this.blurSupport = blurSupport;
        this.arrayPools = arrayPools;
        this.shaders = shaders;
        this.glGlobal = glGlobal;
        this.maxTexImageUnits = glGlobal.getMaxTextureImageUnits();
        this.createReadTextureFunction();
        this.normalBlend3DProgram = shaders.getProgram(VideoLayerComposer.class, "NORMAL_BLEND_3D");
        this.normalBlend2DProgram = shaders.getProgram(VideoLayerComposer.class, "NORMAL_BLEND_2D");
        this.mblur2Accum2Program = shaders.getProgram(VideoLayerComposer.class, "MBLUR2_ACCUM2");
        this.matteMultiplyProgram = shaders.getProgram(VideoLayerComposer.class, "MATTE_MULTIPLY");
        this.diffusionConvolutionProgram = shaders.getProgram(VideoLayerComposer.class, "DIFFUSION_CONVOLUTION");
        this.shadowMultiplyProgram = shaders.getProgram(VideoLayerComposer.class, "SHADOW_MULTIPLY");
        this.composition = (LayerComposition)context.getComposition();
        this.camera = context.getCamera();
        this.lights = context.getLights();
        this.ssScale = context.getVideoResolution().scale < 1.0 ? 1 : this.composition.getSuperSampling().ordinal() + 1;
        this.bounds = new VideoBounds(this.camera.getViewportSize());
        this.boundsX = new VideoBounds(this.bounds.width * this.ssScale, this.bounds.height * this.ssScale);
        this.baseTime = context.getTime();
        boolean lightsCastShadows = false;
        for (Light light : this.lights) {
            if (!light.isCastsShadows()) continue;
            lightsCastShadows = true;
            break;
        }
        this.lightsCastShadows = lightsCastShadows;
    }

    void addLayerRenderer(VideoLayerRenderer r) {
        if (r instanceof VideoLayerRenderer.MatteLayerRenderers) {
            VideoLayerRenderer.MatteLayerRenderers mlr = (VideoLayerRenderer.MatteLayerRenderers)r;
            this.matteLayerRenderers.put(mlr.getMatteId(), mlr);
        } else if (r instanceof VideoLayerRenderer.GeneralLayerRenderer) {
            boolean threeD = LayerNature.isThreeD(r.getLayer());
            if (this.currentGroup == null || this.currentGroup.threeD != threeD) {
                this.currentGroup = new ComposeGroup(threeD);
                this.groups.add(this.currentGroup);
            }
            this.currentGroup.add((VideoLayerRenderer.GeneralLayerRenderer)r);
        } else {
            throw new IllegalArgumentException();
        }
    }

    void addLayerRenderers(List<VideoLayerRenderer> renderers) {
        for (VideoLayerRenderer r : renderers) {
            this.addLayerRenderer(r);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    IVideoBuffer compose() {
        composeBuffer = null;
        try {
            composeBuffer = this.support.createVideoBuffer(this.bounds);
            composeBuffer.clear();
            for (ComposeGroup group : this.groups) {
                if (ComposeGroup.access$0(group)) {
                    buffer = composeBuffer;
                    if ((composeBuffer = this.compose3D(group, buffer)) == buffer) continue;
                    buffer.dispose();
                    continue;
                }
                this.compose2D(group, composeBuffer);
            }
            result = composeBuffer;
            composeBuffer = null;
            var6_5 = result;
            return var6_5;
        }
        finally {
            if (composeBuffer != null) {
                composeBuffer.dispose();
            }
            ** for (vb : this.matteBufferCache.values())
        }
lbl-1000:
        // 1 sources

        {
            vb.dispose();
            continue;
        }
lbl23:
        // 1 sources

        this.matteBufferCache.clear();
        return var6_5;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IVideoBuffer compose3D(final ComposeGroup group, IVideoBuffer composeBuffer) {
        mblurEnabled = false;
        if (this.composition.isMotionBlurEnabled()) {
            for (VideoLayerRenderer.GeneralLayerRenderer r : ComposeGroup.access$3(group)) {
                if (LayerNature.getMotionBlur(r.getLayer()) == MotionBlur.NONE) continue;
                mblurEnabled = true;
                break;
            }
        }
        this.mblurWithShadows = false;
        if (mblurEnabled && this.lightsCastShadows) {
            for (VideoLayerRenderer.GeneralLayerRenderer r : ComposeGroup.access$3(group)) {
                if (LayerNature.getMotionBlur(r.getLayer()) == MotionBlur.NONE || r.getLayer().getCastsShadows() == CastsShadows.OFF) continue;
                this.mblurWithShadows = true;
                break;
            }
        }
        tmpBuffers = Util.newSet();
        cache = Util.newMap();
        try {
            if (this.ssScale > 1) {
                composeBuffer2 = this.magnifyForSuperSampling(composeBuffer);
                tmpBuffers.add(composeBuffer2);
            } else {
                composeBuffer2 = composeBuffer;
            }
            if (mblurEnabled) {
                composeBuffer3 = this.motionBlur1(composeBuffer2, new MotionBlurSampler1(){

                    public IVideoBuffer sample() {
                        IVideoBuffer buffer = null;
                        try {
                            buffer = VideoLayerComposer.this.support.createVideoBuffer(VideoLayerComposer.this.boundsX);
                            VideoLayerComposer.this.support.copy(composeBuffer2, buffer);
                            VideoLayerComposer.this.compose3D(group, buffer, cache);
                            IVideoBuffer result = buffer;
                            buffer = null;
                            IVideoBuffer iVideoBuffer = result;
                            return iVideoBuffer;
                        }
                        finally {
                            if (buffer != null) {
                                buffer.dispose();
                            }
                        }
                    }

                    public double getOpacity() {
                        return 1.0;
                    }
                });
                if (composeBuffer3 != composeBuffer2) {
                    tmpBuffers.add(composeBuffer3);
                }
            } else {
                this.compose3D(group, composeBuffer2, cache);
                composeBuffer3 = composeBuffer2;
            }
            if (this.ssScale > 1) {
                this.downSample(composeBuffer3, composeBuffer);
                var9_8 = composeBuffer;
                return var9_8;
            }
            tmpBuffers.remove(composeBuffer3);
            var9_9 = composeBuffer3;
            return var9_9;
        }
        finally {
            ** for (entry : cache.values())
        }
lbl-1000:
        // 1 sources

        {
            Entry3D.access$2(entry);
            continue;
        }
lbl42:
        // 2 sources

        for (IVideoBuffer vb : tmpBuffers) {
            vb.dispose();
        }
        return var9_8;
    }

    /*
     * Unable to fully structure code
     */
    private void compose3D(ComposeGroup group, IVideoBuffer composeBuffer, Map<VideoLayerRenderer.GeneralLayerRenderer, Entry3D> cache) {
        entryMap = Util.newLinkedHashMap();
        try {
            it = ComposeGroup.access$3(group).listIterator();
            while (it.hasNext()) {
                i = it.nextIndex();
                r = (VideoLayerRenderer.GeneralLayerRenderer)it.next();
                entry = this.render3DLayer(r, i, cache);
                if (entry == null) continue;
                entryMap.put(r, entry);
            }
            this.transformAndLighting(Util.newList(entryMap.values()));
            it = entryMap.entrySet().iterator();
            while (it.hasNext()) {
                e = (Map.Entry)it.next();
                entry = (Entry3D)e.getValue();
                if (Entry3D.access$0(entry).getCastsShadows() != CastsShadows.ONLY && !(Math.abs(Entry3D.access$3((Entry3D)entry).w) < 0.001)) continue;
                cache.put((VideoLayerRenderer.GeneralLayerRenderer)e.getKey(), entry);
                it.remove();
            }
            entries = entryMap.values().toArray(new Entry3D[entryMap.size()]);
            Arrays.sort(entries, Entry3D.access$4());
            polygons = Util.newList();
            var10_13 = entries;
            var9_14 = entries.length;
            entry = 0;
            while (entry < var9_14) {
                entry = var10_13[entry];
                polygons.add(new Polygon(entry));
                ++entry;
            }
            polygons = this.partitionPolygons(polygons);
            triangles = Util.newList();
            buffers = Util.newList();
            it = polygons.listIterator();
            while (it.hasNext()) {
                p = it.next();
                blendMode = Entry3D.access$0(Polygon.access$1(p)).getBlendMode();
                switch (VideoLayerComposer.$SWITCH_TABLE$ch$kuramo$javie$api$BlendMode()[blendMode.ordinal()]) {
                    case 29: 
                    case 30: {
                        blendMode = BlendMode.NORMAL;
                    }
                }
                if (blendMode == BlendMode.NORMAL) {
                    sourceIndex = buffers.indexOf(Entry3D.access$5(Polygon.access$1(p)));
                    v0 = matteIndex = Entry3D.access$6(Polygon.access$1(p)) != null ? buffers.indexOf(Entry3D.access$6(Polygon.access$1(p))) : -2;
                    if (sourceIndex == -1 && matteIndex == -1 && buffers.size() == this.maxTexImageUnits - 1) {
                        it.previous();
                    } else {
                        if (sourceIndex == -1) {
                            sourceIndex = buffers.size();
                            buffers.add(Entry3D.access$5(Polygon.access$1(p)));
                        }
                        if (matteIndex == -1) {
                            matteIndex = buffers.size();
                            buffers.add(Entry3D.access$6(Polygon.access$1(p)));
                        }
                        triangles.addAll(Polygon.access$2(p, sourceIndex, matteIndex));
                        if (buffers.size() < this.maxTexImageUnits && it.hasNext()) continue;
                    }
                }
                if (!buffers.isEmpty()) {
                    this.normalBlend3D(triangles, buffers, composeBuffer);
                    triangles.clear();
                    buffers.clear();
                }
                if (blendMode == BlendMode.NORMAL) continue;
                this.customBlend3D(p, composeBuffer);
            }
        }
        finally {
            ** for (e : entryMap.entrySet())
        }
lbl-1000:
        // 1 sources

        {
            cache.put((VideoLayerRenderer.GeneralLayerRenderer)e.getKey(), (Entry3D)e.getValue());
            continue;
        }
lbl75:
        // 1 sources

    }

    private Entry3D render3DLayer(final VideoLayerRenderer.GeneralLayerRenderer r, final int indexInGroup, final Map<VideoLayerRenderer.GeneralLayerRenderer, Entry3D> cache) {
        return this.context.saveAndExecute(new WrappedOperation<Entry3D>(){

            @Override
            public Entry3D execute() {
                MediaLayer layer = r.getLayer();
                MotionBlur mblur = VideoLayerComposer.this.composition.isMotionBlurEnabled() ? LayerNature.getMotionBlur(layer) : MotionBlur.NONE;
                Entry3D entry = (Entry3D)cache.remove(r);
                IVideoBuffer source = null;
                IVideoBuffer sourceCR = null;
                IVideoBuffer diffusion = null;
                IVideoBuffer matte = null;
                try {
                    double opacity;
                    Point2d[] texCoords;
                    Point3d[] vertices;
                    switch (mblur) {
                        case NONE: {
                            if (entry != null) {
                                if (VideoLayerComposer.this.mblurWithShadows && layer.isAcceptsShadows()) {
                                    entry.disposeLighted();
                                }
                                Entry3D entry3D = entry;
                                return entry3D;
                            }
                            VideoLayerComposer.this.context.setTime(VideoLayerComposer.this.baseTime);
                            break;
                        }
                        case TRANSFORM: {
                            if (r instanceof VideoLayerRenderer.NormalLayerRenderer) {
                                if (entry != null) {
                                    source = entry.source;
                                    diffusion = entry.diffusion;
                                    entry.disposeLighted();
                                    entry = null;
                                    break;
                                }
                                Time time = VideoLayerComposer.this.context.getTime();
                                try {
                                    VideoLayerComposer.this.context.setTime(VideoLayerComposer.this.baseTime);
                                    source = ((VideoLayerRenderer.NormalLayerRenderer)r).render(true, VideoLayerComposer.this.composition.isFrameBlendEnabled());
                                    break;
                                }
                                finally {
                                    VideoLayerComposer.this.context.setTime(time);
                                }
                            }
                        }
                        default: {
                            if (entry == null) break;
                            entry.dispose();
                            entry = null;
                        }
                    }
                    double[] mvMatrix = new double[16];
                    System.arraycopy(VideoLayerComposer.this.camera.getModelView3D(), 0, mvMatrix, 0, 16);
                    if (r instanceof VideoLayerRenderer.NormalLayerRenderer) {
                        VideoLayerRenderer.NormalLayerRenderer nr = (VideoLayerRenderer.NormalLayerRenderer)r;
                        nr.multModelViewMatrix(mvMatrix);
                        if (source == null) {
                            source = nr.render(true, VideoLayerComposer.this.composition.isFrameBlendEnabled());
                        }
                        VideoBounds b = source.getBounds();
                        double expand = 16.0;
                        double ex = expand / (double)b.width;
                        double ey = expand / (double)b.height;
                        vertices = new Point3d[]{new Point3d(b.x - expand, b.y - expand, 0.0), new Point3d(b.x + (double)b.width + expand, b.y - expand, 0.0), new Point3d(b.x + (double)b.width + expand, b.y + (double)b.height + expand, 0.0), new Point3d(b.x - expand, b.y + (double)b.height + expand, 0.0)};
                        Matrix4d m = new Matrix4d(mvMatrix);
                        m.transpose();
                        m.transform(vertices[0]);
                        m.transform(vertices[1]);
                        m.transform(vertices[2]);
                        m.transform(vertices[3]);
                        texCoords = new Point2d[]{new Point2d(-ex, -ey), new Point2d(1.0 + ex, -ey), new Point2d(1.0 + ex, 1.0 + ey), new Point2d(-ex, 1.0 + ey)};
                        opacity = nr.getOpacity();
                    } else {
                        VideoLayerRenderer.CRLayerRenderer crr = (VideoLayerRenderer.CRLayerRenderer)r;
                        crr.multModelViewMatrix(mvMatrix);
                        vertices = VideoLayerComposer.this.unProjectViewport(mvMatrix);
                        if (vertices.length < 3) {
                            return null;
                        }
                        Matrix4d m = new Matrix4d(mvMatrix);
                        m.transpose();
                        Point3d[] point3dArray = vertices;
                        int n = vertices.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Point3d pt = point3dArray[n2];
                            m.transform(pt);
                            ++n2;
                        }
                        CastsShadows castsShadows = layer.getCastsShadows();
                        if (VideoLayerComposer.this.lightsCastShadows && castsShadows != CastsShadows.OFF) {
                            source = crr.render();
                        }
                        if (castsShadows != CastsShadows.ONLY) {
                            sourceCR = crr.render(true, VideoLayerComposer.this.bounds, mvMatrix, VideoLayerComposer.this.camera.getProjection3D());
                        }
                        texCoords = null;
                        opacity = crr.getOpacity();
                    }
                    matte = VideoLayerComposer.this.renderMatte(r);
                    entry = new Entry3D(indexInGroup, layer, source, sourceCR, diffusion, matte, mvMatrix, vertices, texCoords, opacity);
                    source = null;
                    sourceCR = null;
                    diffusion = null;
                    matte = null;
                    Entry3D entry3D = entry;
                    return entry3D;
                }
                finally {
                    if (source != null) {
                        source.dispose();
                    }
                    if (sourceCR != null) {
                        sourceCR.dispose();
                    }
                    if (diffusion != null) {
                        diffusion.dispose();
                    }
                    if (matte != null) {
                        matte.dispose();
                    }
                }
            }
        });
    }

    private void transformAndLighting(List<Entry3D> entries) {
        if (this.lights.isEmpty()) {
            for (Entry3D entry : entries) {
                if (entry.layer.getCastsShadows() == CastsShadows.ONLY || entry.lighted != null) continue;
                if (entry.texCoords != null) {
                    this.setTextureFilter(entry.source, entry.layer);
                    entry.lighted = this.transformWithoutLighting(entry);
                    continue;
                }
                entry.lighted = entry.sourceCR;
            }
            return;
        }
        List<Entry3D> casterEntries = Util.newList();
        if (this.lightsCastShadows) {
            for (Entry3D entry : entries) {
                if (entry.layer.getCastsShadows() == CastsShadows.OFF) continue;
                casterEntries.add(entry);
            }
        }
        entries = Util.newList(entries);
        Iterator<Entry3D> it = entries.iterator();
        while (it.hasNext()) {
            Entry3D entry = it.next();
            if (entry.layer.getCastsShadows() != CastsShadows.ONLY && entry.lighted == null) continue;
            it.remove();
        }
        Map map = Util.newMap();
        for (Entry3D entry : entries) {
            Map<Light, List<Caster>> castingLights = Util.newMap();
            if (entry.layer.isAcceptsShadows()) {
                for (Light light : this.lights) {
                    List<Caster> actual;
                    if (!light.isCastsShadows() || (actual = this.findActualCasters(entry, light, casterEntries)) == null) continue;
                    castingLights.put(light, actual);
                    if (!(light.getShadowDiffusion() > 0.0)) continue;
                    for (Caster caster : actual) {
                        if (caster.entry.diffusion != null) continue;
                        caster.entry.diffusion = this.createDiffusionMap(caster.entry.source);
                    }
                }
            }
            map.put(entry, castingLights);
        }
        Set<Entry3D> all = Util.newSet(entries);
        all.addAll(casterEntries);
        for (Entry3D entry : all) {
            if (entry.source == null || entry.diffusion != null && (entry.texCoords == null || entry.layer.getCastsShadows() == CastsShadows.ONLY)) continue;
            this.setTextureFilter(entry.source, entry.layer);
        }
        for (Entry3D entry : entries) {
            IVideoBuffer buffer;
            if (entry.layer.isAcceptsLights()) {
                buffer = null;
                try {
                    buffer = this.support.createVideoBuffer(this.bounds);
                    buffer.clear();
                    Map castingLights = (Map)map.get(entry);
                    Set<Light> ambientLights = Util.newSet();
                    for (Light light : this.lights) {
                        if (light.getType() == LightType.AMBIENT) {
                            ambientLights.add(light);
                            continue;
                        }
                        IVideoBuffer shadow = null;
                        try {
                            List casters = (List)castingLights.get(light);
                            if (casters != null) {
                                shadow = this.renderShadows(entry, light, casters);
                            }
                            this.parallelOrPointLight(entry, light, buffer, shadow);
                        }
                        finally {
                            if (shadow != null) {
                                shadow.dispose();
                            }
                        }
                    }
                    if (!ambientLights.isEmpty()) {
                        this.ambientLights(entry, ambientLights, buffer);
                    }
                    entry.lighted = buffer;
                    buffer = null;
                    continue;
                }
                finally {
                    if (buffer != null) {
                        buffer.dispose();
                    }
                }
            }
            if (entry.layer.isAcceptsShadows() && !((Map)map.get(entry)).isEmpty()) {
                buffer = null;
                try {
                    if (entry.texCoords != null) {
                        buffer = this.transformWithoutLighting(entry);
                    } else {
                        buffer = this.support.createVideoBuffer(this.bounds);
                        this.support.copy(entry.sourceCR, buffer);
                    }
                    for (Map.Entry e : ((Map)map.get(entry)).entrySet()) {
                        IVideoBuffer shadow = null;
                        try {
                            shadow = this.renderShadows(entry, (Light)e.getKey(), (List)e.getValue());
                            this.shadowMultiply(entry, (Light)e.getKey(), buffer, shadow);
                        }
                        finally {
                            if (shadow != null) {
                                shadow.dispose();
                            }
                        }
                    }
                    entry.lighted = buffer;
                    buffer = null;
                    continue;
                }
                finally {
                    if (buffer != null) {
                        buffer.dispose();
                    }
                }
            }
            entry.lighted = entry.texCoords != null ? this.transformWithoutLighting(entry) : entry.sourceCR;
        }
    }

    private IVideoBuffer createDiffusionMap(IVideoBuffer source) {
        IVideoBuffer diffusion = null;
        IVideoBuffer tmpbuf = null;
        GL2 gl = this.context.getGL().getGL2();
        gl.glPushAttrib(278528);
        try {
            diffusion = this.support.createVideoBuffer(source.getBounds());
            this.support.copy(source, diffusion);
            diffusion.setTextureFilter(IVideoBuffer.TextureFilter.MIPMAP);
            gl.glActiveTexture(33984);
            int[] params = new int[2];
            int level = 0;
            while (true) {
                gl.glBindTexture(3553, diffusion.getTexture());
                gl.glGetTexLevelParameteriv(3553, level, 4096, params, 0);
                gl.glGetTexLevelParameteriv(3553, level, 4097, params, 1);
                VideoBounds b = new VideoBounds(params[0], params[1]);
                if (level < 17) {
                    tmpbuf = this.support.createVideoBuffer(b);
                    double radius = (double)(level * 2) + 1.5;
                    float[] kernel = this.blurSupport.createGaussianBlurKernel(radius);
                    this.diffusionConvolution(gl, kernel, true, b, diffusion.getTexture(), level, tmpbuf.getTexture(), 0);
                    this.diffusionConvolution(gl, kernel, false, b, tmpbuf.getTexture(), 0, diffusion.getTexture(), level);
                    tmpbuf.dispose();
                } else {
                    gl.glFramebufferTexture2D(36160, 36064, 3553, diffusion.getTexture(), level);
                    gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                    gl.glClear(16384);
                }
                if (b.width == 1 && b.height == 1) break;
                ++level;
            }
            IVideoBuffer result = diffusion;
            diffusion = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            gl.glFramebufferTexture2D(36160, 36064, 3553, 0, 0);
            gl.glPopAttrib();
            if (diffusion != null) {
                diffusion.dispose();
            }
            if (tmpbuf != null) {
                tmpbuf.dispose();
            }
        }
    }

    private void diffusionConvolution(final GL2 gl, float[] kernel, boolean horz, final VideoBounds b, int srcTex, int srcLevel, int dstTex, int dstLevel) {
        int i;
        int ksize = kernel.length;
        float[] offset = new float[ksize * 2];
        if (horz) {
            i = 0;
            while (i < ksize) {
                offset[i * 2] = (float)(i - ksize / 2) / (float)b.width;
                offset[i * 2 + 1] = 0.0f;
                ++i;
            }
        } else {
            i = 0;
            while (i < ksize) {
                offset[i * 2] = 0.0f;
                offset[i * 2 + 1] = (float)(i - ksize / 2) / (float)b.height;
                ++i;
            }
        }
        gl.glFramebufferTexture2D(36160, 36064, 3553, dstTex, dstLevel);
        gl.glDrawBuffer(36064);
        gl.glBindTexture(3553, srcTex);
        final Set<GLUniformData> uniforms = Util.newSet();
        uniforms.add(new GLUniformData("texture", 0));
        uniforms.add(new GLUniformData("ksize", ksize));
        uniforms.add(new GLUniformData("kernel[0]", 1, FloatBuffer.wrap(kernel)));
        uniforms.add(new GLUniformData("offset[0]", 2, FloatBuffer.wrap(offset)));
        uniforms.add(new GLUniformData("lod", (float)srcLevel));
        this.diffusionConvolutionProgram.useProgram(new Runnable(){

            public void run() {
                for (GLUniformData data : uniforms) {
                    data.setLocation(VideoLayerComposer.this.diffusionConvolutionProgram.getUniformLocation(data.getName()));
                    gl.glUniform(data);
                }
                VideoLayerComposer.this.support.ortho2D(b);
                VideoLayerComposer.this.support.quad2D(b, (double[][][])new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}}});
            }
        });
    }

    private List<Caster> findActualCasters(Entry3D entry, Light light, List<Entry3D> casterEntries) {
        Vec3d lightPos;
        Vec3d lightDir;
        List<Caster> actualCasters = Util.newList();
        switch (light.getType()) {
            case PARALLEL: {
                lightDir = light.getDirectionInCameraView();
                lightPos = new Vec3d(((Entry3D)entry).vertices[0].x - lightDir.x * 1000000.0, ((Entry3D)entry).vertices[0].y - lightDir.y * 1000000.0, ((Entry3D)entry).vertices[0].z - lightDir.z * 1000000.0);
                break;
            }
            case SPOT: 
            case POINT: {
                lightDir = null;
                lightPos = light.getPositionInCameraView();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Vector4d lightPos4d = new Vector4d(lightPos.x, lightPos.y, lightPos.z, 1.0);
        if (Math.signum(entry.plane.dot(lightPos4d)) * Math.signum(((Entry3D)entry).plane.w) == -1.0 && this.getValue(entry.layer.getLightTransmission()) == 0.0) {
            return null;
        }
        Polygon polygon = new Polygon(entry);
        for (Entry3D ce : casterEntries) {
            if (ce == entry) continue;
            if (ce.texCoords == null) {
                VideoBounds b = ce.source.getBounds();
                double expand = 16.0;
                Point3d[] vertices = new Point3d[]{new Point3d(b.x - expand, b.y - expand, 0.0), new Point3d(b.x + (double)b.width + expand, b.y - expand, 0.0), new Point3d(b.x + (double)b.width + expand, b.y + (double)b.height + expand, 0.0), new Point3d(b.x - expand, b.y + (double)b.height + expand, 0.0)};
                Matrix4d m = new Matrix4d(ce.mvMatrix);
                m.transpose();
                m.transform(vertices[0]);
                m.transform(vertices[1]);
                m.transform(vertices[2]);
                m.transform(vertices[3]);
                ce = new Entry3D(ce.indexInGroup, ce.layer, ce.source, ce.sourceCR, ce.diffusion, ce.matte, ce.mvMatrix, vertices, null, ce.opacity);
            }
            Polygon p = new Polygon(ce);
            List<Polygon> near = Util.newList();
            List<Polygon> far = Util.newList();
            this.partitionPolygons(polygon, p, near, far, lightPos);
            if (near.isEmpty()) continue;
            Vector3d partitionLine = null;
            boolean partitionExpand = false;
            if (!far.isEmpty()) {
                if (this.ssScale > 1) {
                    List partitionPoints = Util.newList(near.get(0).vertices);
                    partitionPoints.retainAll(far.get(0).vertices);
                    Point3d p0 = (Point3d)partitionPoints.get(0);
                    Point3d p1 = (Point3d)partitionPoints.get(1);
                    double[] identity = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
                    double[] projection = this.camera.getProjection3D();
                    int[] nArray = new int[4];
                    nArray[2] = this.bounds.width;
                    nArray[3] = this.bounds.height;
                    int[] viewport = nArray;
                    double[] winpos = new double[6];
                    GLU glu = this.context.getGLU();
                    glu.gluProject(p0.x, p0.y, p0.z, identity, 0, projection, 0, viewport, 0, winpos, 0);
                    glu.gluProject(p1.x, p1.y, p1.z, identity, 0, projection, 0, viewport, 0, winpos, 3);
                    partitionLine = new Vector3d(winpos[4] - winpos[1], winpos[0] - winpos[3], (winpos[3] - winpos[0]) * winpos[1] - (winpos[4] - winpos[1]) * winpos[0]);
                    partitionLine.scale(1.0 / Math.sqrt(partitionLine.x * partitionLine.x + partitionLine.y * partitionLine.y));
                    double signMult = Math.signum(ce.plane.dot(lightPos4d)) * Math.signum(((Entry3D)ce).plane.w);
                    if (signMult == 1.0) {
                        p = near.get(0);
                    } else if (signMult == -1.0) {
                        partitionExpand = true;
                    }
                } else {
                    p = near.get(0);
                }
            }
            Polygon target = polygon;
            Point3d p1 = (Point3d)p.vertices.get(p.vertices.size() - 1);
            for (Point3d p2 : p.vertices) {
                Vector3d v2;
                Vector3d v0;
                if (lightDir != null) {
                    v0 = new Vector3d(lightDir.x, lightDir.y, lightDir.z);
                    v2 = new Vector3d((Tuple3d)p2);
                    v2.sub((Tuple3d)p1);
                } else {
                    v0 = new Vector3d(lightPos.x, lightPos.y, lightPos.z);
                    v2 = new Vector3d((Tuple3d)p2);
                    v0.sub((Tuple3d)p1);
                    v2.sub((Tuple3d)p1);
                }
                Vector3d n = new Vector3d();
                n.cross(v0, v2);
                n.normalize();
                Vector4d plane = new Vector4d(n.x, n.y, n.z, -n.dot(new Vector3d((Tuple3d)p1)));
                double d = 0.0;
                for (Point3d pt : p.vertices) {
                    double dd = plane.dot(new Vector4d(pt.x, pt.y, pt.z, 1.0));
                    if (!(Math.abs(dd) > Math.abs(d))) continue;
                    d = dd;
                }
                near.clear();
                far.clear();
                if (!this.partitionPolygons(plane, Math.signum(d), target, near, far)) {
                    this.partitionPolygons(p, target, far, near, lightPos);
                }
                if (near.isEmpty()) {
                    target = null;
                    break;
                }
                target = near.get(0);
                p1 = p2;
            }
            if (target == null) continue;
            actualCasters.add(new Caster(ce, target.vertices, partitionLine, partitionExpand));
        }
        return actualCasters.isEmpty() ? null : actualCasters;
    }

    private IVideoBuffer transformWithoutLighting(final Entry3D entry) {
        IVideoBuffer buffer = null;
        try {
            buffer = this.support.createVideoBuffer(this.bounds);
            buffer.clear();
            Runnable operation = new Runnable(){

                public void run() {
                    GL2 gl = VideoLayerComposer.this.context.getGL().getGL2();
                    gl.glViewport(0, 0, ((VideoLayerComposer)VideoLayerComposer.this).bounds.width, ((VideoLayerComposer)VideoLayerComposer.this).bounds.height);
                    gl.glMatrixMode(5889);
                    gl.glLoadMatrixd(VideoLayerComposer.this.camera.getProjection3D(), 0);
                    gl.glMatrixMode(5888);
                    gl.glLoadIdentity();
                    gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                    gl.glBegin(7);
                    int i = 0;
                    while (i < 4) {
                        Point2d tc = entry.texCoords[i];
                        Point3d vert = entry.vertices[i];
                        gl.glTexCoord2f((float)tc.x, (float)tc.y);
                        gl.glVertex3f((float)vert.x, (float)vert.y, (float)vert.z);
                        ++i;
                    }
                    gl.glEnd();
                }
            };
            int pushAttribs = 1;
            this.support.useFramebuffer(operation, pushAttribs, buffer, new IVideoBuffer[]{entry.source});
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private IVideoBuffer renderShadows(Entry3D entry, Light light, List<Caster> casters) {
        IVideoBuffer shadow = null;
        try {
            List<Caster> sublist;
            shadow = this.support.createVideoBuffer(this.bounds);
            shadow.clear(Color.WHITE);
            List<Caster> unpartitionedCasters = Util.newList();
            List<Caster> partitionedCasters = Util.newList();
            for (Caster caster : casters) {
                if (caster.partitionLine == null) {
                    unpartitionedCasters.add(caster);
                    continue;
                }
                partitionedCasters.add(caster);
            }
            int i = 0;
            int n = unpartitionedCasters.size();
            while (i < n) {
                sublist = unpartitionedCasters.subList(i, Math.min(n, this.maxTexImageUnits));
                i += sublist.size();
                this.renderShadow(entry, light, sublist, false, shadow);
            }
            i = 0;
            n = partitionedCasters.size();
            while (i < n) {
                sublist = partitionedCasters.subList(i, Math.min(n, this.maxTexImageUnits));
                i += sublist.size();
                this.renderShadow(entry, light, sublist, true, shadow);
            }
            IVideoBuffer result = shadow;
            shadow = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (shadow != null) {
                shadow.dispose();
            }
        }
    }

    private void renderShadow(Entry3D entry, Light light, List<Caster> casters, boolean partitioned, IVideoBuffer shadow) {
        IArray attribs = null;
        try {
            IShaderProgram program;
            int numVertices = 0;
            for (Caster caster : casters) {
                numVertices += (caster.vertices.size() - 2) * 3;
            }
            attribs = this.arrayPools.getFloatArray(numVertices * 4);
            float[] array = (float[])attribs.getArray();
            int k = 0;
            List<IVideoBuffer> buffers = Util.newList();
            float[] casterPlanes = new float[casters.size() * 4];
            float[] casterMvTxInvs = new float[casters.size() * 16];
            float[] casterOpacs = new float[casters.size()];
            float[] casterTrans = new float[casters.size()];
            double diffusion = light.getShadowDiffusion();
            float[] partitionLines = partitioned ? new float[casters.size() * 3] : null;
            float[] partitionExpands = partitioned ? new float[casters.size()] : null;
            for (Caster caster : casters) {
                int i = buffers.size();
                Point3d[] point3dArray = new Point3d[3];
                point3dArray[0] = (Point3d)caster.vertices.get(0);
                point3dArray[1] = (Point3d)caster.vertices.get(1);
                Point3d[] vertices = point3dArray;
                int j = 2;
                while (j < caster.vertices.size()) {
                    vertices[2] = (Point3d)caster.vertices.get(j);
                    Point3d[] point3dArray2 = vertices;
                    int n = vertices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Point3d vert = point3dArray2[n2];
                        array[k++] = (float)vert.x;
                        array[k++] = (float)vert.y;
                        array[k++] = (float)vert.z;
                        array[k++] = (float)i + 0.5f;
                        ++n2;
                    }
                    ++j;
                    vertices[1] = vertices[2];
                }
                if (diffusion > 0.0) {
                    buffers.add(caster.entry.diffusion);
                } else {
                    buffers.add(caster.entry.source);
                }
                casterPlanes[i * 4] = (float)((Entry3D)((Caster)caster).entry).plane.x;
                casterPlanes[i * 4 + 1] = (float)((Entry3D)((Caster)caster).entry).plane.y;
                casterPlanes[i * 4 + 2] = (float)((Entry3D)((Caster)caster).entry).plane.z;
                casterPlanes[i * 4 + 3] = (float)((Entry3D)((Caster)caster).entry).plane.w;
                VideoBounds casterBounds = caster.entry.source.getBounds();
                Matrix4d m = new Matrix4d(1.0 / (double)casterBounds.width, 0.0, 0.0, -casterBounds.x / (double)casterBounds.width, 0.0, 1.0 / (double)casterBounds.height, 0.0, -casterBounds.y / (double)casterBounds.height, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
                Matrix4d casterMvInv = new Matrix4d(caster.entry.mvMatrix);
                casterMvInv.transpose();
                casterMvInv.invert();
                m.mul(casterMvInv);
                int col = 0;
                while (col < 4) {
                    int row = 0;
                    while (row < 4) {
                        casterMvTxInvs[i * 16 + col * 4 + row] = (float)m.getElement(row, col);
                        ++row;
                    }
                    ++col;
                }
                casterOpacs[i] = (float)caster.entry.opacity;
                casterTrans[i] = (float)(this.getValue(caster.entry.layer.getLightTransmission()) / 100.0);
                if (!partitioned) continue;
                partitionLines[i * 3] = (float)((Caster)caster).partitionLine.x;
                partitionLines[i * 3 + 1] = (float)((Caster)caster).partitionLine.y;
                partitionLines[i * 3 + 2] = (float)((Caster)caster).partitionLine.z;
                partitionExpands[i] = caster.partitionExpand ? 1 : 0;
            }
            Set<GLUniformData> uniforms = Util.newSet();
            int i = 0;
            while (i < buffers.size()) {
                uniforms.add(new GLUniformData("texture" + i, i));
                ++i;
            }
            uniforms.add(new GLUniformData("casterPlanes[0]", 4, FloatBuffer.wrap(casterPlanes)));
            uniforms.add(new GLUniformData("casterMvTxInvs[0]", 4, 4, FloatBuffer.wrap(casterMvTxInvs)));
            uniforms.add(new GLUniformData("casterOpacs[0]", 1, FloatBuffer.wrap(casterOpacs)));
            uniforms.add(new GLUniformData("casterTrans[0]", 1, FloatBuffer.wrap(casterTrans)));
            uniforms.add(new GLUniformData("viewport", 2, FloatBuffer.wrap(new float[]{this.bounds.width, this.bounds.height})));
            if (partitioned) {
                uniforms.add(new GLUniformData("partitionLines[0]", 3, FloatBuffer.wrap(partitionLines)));
                uniforms.add(new GLUniformData("partitionExpands[0]", 1, FloatBuffer.wrap(partitionExpands)));
            }
            if (light.getType() == LightType.PARALLEL) {
                Vec3d lightDir = light.getDirectionInCameraView();
                uniforms.add(new GLUniformData("lightDir", 4, FloatBuffer.wrap(new float[]{(float)lightDir.x, (float)lightDir.y, (float)lightDir.z, 0.0f})));
                program = this.getShadowOfParallelLightProgram(partitioned);
            } else {
                Vec3d lightPos = light.getPositionInCameraView();
                uniforms.add(new GLUniformData("lightPos", 4, FloatBuffer.wrap(new float[]{(float)lightPos.x, (float)lightPos.y, (float)lightPos.z, 1.0f})));
                if (diffusion > 0.0) {
                    uniforms.add(new GLUniformData("diffusion", (float)(diffusion * 0.5)));
                    program = this.getShadowOfPointLightProgram(true, partitioned);
                } else {
                    program = this.getShadowOfPointLightProgram(false, partitioned);
                }
            }
            final ByteBuffer directAttribs = ByteBuffer.allocateDirect(attribs.getLength() * 4);
            directAttribs.order(ByteOrder.nativeOrder());
            directAttribs.asFloatBuffer().put((float[])attribs.getArray(), 0, attribs.getLength());
            Runnable operation = new Runnable(){

                public void run() {
                    GL2 gl = VideoLayerComposer.this.context.getGL().getGL2();
                    gl.glViewport(0, 0, ((VideoLayerComposer)VideoLayerComposer.this).bounds.width, ((VideoLayerComposer)VideoLayerComposer.this).bounds.height);
                    gl.glMatrixMode(5889);
                    gl.glLoadMatrixd(VideoLayerComposer.this.camera.getProjection3D(), 0);
                    gl.glMatrixMode(5888);
                    gl.glLoadIdentity();
                    gl.glEnable(3042);
                    gl.glBlendFuncSeparate(0, 768, 0, 1);
                    gl.glBlendEquation(32774);
                    int attrLoc = program.getAttributeLocation("attr");
                    try {
                        gl.glEnableVertexAttribArray(attrLoc);
                        gl.glVertexAttribPointer(attrLoc, 4, 5126, false, 16, (Buffer)directAttribs);
                        gl.glDrawArrays(4, 0, directAttribs.capacity() / 16);
                    }
                    finally {
                        gl.glDisableVertexAttribArray(attrLoc);
                    }
                }
            };
            int pushAttribs = 24576;
            this.support.useShaderProgram(program, uniforms, operation, pushAttribs, shadow, buffers.toArray(new IVideoBuffer[buffers.size()]));
        }
        finally {
            if (attribs != null) {
                attribs.release();
            }
        }
    }

    private void parallelOrPointLight(final Entry3D entry, Light light, IVideoBuffer buffer, IVideoBuffer shadow) {
        boolean back;
        Vec3d lightPos;
        IVideoBuffer source;
        final boolean cr = entry.texCoords == null;
        Runnable operation = new Runnable(){

            public void run() {
                GL2 gl = VideoLayerComposer.this.context.getGL().getGL2();
                gl.glViewport(0, 0, ((VideoLayerComposer)VideoLayerComposer.this).bounds.width, ((VideoLayerComposer)VideoLayerComposer.this).bounds.height);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(VideoLayerComposer.this.camera.getProjection3D(), 0);
                gl.glMatrixMode(5888);
                gl.glLoadIdentity();
                gl.glEnable(3042);
                gl.glBlendFuncSeparate(1, 1, 1, 0);
                gl.glBlendEquation(32774);
                gl.glBegin(9);
                int i = 0;
                while (i < entry.vertices.length) {
                    if (!cr) {
                        Point2d tc = entry.texCoords[i];
                        gl.glTexCoord2f((float)tc.x, (float)tc.y);
                    }
                    Point3d vert = entry.vertices[i];
                    gl.glVertex3f((float)vert.x, (float)vert.y, (float)vert.z);
                    ++i;
                }
                gl.glEnd();
            }
        };
        Set<GLUniformData> uniforms = Util.newSet();
        uniforms.add(new GLUniformData("source", 0));
        if (cr) {
            source = entry.sourceCR;
            VideoBounds b = entry.sourceCR.getBounds();
            uniforms.add(new GLUniformData("sourceOffset", 2, FloatBuffer.wrap(new float[]{(float)(-b.x), (float)(-b.y)})));
            uniforms.add(new GLUniformData("sourceSize", 2, FloatBuffer.wrap(new float[]{b.width, b.height})));
        } else {
            source = entry.source;
        }
        uniforms.add(new GLUniformData("normal", 3, FloatBuffer.wrap(new float[]{(float)((Entry3D)entry).plane.x, (float)((Entry3D)entry).plane.y, (float)((Entry3D)entry).plane.z})));
        uniforms.add(new GLUniformData("material", 4, FloatBuffer.wrap(new float[]{(float)(this.getValue(entry.layer.getDiffuse()) / 100.0), (float)(this.getValue(entry.layer.getSpecular()) / 100.0), this.getValue(entry.layer.getShininess()).floatValue(), (float)(this.getValue(entry.layer.getMetal()) / 100.0)})));
        switch (light.getType()) {
            case PARALLEL: {
                Vec3d lightDir = light.getDirectionInCameraView();
                uniforms.add(new GLUniformData("lightVec", 3, FloatBuffer.wrap(new float[]{(float)(-lightDir.x), (float)(-lightDir.y), (float)(-lightDir.z)})));
                lightPos = new Vec3d(((Entry3D)entry).vertices[0].x - lightDir.x * 1000000.0, ((Entry3D)entry).vertices[0].y - lightDir.y * 1000000.0, ((Entry3D)entry).vertices[0].z - lightDir.z * 1000000.0);
                break;
            }
            case SPOT: {
                Vec3d lightDir = light.getDirectionInCameraView();
                double spotCutoff = Math.cos(Math.toRadians(light.getConeAngle() / 2.0));
                double spotSlope = 1.0 / Math.atan(1.5707963267948966 * light.getConeFeather() / 100.0) / (1.0 - spotCutoff);
                uniforms.add(new GLUniformData("spotVec", 3, FloatBuffer.wrap(new float[]{(float)(-lightDir.x), (float)(-lightDir.y), (float)(-lightDir.z)})));
                uniforms.add(new GLUniformData("spotCutoff", (float)spotCutoff));
                uniforms.add(new GLUniformData("spotSlope", (float)spotSlope));
            }
            case POINT: {
                lightPos = light.getPositionInCameraView();
                Vec3d lightAtten = light.getAttenuation();
                uniforms.add(new GLUniformData("lightPos", 3, FloatBuffer.wrap(new float[]{(float)lightPos.x, (float)lightPos.y, (float)lightPos.z})));
                uniforms.add(new GLUniformData("lightAttenuation", 3, FloatBuffer.wrap(new float[]{(float)lightAtten.x, (float)(lightAtten.y / 10000.0), (float)(lightAtten.z / 1.0E7)})));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        double lightIntensity = light.getIntensity() / 100.0;
        Color lightColor = light.getColor();
        uniforms.add(new GLUniformData("lightIntensity", (float)lightIntensity));
        uniforms.add(new GLUniformData("lightColor", 3, FloatBuffer.wrap(new float[]{(float)lightColor.r, (float)lightColor.g, (float)lightColor.b})));
        double lightSignum = Math.signum(entry.plane.dot(new Vector4d(lightPos.x, lightPos.y, lightPos.z, 1.0)));
        boolean bl = back = lightSignum * Math.signum(((Entry3D)entry).plane.w) == -1.0;
        if (back) {
            double lightTransmission = this.getValue(entry.layer.getLightTransmission()) / 100.0;
            uniforms.add(new GLUniformData("lightTransmission", (float)lightTransmission));
        }
        IShaderProgram program = this.getParallelOrPointLightProgram(light.getType(), shadow != null, back, cr);
        int pushAttribs = 24576;
        if (shadow == null) {
            this.support.useShaderProgram(program, uniforms, operation, pushAttribs, buffer, new IVideoBuffer[]{source});
        } else {
            uniforms.add(new GLUniformData("shadow", 1));
            uniforms.add(new GLUniformData("shadowSize", 2, FloatBuffer.wrap(new float[]{this.bounds.width, this.bounds.height})));
            double shadowDarkness = light.getShadowDarkness() / 100.0;
            uniforms.add(new GLUniformData("shadowDarkness", (float)shadowDarkness));
            this.support.useShaderProgram(program, uniforms, operation, pushAttribs, buffer, new IVideoBuffer[]{source, shadow});
        }
    }

    private void ambientLights(final Entry3D entry, Set<Light> lights, IVideoBuffer buffer) {
        IVideoBuffer source;
        double[] ambient = new double[3];
        for (Light light : lights) {
            double intensity = light.getIntensity() / 100.0;
            Color color = light.getColor();
            ambient[0] = ambient[0] + color.r * intensity;
            ambient[1] = ambient[1] + color.g * intensity;
            ambient[2] = ambient[2] + color.b * intensity;
        }
        double materialAmbient = this.getValue(entry.layer.getAmbient()) / 100.0;
        ambient[0] = ambient[0] * materialAmbient;
        ambient[1] = ambient[1] * materialAmbient;
        ambient[2] = ambient[2] * materialAmbient;
        final boolean cr = entry.texCoords == null;
        Runnable operation = new Runnable(){

            public void run() {
                GL2 gl = VideoLayerComposer.this.context.getGL().getGL2();
                gl.glViewport(0, 0, ((VideoLayerComposer)VideoLayerComposer.this).bounds.width, ((VideoLayerComposer)VideoLayerComposer.this).bounds.height);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(VideoLayerComposer.this.camera.getProjection3D(), 0);
                gl.glMatrixMode(5888);
                gl.glLoadIdentity();
                gl.glEnable(3042);
                gl.glBlendFuncSeparate(1, 1, 1, 0);
                gl.glBlendEquation(32774);
                gl.glBegin(9);
                int i = 0;
                while (i < entry.vertices.length) {
                    if (!cr) {
                        Point2d tc = entry.texCoords[i];
                        gl.glTexCoord2f((float)tc.x, (float)tc.y);
                    }
                    Point3d vert = entry.vertices[i];
                    gl.glVertex3f((float)vert.x, (float)vert.y, (float)vert.z);
                    ++i;
                }
                gl.glEnd();
            }
        };
        Set<GLUniformData> uniforms = Util.newSet();
        uniforms.add(new GLUniformData("source", 0));
        if (cr) {
            source = entry.sourceCR;
            VideoBounds b = entry.sourceCR.getBounds();
            uniforms.add(new GLUniformData("sourceOffset", 2, FloatBuffer.wrap(new float[]{(float)(-b.x), (float)(-b.y)})));
            uniforms.add(new GLUniformData("sourceSize", 2, FloatBuffer.wrap(new float[]{b.width, b.height})));
        } else {
            source = entry.source;
        }
        uniforms.add(new GLUniformData("ambient", 3, FloatBuffer.wrap(new float[]{(float)ambient[0], (float)ambient[1], (float)ambient[2]})));
        IShaderProgram program = this.getAmbientLightsProgram(cr);
        int pushAttribs = 24576;
        this.support.useShaderProgram(program, uniforms, operation, pushAttribs, buffer, new IVideoBuffer[]{source});
    }

    private void shadowMultiply(final Entry3D entry, Light light, IVideoBuffer buffer, IVideoBuffer shadow) {
        Runnable operation = new Runnable(){

            public void run() {
                GL2 gl = VideoLayerComposer.this.context.getGL().getGL2();
                gl.glViewport(0, 0, ((VideoLayerComposer)VideoLayerComposer.this).bounds.width, ((VideoLayerComposer)VideoLayerComposer.this).bounds.height);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(VideoLayerComposer.this.camera.getProjection3D(), 0);
                gl.glMatrixMode(5888);
                gl.glLoadIdentity();
                gl.glEnable(3042);
                gl.glBlendFuncSeparate(0, 768, 0, 1);
                gl.glBlendEquation(32774);
                gl.glBegin(9);
                int i = 0;
                while (i < entry.vertices.length) {
                    Point3d vert = entry.vertices[i];
                    gl.glVertex3f((float)vert.x, (float)vert.y, (float)vert.z);
                    ++i;
                }
                gl.glEnd();
            }
        };
        double shadowDarkness = light.getShadowDarkness() / 100.0;
        Set<GLUniformData> uniforms = Util.newSet();
        uniforms.add(new GLUniformData("shadow", 0));
        uniforms.add(new GLUniformData("shadowSize", 2, FloatBuffer.wrap(new float[]{this.bounds.width, this.bounds.height})));
        uniforms.add(new GLUniformData("shadowDarkness", (float)shadowDarkness));
        int pushAttribs = 24576;
        this.support.useShaderProgram(this.shadowMultiplyProgram, uniforms, operation, pushAttribs, buffer, new IVideoBuffer[]{shadow});
    }

    private void normalBlend3D(List<Triangle> triangles, List<IVideoBuffer> buffers, IVideoBuffer composeBuffer) {
        IArray attribs = null;
        try {
            attribs = this.arrayPools.getFloatArray(triangles.size() * 3 * 6);
            float[] array = (float[])attribs.getArray();
            int k = 0;
            for (Triangle tri : triangles) {
                int i = 0;
                while (i < 3) {
                    array[k++] = (float)((Triangle)tri).vertices[i].x;
                    array[k++] = (float)((Triangle)tri).vertices[i].y;
                    array[k++] = (float)((Triangle)tri).vertices[i].z;
                    array[k++] = (float)tri.entry.opacity;
                    array[k++] = (float)tri.sourceIndex + 0.5f;
                    array[k++] = (float)tri.matteIndex + 0.5f;
                    ++i;
                }
            }
            final ByteBuffer directAttribs = ByteBuffer.allocateDirect(attribs.getLength() * 4);
            directAttribs.order(ByteOrder.nativeOrder());
            directAttribs.asFloatBuffer().put((float[])attribs.getArray(), 0, attribs.getLength());
            Set<GLUniformData> uniforms = Util.newSet();
            float[] texOffsetAndSize = new float[buffers.size() * 4];
            ListIterator<IVideoBuffer> it = buffers.listIterator();
            while (it.hasNext()) {
                int i = it.nextIndex();
                uniforms.add(new GLUniformData("texture" + i, i));
                VideoBounds b = it.next().getBounds();
                texOffsetAndSize[i * 4] = (float)(-b.x * (double)this.ssScale);
                texOffsetAndSize[i * 4 + 1] = (float)(-b.y * (double)this.ssScale);
                texOffsetAndSize[i * 4 + 2] = b.width * this.ssScale;
                texOffsetAndSize[i * 4 + 3] = b.height * this.ssScale;
            }
            uniforms.add(new GLUniformData("texOffsetAndSize[0]", 4, FloatBuffer.wrap(texOffsetAndSize)));
            uniforms.add(new GLUniformData("dstSize", 2, FloatBuffer.wrap(new float[]{this.boundsX.width, this.boundsX.height})));
            Runnable operation = new Runnable(){

                public void run() {
                    GL2 gl = VideoLayerComposer.this.context.getGL().getGL2();
                    gl.glViewport(0, 0, ((VideoLayerComposer)VideoLayerComposer.this).boundsX.width, ((VideoLayerComposer)VideoLayerComposer.this).boundsX.height);
                    gl.glMatrixMode(5889);
                    gl.glLoadMatrixd(VideoLayerComposer.this.camera.getProjection3D(), 0);
                    gl.glMatrixMode(5888);
                    gl.glLoadIdentity();
                    gl.glEnable(3042);
                    gl.glBlendFunc(1, 771);
                    gl.glBlendEquation(32774);
                    int attr1Loc = VideoLayerComposer.this.normalBlend3DProgram.getAttributeLocation("attr1");
                    int attr2Loc = VideoLayerComposer.this.normalBlend3DProgram.getAttributeLocation("attr2");
                    try {
                        gl.glEnableVertexAttribArray(attr1Loc);
                        gl.glEnableVertexAttribArray(attr2Loc);
                        directAttribs.position(12);
                        gl.glVertexAttribPointer(attr2Loc, 3, 5126, false, 24, (Buffer)directAttribs.slice());
                        directAttribs.position(0);
                        gl.glVertexAttribPointer(attr1Loc, 3, 5126, false, 24, (Buffer)directAttribs);
                        gl.glDrawArrays(4, 0, directAttribs.capacity() / 24);
                    }
                    finally {
                        gl.glDisableVertexAttribArray(attr1Loc);
                        gl.glDisableVertexAttribArray(attr2Loc);
                    }
                }
            };
            int pushAttribs = 24576;
            this.support.useShaderProgram(this.normalBlend3DProgram, uniforms, operation, pushAttribs, composeBuffer, buffers.toArray(new IVideoBuffer[buffers.size()]));
        }
        finally {
            if (attribs != null) {
                attribs.release();
            }
        }
    }

    private void customBlend3D(final Polygon p, IVideoBuffer composeBuffer) {
        boolean matte;
        Runnable operation = new Runnable(){

            public void run() {
                GL2 gl = VideoLayerComposer.this.context.getGL().getGL2();
                gl.glViewport(0, 0, ((VideoLayerComposer)VideoLayerComposer.this).boundsX.width, ((VideoLayerComposer)VideoLayerComposer.this).boundsX.height);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(VideoLayerComposer.this.camera.getProjection3D(), 0);
                gl.glMatrixMode(5888);
                gl.glLoadIdentity();
                gl.glBegin(9);
                int i = 0;
                int n = p.vertices.size();
                while (i < n) {
                    Point3d vert = (Point3d)p.vertices.get(i);
                    gl.glVertex3f((float)vert.x, (float)vert.y, (float)vert.z);
                    ++i;
                }
                gl.glEnd();
            }
        };
        Set<GLUniformData> uniforms = Util.newSet();
        uniforms.add(new GLUniformData("texDst", 0));
        uniforms.add(new GLUniformData("texSrc", 1));
        uniforms.add(new GLUniformData("opacity", (float)p.entry.opacity));
        uniforms.add(new GLUniformData("dstSize", 2, FloatBuffer.wrap(new float[]{this.boundsX.width, this.boundsX.height})));
        boolean bl = matte = p.entry.matte != null;
        if (matte) {
            uniforms.add(new GLUniformData("texMatte", 2));
        }
        BlendMode blendMode = p.entry.layer.getBlendMode();
        switch (blendMode) {
            case DISSOLVE: {
                uniforms.add(new GLUniformData("dissolveSeed", (float)((double)(p.entry.layer.getId().hashCode() + p.entry.layer.getName().hashCode()) * 100.0 / 2.147483647E9)));
                break;
            }
            case DANCING_DISSOLVE: {
                uniforms.add(new GLUniformData("dissolveSeed", (float)((double)(p.entry.layer.getId().hashCode() + p.entry.layer.getName().hashCode()) * 100.0 / 2.147483647E9 + this.context.getTime().toSecond())));
                blendMode = BlendMode.DISSOLVE;
            }
        }
        VideoBounds b = p.entry.lighted.getBounds();
        uniforms.add(new GLUniformData("srcOffset", 2, FloatBuffer.wrap(new float[]{(float)(-b.x * (double)this.ssScale), (float)(-b.y * (double)this.ssScale)})));
        uniforms.add(new GLUniformData("srcSize", 2, FloatBuffer.wrap(new float[]{b.width * this.ssScale, b.height * this.ssScale})));
        IShaderProgram program = this.getCustomBlend3DProgram(blendMode, matte);
        IVideoBuffer copy = null;
        try {
            copy = this.support.createVideoBuffer(this.boundsX);
            this.support.copy(composeBuffer, copy);
            if (matte) {
                this.support.useShaderProgram(program, uniforms, operation, 0, composeBuffer, new IVideoBuffer[]{copy, p.entry.lighted, p.entry.matte});
            } else {
                this.support.useShaderProgram(program, uniforms, operation, 0, composeBuffer, new IVideoBuffer[]{copy, p.entry.lighted});
            }
        }
        finally {
            if (copy != null) {
                copy.dispose();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void compose2D(ComposeGroup group, IVideoBuffer composeBuffer) {
        entries = Util.newList();
        try {
            numTextures = 0;
            it = ComposeGroup.access$3(group).listIterator();
            while (it.hasNext()) {
                r = (VideoLayerRenderer.GeneralLayerRenderer)it.next();
                blendMode = r.getLayer().getBlendMode();
                if (blendMode == BlendMode.NORMAL) {
                    v0 = incTextures = r.getMatteIds() != null ? 2 : 1;
                    if (incTextures == 2 && numTextures == this.maxTexImageUnits - 1) {
                        it.previous();
                    } else {
                        entries.add(this.render2DLayer(r));
                        if ((numTextures += incTextures) < this.maxTexImageUnits && it.hasNext()) continue;
                    }
                }
                if (!entries.isEmpty()) {
                    this.normalBlend2D(entries, composeBuffer);
                    for (Entry2D entry : entries) {
                        Entry2D.access$0(entry).dispose();
                    }
                    entries.clear();
                    numTextures = 0;
                }
                if (blendMode == BlendMode.NORMAL) continue;
                entry = this.render2DLayer(r);
                try {
                    this.customBlend2D(entry, composeBuffer);
                }
                finally {
                    Entry2D.access$0(entry).dispose();
                }
            }
        }
        finally {
            ** for (entry : entries)
        }
lbl-1000:
        // 1 sources

        {
            Entry2D.access$0(entry).dispose();
            continue;
        }
lbl37:
        // 1 sources

    }

    private Entry2D render2DLayer(final VideoLayerRenderer.GeneralLayerRenderer r) {
        return this.context.saveAndExecute(new WrappedOperation<Entry2D>(){

            @Override
            public Entry2D execute() {
                final MediaLayer layer = r.getLayer();
                MotionBlur mblur = VideoLayerComposer.this.composition.isMotionBlurEnabled() ? LayerNature.getMotionBlur(layer) : MotionBlur.NONE;
                IVideoBuffer source = null;
                IVideoBuffer matte = null;
                try {
                    double opacity;
                    Point3d[] vertices = new Point3d[4];
                    Point2d[] texCoords = new Point2d[4];
                    if (r instanceof VideoLayerRenderer.NormalLayerRenderer) {
                        final VideoLayerRenderer.NormalLayerRenderer nr = (VideoLayerRenderer.NormalLayerRenderer)r;
                        if (mblur == MotionBlur.NONE) {
                            source = nr.render(true, VideoLayerComposer.this.composition.isFrameBlendEnabled());
                            VideoLayerComposer.this.setTextureFilter(source, layer);
                            double[] mvMatrix = new double[16];
                            System.arraycopy(VideoLayerComposer.this.camera.getModelView2D(), 0, mvMatrix, 0, 16);
                            nr.multModelViewMatrix(mvMatrix);
                            VideoLayerComposer.this.transform2DLayerBounds(source.getBounds(), mvMatrix, vertices, texCoords);
                            opacity = nr.getOpacity();
                        } else {
                            MotionBlurSampler2 sampler = new MotionBlurSampler2(){
                                private final double[] mvMatrix = new double[16];

                                public IVideoBuffer sample() {
                                    IVideoBuffer buffer = nr.render(true, VideoLayerComposer.this.composition.isFrameBlendEnabled());
                                    VideoLayerComposer.this.setTextureFilter(buffer, layer);
                                    return buffer;
                                }

                                public double getOpacity() {
                                    return nr.getOpacity();
                                }

                                public void transform(VideoBounds bounds, Point3d[] vertices, Point2d[] texCoords) {
                                    System.arraycopy(VideoLayerComposer.this.camera.getModelView2D(), 0, this.mvMatrix, 0, 16);
                                    nr.multModelViewMatrix(this.mvMatrix);
                                    VideoLayerComposer.this.transform2DLayerBounds(bounds, this.mvMatrix, vertices, texCoords);
                                }
                            };
                            source = VideoLayerComposer.this.motionBlur2(mblur, sampler);
                            VideoBounds b = source.getBounds();
                            vertices[0] = new Point3d(b.x, b.y, 0.0);
                            vertices[1] = new Point3d(b.x + (double)b.width, b.y, 0.0);
                            vertices[2] = new Point3d(b.x + (double)b.width, b.y + (double)b.height, 0.0);
                            vertices[3] = new Point3d(b.x, b.y + (double)b.height, 0.0);
                            texCoords[0] = new Point2d(0.0, 0.0);
                            texCoords[1] = new Point2d(1.0, 0.0);
                            texCoords[2] = new Point2d(1.0, 1.0);
                            texCoords[3] = new Point2d(0.0, 1.0);
                            opacity = 1.0;
                        }
                    } else {
                        final VideoLayerRenderer.CRLayerRenderer crr = (VideoLayerRenderer.CRLayerRenderer)r;
                        if (mblur == MotionBlur.NONE) {
                            double[] mvMatrix = new double[16];
                            System.arraycopy(VideoLayerComposer.this.camera.getModelView2D(), 0, mvMatrix, 0, 16);
                            crr.multModelViewMatrix(mvMatrix);
                            source = crr.render(true, VideoLayerComposer.this.bounds, mvMatrix, VideoLayerComposer.this.camera.getProjection2D());
                            opacity = crr.getOpacity();
                        } else {
                            source = VideoLayerComposer.this.motionBlur1(null, new MotionBlurSampler1(){
                                private final double[] mvMatrix = new double[16];

                                public IVideoBuffer sample() {
                                    System.arraycopy(VideoLayerComposer.this.camera.getModelView2D(), 0, this.mvMatrix, 0, 16);
                                    crr.multModelViewMatrix(this.mvMatrix);
                                    return crr.render(true, VideoLayerComposer.this.bounds, this.mvMatrix, VideoLayerComposer.this.camera.getProjection2D());
                                }

                                public double getOpacity() {
                                    return crr.getOpacity();
                                }
                            });
                            opacity = 1.0;
                        }
                        VideoBounds b = source.getBounds();
                        vertices[0] = new Point3d(b.x, b.y, 0.0);
                        vertices[1] = new Point3d(b.x + (double)b.width, b.y, 0.0);
                        vertices[2] = new Point3d(b.x + (double)b.width, b.y + (double)b.height, 0.0);
                        vertices[3] = new Point3d(b.x, b.y + (double)b.height, 0.0);
                        texCoords[0] = new Point2d(0.0, 0.0);
                        texCoords[1] = new Point2d(1.0, 0.0);
                        texCoords[2] = new Point2d(1.0, 1.0);
                        texCoords[3] = new Point2d(0.0, 1.0);
                    }
                    matte = VideoLayerComposer.this.renderMatte(r);
                    Entry2D entry = new Entry2D(layer, source, matte, vertices, texCoords, opacity);
                    source = null;
                    matte = null;
                    Entry2D entry2D = entry;
                    return entry2D;
                }
                finally {
                    if (source != null) {
                        source.dispose();
                    }
                    if (matte != null) {
                        matte.dispose();
                    }
                }
            }
        });
    }

    private void transform2DLayerBounds(VideoBounds b, double[] mvMatrix, Point3d[] vertices, Point2d[] texCoords) {
        double expand = 16.0;
        double ex = expand / (double)b.width;
        double ey = expand / (double)b.height;
        vertices[0] = new Point3d(b.x - expand, b.y - expand, 0.0);
        vertices[1] = new Point3d(b.x + (double)b.width + expand, b.y - expand, 0.0);
        vertices[2] = new Point3d(b.x + (double)b.width + expand, b.y + (double)b.height + expand, 0.0);
        vertices[3] = new Point3d(b.x - expand, b.y + (double)b.height + expand, 0.0);
        Matrix4d m = new Matrix4d(mvMatrix);
        m.transpose();
        m.transform(vertices[0]);
        m.transform(vertices[1]);
        m.transform(vertices[2]);
        m.transform(vertices[3]);
        texCoords[0] = new Point2d(-ex, -ey);
        texCoords[1] = new Point2d(1.0 + ex, -ey);
        texCoords[2] = new Point2d(1.0 + ex, 1.0 + ey);
        texCoords[3] = new Point2d(-ex, 1.0 + ey);
    }

    private void normalBlend2D(List<Entry2D> entries, IVideoBuffer composeBuffer) {
        IArray attribs = null;
        try {
            attribs = this.arrayPools.getFloatArray(entries.size() * 4 * 7);
            float[] array = (float[])attribs.getArray();
            List<IVideoBuffer> buffers = Util.newList();
            int k = 0;
            for (Entry2D entry : entries) {
                int sourceIndex = buffers.size();
                buffers.add(entry.source);
                int matteIndex = -1;
                if (entry.matte != null) {
                    matteIndex = buffers.size();
                    buffers.add(entry.matte);
                }
                int i = 0;
                while (i < 4) {
                    array[k++] = (float)((Entry2D)entry).vertices[i].x;
                    array[k++] = (float)((Entry2D)entry).vertices[i].y;
                    array[k++] = (float)entry.opacity;
                    array[k++] = (float)((Entry2D)entry).texCoords[i].x;
                    array[k++] = (float)((Entry2D)entry).texCoords[i].y;
                    array[k++] = (float)sourceIndex + 0.5f;
                    array[k++] = (float)matteIndex + 0.5f;
                    ++i;
                }
            }
            final ByteBuffer directAttribs = ByteBuffer.allocateDirect(attribs.getLength() * 4);
            directAttribs.order(ByteOrder.nativeOrder());
            directAttribs.asFloatBuffer().put((float[])attribs.getArray(), 0, attribs.getLength());
            Set<GLUniformData> uniforms = Util.newSet();
            int i = 0;
            int n = buffers.size();
            while (i < n) {
                uniforms.add(new GLUniformData("texture" + i, i));
                ++i;
            }
            uniforms.add(new GLUniformData("dstSize", 2, FloatBuffer.wrap(new float[]{this.bounds.width, this.bounds.height})));
            Runnable operation = new Runnable(){

                public void run() {
                    GL2 gl = VideoLayerComposer.this.context.getGL().getGL2();
                    gl.glViewport(0, 0, ((VideoLayerComposer)VideoLayerComposer.this).bounds.width, ((VideoLayerComposer)VideoLayerComposer.this).bounds.height);
                    gl.glMatrixMode(5889);
                    gl.glLoadMatrixd(VideoLayerComposer.this.camera.getProjection2D(), 0);
                    gl.glMatrixMode(5888);
                    gl.glLoadIdentity();
                    gl.glEnable(3042);
                    gl.glBlendFunc(1, 771);
                    gl.glBlendEquation(32774);
                    int attr1Loc = VideoLayerComposer.this.normalBlend2DProgram.getAttributeLocation("attr1");
                    int attr2Loc = VideoLayerComposer.this.normalBlend2DProgram.getAttributeLocation("attr2");
                    try {
                        gl.glEnableVertexAttribArray(attr1Loc);
                        gl.glEnableVertexAttribArray(attr2Loc);
                        directAttribs.position(12);
                        gl.glVertexAttribPointer(attr2Loc, 4, 5126, false, 28, (Buffer)directAttribs.slice());
                        directAttribs.position(0);
                        gl.glVertexAttribPointer(attr1Loc, 3, 5126, false, 28, (Buffer)directAttribs);
                        gl.glDrawArrays(7, 0, directAttribs.capacity() / 28);
                    }
                    finally {
                        gl.glDisableVertexAttribArray(attr1Loc);
                        gl.glDisableVertexAttribArray(attr2Loc);
                    }
                }
            };
            int pushAttribs = 24576;
            this.support.useShaderProgram(this.normalBlend2DProgram, uniforms, operation, pushAttribs, composeBuffer, buffers.toArray(new IVideoBuffer[buffers.size()]));
        }
        finally {
            if (attribs != null) {
                attribs.release();
            }
        }
    }

    private void customBlend2D(final Entry2D entry, IVideoBuffer composeBuffer) {
        boolean matte;
        Runnable operation = new Runnable(){

            public void run() {
                GL2 gl = VideoLayerComposer.this.context.getGL().getGL2();
                switch (entry.layer.getBlendMode()) {
                    case STENCIL_ALPHA: 
                    case STENCIL_LUMA: {
                        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                        gl.glClear(16384);
                    }
                }
                gl.glViewport(0, 0, ((VideoLayerComposer)VideoLayerComposer.this).bounds.width, ((VideoLayerComposer)VideoLayerComposer.this).bounds.height);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(VideoLayerComposer.this.camera.getProjection2D(), 0);
                gl.glMatrixMode(5888);
                gl.glLoadIdentity();
                gl.glBegin(7);
                int i = 0;
                while (i < 4) {
                    gl.glTexCoord2f((float)((Entry2D)entry).texCoords[i].x, (float)((Entry2D)entry).texCoords[i].y);
                    gl.glVertex2f((float)((Entry2D)entry).vertices[i].x, (float)((Entry2D)entry).vertices[i].y);
                    ++i;
                }
                gl.glEnd();
            }
        };
        Set<GLUniformData> uniforms = Util.newSet();
        uniforms.add(new GLUniformData("texDst", 0));
        uniforms.add(new GLUniformData("texSrc", 1));
        uniforms.add(new GLUniformData("opacity", (float)entry.opacity));
        uniforms.add(new GLUniformData("dstSize", 2, FloatBuffer.wrap(new float[]{this.bounds.width, this.bounds.height})));
        boolean bl = matte = entry.matte != null;
        if (matte) {
            uniforms.add(new GLUniformData("texMatte", 2));
        }
        BlendMode blendMode = entry.layer.getBlendMode();
        switch (blendMode) {
            case DISSOLVE: {
                uniforms.add(new GLUniformData("dissolveSeed", (float)((double)(entry.layer.getId().hashCode() + entry.layer.getName().hashCode()) * 100.0 / 2.147483647E9)));
                break;
            }
            case DANCING_DISSOLVE: {
                uniforms.add(new GLUniformData("dissolveSeed", (float)((double)(entry.layer.getId().hashCode() + entry.layer.getName().hashCode()) * 100.0 / 2.147483647E9 + this.context.getTime().toSecond())));
                blendMode = BlendMode.DISSOLVE;
            }
        }
        IShaderProgram program = this.getCustomBlend2DProgram(blendMode, matte);
        int pushAttribs = 16384;
        IVideoBuffer copy = null;
        try {
            copy = this.support.createVideoBuffer(this.bounds);
            this.support.copy(composeBuffer, copy);
            if (matte) {
                this.support.useShaderProgram(program, uniforms, operation, pushAttribs, composeBuffer, new IVideoBuffer[]{copy, entry.source, entry.matte});
            } else {
                this.support.useShaderProgram(program, uniforms, operation, pushAttribs, composeBuffer, new IVideoBuffer[]{copy, entry.source});
            }
        }
        finally {
            if (copy != null) {
                copy.dispose();
            }
        }
    }

    private void setTextureFilter(IVideoBuffer buffer, MediaLayer layer) {
        Quality quality = LayerNature.getQuality(layer);
        switch (quality) {
            case BEST: {
                buffer.setTextureFilter(IVideoBuffer.TextureFilter.MIPMAP);
                break;
            }
            case NORMAL: {
                buffer.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
                break;
            }
            case DRAFT: {
                buffer.setTextureFilter(IVideoBuffer.TextureFilter.NEAREST);
                break;
            }
            default: {
                throw new RuntimeException("unknown quality: " + (Object)((Object)quality));
            }
        }
    }

    private <V> V getValue(AnimatableValue<V> avalue) {
        Object value;
        Time time = this.context.getTime();
        Map<Object, Object> map = this.valueCache.get(avalue);
        if (map != null) {
            value = map.get(time);
            if (value != null) {
                return (V)value;
            }
        } else {
            map = Util.newMap();
            this.valueCache.put(avalue, map);
        }
        value = avalue.value(this.context);
        map.put(time, value);
        return (V)value;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IVideoBuffer renderMatte(VideoLayerRenderer.GeneralLayerRenderer renderer) {
        matteIds = renderer.getMatteIds();
        if (matteIds == null) {
            return null;
        }
        cacheKeySb = new StringBuilder(matteIds.get(0));
        for (String matteId : matteIds.subList(1, matteIds.size())) {
            cacheKeySb.append(":").append(matteId);
        }
        cacheKey = cacheKeySb.toString();
        buffer = this.matteBufferCache.get(cacheKey);
        if (buffer != null) {
            return buffer;
        }
        buffers = Util.newList();
        trackMattes = Util.newList();
        try {
            buffer = this.support.createVideoBuffer(this.bounds);
            buffer.clear(Color.WHITE);
            it = matteIds.iterator();
            while (it.hasNext()) {
                mlr = this.matteLayerRenderers.get(it.next());
                buffers.add(this.context.saveAndExecute(new WrappedOperation<IVideoBuffer>(){

                    @Override
                    public IVideoBuffer execute() {
                        VideoLayerComposer.this.context.setTime(VideoLayerComposer.this.baseTime);
                        VideoLayerComposer composer = new VideoLayerComposer(VideoLayerComposer.this.context, VideoLayerComposer.this.support, VideoLayerComposer.this.accumSupport, VideoLayerComposer.this.convolution, VideoLayerComposer.this.blurSupport, VideoLayerComposer.this.arrayPools, VideoLayerComposer.this.shaders, VideoLayerComposer.this.glGlobal);
                        composer.addLayerRenderers(mlr.getRenderers());
                        return composer.compose();
                    }
                }));
                trackMattes.add(mlr.getLayer().getTrackMatte());
                if (buffers.size() != this.maxTexImageUnits && it.hasNext()) continue;
                this.matteMultiply(buffer, buffers, trackMattes);
                for (IVideoBuffer vb : buffers) {
                    vb.dispose();
                }
                buffers.clear();
                trackMattes.clear();
            }
            this.matteBufferCache.put(cacheKey, buffer);
            result = buffer;
            buffer = null;
            var13_12 = result;
            return var13_12;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
            ** for (vb : buffers)
        }
lbl-1000:
        // 1 sources

        {
            vb.dispose();
            continue;
        }
lbl45:
        // 1 sources

        return var13_12;
    }

    private void matteMultiply(IVideoBuffer dstBuffer, List<IVideoBuffer> buffers, List<TrackMatte> trackMattes) {
        Runnable operation = new Runnable(){

            public void run() {
                GL2 gl = VideoLayerComposer.this.context.getGL().getGL2();
                gl.glEnable(3042);
                gl.glBlendFunc(0, 770);
                gl.glBlendEquation(32774);
                VideoLayerComposer.this.support.ortho2D(VideoLayerComposer.this.bounds);
                VideoLayerComposer.this.support.quad2D(VideoLayerComposer.this.bounds, (double[][][])new double[0][][]);
            }
        };
        Set<GLUniformData> uniforms = Util.newSet();
        float[] trackMattesData = new float[buffers.size()];
        int i = 0;
        int n = buffers.size();
        while (i < n) {
            uniforms.add(new GLUniformData("texture" + i, i));
            trackMattesData[i] = (float)trackMattes.get(i).ordinal() + 0.5f;
            ++i;
        }
        uniforms.add(new GLUniformData("trackMattes[0]", 1, FloatBuffer.wrap(trackMattesData)));
        uniforms.add(new GLUniformData("numMattes", trackMattesData.length));
        uniforms.add(new GLUniformData("size", 2, FloatBuffer.wrap(new float[]{this.bounds.width, this.bounds.height})));
        int pushAttribs = 24576;
        this.support.useShaderProgram(this.matteMultiplyProgram, uniforms, operation, pushAttribs, dstBuffer, buffers.toArray(new IVideoBuffer[buffers.size()]));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IVideoBuffer motionBlur1(IVideoBuffer dstBuffer, MotionBlurSampler1 sampler) {
        accumBuf = null;
        buffers = Util.newList();
        try {
            ctxColorMode = this.context.getColorMode();
            dstBounds = dstBuffer != null ? dstBuffer.getBounds() : this.bounds;
            accumBuf = ctxColorMode.isFloat() != false ? this.support.createVideoBuffer(dstBounds) : this.support.createVideoBuffer(dstBounds, ColorMode.RGBA16_FLOAT);
            accumBuf.clear();
            shutterAngle = this.composition.getMotionBlurShutterAngle();
            shutterPhase = this.composition.getMotionBlurShutterPhase();
            samples = this.composition.getMotionBlurSamples();
            baseTime = this.context.getTime();
            frameDuration = this.context.getVideoFrameDuration();
            weights = Util.newList();
            maxSources = this.accumSupport.getMaxSourcesAtATime();
            i = 0;
            while (i < samples) {
                angle = shutterPhase + shutterAngle * (double)i / (double)samples;
                time = baseTime.add(new Time((long)((double)frameDuration.timeValue * angle / 360.0), frameDuration.timeScale));
                this.context.setTime(time);
                buffers.add(sampler.sample());
                weights.add(sampler.getOpacity() / (double)samples);
                if (buffers.size() == maxSources || i == samples - 1) {
                    this.accumSupport.accumulate(buffers, weights, accumBuf);
                    for (IVideoBuffer vb : buffers) {
                        vb.dispose();
                    }
                    buffers.clear();
                    weights.clear();
                }
                ++i;
            }
            if (accumBuf.getColorMode() == ctxColorMode) {
                dstBuffer = accumBuf;
                accumBuf = null;
            } else if (dstBuffer != null) {
                this.support.copy(accumBuf, dstBuffer);
            } else {
                copy = null;
                try {
                    copy = this.support.createVideoBuffer(dstBounds);
                    this.support.copy(accumBuf, copy);
                    dstBuffer = copy;
                    copy = null;
                }
                finally {
                    if (copy != null) {
                        copy.dispose();
                    }
                }
            }
            var23_21 = dstBuffer;
            return var23_21;
        }
        finally {
            this.context.setTime(this.baseTime);
            ** for (vb : buffers)
        }
lbl-1000:
        // 1 sources

        {
            vb.dispose();
            continue;
        }
lbl59:
        // 1 sources

        if (accumBuf == null) return var23_21;
        accumBuf.dispose();
        return var23_21;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IVideoBuffer motionBlur2(MotionBlur mblur, MotionBlurSampler2 sampler) {
        if (mblur == MotionBlur.NONE) {
            throw new IllegalArgumentException();
        }
        accumBuf = null;
        buffers = Util.newList();
        try {
            ctxColorMode = this.context.getColorMode();
            accumBuf = ctxColorMode.isFloat() != false ? this.support.createVideoBuffer(this.bounds) : this.support.createVideoBuffer(this.bounds, ColorMode.RGBA16_FLOAT);
            accumBuf.clear();
            shutterAngle = this.composition.getMotionBlurShutterAngle();
            shutterPhase = this.composition.getMotionBlurShutterPhase();
            samples = this.composition.getMotionBlurSamples();
            baseTime = this.context.getTime();
            frameDuration = this.context.getVideoFrameDuration();
            verticesList = Util.newList();
            texCoordsList = Util.newList();
            weightList = Util.newList();
            block2 : switch (VideoLayerComposer.$SWITCH_TABLE$ch$kuramo$javie$core$MotionBlur()[mblur.ordinal()]) {
                case 2: {
                    buffer = sampler.sample();
                    buffers.add(buffer);
                    i = 0;
                    while (true) {
                        if (i >= samples) {
                            this.motionBlur2Accumulate1(accumBuf, buffer, verticesList, texCoordsList, weightList);
                            break block2;
                        }
                        angle = shutterPhase + shutterAngle * (double)i / (double)samples;
                        time = baseTime.add(new Time((long)((double)frameDuration.timeValue * angle / 360.0), frameDuration.timeScale));
                        this.context.setTime(time);
                        vertices = new Point3d[4];
                        texCoords = new Point2d[4];
                        sampler.transform(buffer.getBounds(), vertices, texCoords);
                        verticesList.add(vertices);
                        texCoordsList.add(texCoords);
                        weightList.add(sampler.getOpacity() / (double)samples);
                        ++i;
                    }
                }
                case 3: {
                    i = 0;
                    while (i < samples) {
                        angle = shutterPhase + shutterAngle * (double)i / (double)samples;
                        time = baseTime.add(new Time((long)((double)frameDuration.timeValue * angle / 360.0), frameDuration.timeScale));
                        this.context.setTime(time);
                        buffer = sampler.sample();
                        buffers.add(buffer);
                        vertices = new Point3d[4];
                        texCoords = new Point2d[4];
                        sampler.transform(buffer.getBounds(), vertices, texCoords);
                        verticesList.add(vertices);
                        texCoordsList.add(texCoords);
                        weightList.add(sampler.getOpacity() / (double)samples);
                        if (buffers.size() == this.maxTexImageUnits || i == samples - 1) {
                            this.motionBlur2Accumulate2(accumBuf, buffers, verticesList, texCoordsList, weightList);
                            var24_26 = buffers.iterator();
                            while (true) {
                                if (!var24_26.hasNext()) {
                                    buffers.clear();
                                    break;
                                }
                                vb = var24_26.next();
                                vb.dispose();
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
            if (accumBuf.getColorMode() == ctxColorMode) {
                result = accumBuf;
                accumBuf = null;
            } else {
                copy = null;
                try {
                    copy = this.support.createVideoBuffer(this.bounds);
                    this.support.copy(accumBuf, copy);
                    result = copy;
                    copy = null;
                }
                finally {
                    if (copy != null) {
                        copy.dispose();
                    }
                }
            }
            var26_27 = result;
            return var26_27;
        }
        finally {
            this.context.setTime(this.baseTime);
            ** for (vb : buffers)
        }
lbl-1000:
        // 1 sources

        {
            vb.dispose();
            continue;
        }
lbl95:
        // 1 sources

        if (accumBuf == null) return var26_27;
        accumBuf.dispose();
        return var26_27;
    }

    private void motionBlur2Accumulate1(IVideoBuffer accumBuffer, IVideoBuffer srcBuffer, final List<Point3d[]> verticesList, final List<Point2d[]> texCoordsList, final List<Double> weightList) {
        Runnable operation = new Runnable(){

            public void run() {
                GL2 gl = VideoLayerComposer.this.context.getGL().getGL2();
                gl.glViewport(0, 0, ((VideoLayerComposer)VideoLayerComposer.this).bounds.width, ((VideoLayerComposer)VideoLayerComposer.this).bounds.height);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(VideoLayerComposer.this.camera.getProjection2D(), 0);
                gl.glMatrixMode(5888);
                gl.glLoadIdentity();
                gl.glEnable(3042);
                gl.glBlendFunc(1, 1);
                gl.glBlendEquation(32774);
                gl.glBegin(7);
                int i = 0;
                int n = verticesList.size();
                while (i < n) {
                    Point3d[] vertices = (Point3d[])verticesList.get(i);
                    Point2d[] texCoords = (Point2d[])texCoordsList.get(i);
                    float weight = ((Double)weightList.get(i)).floatValue();
                    int j = 0;
                    while (j < 4) {
                        gl.glColor4f(weight, weight, weight, weight);
                        gl.glTexCoord2f((float)texCoords[j].x, (float)texCoords[j].y);
                        gl.glVertex2f((float)vertices[j].x, (float)vertices[j].y);
                        ++j;
                    }
                    ++i;
                }
                gl.glEnd();
            }
        };
        int pushAttribs = 24577;
        this.support.useFramebuffer(operation, pushAttribs, accumBuffer, new IVideoBuffer[]{srcBuffer});
    }

    private void motionBlur2Accumulate2(IVideoBuffer accumBuffer, List<IVideoBuffer> srcBuffers, List<Point3d[]> verticesList, List<Point2d[]> texCoordsList, List<Double> weightList) {
        IArray attribs = null;
        try {
            attribs = this.arrayPools.getFloatArray(srcBuffers.size() * 4 * 6);
            float[] array = (float[])attribs.getArray();
            List<IVideoBuffer> buffers = Util.newList();
            int i = 0;
            int k = 0;
            int n = srcBuffers.size();
            while (i < n) {
                Point3d[] vertices = verticesList.get(i);
                Point2d[] texCoords = texCoordsList.get(i);
                float weight = weightList.get(i).floatValue();
                int j = 0;
                while (j < 4) {
                    array[k++] = (float)vertices[j].x;
                    array[k++] = (float)vertices[j].y;
                    array[k++] = weight;
                    array[k++] = (float)texCoords[j].x;
                    array[k++] = (float)texCoords[j].y;
                    array[k++] = (float)i + 0.5f;
                    ++j;
                }
                buffers.add(srcBuffers.get(i));
                ++i;
            }
            final ByteBuffer directAttribs = ByteBuffer.allocateDirect(attribs.getLength() * 4);
            directAttribs.order(ByteOrder.nativeOrder());
            directAttribs.asFloatBuffer().put((float[])attribs.getArray(), 0, attribs.getLength());
            Set<GLUniformData> uniforms = Util.newSet();
            int i2 = 0;
            int n2 = buffers.size();
            while (i2 < n2) {
                uniforms.add(new GLUniformData("texture" + i2, i2));
                ++i2;
            }
            Runnable operation = new Runnable(){

                public void run() {
                    GL2 gl = VideoLayerComposer.this.context.getGL().getGL2();
                    gl.glViewport(0, 0, ((VideoLayerComposer)VideoLayerComposer.this).bounds.width, ((VideoLayerComposer)VideoLayerComposer.this).bounds.height);
                    gl.glMatrixMode(5889);
                    gl.glLoadMatrixd(VideoLayerComposer.this.camera.getProjection2D(), 0);
                    gl.glMatrixMode(5888);
                    gl.glLoadIdentity();
                    gl.glEnable(3042);
                    gl.glBlendFunc(1, 1);
                    gl.glBlendEquation(32774);
                    int attr1Loc = VideoLayerComposer.this.mblur2Accum2Program.getAttributeLocation("attr1");
                    int attr2Loc = VideoLayerComposer.this.mblur2Accum2Program.getAttributeLocation("attr2");
                    try {
                        gl.glEnableVertexAttribArray(attr1Loc);
                        gl.glEnableVertexAttribArray(attr2Loc);
                        directAttribs.position(12);
                        gl.glVertexAttribPointer(attr2Loc, 3, 5126, false, 24, (Buffer)directAttribs.slice());
                        directAttribs.position(0);
                        gl.glVertexAttribPointer(attr1Loc, 3, 5126, false, 24, (Buffer)directAttribs);
                        gl.glDrawArrays(7, 0, directAttribs.capacity() / 24);
                    }
                    finally {
                        gl.glDisableVertexAttribArray(attr1Loc);
                        gl.glDisableVertexAttribArray(attr2Loc);
                    }
                }
            };
            int pushAttribs = 24576;
            this.support.useShaderProgram(this.mblur2Accum2Program, uniforms, operation, pushAttribs, accumBuffer, buffers.toArray(new IVideoBuffer[buffers.size()]));
        }
        finally {
            if (attribs != null) {
                attribs.release();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Point3d[] unProjectViewport(double[] mvMatrix) {
        boolean y;
        boolean x;
        Point3d p;
        Point3d p1;
        Point3d p0;
        int i;
        Vector3d v;
        List<Point3d> list;
        Point3d[][] frustumEdges;
        block7: {
            double[] prjMatrix = this.camera.getProjection3D();
            int w = this.boundsX.width;
            int h = this.boundsX.height;
            int[] nArray = new int[4];
            nArray[2] = w;
            nArray[3] = h;
            int[] viewport = nArray;
            double[][] unprj = new double[8][3];
            GLU glu = this.context.getGLU();
            glu.gluUnProject(0.0, 0.0, 0.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[0], 0);
            glu.gluUnProject(0.0, 0.0, 1.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[1], 0);
            glu.gluUnProject((double)w, 0.0, 0.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[2], 0);
            glu.gluUnProject((double)w, 0.0, 1.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[3], 0);
            glu.gluUnProject((double)w, (double)h, 0.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[4], 0);
            glu.gluUnProject((double)w, (double)h, 1.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[5], 0);
            glu.gluUnProject(0.0, (double)h, 0.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[6], 0);
            glu.gluUnProject(0.0, (double)h, 1.0, mvMatrix, 0, prjMatrix, 0, viewport, 0, unprj[7], 0);
            Point3d[] frustumVertices = new Point3d[8];
            int i2 = 0;
            while (i2 < 8) {
                frustumVertices[i2] = new Point3d(unprj[i2]);
                ++i2;
            }
            frustumEdges = new Point3d[12][2];
            int i3 = 0;
            while (i3 < 12) {
                frustumEdges[i3][0] = frustumVertices[frustumEdgeTable[i3][0]];
                frustumEdges[i3][1] = frustumVertices[frustumEdgeTable[i3][1]];
                ++i3;
            }
            list = Util.newList();
            v = new Vector3d();
            i = 0;
            while (i < 12) {
                p0 = frustumEdges[i][0];
                p1 = frustumEdges[i][1];
                v.sub((Tuple3d)p1, (Tuple3d)p0);
                p = new Point3d(p0.x - v.x / v.z * p0.z, p0.y - v.y / v.z * p0.z, 0.0);
                x = p0.x <= p.x && p.x <= p1.x || p1.x <= p.x && p.x <= p0.x;
                boolean bl = y = p0.y <= p.y && p.y <= p1.y || p1.y <= p.y && p.y <= p0.y;
                if (!x || !y) {
                    ++i;
                    continue;
                }
                break block7;
            }
            return list.toArray(new Point3d[list.size()]);
        }
        list.add(p);
        block3: while (true) {
            int j = 0;
            while (j < 6) {
                int k = frustumClipSearchTable[i][j];
                p0 = frustumEdges[k][0];
                p1 = frustumEdges[k][1];
                v.sub((Tuple3d)p1, (Tuple3d)p0);
                p = new Point3d(p0.x - v.x / v.z * p0.z, p0.y - v.y / v.z * p0.z, 0.0);
                x = p0.x <= p.x && p.x <= p1.x || p1.x <= p.x && p.x <= p0.x;
                boolean bl = y = p0.y <= p.y && p.y <= p1.y || p1.y <= p.y && p.y <= p0.y;
                if (x && y && !list.contains(p)) {
                    list.add(p);
                    i = k;
                    continue block3;
                }
                ++j;
            }
            break;
        }
        return list.toArray(new Point3d[list.size()]);
    }

    private List<Polygon> partitionPolygons(List<Polygon> polygons) {
        if (polygons.isEmpty()) {
            return polygons;
        }
        Iterator<Polygon> it = polygons.iterator();
        Polygon base = it.next();
        List<Polygon> near = Util.newList();
        List<Polygon> far = Util.newList();
        while (it.hasNext()) {
            Polygon target = it.next();
            this.partitionPolygons(base, target, near, far, null);
        }
        near = this.partitionPolygons(near);
        far = this.partitionPolygons(far);
        far.add(base);
        far.addAll(near);
        return far;
    }

    private void partitionPolygons(Polygon base, Polygon target, List<Polygon> near, List<Polygon> far, Vec3d lightPos) {
        double signum = lightPos != null ? Math.signum(((Entry3D)((Polygon)base).entry).plane.x * lightPos.x + ((Entry3D)((Polygon)base).entry).plane.y * lightPos.y + ((Entry3D)((Polygon)base).entry).plane.z * lightPos.z + ((Entry3D)((Polygon)base).entry).plane.w) : Math.signum(((Entry3D)((Polygon)base).entry).plane.w);
        if (!this.partitionPolygons(base.entry.plane, signum, target, near, far)) {
            Matrix4d mat = new Matrix4d(base.entry.mvMatrix);
            Point3d p0 = new Point3d(0.0, 0.0, -1000000.0);
            mat.transform(p0);
            double signum0 = Math.signum(base.entry.plane.dot(new Vector4d(p0.x, p0.y, p0.z, 1.0)));
            if (signum == signum0 ^ base.entry.indexInGroup < target.entry.indexInGroup) {
                far.add(target);
            } else {
                near.add(target);
            }
        }
    }

    /*
     * Iterators could be improved
     * Unable to fully structure code
     */
    private boolean partitionPolygons(Vector4d plane, double signum, Polygon target, List<Polygon> near, List<Polygon> far) {
        d = 0.0;
        for (Point3d pt : Polygon.access$3(target)) {
            dd = plane.dot(new Vector4d(pt.x, pt.y, pt.z, 1.0));
            if (!(Math.abs(dd) > Math.abs(d))) continue;
            d = dd;
        }
        if (Math.abs(d) < 0.001) {
            return false;
        }
        vertices = Util.newList(Polygon.access$3(target));
        vertIndex1 = -1;
        vertIndex2 = -1;
        i1 = 0;
        while (i1 < vertices.size()) {
            block14: {
                block15: {
                    block16: {
                        i2 = (i1 + 1) % vertices.size();
                        vert1 = (Point3d)vertices.get(i1);
                        vert2 = (Point3d)vertices.get(i2);
                        d1 = plane.dot(new Vector4d(vert1.x, vert1.y, vert1.z, 1.0));
                        d2 = plane.dot(new Vector4d(vert2.x, vert2.y, vert2.z, 1.0));
                        if (Math.signum(d1) == Math.signum(d2)) break block14;
                        if (!(Math.abs(d1) < 0.001)) break block15;
                        if (vertIndex1 != -1) break block16;
                        vertIndex1 = i1;
                        break block14;
                    }
                    vertIndex2 = i1;
                    break;
                }
                if (!(Math.abs(d2) < 0.001)) ** GOTO lbl34
                if (vertIndex1 == -1) {
                    vertIndex1 = ++i1;
                } else {
                    vertIndex2 = i1 + 1;
                    break;
lbl34:
                    // 1 sources

                    v = new Vector3d();
                    v.sub((Tuple3d)vert2, (Tuple3d)vert1);
                    t = -d1 / plane.dot(new Vector4d((Tuple3d)v));
                    v.scale(t);
                    vertNew = new Point3d();
                    vertNew.add((Tuple3d)vert1, (Tuple3d)v);
                    vertices.add(i1 + 1, vertNew);
                    if (vertIndex1 == -1) {
                        vertIndex1 = ++i1;
                    } else {
                        vertIndex2 = i1 + 1;
                        break;
                    }
                }
            }
            ++i1;
        }
        if (vertIndex2 == -1 || vertIndex2 - vertIndex1 <= 1 || vertIndex2 - vertIndex1 >= vertices.size() - 1) {
            d = 0.0;
            for (Point3d pt : vertices) {
                dd = plane.dot(new Vector4d(pt.x, pt.y, pt.z, 1.0));
                if (!(Math.abs(dd) > Math.abs(d))) continue;
                d = dd;
            }
            if (Math.signum(d) == signum) {
                near.add(target);
            } else {
                far.add(target);
            }
            return true;
        }
        vertices.add((Point3d)vertices.get(0));
        vertices1 = Util.newList(vertices.subList(0, vertIndex1 + 1));
        vertices2 = Util.newList(vertices.subList(vertIndex1, vertIndex2 + 1));
        vertices1.addAll(vertices.subList(vertIndex2, vertices.size() - 1));
        p1 = new Polygon(Polygon.access$1(target), vertices1);
        p2 = new Polygon(Polygon.access$1(target), vertices2);
        d = 0.0;
        for (Point3d pt : vertices1) {
            dd = plane.dot(new Vector4d(pt.x, pt.y, pt.z, 1.0));
            if (!(Math.abs(dd) > Math.abs(d))) continue;
            d = dd;
        }
        if (Math.signum(d) == signum) {
            near.add(p1);
            far.add(p2);
        } else {
            near.add(p2);
            far.add(p1);
        }
        return true;
    }

    private IVideoBuffer magnifyForSuperSampling(IVideoBuffer input) {
        IVideoBuffer output = null;
        try {
            Runnable operation = new Runnable(){

                public void run() {
                    GL2 gl = VideoLayerComposer.this.context.getGL().getGL2();
                    gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                    VideoLayerComposer.this.support.ortho2D(VideoLayerComposer.this.boundsX);
                    VideoLayerComposer.this.support.quad2D(VideoLayerComposer.this.boundsX, (double[][][])new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}}});
                }
            };
            output = this.support.createVideoBuffer(this.boundsX);
            this.support.useFramebuffer(operation, 1, output, new IVideoBuffer[]{input});
            IVideoBuffer result = output;
            output = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (output != null) {
                output.dispose();
            }
        }
    }

    private void downSample(IVideoBuffer input, IVideoBuffer output) {
        VideoBounds bin = input.getBounds();
        final VideoBounds bout = output.getBounds();
        if (bin.width != bout.width * this.ssScale || bin.height != bout.height * this.ssScale) {
            throw new IllegalArgumentException();
        }
        float[] kernel = new float[this.ssScale * this.ssScale];
        float[] offset = new float[kernel.length * 2];
        int j = 0;
        while (j < this.ssScale) {
            int i = 0;
            while (i < this.ssScale) {
                int k = j * this.ssScale + i;
                kernel[k] = 1.0f / (float)kernel.length;
                offset[k * 2] = (float)((double)i - (double)this.ssScale * 0.5 + 0.5) / (float)bin.width;
                offset[k * 2 + 1] = (float)((double)j - (double)this.ssScale * 0.5 + 0.5) / (float)bin.height;
                ++i;
            }
            ++j;
        }
        Runnable operation = new Runnable(){

            public void run() {
                VideoLayerComposer.this.support.ortho2D(bout);
                VideoLayerComposer.this.support.quad2D(bout, (double[][][])new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}}});
            }
        };
        this.convolution.convolve(input, output, kernel, offset, operation, 0);
    }

    private void createReadTextureFunction() {
        IShaderSourceFactory factory = new IShaderSourceFactory(){

            public String getName() {
                return String.valueOf(VideoLayerComposer.class.getName()) + ".read_texture";
            }

            public ShaderType getType() {
                return ShaderType.FRAGMENT_SHADER;
            }

            public boolean isProgram() {
                return false;
            }

            public String[] getAttach() {
                return new String[0];
            }

            public String[] getSource() {
                List<String> list = Util.newList();
                int i = 0;
                while (i < VideoLayerComposer.this.maxTexImageUnits) {
                    list.add(String.format("uniform sampler2D texture%d;", i));
                    ++i;
                }
                list.addAll(Arrays.asList("vec4 readTexture(int i, vec2 coord) {", "\treturn"));
                i = 0;
                while (i < VideoLayerComposer.this.maxTexImageUnits) {
                    list.add(String.format("\t\t(i==%1$d) ? texture2D(texture%1$d, coord) :", i));
                    ++i;
                }
                list.addAll(Arrays.asList("\t\tvec4(0.0);", "}"));
                list.addAll(Arrays.asList("vec4 mixLod(sampler2D sampler, vec2 coord, float lod) {", "\tfloat lod1 = floor(lod);", "\treturn mix(texture2DLod(sampler, coord, lod1),", "\t\t\ttexture2DLod(sampler, coord, lod1+1.0), lod-lod1);", "}"));
                list.addAll(Arrays.asList("vec4 readTexture(int i, vec2 coord, float lod) {", "\treturn"));
                i = 0;
                while (i < VideoLayerComposer.this.maxTexImageUnits) {
                    list.add(String.format("\t\t(i==%1$d) ? mixLod(texture%1$d, coord, lod) :", i));
                    ++i;
                }
                list.addAll(Arrays.asList("\t\tvec4(0.0);", "}"));
                return list.toArray(new String[list.size()]);
            }
        };
        this.shaders.addShader(factory);
    }

    private String[] createCustomBlend2DSource(String name, boolean dissolve, boolean matte) {
        return new String[]{"uniform sampler2D texDst;", "uniform sampler2D texSrc;", matte ? "uniform sampler2D texMatte;" : "", "uniform vec2 dstSize;", "uniform float opacity;", dissolve ? "uniform float dissolveSeed;" : "", "", String.format("vec4 blend_%s(vec4 pDst, vec4 pSrc, float opacity%s);", name, dissolve ? ", float dissolveSeed" : ""), "", "void main(void)", "{", "\tvec2 dstCoord = gl_FragCoord.xy / dstSize;", "\tvec4 dst = texture2D(texDst, dstCoord);", "\tvec4 src = texture2D(texSrc, gl_TexCoord[0].st);", String.format("\tgl_FragColor = blend_%s(dst, src, opacity%s%s);", name, matte ? "*texture2D(texMatte, dstCoord).a" : "", dissolve ? ", dissolveSeed" : ""), "}"};
    }

    private String[] createCustomBlend3DSource(String name, boolean dissolve, boolean matte) {
        return new String[]{"uniform sampler2D texDst;", "uniform sampler2D texSrc;", matte ? "uniform sampler2D texMatte;" : "", "uniform vec2 dstSize;", "uniform vec2 srcOffset;", "uniform vec2 srcSize;", "uniform float opacity;", dissolve ? "uniform float dissolveSeed;" : "", "", String.format("vec4 blend_%s(vec4 pDst, vec4 pSrc, float opacity%s);", name, dissolve ? ", float dissolveSeed" : ""), "", "void main(void)", "{", "\tvec2 dstCoord = gl_FragCoord.xy / dstSize;", "\tvec4 dst = texture2D(texDst, dstCoord);", "\tvec4 src = texture2D(texSrc, (gl_FragCoord.xy + srcOffset) / srcSize);", String.format("\tgl_FragColor = blend_%s(dst, src, opacity%s%s);", name, matte ? "*texture2D(texMatte, dstCoord).a" : "", dissolve ? ", dissolveSeed" : ""), "}"};
    }

    private String[] createCustomBlendSource(BlendMode blendMode, boolean matte, boolean threeD) {
        boolean dissolve;
        switch (blendMode) {
            case DANCING_DISSOLVE: {
                blendMode = BlendMode.DISSOLVE;
            }
            case DISSOLVE: {
                dissolve = true;
                break;
            }
            default: {
                dissolve = false;
            }
        }
        String name = blendMode.name().toLowerCase();
        if (threeD) {
            return this.createCustomBlend3DSource(name, dissolve, matte);
        }
        return this.createCustomBlend2DSource(name, dissolve, matte);
    }

    private IShaderProgram getCustomBlendProgram(final BlendMode blendMode, final boolean matte, final boolean threeD) {
        final String programName = String.valueOf(VideoLayerComposer.class.getName()) + "." + blendMode.name() + (matte ? "_MATTE" : "") + (threeD ? "_3D" : "_2D");
        IShaderProgram program = this.shaders.getProgram(programName);
        if (program == null) {
            IShaderProgram p;
            IShaderSourceFactory factory = new IShaderSourceFactory(){

                public String getName() {
                    return programName;
                }

                public ShaderType getType() {
                    return ShaderType.FRAGMENT_SHADER;
                }

                public boolean isProgram() {
                    return true;
                }

                public String[] getAttach() {
                    return new String[]{"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"};
                }

                public String[] getSource() {
                    return VideoLayerComposer.this.createCustomBlendSource(blendMode, matte, threeD);
                }
            };
            program = p = this.shaders.getProgram(factory);
        }
        return program;
    }

    private IShaderProgram getCustomBlend3DProgram(BlendMode blendMode, boolean matte) {
        return this.getCustomBlendProgram(blendMode, matte, true);
    }

    private IShaderProgram getCustomBlend2DProgram(BlendMode blendMode, boolean matte) {
        return this.getCustomBlendProgram(blendMode, matte, false);
    }

    private static final String[] createShadowOfParallelLightSource(boolean partitioned) {
        return new String[]{"varying vec4 coord;", "varying float caster;", "", "uniform vec4 casterPlanes[gl_MaxTextureImageUnits];", "uniform mat4 casterMvTxInvs[gl_MaxTextureImageUnits];", "uniform float casterOpacs[gl_MaxTextureImageUnits];", "uniform float casterTrans[gl_MaxTextureImageUnits];", "uniform vec4 lightDir;", "uniform vec2 viewport;", partitioned ? "uniform vec3 partitionLines[gl_MaxTextureImageUnits];" : "", partitioned ? "uniform float partitionExpands[gl_MaxTextureImageUnits];" : "", "", "vec4 readTexture(int i, vec2 coord);", "", "void main(void)", "{", "\tint i = int(caster);", "\tvec4 casterPlane = casterPlanes[i];", "\tfloat t = -dot(casterPlane, coord) / dot(casterPlane, lightDir);", partitioned ? "\tfloat t2 = abs(dot(partitionLines[i], vec3(gl_FragCoord.xy, 1.0)))*sign(-t);" : "", partitioned ? "\tif (t2 > -1.0) {" : "", "\t\tvec4 p = coord + t*lightDir;", "\t\tvec4 casterColor = readTexture(i, (casterMvTxInvs[i]*p).xy)*casterOpacs[i];", "", !partitioned ? "\t\tgl_FragColor = vec4(1.0-casterColor.a) + casterColor*casterTrans[i];" : "\t\tgl_FragColor = mix(vec4(1.0), vec4(1.0-casterColor.a) + casterColor*casterTrans[i],", partitioned ? "\t\t\t\t\t\t\tclamp(t2+partitionExpands[i], 0.0, 1.0));" : "", "", partitioned ? "\t} else {" : "", partitioned ? "\t\tdiscard;" : "", partitioned ? "\t}" : "", "}"};
    }

    private IShaderProgram getShadowOfParallelLightProgram(final boolean partitioned) {
        final String programName = String.valueOf(VideoLayerComposer.class.getName()) + ".SHADOW_OF_PARALLEL_LIGHT" + (partitioned ? "_PARTITIONED" : "");
        IShaderProgram program = this.shaders.getProgram(programName);
        if (program == null) {
            IShaderProgram p;
            final String[] attach = new String[]{String.valueOf(VideoLayerComposer.class.getName()) + ".shadow_vert", String.valueOf(VideoLayerComposer.class.getName()) + ".read_texture"};
            IShaderSourceFactory factory = new IShaderSourceFactory(){

                public String getName() {
                    return programName;
                }

                public ShaderType getType() {
                    return ShaderType.FRAGMENT_SHADER;
                }

                public boolean isProgram() {
                    return true;
                }

                public String[] getAttach() {
                    return attach;
                }

                public String[] getSource() {
                    return VideoLayerComposer.createShadowOfParallelLightSource(partitioned);
                }
            };
            program = p = this.shaders.getProgram(factory);
        }
        return program;
    }

    private static final String[] createShadowOfPointLightSource(boolean diffusion, boolean partitioned) {
        return new String[]{"varying vec4 coord;", "varying float caster;", "", "uniform vec4 casterPlanes[gl_MaxTextureImageUnits];", "uniform mat4 casterMvTxInvs[gl_MaxTextureImageUnits];", "uniform float casterOpacs[gl_MaxTextureImageUnits];", "uniform float casterTrans[gl_MaxTextureImageUnits];", "uniform vec4 lightPos;", "uniform vec2 viewport;", diffusion ? "uniform float diffusion;" : "", partitioned ? "uniform vec3 partitionLines[gl_MaxTextureImageUnits];" : "", partitioned ? "uniform float partitionExpands[gl_MaxTextureImageUnits];" : "", "", diffusion ? "vec4 readTexture(int i, vec2 coord, float lod);" : "vec4 readTexture(int i, vec2 coord);", "", "void main(void)", "{", "\tint i = int(caster);", "\tvec4 casterPlane = casterPlanes[i];", "\tvec4 v = lightPos - coord;", "\tfloat t = -dot(casterPlane, coord) / dot(casterPlane, v);", partitioned ? "\tfloat t2 = abs(dot(partitionLines[i], vec3(gl_FragCoord.xy, 1.0)))*sign(t);" : "", partitioned ? "\tif (t2 > -1.0) {" : "", "", "\t\tvec4 p = coord + v*t;", diffusion ? "\t\tfloat blur = diffusion*t/(1.0-t);" : "", diffusion ? "\t\tfloat lod = 1.34*pow(log(max(blur-0.4, 1.0))/2.30258509299404590109, 1.4);" : "", diffusion ? "\t\tvec4 casterColor = readTexture(i, (casterMvTxInvs[i]*p).xy, lod)*casterOpacs[i];" : "\t\tvec4 casterColor = readTexture(i, (casterMvTxInvs[i]*p).xy)*casterOpacs[i];", !partitioned ? "\t\tgl_FragColor = vec4(1.0-casterColor.a) + casterColor*casterTrans[i];" : "\t\tgl_FragColor = mix(vec4(1.0), vec4(1.0-casterColor.a) + casterColor*casterTrans[i],", partitioned ? "\t\t\t\t\t\t\tclamp(t2+partitionExpands[i], 0.0, 1.0));" : "", "", partitioned ? "\t} else {" : "", partitioned ? "\t\tdiscard;" : "", partitioned ? "\t}" : "", "}"};
    }

    private IShaderProgram getShadowOfPointLightProgram(final boolean diffusion, final boolean partitioned) {
        final String programName = String.valueOf(VideoLayerComposer.class.getName()) + ".SHADOW_OF_POINT_LIGHT" + (diffusion ? "_WITH_DIFFUSION" : "") + (partitioned ? "_PARTITIONED" : "");
        IShaderProgram program = this.shaders.getProgram(programName);
        if (program == null) {
            IShaderProgram p;
            final String[] attach = new String[]{String.valueOf(VideoLayerComposer.class.getName()) + ".shadow_vert", String.valueOf(VideoLayerComposer.class.getName()) + ".read_texture"};
            IShaderSourceFactory factory = new IShaderSourceFactory(){

                public String getName() {
                    return programName;
                }

                public ShaderType getType() {
                    return ShaderType.FRAGMENT_SHADER;
                }

                public boolean isProgram() {
                    return true;
                }

                public String[] getAttach() {
                    return attach;
                }

                public String[] getSource() {
                    return VideoLayerComposer.createShadowOfPointLightSource(diffusion, partitioned);
                }
            };
            program = p = this.shaders.getProgram(factory);
        }
        return program;
    }

    private String[] createParallelOrPointLightSource(LightType type, boolean shadow, boolean back, boolean cr) {
        boolean parallel = type == LightType.PARALLEL;
        boolean spot = type == LightType.SPOT;
        return new String[]{"varying vec3 coord;", "", "uniform sampler2D source;", shadow ? "uniform sampler2D shadow;" : "", shadow ? "uniform vec2 shadowSize;" : "", cr ? "uniform vec2 sourceOffset;" : "", cr ? "uniform vec2 sourceSize;" : "", "", "uniform vec3 normal;", "uniform vec4 material;", back ? "uniform float lightTransmission;" : "", "", parallel ? "uniform vec3 lightVec;" : "uniform vec3 lightPos;", "uniform float lightIntensity;", !parallel ? "uniform vec3 lightAttenuation;" : "", "uniform vec3 lightColor;", spot ? "uniform vec3 spotVec;" : "", spot ? "uniform float spotCutoff;" : "", spot ? "uniform float spotSlope;" : "", shadow ? "uniform float shadowDarkness;" : "", "", "void main(void)", "{", cr ? "\tvec4 srcColor = texture2D(source, (gl_FragCoord.xy + sourceOffset)/sourceSize);" : "\tvec4 srcColor = texture2D(source, gl_TexCoord[0].st);", shadow ? "\tvec4 sdwColor = vec4(1.0)-(vec4(1.0)-texture2D(shadow, gl_FragCoord.xy/shadowSize))*shadowDarkness;" : "", "", !parallel ? "\tvec3 lightVec = lightPos - coord;" : "", !parallel ? "\tfloat lightDis = length(lightVec);" : "", !parallel ? "\tlightVec /= lightDis;" : "", "", !parallel ? "\tfloat attenuation = 1.0 / dot(lightAttenuation, vec3(1.0, lightDis, lightDis*lightDis));" : "", "", spot ? "\tfloat spot = smoothstep(0.0, 1.0, (dot(lightVec, spotVec)-spotCutoff)*spotSlope);" : "", "", "\tfloat diffuse = abs(dot(lightVec, normal));", "", "\tvec3 viewVec = normalize(-coord);", !back ? "\tvec3 halfVec = normalize(lightVec + viewVec);" : "", !back ? "\tfloat specular = pow(abs(dot(normal, halfVec)), material.z);" : "\tfloat specular = pow(max(-dot(lightVec, viewVec), 0.0), material.z);", "", "\tgl_FragColor = vec4(lightIntensity*lightColor", !parallel ? "\t\t\t\t\t*attenuation" : "", spot ? "\t\t\t\t\t*spot" : "", shadow ? "\t\t\t\t\t*sdwColor.rgb" : "", back ? "\t\t\t\t\t*lightTransmission" : "", "\t\t\t\t\t*(material.x*diffuse*srcColor.rgb", "\t\t\t\t\t+ material.y*specular*mix(vec3(srcColor.a), srcColor.rgb, material.w)), srcColor.a);", "", "}"};
    }

    private IShaderProgram getParallelOrPointLightProgram(final LightType type, final boolean shadow, final boolean back, final boolean cr) {
        if (type == LightType.AMBIENT) {
            throw new IllegalArgumentException();
        }
        final String programName = String.valueOf(VideoLayerComposer.class.getName()) + "." + type.name() + "_LIGHT" + (shadow ? "_WITH_SHADOW" : "") + (back ? "_BACK" : "") + (cr ? "_CR" : "");
        IShaderProgram program = this.shaders.getProgram(programName);
        if (program == null) {
            IShaderProgram p;
            IShaderSourceFactory factory = new IShaderSourceFactory(){

                public String getName() {
                    return programName;
                }

                public ShaderType getType() {
                    return ShaderType.FRAGMENT_SHADER;
                }

                public boolean isProgram() {
                    return true;
                }

                public String[] getAttach() {
                    return new String[]{String.valueOf(VideoLayerComposer.class.getName()) + ".light_vert"};
                }

                public String[] getSource() {
                    return VideoLayerComposer.this.createParallelOrPointLightSource(type, shadow, back, cr);
                }
            };
            program = p = this.shaders.getProgram(factory);
        }
        return program;
    }

    private String[] createAmbientLightsSource(boolean cr) {
        return new String[]{"uniform sampler2D source;", cr ? "uniform vec2 sourceOffset;" : "", cr ? "uniform vec2 sourceSize;" : "", "", "uniform vec3 ambient;", "", "void main(void)", "{", cr ? "\tvec4 sourceColor = texture2D(source, (gl_FragCoord.xy + sourceOffset)/sourceSize);" : "\tvec4 sourceColor = texture2D(source, gl_TexCoord[0].st);", "", "\tgl_FragColor = vec4(ambient*sourceColor.rgb, sourceColor.a);", "}"};
    }

    private IShaderProgram getAmbientLightsProgram(final boolean cr) {
        final String programName = String.valueOf(VideoLayerComposer.class.getName()) + ".AMBIENT_LIGHTS" + (cr ? "_CR" : "");
        IShaderProgram program = this.shaders.getProgram(programName);
        if (program == null) {
            IShaderProgram p;
            IShaderSourceFactory factory = new IShaderSourceFactory(){

                public String getName() {
                    return programName;
                }

                public ShaderType getType() {
                    return ShaderType.FRAGMENT_SHADER;
                }

                public boolean isProgram() {
                    return true;
                }

                public String[] getAttach() {
                    return new String[0];
                }

                public String[] getSource() {
                    return VideoLayerComposer.this.createAmbientLightsSource(cr);
                }
            };
            program = p = this.shaders.getProgram(factory);
        }
        return program;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$core$MotionBlur() {
        if ($SWITCH_TABLE$ch$kuramo$javie$core$MotionBlur != null) {
            return $SWITCH_TABLE$ch$kuramo$javie$core$MotionBlur;
        }
        int[] nArray = new int[MotionBlur.values().length];
        try {
            nArray[MotionBlur.FULL.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MotionBlur.NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MotionBlur.TRANSFORM.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$ch$kuramo$javie$core$MotionBlur = nArray;
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Caster {
        private final Entry3D entry;
        private final List<Point3d> vertices;
        private final Vector3d partitionLine;
        private final boolean partitionExpand;

        private Caster(Entry3D entry, List<Point3d> vertices, Vector3d partitionLine, boolean partitionExpand) {
            this.entry = entry;
            this.vertices = vertices;
            this.partitionLine = partitionLine;
            this.partitionExpand = partitionExpand;
        }
    }

    private static class ComposeGroup {
        private final boolean threeD;
        private final List<VideoLayerRenderer.GeneralLayerRenderer> renderers = Util.newList();

        private ComposeGroup(boolean threeD) {
            this.threeD = threeD;
        }

        private void add(VideoLayerRenderer.GeneralLayerRenderer r) {
            this.renderers.add(r);
        }

        static /* synthetic */ List access$3(ComposeGroup composeGroup) {
            return composeGroup.renderers;
        }
    }

    private static class Entry2D {
        private final MediaLayer layer;
        private final IVideoBuffer source;
        private final IVideoBuffer matte;
        private final Point3d[] vertices;
        private final Point2d[] texCoords;
        private final double opacity;

        private Entry2D(MediaLayer layer, IVideoBuffer source, IVideoBuffer matte, Point3d[] vertices, Point2d[] texCoords, double opacity) {
            this.layer = layer;
            this.source = source;
            this.matte = matte;
            this.vertices = vertices;
            this.texCoords = texCoords;
            this.opacity = opacity;
        }
    }

    private static class Entry3D {
        private final int indexInGroup;
        private final MediaLayer layer;
        private final IVideoBuffer source;
        private final IVideoBuffer sourceCR;
        private IVideoBuffer diffusion;
        private IVideoBuffer lighted;
        private final IVideoBuffer matte;
        private final double[] mvMatrix;
        private final Point3d[] vertices;
        private final Point2d[] texCoords;
        private final double opacity;
        private final Vector4d plane;
        private static final Comparator<Entry3D> partitioningOrderComparator = new Comparator<Entry3D>(){

            @Override
            public int compare(Entry3D o1, Entry3D o2) {
                BlendMode blendMode1 = o1.layer.getBlendMode();
                BlendMode blendMode2 = o2.layer.getBlendMode();
                if (blendMode1 == BlendMode.NORMAL && blendMode2 != BlendMode.NORMAL) {
                    return 1;
                }
                if (blendMode1 != BlendMode.NORMAL && blendMode2 == BlendMode.NORMAL) {
                    return -1;
                }
                double span1 = this.spanSquared(o1);
                double span2 = this.spanSquared(o2);
                return (int)Math.signum(span2 - span1);
            }

            private double spanSquared(Entry3D entry) {
                double spanSquared = 0.0;
                Vector3d vec = new Vector3d();
                int i = 0;
                int n = entry.vertices.length;
                while (i < n) {
                    int j = i + 1;
                    while (j < n) {
                        vec.sub((Tuple3d)entry.vertices[i], (Tuple3d)entry.vertices[j]);
                        spanSquared = Math.max(spanSquared, vec.lengthSquared());
                        ++j;
                    }
                    ++i;
                }
                return spanSquared;
            }
        };

        private Entry3D(int indexInGroup, MediaLayer layer, IVideoBuffer source, IVideoBuffer sourceCR, IVideoBuffer diffusion, IVideoBuffer matte, double[] mvMatrix, Point3d[] vertices, Point2d[] texCoords, double opacity) {
            this.indexInGroup = indexInGroup;
            this.layer = layer;
            this.source = source;
            this.sourceCR = sourceCR;
            this.diffusion = diffusion;
            this.matte = matte;
            this.mvMatrix = mvMatrix;
            this.vertices = vertices;
            this.texCoords = texCoords;
            this.opacity = opacity;
            Vector3d v1 = new Vector3d();
            v1.sub((Tuple3d)vertices[1], (Tuple3d)vertices[0]);
            Vector3d v2 = new Vector3d();
            v2.sub((Tuple3d)vertices[vertices.length - 1], (Tuple3d)vertices[0]);
            Vector3d n = new Vector3d();
            n.cross(v1, v2);
            n.normalize();
            double d = -n.dot(new Vector3d((Tuple3d)vertices[0]));
            this.plane = new Vector4d(n.x, n.y, n.z, d);
        }

        private void dispose() {
            if (this.source != null) {
                this.source.dispose();
            }
            if (this.sourceCR != null) {
                this.sourceCR.dispose();
            }
            if (this.diffusion != null) {
                this.diffusion.dispose();
            }
            if (this.lighted != null) {
                this.lighted.dispose();
            }
        }

        private void disposeLighted() {
            if (this.lighted != null && this.lighted != this.sourceCR) {
                this.lighted.dispose();
            }
            this.lighted = null;
        }

        static /* synthetic */ Comparator access$4() {
            return partitioningOrderComparator;
        }
    }

    private static interface MotionBlurSampler1 {
        public IVideoBuffer sample();

        public double getOpacity();
    }

    private static interface MotionBlurSampler2 {
        public IVideoBuffer sample();

        public void transform(VideoBounds var1, Point3d[] var2, Point2d[] var3);

        public double getOpacity();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Polygon {
        private final Entry3D entry;
        private final List<Point3d> vertices;

        private Polygon(Entry3D entry) {
            this(entry, Arrays.asList(entry.vertices));
        }

        private Polygon(Entry3D entry, List<Point3d> vertices) {
            this.entry = entry;
            this.vertices = vertices;
        }

        private List<Triangle> toTriangles(int sourceIndex, int matteIndex) {
            List<Triangle> triangles = Util.newList();
            Point3d vert0 = this.vertices.get(0);
            Point3d vert1 = this.vertices.get(1);
            int i = 2;
            int n = this.vertices.size();
            while (i < n) {
                Point3d vert2 = this.vertices.get(i);
                triangles.add(new Triangle(this.entry, sourceIndex, matteIndex, vert0, vert1, vert2));
                ++i;
                vert1 = vert2;
            }
            return triangles;
        }

        static /* synthetic */ List access$2(Polygon polygon, int n, int n2) {
            return polygon.toTriangles(n, n2);
        }
    }

    private static class Triangle {
        private final Entry3D entry;
        private final int sourceIndex;
        private final int matteIndex;
        private final Point3d[] vertices;

        private Triangle(Entry3D entry, int sourceIndex, int matteIndex, Point3d vert0, Point3d vert1, Point3d vert2) {
            this.entry = entry;
            this.sourceIndex = sourceIndex;
            this.matteIndex = matteIndex;
            this.vertices = new Point3d[]{vert0, vert1, vert2};
        }
    }
}

