/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.Util;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.media.opengl.GLUniformData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlendSupportImpl
implements IBlendSupport {
    private static final String BLEND_FUNCTIONS = "ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions";
    private final IVideoRenderSupport support;
    private final IShaderRegistry shaders;
    private Class<?> programsClass;
    private Map<BlendMode, IShaderProgram> programs;

    @Inject
    public BlendSupportImpl(IVideoRenderSupport support, IShaderRegistry shaders) {
        this.support = support;
        this.shaders = shaders;
        this.setProgramsClass(Premult.class);
    }

    public Class<?> getUnmultSrcClass() {
        return UnmultSrc.class;
    }

    public void setProgramsClass(Class<?> programsClass) {
        HashMap<BlendMode, IShaderProgram> programs = new HashMap<BlendMode, IShaderProgram>();
        Set<BlendMode> values = Util.newSet(Arrays.asList(BlendMode.values()));
        values.remove(BlendMode.DANCING_DISSOLVE);
        for (BlendMode blendMode : values) {
            IShaderProgram program = this.shaders.getProgram(programsClass, blendMode.name());
            if (program == null) {
                throw new IllegalArgumentException(String.format("no shader program found for BlendMode.%s in class %s", blendMode.name(), programsClass.getName()));
            }
            programs.put(blendMode, program);
        }
        this.programsClass = programsClass;
        this.programs = programs;
    }

    public void replace(BlendMode blendMode, IShaderProgram program) {
        if (blendMode == BlendMode.DANCING_DISSOLVE) {
            throw new IllegalArgumentException("DANCING_DISSOLVE uses same program as DISSOLVE");
        }
        if (program == null) {
            program = this.shaders.getProgram(this.programsClass, blendMode.name());
        }
        this.programs.put(blendMode, program);
    }

    private IVideoBuffer blend(IVideoBuffer src, IVideoBuffer dstIn, IVideoBuffer dstOut, BlendMode blendMode, double opacity, double dissolveSeed) {
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        uniforms.add(new GLUniformData("opacity", (float)opacity));
        switch (blendMode) {
            case DANCING_DISSOLVE: {
                blendMode = BlendMode.DISSOLVE;
            }
            case DISSOLVE: {
                uniforms.add(new GLUniformData("dissolveSeed", (float)dissolveSeed));
            }
        }
        uniforms.add(new GLUniformData("texDst", 0));
        uniforms.add(new GLUniformData("texSrc", 1));
        return this.support.useShaderProgram(this.programs.get(blendMode), uniforms, dstOut, new IVideoBuffer[]{dstIn, src});
    }

    public IVideoBuffer blend(IVideoBuffer src, IVideoBuffer dstIn, IVideoBuffer dstOut, BlendMode blendMode, double opacity, IVideoEffectContext context) {
        double dissolveSeed;
        switch (blendMode) {
            case DISSOLVE: {
                dissolveSeed = 100.0 * (double)context.getEffectName().hashCode() / 2.147483647E9;
                break;
            }
            case DANCING_DISSOLVE: {
                dissolveSeed = 100.0 * (double)context.getEffectName().hashCode() / 2.147483647E9 + context.getTime().toSecond();
                break;
            }
            default: {
                dissolveSeed = 0.0;
            }
        }
        return this.blend(src, dstIn, dstOut, blendMode, opacity, dissolveSeed);
    }

    public IVideoBuffer blend(IVideoBuffer src, IVideoBuffer dstIn, IVideoBuffer dstOut, BlendMode blendMode, double opacity) {
        if (blendMode == BlendMode.DISSOLVE || blendMode == BlendMode.DANCING_DISSOLVE) {
            throw new IllegalArgumentException("Neither DISSOLVE nor DANCING_DISSOLVE can be used. Use anothor blend method or dissolve method.");
        }
        return this.blend(src, dstIn, dstOut, blendMode, opacity, 0.0);
    }

    public IVideoBuffer dissolve(IVideoBuffer src, IVideoBuffer dstIn, IVideoBuffer dstOut, double opacity, double seed) {
        return this.blend(src, dstIn, dstOut, BlendMode.DISSOLVE, opacity, seed);
    }

    public static class Premult {
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] NONE = Premult.createSource("none");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] NORMAL = Premult.createSource("normal");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DISSOLVE = Premult.createSource("dissolve", true);
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DARKEN = Premult.createSource("darken");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] MULTIPLY = Premult.createSource("multiply");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR_BURN = Premult.createSource("color_burn");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_BURN = Premult.createSource("linear_burn");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DARKER_COLOR = Premult.createSource("darker_color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] ADD = Premult.createSource("add");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LIGHTEN = Premult.createSource("lighten");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SCREEN = Premult.createSource("screen");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR_DODGE = Premult.createSource("color_dodge");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_DODGE = Premult.createSource("linear_dodge");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LIGHTER_COLOR = Premult.createSource("lighter_color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] OVERLAY = Premult.createSource("overlay");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SOFT_LIGHT = Premult.createSource("soft_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HARD_LIGHT = Premult.createSource("hard_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_LIGHT = Premult.createSource("linear_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] VIVID_LIGHT = Premult.createSource("vivid_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] PIN_LIGHT = Premult.createSource("pin_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HARD_MIX = Premult.createSource("hard_mix");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DIFFERENCE = Premult.createSource("difference");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] EXCLUSION = Premult.createSource("exclusion");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HUE = Premult.createSource("hue");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SATURATION = Premult.createSource("saturation");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR = Premult.createSource("color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LUMINOSITY = Premult.createSource("luminosity");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] STENCIL_ALPHA = Premult.createSource("stencil_alpha");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] STENCIL_LUMA = Premult.createSource("stencil_luma");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SILHOUETTE_ALPHA = Premult.createSource("silhouette_alpha");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SILHOUETTE_LUMA = Premult.createSource("silhouette_luma");

        private static String[] createSource(String name, boolean dissolve) {
            return new String[]{"uniform sampler2D texDst;", "uniform sampler2D texSrc;", "uniform float opacity;", dissolve ? "uniform float dissolveSeed;" : "", "", String.format("vec4 blend_%s(vec4 pDst, vec4 pSrc, float opacity%s);", name, dissolve ? ", float dissolveSeed" : ""), "", "void main(void)", "{", "\tvec4 dst = texture2D(texDst, gl_TexCoord[0].st);", "\tvec4 src = texture2D(texSrc, gl_TexCoord[1].st);", String.format("\tgl_FragColor = blend_%s(dst, src, opacity%s);", name, dissolve ? ", dissolveSeed" : ""), "}"};
        }

        private static String[] createSource(String name) {
            return Premult.createSource(name, false);
        }
    }

    public static class UnmultSrc {
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] NONE = UnmultSrc.createSource("none");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] NORMAL = UnmultSrc.createSource("normal");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DISSOLVE = UnmultSrc.createSource("dissolve", true);
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DARKEN = UnmultSrc.createSource("darken");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] MULTIPLY = UnmultSrc.createSource("multiply");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR_BURN = UnmultSrc.createSource("color_burn");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_BURN = UnmultSrc.createSource("linear_burn");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DARKER_COLOR = UnmultSrc.createSource("darker_color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] ADD = UnmultSrc.createSource("add");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LIGHTEN = UnmultSrc.createSource("lighten");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SCREEN = UnmultSrc.createSource("screen");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR_DODGE = UnmultSrc.createSource("color_dodge");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_DODGE = UnmultSrc.createSource("linear_dodge");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LIGHTER_COLOR = UnmultSrc.createSource("lighter_color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] OVERLAY = UnmultSrc.createSource("overlay");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SOFT_LIGHT = UnmultSrc.createSource("soft_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HARD_LIGHT = UnmultSrc.createSource("hard_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_LIGHT = UnmultSrc.createSource("linear_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] VIVID_LIGHT = UnmultSrc.createSource("vivid_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] PIN_LIGHT = UnmultSrc.createSource("pin_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HARD_MIX = UnmultSrc.createSource("hard_mix");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DIFFERENCE = UnmultSrc.createSource("difference");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] EXCLUSION = UnmultSrc.createSource("exclusion");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HUE = UnmultSrc.createSource("hue");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SATURATION = UnmultSrc.createSource("saturation");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR = UnmultSrc.createSource("color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LUMINOSITY = UnmultSrc.createSource("luminosity");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] STENCIL_ALPHA = UnmultSrc.createSource("stencil_alpha");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] STENCIL_LUMA = UnmultSrc.createSource("stencil_luma");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SILHOUETTE_ALPHA = UnmultSrc.createSource("silhouette_alpha");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SILHOUETTE_LUMA = UnmultSrc.createSource("silhouette_luma");

        private static String[] createSource(String name, boolean dissolve) {
            return new String[]{"uniform sampler2D texDst;", "uniform sampler2D texSrc;", "uniform float opacity;", dissolve ? "uniform float dissolveSeed;" : "", "", String.format("vec4 blend_%s(vec4 pDst, vec4 pSrc, float opacity%s);", name, dissolve ? ", float dissolveSeed" : ""), "", "void main(void)", "{", "\tvec4 dst = texture2D(texDst, gl_TexCoord[0].st);", "\tvec4 src = texture2D(texSrc, gl_TexCoord[1].st);", String.format("\tgl_FragColor = blend_%s(dst, vec4(src.rgb*src.a, src.a), opacity%s);", name, dissolve ? ", dissolveSeed" : ""), "}"};
        }

        private static String[] createSource(String name) {
            return UnmultSrc.createSource(name, false);
        }
    }
}

