/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.ICamera;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.VideoEffect;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.services.AbstractEffectContext;
import ch.kuramo.javie.core.internal.services.VideoEffectContextProxy;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoEffectPipeline;
import com.google.inject.Inject;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoEffectPipelineImpl
implements VideoEffectPipeline {
    private static final Logger _logger = LoggerFactory.getLogger(VideoEffectPipelineImpl.class);
    @Inject
    private RenderContext _context;
    @Inject
    private IVideoRenderSupport _vrSupport;
    @Inject
    private AudioRenderSupport _arSupport;

    @Override
    public VideoBounds getVideoBounds(List<Effect> effects, WrappedOperation<VideoBounds> inputBoundsOperation) {
        VideoEffectContextImpl impl = new VideoEffectContextImpl(this.enabledVideoEffectsOnly(effects), inputBoundsOperation, null);
        VideoEffectContextProxy.push(impl);
        try {
            VideoBounds videoBounds = impl.getPreviousBounds();
            return videoBounds;
        }
        finally {
            VideoEffectContextProxy.pop();
        }
    }

    @Override
    public IVideoBuffer doVideoEffects(List<Effect> effects, WrappedOperation<VideoBounds> inputBoundsOperation, WrappedOperation<IVideoBuffer> inputBufferOperation) {
        VideoEffectContextImpl impl = new VideoEffectContextImpl(this.enabledVideoEffectsOnly(effects), inputBoundsOperation, inputBufferOperation);
        VideoEffectContextProxy.push(impl);
        try {
            IVideoBuffer iVideoBuffer = impl.doPreviousEffect();
            return iVideoBuffer;
        }
        finally {
            VideoEffectContextProxy.pop();
        }
    }

    private List<VideoEffect> enabledVideoEffectsOnly(List<Effect> effects) {
        List<VideoEffect> videoEffects = Util.newList();
        for (Effect e : effects) {
            if (!(e instanceof VideoEffect) || !e.isEnabled()) continue;
            videoEffects.add((VideoEffect)e);
        }
        return videoEffects;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VideoEffectContextImpl
    extends AbstractEffectContext
    implements IVideoEffectContext {
        private List<VideoEffect> effects;
        private final WrappedOperation<VideoBounds> inputBoundsOperation;
        private final WrappedOperation<IVideoBuffer> inputBufferOperation;
        private VideoEffect currentEffect;
        private boolean gettingBounds;

        private VideoEffectContextImpl(List<VideoEffect> effects, WrappedOperation<VideoBounds> inputBoundsOperation, WrappedOperation<IVideoBuffer> inputBufferOperation) {
            super(VideoEffectPipelineImpl.this._context, VideoEffectPipelineImpl.this._vrSupport, VideoEffectPipelineImpl.this._arSupport);
            this.effects = effects;
            this.inputBoundsOperation = inputBoundsOperation;
            this.inputBufferOperation = inputBufferOperation;
        }

        public VideoBounds getPreviousBounds() {
            if (this.inputBoundsOperation == null) {
                throw new IllegalStateException();
            }
            boolean savedGettingBounds = this.gettingBounds;
            try {
                this.gettingBounds = true;
                if (this.effects.isEmpty()) {
                    VideoBounds videoBounds = VideoEffectPipelineImpl.this._context.saveAndExecute(this.inputBoundsOperation);
                    return videoBounds;
                }
                VideoBounds videoBounds = this.executePrevious(new WrappedOperation<VideoBounds>(){

                    @Override
                    public VideoBounds execute() {
                        VideoBounds bounds = VideoEffectContextImpl.this.currentEffect.getVideoBounds();
                        return bounds != null ? bounds : VideoEffectContextImpl.this.getPreviousBounds();
                    }
                });
                return videoBounds;
            }
            finally {
                this.gettingBounds = savedGettingBounds;
            }
        }

        public IVideoBuffer doPreviousEffect() {
            if (this.inputBufferOperation == null || this.gettingBounds) {
                throw new IllegalStateException();
            }
            if (this.effects.isEmpty()) {
                return VideoEffectPipelineImpl.this._context.saveAndExecute(this.inputBufferOperation);
            }
            return this.executePrevious(new WrappedOperation<IVideoBuffer>(){

                @Override
                public IVideoBuffer execute() {
                    IVideoBuffer buffer = VideoEffectContextImpl.this.currentEffect.doVideoEffect();
                    if (buffer == null) {
                        return VideoEffectContextImpl.this.doPreviousEffect();
                    }
                    try {
                        if (buffer.getColorMode() != VideoEffectPipelineImpl.this._context.getColorMode()) {
                            _logger.warn(String.format("ColorMode of the buffer from '%s' differs from context ColorMode", VideoEffectContextImpl.this.currentEffect.getName()));
                            IVideoBuffer copy = null;
                            try {
                                copy = VideoEffectPipelineImpl.this._vrSupport.createVideoBuffer(buffer.getBounds());
                                VideoEffectPipelineImpl.this._vrSupport.copy(buffer, copy);
                                buffer.dispose();
                                buffer = copy;
                                copy = null;
                            }
                            finally {
                                if (copy != null) {
                                    copy.dispose();
                                }
                            }
                        } else if (buffer.isTexture()) {
                            buffer.setTextureFilter(IVideoBuffer.TextureFilter.NEAREST);
                            buffer.setTextureWrapMode(IVideoBuffer.TextureWrapMode.CLAMP_TO_BORDER);
                        }
                        IVideoBuffer result = buffer;
                        buffer = null;
                        IVideoBuffer iVideoBuffer = result;
                        return iVideoBuffer;
                    }
                    finally {
                        if (buffer != null) {
                            buffer.dispose();
                        }
                    }
                }
            });
        }

        private <T> T executePrevious(WrappedOperation<T> wop) {
            VideoEffect savedCurrent = this.currentEffect;
            List<VideoEffect> savedEffects = this.effects;
            try {
                int lastIndex = this.effects.size() - 1;
                this.currentEffect = this.effects.get(lastIndex);
                this.effects = this.effects.subList(0, lastIndex);
                T t = VideoEffectPipelineImpl.this._context.saveAndExecute(wop);
                return t;
            }
            finally {
                this.effects = savedEffects;
                this.currentEffect = savedCurrent;
            }
        }

        public ICamera getCamera() {
            return VideoEffectPipelineImpl.this._context.getCamera();
        }

        public String getEffectName() {
            if (this.currentEffect == null) {
                throw new IllegalStateException("no current Effect");
            }
            return this.currentEffect.getName();
        }
    }
}

