/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.output;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.output.PullSourceOutput;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacOSXQTMovieOutput
extends PullSourceOutput {
    private static final Logger _logger = LoggerFactory.getLogger(MacOSXQTMovieOutput.class);
    private VideoCompressorSettings vcSettings;
    private AudioCompressorSettings acSettings;

    static {
        System.loadLibrary("QTMovieOutput");
    }

    public VideoCompressorSettings getVideoCompressorSettings() {
        return this.vcSettings;
    }

    public void setVideoCompressorSettings(VideoCompressorSettings vcSettings) {
        this.vcSettings = vcSettings;
    }

    public AudioCompressorSettings getAudioCompressorSettings() {
        return this.acSettings;
    }

    public void setAudioCompressorSettings(AudioCompressorSettings acSettings) {
        this.acSettings = acSettings;
    }

    protected void doOutput() {
        int error;
        Composition comp = this.getComposition();
        AudioMode audioMode = this.getAudioMode();
        File file = this.getFile();
        if (file.exists()) {
            file.delete();
        }
        Size2i size = comp.getSize();
        Time frameDuration = comp.getFrameDuration();
        Time duration = comp.getDuration();
        if (duration.timeScale != frameDuration.timeScale) {
            duration = Time.fromFrameNumber((long)duration.toFrameNumber(frameDuration), (Time)frameDuration);
        }
        boolean videoEnabled = this.isVideoEnabled();
        boolean audioEnabled = this.isAudioEnabled();
        if (videoEnabled && audioEnabled) {
            error = this.doOutput(this.vcSettings != null ? this.vcSettings.settings : null, this.acSettings != null ? this.acSettings.settings : null, file.getAbsolutePath(), size.width, size.height, frameDuration.timeScale, frameDuration.timeValue, duration.timeValue, audioMode.channels, audioMode.sampleRate, audioMode.sampleSize, audioMode.dataType == AudioMode.DataType.FLOAT, duration.toFrameNumber(audioMode.sampleDuration));
        } else if (videoEnabled) {
            error = this.doOutput(this.vcSettings != null ? this.vcSettings.settings : null, null, file.getAbsolutePath(), size.width, size.height, frameDuration.timeScale, frameDuration.timeValue, duration.timeValue, 0, 0, 0, false, 0L);
        } else if (audioEnabled) {
            error = this.doOutput(null, this.acSettings != null ? this.acSettings.settings : null, file.getAbsolutePath(), 0, 0, 0, 0L, 0L, audioMode.channels, audioMode.sampleRate, audioMode.sampleSize, audioMode.dataType == AudioMode.DataType.FLOAT, duration.toFrameNumber(audioMode.sampleDuration));
        } else {
            throw new Error();
        }
        if (error != 0 && error != -128) {
            _logger.error("doOutput: error=" + error);
        }
    }

    protected void finishVideoRequest(PullSourceOutput.VideoRequest request, IVideoBuffer vb) {
        this.copyVideoBufferToByteBuffer(vb, ((VideoRequestWithByteBuffer)request).byteBuffer);
    }

    protected void finishAudioRequest(PullSourceOutput.AudioRequest request, IAudioBuffer ab) {
        this.copyAudioBufferToByteBuffer(ab, ((AudioRequestWithByteBuffer)request).byteBuffer);
    }

    protected void copyVideoBufferToByteBuffer(IVideoBuffer vb, ByteBuffer bb) {
        Object array = vb.getArray();
        bb.order(ByteOrder.nativeOrder());
        if (array instanceof byte[]) {
            bb.put((byte[])array, 0, bb.capacity());
        } else if (array instanceof short[]) {
            bb.asShortBuffer().put((short[])array, 0, bb.capacity() / 2);
        } else if (array instanceof float[]) {
            bb.asFloatBuffer().put((float[])array, 0, bb.capacity() / 4);
        } else {
            throw new IllegalArgumentException("not array or unsupported array type: " + array.getClass().getName());
        }
        bb.position(bb.capacity());
    }

    protected void copyAudioBufferToByteBuffer(IAudioBuffer ab, ByteBuffer bb) {
        bb.order(ByteOrder.nativeOrder());
        AudioMode audioMode = ab.getAudioMode();
        int dataLen = ab.getDataLength();
        switch (audioMode.dataType) {
            case SHORT: {
                bb.asShortBuffer().put((short[])ab.getData(), 0, dataLen);
                break;
            }
            case INT: {
                bb.asIntBuffer().put((int[])ab.getData(), 0, dataLen);
                break;
            }
            case FLOAT: {
                bb.asFloatBuffer().put((float[])ab.getData(), 0, dataLen);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported AudioMode: " + audioMode);
            }
        }
        bb.position(dataLen * audioMode.sampleSize);
    }

    private int videoRequest(long timeValue, int timeScale, ByteBuffer buffer) {
        try {
            buffer.clear();
            this.postVideoRequest(new VideoRequestWithByteBuffer(new Time(timeValue, timeScale), buffer));
            return buffer.position();
        }
        catch (InterruptedException e) {
            _logger.warn("unexpected interruption", (Throwable)e);
            return -1;
        }
    }

    private int audioRequest(long timeValue, int timeScale, ByteBuffer buffer) {
        int frameCount = timeScale;
        try {
            buffer.clear();
            this.postAudioRequest(new AudioRequestWithByteBuffer(new Time(timeValue, timeScale), frameCount, buffer));
            return buffer.position();
        }
        catch (InterruptedException e) {
            _logger.warn("unexpected interruption", (Throwable)e);
            return -1;
        }
    }

    private boolean updateProgress(short message, int percentDone) {
        if (this.isCanceled()) {
            return false;
        }
        switch (message) {
            case 0: {
                this.beginTask(65536);
                break;
            }
            case 1: {
                this.currentWork(percentDone);
                break;
            }
            case 2: {
                this.done();
            }
        }
        return true;
    }

    public static VideoCompressorSettings doVideoCompressorSettings(VideoCompressorSettings defaultSettings, double frameRate, boolean showDialog) {
        Object[] newSettings = new Object[4];
        int error = MacOSXQTMovieOutput.doVideoCompressorSettings(defaultSettings != null ? defaultSettings.settings : null, frameRate, showDialog, newSettings);
        switch (error) {
            case 0: {
                return new VideoCompressorSettings((byte[])newSettings[0], (Integer)newSettings[1], (Double)newSettings[2], (String)newSettings[3]);
            }
            case 1: {
                return null;
            }
        }
        _logger.error("doVideoCompressorSettings: error=" + error);
        return null;
    }

    public static AudioCompressorSettings doAudioCompressorSettings(AudioCompressorSettings defaultSettings, double sampleRate, boolean showDialog) {
        Object[] newSettings = new Object[3];
        int error = MacOSXQTMovieOutput.doAudioCompressorSettings(defaultSettings != null ? defaultSettings.settings : null, sampleRate, showDialog, newSettings);
        switch (error) {
            case 0: {
                return new AudioCompressorSettings((byte[])newSettings[0], (Double)newSettings[1], (String)newSettings[2]);
            }
            case -128: {
                return null;
            }
        }
        _logger.error("doAudioCompressorSettings: error=" + error);
        return null;
    }

    private static native int doVideoCompressorSettings(byte[] var0, double var1, boolean var3, Object[] var4);

    private static native int doAudioCompressorSettings(byte[] var0, double var1, boolean var3, Object[] var4);

    private native int doOutput(byte[] var1, byte[] var2, String var3, int var4, int var5, int var6, long var7, long var9, int var11, int var12, int var13, boolean var14, long var15);

    public static class AudioCompressorSettings {
        private final byte[] settings;
        public final double sampleRate;
        public final String text;

        private AudioCompressorSettings(byte[] settings, double sampleRate, String text) {
            this.settings = settings;
            this.sampleRate = sampleRate;
            this.text = text;
        }
    }

    private class AudioRequestWithByteBuffer
    extends PullSourceOutput.AudioRequest {
        private final ByteBuffer byteBuffer;

        private AudioRequestWithByteBuffer(Time time, int frameCount, ByteBuffer byteBuffer) {
            super(time, frameCount);
            this.byteBuffer = byteBuffer;
        }
    }

    public static class VideoCompressorSettings {
        private final byte[] settings;
        public final int depth;
        public final double frameRate;
        public final String text;

        private VideoCompressorSettings(byte[] settings, int depth, double frameRate, String text) {
            this.settings = settings;
            this.depth = depth;
            this.frameRate = frameRate;
            this.text = text;
        }
    }

    private class VideoRequestWithByteBuffer
    extends PullSourceOutput.VideoRequest {
        private final ByteBuffer byteBuffer;

        private VideoRequestWithByteBuffer(Time time, ByteBuffer byteBuffer) {
            super(time);
            this.byteBuffer = byteBuffer;
        }
    }
}

