/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nativewindow.impl.x11;

import com.sun.nativewindow.impl.Debug;
import com.sun.nativewindow.impl.NativeLibLoaderBase;
import com.sun.nativewindow.impl.x11.X11Lib;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.NativeWindowException;

public class X11Util {
    private static final boolean DEBUG = Debug.debug("X11Util");
    private static ThreadLocal currentDisplayMap;

    private X11Util() {
    }

    public static Map getCurrentDisplayMap() {
        return (Map)((HashMap)X11Util.getCurrentDisplayMapImpl()).clone();
    }

    public static long getThreadLocalDefaultDisplay() {
        return X11Util.getThreadLocalDisplay(null);
    }

    public static long getThreadLocalDisplay(String string) {
        NamedDisplay namedDisplay = X11Util.getCurrentDisplay(string);
        if (null == namedDisplay) {
            long l = X11Lib.XOpenDisplay(string);
            if (0L == l) {
                throw new NativeWindowException("X11Util.Display: Unable to create a display(" + string + ") connection in Thread " + Thread.currentThread().getName());
            }
            namedDisplay = new NamedDisplay(string, l);
            X11Util.setCurrentDisplay(namedDisplay);
            if (DEBUG) {
                Exception exception = new Exception("X11Util.Display: Created new TLS display(" + string + ") connection 0x" + Long.toHexString(l) + " in thread " + Thread.currentThread().getName());
                exception.printStackTrace();
            }
        }
        return namedDisplay.getHandle();
    }

    public static long closeThreadLocalDisplay(String string) {
        NamedDisplay namedDisplay = X11Util.removeCurrentDisplay(string);
        if (null == namedDisplay) {
            if (DEBUG) {
                Exception exception = new Exception("X11Util.Display: Display(" + string + ") with given handle is not mapped to TLS in thread " + Thread.currentThread().getName());
                exception.printStackTrace();
            }
            return 0L;
        }
        long l = namedDisplay.getHandle();
        X11Lib.XCloseDisplay(l);
        if (DEBUG) {
            Exception exception = new Exception("X11Util.Display: Closed TLS Display(" + string + ") with handle 0x" + Long.toHexString(l) + " in thread " + Thread.currentThread().getName());
            exception.printStackTrace();
        }
        return l;
    }

    private static Map getCurrentDisplayMapImpl() {
        HashMap hashMap = (HashMap)currentDisplayMap.get();
        if (null == hashMap) {
            hashMap = new HashMap();
            currentDisplayMap.set(hashMap);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NamedDisplay setCurrentDisplay(NamedDisplay namedDisplay) {
        Map map = X11Util.getCurrentDisplayMapImpl();
        NamedDisplay namedDisplay2 = null;
        Map map2 = map;
        synchronized (map2) {
            String string = null == namedDisplay.getName() ? "nil" : namedDisplay.getName();
            namedDisplay2 = map.put(string, namedDisplay);
            map.notifyAll();
        }
        return namedDisplay2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NamedDisplay removeCurrentDisplay(String string) {
        Map map = X11Util.getCurrentDisplayMapImpl();
        NamedDisplay namedDisplay = null;
        Map map2 = map;
        synchronized (map2) {
            if (null == string) {
                string = "nil";
            }
            namedDisplay = (NamedDisplay)map.remove(string);
            map.notifyAll();
        }
        return namedDisplay;
    }

    private static NamedDisplay getCurrentDisplay(String string) {
        if (null == string) {
            string = "nil";
        }
        Map map = X11Util.getCurrentDisplayMapImpl();
        return (NamedDisplay)map.get(string);
    }

    static {
        NativeLibLoaderBase.loadNativeWindow("x11");
        currentDisplayMap = new ThreadLocal();
    }

    public static class NamedDisplay
    implements Cloneable {
        private String name;
        private long handle;

        protected NamedDisplay(String string, long l) {
            this.name = string;
            this.handle = l;
        }

        public String getName() {
            return this.name;
        }

        public long getHandle() {
            return this.handle;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

