/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class NativeLibLoader {
    private static volatile boolean loadingEnabled = true;
    private static volatile boolean didLoading;

    public static void disableLoading() {
        loadingEnabled = false;
    }

    public static void enableLoading() {
        loadingEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadGlueGenRT() {
        if (!didLoading && loadingEnabled) {
            Class clazz = NativeLibLoader.class;
            synchronized (clazz) {
                if (!didLoading && loadingEnabled) {
                    didLoading = true;
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            NativeLibLoader.loadLibraryInternal("gluegen-rt");
                            return null;
                        }
                    });
                }
            }
        }
    }

    private static void loadLibraryInternal(String libraryName) {
        String sunAppletLauncher = System.getProperty("sun.jnlp.applet.launcher");
        boolean usingJNLPAppletLauncher = Boolean.valueOf(sunAppletLauncher);
        if (usingJNLPAppletLauncher) {
            try {
                Class<?> jnlpAppletLauncherClass = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                Method jnlpLoadLibraryMethod = jnlpAppletLauncherClass.getDeclaredMethod("loadLibrary", String.class);
                jnlpLoadLibraryMethod.invoke(null, libraryName);
            }
            catch (Exception e) {
                Throwable t = e;
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError().initCause(e);
            }
        } else {
            System.loadLibrary(libraryName);
        }
    }
}

