/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.impl;

import com.jogamp.common.util.locks.RecursiveLock;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.SurfaceChangeable;

public class ProxySurface
implements NativeSurface,
SurfaceChangeable {
    private RecursiveLock recurLock = new RecursiveLock();
    protected AbstractGraphicsConfiguration config;
    protected long displayHandle;
    protected long surfaceHandle;
    protected int scrnIndex;
    protected int width;
    protected int height;

    public ProxySurface(AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        this(abstractGraphicsConfiguration, 0L);
    }

    public ProxySurface(AbstractGraphicsConfiguration abstractGraphicsConfiguration, long l) {
        this.invalidate();
        this.config = abstractGraphicsConfiguration;
        this.displayHandle = abstractGraphicsConfiguration.getScreen().getDevice().getHandle();
        this.surfaceHandle = l;
        this.scrnIndex = abstractGraphicsConfiguration.getScreen().getIndex();
    }

    protected void init(Object object) throws NativeWindowException {
    }

    protected void initNative() throws NativeWindowException {
    }

    public NativeWindow getParent() {
        return null;
    }

    public void destroy() {
        this.invalidate();
    }

    public synchronized void invalidate() {
        this.displayHandle = 0L;
        this.scrnIndex = -1;
        this.surfaceHandle = 0L;
    }

    public final int lockSurface() throws NativeWindowException {
        this.recurLock.lock();
        if (this.recurLock.getRecursionCount() == 0) {
            this.config.getScreen().getDevice().lock();
        }
        return 3;
    }

    public final void unlockSurface() {
        this.recurLock.validateLocked();
        if (this.recurLock.getRecursionCount() == 0) {
            this.config.getScreen().getDevice().unlock();
        }
        this.recurLock.unlock();
    }

    public final void validateSurfaceLocked() {
        this.recurLock.validateLocked();
    }

    public final int getSurfaceRecursionCount() {
        return this.recurLock.getRecursionCount();
    }

    public final boolean isSurfaceLockedByOtherThread() {
        return this.recurLock.isLockedByOtherThread();
    }

    public final boolean isSurfaceLocked() {
        return this.recurLock.isLocked();
    }

    public final Thread getSurfaceLockOwner() {
        return this.recurLock.getOwner();
    }

    public boolean surfaceSwap() {
        return false;
    }

    public long getSurfaceHandle() {
        return this.surfaceHandle;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config;
    }

    public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
    }

    public long getDisplayHandle() {
        return this.displayHandle;
    }

    public int getScreenIndex() {
        return this.scrnIndex;
    }

    public void setSurfaceHandle(long l) {
        this.surfaceHandle = l;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public String toString() {
        return "ProxySurface[config " + this.config + ", displayHandle 0x" + Long.toHexString(this.getDisplayHandle()) + ", surfaceHandle 0x" + Long.toHexString(this.getSurfaceHandle()) + ", size " + this.getWidth() + "x" + this.getHeight() + "]";
    }
}

