/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.blurSharpen;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.SpinBlur", category="ch.kuramo.javie.api.effectCategory.blurAndSharpen")
public class SpinBlur {
    @Property(value="0", min="0", max="360")
    private IAnimatableDouble amount;
    @Property
    private IAnimatableVec2d center;
    @Property(value="BOTH")
    private IAnimatableEnum<Direction> direction;
    @Property(value="100", min="0")
    private IAnimatableInteger maxSamples;
    @Property(value="true")
    private IAnimatableBoolean fast;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram clockwiseProgram;
    private final IShaderProgram countercwProgram;
    private final IShaderProgram bothProgram;
    @ShaderSource
    public static final String[] CLOCKWISE = SpinBlur.createShaderSource(Direction.CLOCKWISE);
    @ShaderSource
    public static final String[] COUNTERCLOCKWISE = SpinBlur.createShaderSource(Direction.COUNTERCLOCKWISE);
    @ShaderSource
    public static final String[] BOTH = SpinBlur.createShaderSource(Direction.BOTH);
    private static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$effects$blurSharpen$SpinBlur$Direction;

    @Inject
    public SpinBlur(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.clockwiseProgram = shaders.getProgram(SpinBlur.class, "CLOCKWISE");
        this.countercwProgram = shaders.getProgram(SpinBlur.class, "COUNTERCLOCKWISE");
        this.bothProgram = shaders.getProgram(SpinBlur.class, "BOTH");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IVideoBuffer doVideoEffect() {
        buffer = this.context.doPreviousEffect();
        bounds = buffer.getBounds();
        if (bounds.isEmpty()) {
            return buffer;
        }
        amount = (Double)this.context.value((IAnimatableValue)this.amount);
        maxSamples = (Integer)this.context.value((IAnimatableValue)this.maxSamples);
        if (amount == 0.0) return buffer;
        if (maxSamples == 0) {
            return buffer;
        }
        resolution = this.context.getVideoResolution();
        center = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.center));
        direction = (Direction)this.context.value(this.direction);
        fast = (Boolean)this.context.value((IAnimatableValue)this.fast);
        tmpBuffers = new HashSet<IVideoBuffer>();
        tmpBuffers.add(buffer);
        try {
            switch (SpinBlur.$SWITCH_TABLE$ch$kuramo$javie$effects$blurSharpen$SpinBlur$Direction()[direction.ordinal()]) {
                case 1: {
                    program = this.clockwiseProgram;
                    ++maxSamples;
                    break;
                }
                case 2: {
                    program = this.countercwProgram;
                    ++maxSamples;
                    break;
                }
                case 3: {
                    program = this.bothProgram;
                    amount *= 0.5;
                    break;
                }
                default: {
                    throw new RuntimeException("unknown spin direction: " + (Object)direction);
                }
            }
            var15_11 = this.multipassMaxSamples(maxSamples, fast);
            var14_12 = var15_11.length;
            var13_13 = 0;
            while (var13_13 < var14_12) {
                ms = var15_11[var13_13];
                uniforms = new HashSet<GLUniformData>();
                uniforms.add(new GLUniformData("texture", 0));
                uniforms.add(new GLUniformData("amount", (float)Math.toRadians(amount)));
                uniforms.add(new GLUniformData("center", 2, this.toFloatBuffer(new double[]{center.x - bounds.x, center.y - bounds.y})));
                uniforms.add(new GLUniformData("size", 2, this.toFloatBuffer(new double[]{bounds.width, bounds.height})));
                uniforms.add(new GLUniformData("maxSamples", (float)ms));
                buffer.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
                buffer.setTextureWrapMode(IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE);
                buffer = this.support.useShaderProgram(program, uniforms, null, new IVideoBuffer[]{buffer});
                tmpBuffers.add(buffer);
                amount /= (double)ms;
                ++var13_13;
            }
            tmpBuffers.remove(buffer);
            var18_16 = buffer;
            return var18_16;
        }
        finally {
            ** for (vb : tmpBuffers)
        }
lbl-1000:
        // 1 sources

        {
            vb.dispose();
            continue;
        }
lbl65:
        // 1 sources

        return var18_16;
    }

    private int[] multipassMaxSamples(int maxSamples, boolean fast) {
        if (!fast || maxSamples <= 10) {
            return new int[]{maxSamples};
        }
        if (maxSamples <= 100) {
            int ms1 = (int)Math.ceil(Math.sqrt(maxSamples));
            int ms2 = (int)Math.ceil((double)maxSamples / (double)ms1);
            return new int[]{ms1, ms2};
        }
        int ms1 = (int)Math.ceil(Math.cbrt(maxSamples));
        int ms2 = (int)Math.ceil((double)maxSamples / (double)ms1 / (double)ms1);
        return new int[]{ms1, ms1, ms2};
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] array = new float[values.length];
        int i = 0;
        while (i < values.length) {
            array[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(array);
    }

    private static String[] createShaderSource(Direction direction) {
        boolean cw = direction != Direction.COUNTERCLOCKWISE;
        boolean ccw = direction != Direction.CLOCKWISE;
        return new String[]{"uniform sampler2D texture;", "uniform float amount;", "uniform vec2 center;", "uniform vec2 size;", "uniform float maxSamples;", "", "void main(void)", "{", "\tvec2 coord = gl_TexCoord[0].st;", "\tvec4 color = texture2D(texture, coord);", "", "\tvec2 v = coord * size - center;", "\tfloat r = length(v);", "", "\tif (r > 0.0) {", "\t\tfloat arc = r*amount;", "\t\tint   n = int(min(arc+1.0, maxSamples));", "\t\tfor (int i = 1; i < n; ++i) {", "\t\t\tfloat t = amount*float(i)/float(n);", cw ? "\t\t\tcolor += texture2D(texture, (v * mat2(cos(t), sin(t), -sin(t), cos(t)) + center) / size);" : "", ccw ? "\t\t\tcolor += texture2D(texture, (v * mat2(cos(t), -sin(t), sin(t), cos(t)) + center) / size);" : "", "\t\t}", cw && ccw ? "\t\tcolor += texture2D(texture, (v * mat2(cos(amount), sin(amount), -sin(amount), cos(amount)) + center) / size) * 0.5;" : "", cw && ccw ? "\t\tcolor += texture2D(texture, (v * mat2(cos(amount), -sin(amount), sin(amount), cos(amount)) + center) / size) * 0.5;" : "", cw && ccw ? "\t\tcolor /= float(2*n);" : "\t\tcolor /= float(n);", "\t}", "", "\tgl_FragColor = color;", "}"};
    }

    static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$effects$blurSharpen$SpinBlur$Direction() {
        if ($SWITCH_TABLE$ch$kuramo$javie$effects$blurSharpen$SpinBlur$Direction != null) {
            return $SWITCH_TABLE$ch$kuramo$javie$effects$blurSharpen$SpinBlur$Direction;
        }
        int[] nArray = new int[Direction.values().length];
        try {
            nArray[Direction.BOTH.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Direction.CLOCKWISE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Direction.COUNTERCLOCKWISE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$ch$kuramo$javie$effects$blurSharpen$SpinBlur$Direction = nArray;
        return nArray;
    }

    @Effect(id="ch.kuramo.javie.SpinZoom", convertTo="SpinBlur")
    public static class ConvertFromSpinZoom {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        CLOCKWISE,
        COUNTERCLOCKWISE,
        BOTH;

    }
}

