/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.blurSharpen;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.ZoomBlur", category="ch.kuramo.javie.api.effectCategory.blurAndSharpen")
public class ZoomBlur {
    @Property(value="0", min="0", max="1000")
    private IAnimatableDouble amount;
    @Property
    private IAnimatableVec2d center;
    @Property(value="ZOOM_IN")
    private IAnimatableEnum<Direction> direction;
    @Property(value="100", min="0")
    private IAnimatableInteger maxSamples;
    @Property(value="true")
    private IAnimatableBoolean fast;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram zoomInProgram;
    private final IShaderProgram zoomOutProgram;
    private final IShaderProgram zoomBothProgram;
    @ShaderSource
    public static final String[] ZOOM_IN = ZoomBlur.createShaderSource(Direction.ZOOM_IN);
    @ShaderSource
    public static final String[] ZOOM_OUT = ZoomBlur.createShaderSource(Direction.ZOOM_OUT);
    @ShaderSource
    public static final String[] ZOOM_BOTH = ZoomBlur.createShaderSource(Direction.ZOOM_BOTH);
    private static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$effects$blurSharpen$ZoomBlur$Direction;

    @Inject
    public ZoomBlur(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.zoomInProgram = shaders.getProgram(ZoomBlur.class, "ZOOM_IN");
        this.zoomOutProgram = shaders.getProgram(ZoomBlur.class, "ZOOM_OUT");
        this.zoomBothProgram = shaders.getProgram(ZoomBlur.class, "ZOOM_BOTH");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IVideoBuffer doVideoEffect() {
        source = this.context.doPreviousEffect();
        bounds = source.getBounds();
        if (bounds.isEmpty()) {
            return source;
        }
        resolution = this.context.getVideoResolution();
        amount = resolution.scale(((Double)this.context.value((IAnimatableValue)this.amount)).doubleValue());
        maxSamples = (Integer)this.context.value((IAnimatableValue)this.maxSamples);
        if (amount == 0.0) return source;
        if (maxSamples == 0) {
            return source;
        }
        center = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.center));
        direction = (Direction)this.context.value(this.direction);
        fast = (Boolean)this.context.value((IAnimatableValue)this.fast);
        tmpBuffers = new HashSet<IVideoBuffer>();
        tmpBuffers.add(source);
        try {
            uniforms = new HashSet<GLUniformData>();
            if (fast) {
                switch (ZoomBlur.$SWITCH_TABLE$ch$kuramo$javie$effects$blurSharpen$ZoomBlur$Direction()[direction.ordinal()]) {
                    case 1: {
                        amountIn = amountOut = Math.min(amount / resolution.scale(200.0), 1.0) / (double)maxSamples * 5.0;
                        break;
                    }
                    case 2: {
                        amountIn = amountOut = amount / resolution.scale(200.0) / (double)maxSamples * 5.0;
                        break;
                    }
                    case 3: {
                        amountIn = Math.min(amount / resolution.scale(400.0), 1.0) / (double)maxSamples * 2.5;
                        amountOut = amount / resolution.scale(400.0) / (double)maxSamples * 2.5;
                        break;
                    }
                    default: {
                        throw new RuntimeException("unknown zoom direction: " + (Object)direction);
                    }
                }
                uniforms.add(new GLUniformData("amountIn", (float)Math.min(amountIn, 1.0)));
                uniforms.add(new GLUniformData("amountOut", (float)amountOut));
                uniforms.add(new GLUniformData("source", 0));
                uniforms.add(new GLUniformData("center", 2, this.toFloatBuffer(new double[]{center.x - bounds.x, center.y - bounds.y})));
                uniforms.add(new GLUniformData("size", 2, this.toFloatBuffer(new double[]{bounds.width, bounds.height})));
                uniforms.add(new GLUniformData("maxSamples", 5.0f));
                i = 0;
                while (i < 2) {
                    source.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
                    source.setTextureWrapMode(IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE);
                    source = this.support.useShaderProgram(this.zoomBothProgram, uniforms, null, new IVideoBuffer[]{source});
                    tmpBuffers.add(source);
                    ++i;
                }
                uniforms.clear();
                maxSamples = (int)Math.ceil((double)maxSamples / 5.0);
            }
            switch (ZoomBlur.$SWITCH_TABLE$ch$kuramo$javie$effects$blurSharpen$ZoomBlur$Direction()[direction.ordinal()]) {
                case 1: {
                    program = this.zoomInProgram;
                    uniforms.add(new GLUniformData("amountIn", (float)Math.min(amount /= resolution.scale(200.0), 1.0)));
                    break;
                }
                case 2: {
                    program = this.zoomOutProgram;
                    uniforms.add(new GLUniformData("amountOut", (float)(amount /= resolution.scale(200.0))));
                    break;
                }
                case 3: {
                    program = this.zoomBothProgram;
                    uniforms.add(new GLUniformData("amountIn", (float)Math.min(amount /= resolution.scale(400.0), 1.0)));
                    uniforms.add(new GLUniformData("amountOut", (float)amount));
                    break;
                }
                default: {
                    throw new RuntimeException("unknown zoom direction: " + (Object)direction);
                }
            }
            uniforms.add(new GLUniformData("source", 0));
            uniforms.add(new GLUniformData("center", 2, this.toFloatBuffer(new double[]{center.x - bounds.x, center.y - bounds.y})));
            uniforms.add(new GLUniformData("size", 2, this.toFloatBuffer(new double[]{bounds.width, bounds.height})));
            uniforms.add(new GLUniformData("maxSamples", (float)maxSamples));
            source.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
            source.setTextureWrapMode(IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE);
            var18_15 = this.support.useShaderProgram(program, uniforms, null, new IVideoBuffer[]{source});
            return var18_15;
        }
        finally {
            ** for (vb : tmpBuffers)
        }
lbl-1000:
        // 1 sources

        {
            vb.dispose();
            continue;
        }
lbl92:
        // 1 sources

        return var18_15;
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] array = new float[values.length];
        int i = 0;
        while (i < values.length) {
            array[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(array);
    }

    private static String[] createShaderSource(Direction direction) {
        boolean in = direction != Direction.ZOOM_OUT;
        boolean out = direction != Direction.ZOOM_IN;
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("uniform sampler2D source;", in ? "uniform float amountIn;" : "", out ? "uniform float amountOut;" : "", "uniform vec2 center;", "uniform vec2 size;", "uniform float maxSamples;", "", "void main(void)", "{", "\tvec2 coord = gl_TexCoord[0].st;", "\tvec2 v = center - coord * size;", "\tfloat d = length(v);", "", "\tvec4 color = texture2D(source, coord);", "", "\tif (d > 0.0) {", "\t\tv /= size;", "\t\tint n = 0;"));
        if (in) {
            list.addAll(Arrays.asList("\t\tint   n1 = int(min(amountIn*d+1.0, maxSamples));", "\t\tvec2  v1 = v*amountIn/float(n1);", "\t\tfor (int i = 1; i <= n1; ++i) {", "\t\t\tcolor += texture2D(source, coord + v1*float(i));", "\t\t}", "\t\tn += n1;"));
        }
        if (out) {
            list.addAll(Arrays.asList("\t\tint   n2 = int(min(amountOut*d+1.0, maxSamples));", "\t\tvec2  v2 = v*amountOut/float(n2);", "\t\tfor (int i = 1; i <= n2; ++i) {", "\t\t\tcolor += texture2D(source, coord - v2*float(i));", "\t\t}", "\t\tn += n2;"));
        }
        list.addAll(Arrays.asList("", "\t\tcolor /= float(n+1);", "\t}", "", "\tgl_FragColor = color;", "}"));
        return list.toArray(new String[list.size()]);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$effects$blurSharpen$ZoomBlur$Direction() {
        if ($SWITCH_TABLE$ch$kuramo$javie$effects$blurSharpen$ZoomBlur$Direction != null) {
            return $SWITCH_TABLE$ch$kuramo$javie$effects$blurSharpen$ZoomBlur$Direction;
        }
        int[] nArray = new int[Direction.values().length];
        try {
            nArray[Direction.ZOOM_BOTH.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Direction.ZOOM_IN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Direction.ZOOM_OUT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$ch$kuramo$javie$effects$blurSharpen$ZoomBlur$Direction = nArray;
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        ZOOM_IN,
        ZOOM_OUT,
        ZOOM_BOTH;

    }
}

