/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.distort;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.PolarCoordinates", category="ch.kuramo.javie.api.effectCategory.distort")
public class PolarCoordinates {
    @ShaderSource
    public static final String[] RECT_TO_POLAR = new String[]{"uniform sampler2D texture;", "uniform vec2 size;", "uniform vec2 center;", "uniform float radians_per_px;", "uniform float interp;", "", "void main(void)", "{", "\tvec2 coordRect = gl_TexCoord[0].st * size;", "\tvec2 fromCenter = coordRect - center;", "", "\tvec2 coordPolar = vec2(", "\t\t\tatan(fromCenter.x, fromCenter.y) / radians_per_px + center.x,", "\t\t\tlength(fromCenter) * 2.0);", "", "\tgl_FragColor = texture2D(texture, mix(coordRect, coordPolar, interp) / size);", "}"};
    @ShaderSource
    public static final String[] POLAR_TO_RECT = new String[]{"uniform sampler2D texture;", "uniform vec2 size;", "uniform vec2 center;", "uniform float radians_per_px;", "uniform float maxRadius_div_h;", "uniform float interp;", "", "void main(void)", "{", "\tvec2 coordPolar = gl_TexCoord[0].st * size;", "", "\tfloat theta = (coordPolar.x - center.x) * radians_per_px;", "\tvec2 coordRect = maxRadius_div_h * coordPolar.y * vec2(cos(theta), sin(theta)) + center;", "", "\tgl_FragColor = texture2D(texture, mix(coordPolar, coordRect, interp) / size);", "}"};
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram rectToPolarProgram;
    private final IShaderProgram polarToRectProgram;
    @Property(min="0", max="100")
    private IAnimatableDouble interpolation;
    @Property
    private IAnimatableEnum<TypeOfConversion> typeOfConversion;

    @Inject
    public PolarCoordinates(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.rectToPolarProgram = shaders.getProgram(PolarCoordinates.class, "RECT_TO_POLAR");
        this.polarToRectProgram = shaders.getProgram(PolarCoordinates.class, "POLAR_TO_RECT");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds bounds = input.getBounds();
        if (bounds.isEmpty()) {
            return input;
        }
        double interp = (Double)this.context.value((IAnimatableValue)this.interpolation);
        if (interp == 0.0) {
            return input;
        }
        TypeOfConversion type = (TypeOfConversion)((Object)this.context.value(this.typeOfConversion));
        IShaderProgram program = type == TypeOfConversion.RECT_TO_POLAR ? this.rectToPolarProgram : this.polarToRectProgram;
        int w = bounds.width;
        int h = bounds.height;
        try {
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("size", 2, FloatBuffer.wrap(new float[]{w, h})));
            uniforms.add(new GLUniformData("center", 2, FloatBuffer.wrap(new float[]{(float)w / 2.0f, (float)h / 2.0f})));
            uniforms.add(new GLUniformData("radians_per_px", (float)Math.toRadians(360.0 / (double)w)));
            if (type == TypeOfConversion.POLAR_TO_RECT) {
                uniforms.add(new GLUniformData("maxRadius_div_h", (float)(Math.sqrt(w * w + h * h) * 0.5 / (double)h)));
            }
            uniforms.add(new GLUniformData("interp", (float)(interp / 100.0)));
            input.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(program, uniforms, null, new IVideoBuffer[]{input});
            return iVideoBuffer;
        }
        finally {
            input.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeOfConversion {
        RECT_TO_POLAR,
        POLAR_TO_RECT;

    }
}

