/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.ITexture1DSupport;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.effects.generate.GradientBase;
import com.google.inject.Inject;
import javax.media.opengl.GL2;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;

@Effect(id="ch.kuramo.javie.LinearGradient", category="ch.kuramo.javie.api.effectCategory.generate")
public class LinearGradient
extends GradientBase {
    @Property
    private IAnimatableVec2d startPoint;
    @Property
    private IAnimatableVec2d endPoint;
    @Property(value="1,1,1")
    private IAnimatableColor startColor;
    @Property(value="0,0,0")
    private IAnimatableColor endColor;
    @Property(value="RGB")
    private IAnimatableEnum<GradientBase.ColorSpace> colorSpace;
    @Property(value="CLAMP_TO_EDGE")
    private IAnimatableEnum<GradientBase.RepeatMode> repeatMode;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property
    private IAnimatableEnum<BlendMode> blendMode;
    private final IVideoRenderSupport support;

    @Inject
    public LinearGradient(IVideoEffectContext context, IBlendSupport blendSupport, ITexture1DSupport tex1DSupport, IArrayPools arrayPools, IVideoRenderSupport support) {
        super(context, blendSupport, tex1DSupport, arrayPools);
        this.support = support;
    }

    public IVideoBuffer doVideoEffect() {
        return this.doGradientEffect((BlendMode)this.context.value(this.blendMode), (Double)this.context.value((IAnimatableValue)this.opacity) / 100.0);
    }

    protected IVideoBuffer createGradient(final VideoBounds bounds) {
        IVideoBuffer iVideoBuffer;
        LinearGradientParams p;
        block4: {
            Vec2d endPoint;
            Vec2d startPoint = (Vec2d)this.context.value((IAnimatableValue)this.startPoint);
            if (startPoint.equals((Object)(endPoint = (Vec2d)this.context.value((IAnimatableValue)this.endPoint)))) {
                IVideoBuffer buffer = this.context.createVideoBuffer(bounds);
                buffer.clear();
                return buffer;
            }
            p = new LinearGradientParams(bounds, startPoint, endPoint);
            IVideoBuffer gradient = null;
            try {
                Runnable operation = new Runnable(){

                    public void run() {
                        GL2 gl = LinearGradient.this.context.getGL().getGL2();
                        gl.glActiveTexture(33984);
                        gl.glBindTexture(3552, p.texture);
                        gl.glEnable(3552);
                        LinearGradient.this.support.ortho2D(bounds);
                        gl.glMatrixMode(5888);
                        gl.glTranslatef(p.translateX, p.translateY, 0.0f);
                        gl.glRotatef(p.rotateZ, 0.0f, 0.0f, 1.0f);
                        gl.glScalef(p.scaleX, p.scaleY, 1.0f);
                        gl.glTranslatef(-p.translateX, -p.translateY, 0.0f);
                        gl.glBegin(7);
                        gl.glTexCoord1f(p.texCoord0);
                        gl.glVertex2f(p.vertexLeft, p.vertexTop);
                        gl.glTexCoord1f(p.texCoord1);
                        gl.glVertex2f(p.vertexRight, p.vertexTop);
                        gl.glTexCoord1f(p.texCoord1);
                        gl.glVertex2f(p.vertexRight, p.vertexBottom);
                        gl.glTexCoord1f(p.texCoord0);
                        gl.glVertex2f(p.vertexLeft, p.vertexBottom);
                        gl.glEnd();
                    }
                };
                gradient = this.context.createVideoBuffer(bounds);
                gradient.clear();
                this.support.useFramebuffer(operation, 270336, gradient, new IVideoBuffer[0]);
                IVideoBuffer result = gradient;
                gradient = null;
                iVideoBuffer = result;
                if (gradient == null) break block4;
            }
            catch (Throwable throwable) {
                if (gradient != null) {
                    gradient.dispose();
                }
                this.deleteTextures(p.texture);
                throw throwable;
            }
            gradient.dispose();
        }
        this.deleteTextures(p.texture);
        return iVideoBuffer;
    }

    private class LinearGradientParams {
        private final float translateX;
        private final float translateY;
        private final float rotateZ;
        private final float scaleX;
        private final float scaleY;
        private final float texCoord0;
        private final float texCoord1;
        private final float vertexLeft;
        private final float vertexTop;
        private final float vertexRight;
        private final float vertexBottom;
        private final int texture;

        private LinearGradientParams(VideoBounds bounds, Vec2d startPoint, Vec2d endPoint) {
            Resolution resolution = LinearGradient.this.context.getVideoResolution();
            startPoint = resolution.scale(startPoint);
            endPoint = resolution.scale(endPoint);
            Vector2d startToEnd = new Vector2d(endPoint.x - startPoint.x, endPoint.y - startPoint.y);
            double x = bounds.x;
            double y = bounds.y;
            int w = bounds.width;
            int h = bounds.height;
            Point2d center = new Point2d(x + (double)w * 0.5, y + (double)h * 0.5);
            double theta = Math.atan2(startToEnd.y, startToEnd.x);
            double gradWidth = (double)w * Math.abs(Math.cos(theta)) + (double)h * Math.abs(Math.sin(theta));
            double gradHeight = (double)h * Math.abs(Math.cos(theta)) + (double)w * Math.abs(Math.sin(theta));
            double angle = Math.toDegrees(theta);
            this.translateX = (float)center.x;
            this.translateY = (float)center.y;
            this.rotateZ = (float)angle;
            this.scaleX = (float)(gradWidth / (double)w);
            this.scaleY = (float)(gradHeight / (double)h);
            Vector2d startToCenter = new Vector2d(center.x - startPoint.x, center.y - startPoint.y);
            Vector2d endToCenter = new Vector2d(center.x - endPoint.x, center.y - endPoint.y);
            double lenOfStartToEnd = startToEnd.length();
            this.texCoord0 = (float)(-(gradWidth * 0.5 - startToCenter.dot(startToEnd) / lenOfStartToEnd) / lenOfStartToEnd);
            this.texCoord1 = (float)(1.0 + (gradWidth * 0.5 + endToCenter.dot(startToEnd) / lenOfStartToEnd) / lenOfStartToEnd);
            this.vertexLeft = (float)x;
            this.vertexTop = (float)y;
            this.vertexRight = (float)(x + (double)w);
            this.vertexBottom = (float)(y + (double)h);
            Color startColor = (Color)LinearGradient.this.context.value((IAnimatableValue)LinearGradient.this.startColor);
            Color endColor = (Color)LinearGradient.this.context.value((IAnimatableValue)LinearGradient.this.endColor);
            GradientBase.ColorSpace colorSpace = (GradientBase.ColorSpace)((Object)LinearGradient.this.context.value((IAnimatableValue)LinearGradient.this.colorSpace));
            GradientBase.RepeatMode repeatMode = (GradientBase.RepeatMode)((Object)LinearGradient.this.context.value((IAnimatableValue)LinearGradient.this.repeatMode));
            int texSize = Math.min(Math.max((int)Math.ceil(lenOfStartToEnd), 2), 4000);
            switch (colorSpace) {
                case RGB: {
                    this.texture = LinearGradient.this.createRGBGradientTexture(startColor, endColor, texSize, repeatMode);
                    break;
                }
                case HSL: {
                    this.texture = LinearGradient.this.createHSLGradientTexture(startColor, endColor, false, texSize, repeatMode);
                    break;
                }
                case HSL_REVERSE_HUE: {
                    this.texture = LinearGradient.this.createHSLGradientTexture(startColor, endColor, true, texSize, repeatMode);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
    }
}

