/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.keying;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.effects.TexCoords;
import ch.kuramo.javie.effects.keying.KeyingShaders;
import ch.kuramo.javie.effects.keying.Smoothing;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.ChromaKey", category="ch.kuramo.javie.api.effectCategory.keying")
public class ChromaKey {
    @Property(value="1,1,1")
    private IAnimatableColor keyColor;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble similarity;
    @Property(value="10", min="0", max="100")
    private IAnimatableDouble blend;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble threshold;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble cutoff;
    @Property
    private IAnimatableEnum<Smoothing> smoothing;
    @Property
    private IAnimatableBoolean maskOnly;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram keyingProgram;
    private final IShaderProgram maskOnlyProgram;
    private final IShaderProgram smoothingLowProgram;
    private final IShaderProgram smoothingHighProgram;
    private static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$effects$keying$Smoothing;

    @Inject
    public ChromaKey(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.keyingProgram = shaders.getProgram(KeyingShaders.class, "CHROMA_KEY");
        this.maskOnlyProgram = shaders.getProgram(KeyingShaders.class, "CHROMA_KEY_MASK_ONLY");
        this.smoothingLowProgram = shaders.getProgram(KeyingShaders.class, "CHROMA_KEY_SMOOTHING_LOW");
        this.smoothingHighProgram = shaders.getProgram(KeyingShaders.class, "CHROMA_KEY_SMOOTHING_HIGH");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IVideoBuffer doVideoEffect() {
        input = this.context.doPreviousEffect();
        bounds = input.getBounds();
        if (bounds.isEmpty()) {
            return input;
        }
        keyColor = (Color)this.context.value((IAnimatableValue)this.keyColor);
        similarity = (Double)this.context.value((IAnimatableValue)this.similarity) / 100.0 * 0.4;
        blend = (Double)this.context.value((IAnimatableValue)this.blend) / 100.0 * 0.4;
        threshold = (Double)this.context.value((IAnimatableValue)this.threshold) / 100.0;
        cutoff = (Double)this.context.value((IAnimatableValue)this.cutoff) / 100.0;
        smoothing = (Smoothing)this.context.value(this.smoothing);
        maskOnly = (Boolean)this.context.value((IAnimatableValue)this.maskOnly);
        r = keyColor.r;
        g = keyColor.g;
        b = keyColor.b;
        u = -0.14713 * r - 0.28886 * g + 0.436 * b;
        v = 0.615 * r - 0.51499 * g - 0.10001 * b;
        tmpBuffers = new HashSet<IVideoBuffer>();
        tmpBuffers.add(input);
        try {
            uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("keyUV", 2, FloatBuffer.wrap(new float[]{(float)u, (float)v})));
            uniforms.add(new GLUniformData("similarity", (float)similarity));
            uniforms.add(new GLUniformData("blend", (float)blend));
            uniforms.add(new GLUniformData("t_minus_c", (float)(threshold - cutoff)));
            uniforms.add(new GLUniformData("cutoff", (float)cutoff));
            keyedOut = null;
            smoothMask = null;
            keyedOut = this.context.createVideoBuffer(bounds);
            tmpBuffers.add(keyedOut);
            v0 = program = maskOnly != false ? this.maskOnlyProgram : this.keyingProgram;
            if (smoothing == Smoothing.NONE || maskOnly) {
                this.support.useShaderProgram(program, uniforms, keyedOut, new IVideoBuffer[]{input});
            } else {
                smoothMask = this.context.createVideoBuffer(bounds);
                tmpBuffers.add(smoothMask);
                this.support.useShaderProgramMRT(program, uniforms, new IVideoBuffer[]{keyedOut, smoothMask}, new IVideoBuffer[]{input});
            }
            switch (ChromaKey.$SWITCH_TABLE$ch$kuramo$javie$effects$keying$Smoothing()[smoothing.ordinal()]) {
                case 2: {
                    program = this.smoothingLowProgram;
                    neib = TexCoords.neighboringOffset8(bounds.width, bounds.height);
                    break;
                }
                case 3: {
                    program = this.smoothingHighProgram;
                    neib = TexCoords.neighboringOffset24(bounds.width, bounds.height);
                    break;
                }
                default: {
                    tmpBuffers.remove(keyedOut);
                    var31_21 = keyedOut;
                    return var31_21;
                }
            }
            uniforms.clear();
            uniforms.add(new GLUniformData("tex0", 0));
            uniforms.add(new GLUniformData("tex1", 1));
            uniforms.add(new GLUniformData("neib[0]", 2, FloatBuffer.wrap(neib)));
            this.support.useShaderProgram(program, uniforms, input, new IVideoBuffer[]{keyedOut, smoothMask});
            tmpBuffers.remove(input);
            var31_22 = input;
            return var31_22;
        }
        finally {
            ** for (vb : tmpBuffers)
        }
lbl-1000:
        // 1 sources

        {
            vb.dispose();
            continue;
        }
lbl79:
        // 1 sources

        return var31_21;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$effects$keying$Smoothing() {
        if ($SWITCH_TABLE$ch$kuramo$javie$effects$keying$Smoothing != null) {
            return $SWITCH_TABLE$ch$kuramo$javie$effects$keying$Smoothing;
        }
        int[] nArray = new int[Smoothing.values().length];
        try {
            nArray[Smoothing.HIGH.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Smoothing.LOW.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Smoothing.NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$ch$kuramo$javie$effects$keying$Smoothing = nArray;
        return nArray;
    }
}

