/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.ConfigurationManager;
import org.eclipse.equinox.internal.ds.FactoryReg;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.Reference;
import org.eclipse.equinox.internal.ds.Resolver;
import org.eclipse.equinox.internal.ds.ServiceReg;
import org.eclipse.equinox.internal.ds.impl.ComponentFactoryImpl;
import org.eclipse.equinox.internal.ds.impl.ComponentInstanceImpl;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentInstance;

public class InstanceProcess {
    public static Resolver resolver;
    public static InstanceProcess staticRef;
    protected Hashtable factoryRegistrations;
    private Vector delayedBindList;
    static Hashtable buildingThreads;
    static Hashtable stackCounts;
    static int waitTime;
    boolean busyBuilding = false;
    Thread workingThread;
    Object lock = new Object();
    int lockCounter = 0;
    static /* synthetic */ Class class$0;

    static {
        buildingThreads = new Hashtable(7);
        stackCounts = new Hashtable(7);
        waitTime = Activator.getInteger("equinox.scr.waitTimeOnBlock", 10000);
    }

    InstanceProcess(Resolver resolver) {
        InstanceProcess.resolver = resolver;
        this.factoryRegistrations = new Hashtable(19);
        this.delayedBindList = new Vector(10);
        staticRef = this;
    }

    void dispose() {
        this.factoryRegistrations = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getLock() {
        Object object = this.lock;
        synchronized (object) {
            Thread currentThread = Thread.currentThread();
            if (!this.busyBuilding) {
                this.busyBuilding = true;
                ++this.lockCounter;
                this.workingThread = currentThread;
            } else if (this.workingThread == currentThread) {
                ++this.lockCounter;
            } else if (this.workingThread != currentThread) {
                long start = System.currentTimeMillis();
                long timeToWait = waitTime;
                boolean lockSucceeded = false;
                do {
                    try {
                        this.lock.wait(timeToWait);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.busyBuilding) continue;
                    this.busyBuilding = true;
                    ++this.lockCounter;
                    this.workingThread = currentThread;
                    lockSucceeded = true;
                    break;
                } while ((timeToWait = (long)waitTime + start - System.currentTimeMillis()) > 0L);
                if (!lockSucceeded) {
                    Activator.log.warning(NLS.bind((String)Messages.TIMEOUT_GETTING_LOCK, (Object)Integer.toString(waitTime)), (Throwable)new Exception("Debug stacktrace"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeLock() {
        Object object = this.lock;
        synchronized (object) {
            if (this.busyBuilding) {
                if (this.workingThread == Thread.currentThread()) {
                    --this.lockCounter;
                }
                if (this.lockCounter == 0) {
                    this.busyBuilding = false;
                    this.workingThread = null;
                    this.lock.notify();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void buildComponents(Vector list, boolean security) {
        scp = null;
        factoryPid = null;
        if (list != null) {
            i = 0;
            while (i < list.size()) {
                block29: {
                    scp = (ServiceComponentProp)list.elementAt(i);
                    this.getLock();
                    componentState = scp.getState();
                    if (componentState <= 1 || componentState > 2) {
                        this.freeLock();
                    } else {
                        block27: {
                            block28: {
                                start = 0L;
                                successfullyBuilt = true;
                                if (Activator.PERF) {
                                    start = System.currentTimeMillis();
                                    Activator.log.info(NLS.bind((String)Messages.START_BUILDING_COMPONENT, (Object)scp));
                                }
                                scp.setState(3);
                                sc = scp.serviceComponent;
                                if (sc.immediate || sc.factory == null && Activator.INSTANTIATE_ALL) {
                                    block26: {
                                        if (Activator.DEBUG) {
                                            Activator.log.debug(NLS.bind((String)Messages.BUILDING_IMMEDIATE_COMPONENT, (Object)scp.name), null);
                                        }
                                        if (scp.instances.isEmpty()) {
                                            try {
                                                this.buildComponent(null, scp, null, security);
                                            }
                                            catch (Exception e) {
                                                successfullyBuilt = false;
                                                if (e instanceof ComponentException) break block26;
                                                Activator.log.error(NLS.bind((String)Messages.CANNOT_BUILD_COMPONENT, (Object)scp), (Throwable)e);
                                            }
                                        }
                                    }
                                    if (sc.serviceInterfaces != null && successfullyBuilt) {
                                        this.registerService(scp, sc.serviceFactory, null);
                                    }
                                    break block27;
                                }
                                if (sc.factory == null || !scp.isComponentFactory()) break block28;
                                if (Activator.DEBUG) {
                                    Activator.log.debug(NLS.bind((String)Messages.BUILDING_COMPONENT_FACTORY, (Object)scp.name), null);
                                }
                                try {
                                    config = ConfigurationManager.getConfiguration(sc.name);
                                    if (config != null) {
                                        factoryPid = config.getFactoryPid();
                                    }
                                }
                                catch (Exception e) {
                                    Activator.log.error(NLS.bind((String)Messages.CANNOT_GET_CONFIGURATION, (Object)sc.name), (Throwable)e);
                                }
                                if (factoryPid != null) {
                                    toDisable = new Vector<ServiceComponent>(1);
                                    toDisable.addElement(sc);
                                    InstanceProcess.resolver.disableComponents(toDisable, 0);
                                    successfullyBuilt = false;
                                    throw new ComponentException(Messages.INCOMPATIBLE_COMBINATION);
                                }
                                this.registerComponentFactory(scp);
                                scp.setState(successfullyBuilt != false ? 4 : 0);
                                this.freeLock();
                                ** if (!Activator.PERF) goto lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    start = System.currentTimeMillis() - start;
                                    Activator.log.info(NLS.bind((String)Messages.COMPONENT_BUILT_TIME, (Object)scp, (Object)Long.toString(start)));
                                }
lbl-1000:
                                // 2 sources

                                {
                                    break block29;
                                }
                            }
                            try {
                                try {
                                    if (sc.provides != null) {
                                        this.registerService(scp, sc.serviceFactory, null);
                                    }
                                }
                                catch (Throwable t) {
                                    Activator.log.error(NLS.bind((String)Messages.EXCEPTION_BUILDING_COMPONENT, (Object)scp.serviceComponent), t);
                                    scp.setState(successfullyBuilt != false ? 4 : 0);
                                    this.freeLock();
                                    if (Activator.PERF) {
                                        start = System.currentTimeMillis() - start;
                                        Activator.log.info(NLS.bind((String)Messages.COMPONENT_BUILT_TIME, (Object)scp, (Object)Long.toString(start)));
                                    }
                                    break block29;
                                }
                            }
                            catch (Throwable var12_14) {
                                scp.setState(successfullyBuilt != false ? 4 : 0);
                                this.freeLock();
                                if (Activator.PERF) {
                                    start = System.currentTimeMillis() - start;
                                    Activator.log.info(NLS.bind((String)Messages.COMPONENT_BUILT_TIME, (Object)scp, (Object)Long.toString(start)));
                                }
                                throw var12_14;
                            }
                        }
                        scp.setState(successfullyBuilt != false ? 4 : 0);
                        this.freeLock();
                        if (Activator.PERF) {
                            start = System.currentTimeMillis() - start;
                            Activator.log.info(NLS.bind((String)Messages.COMPONENT_BUILT_TIME, (Object)scp, (Object)Long.toString(start)));
                        }
                    }
                }
                ++i;
            }
        }
    }

    void disposeInstances(Vector scpList, int deactivateReason) {
        if (scpList != null) {
            int i = 0;
            while (i < scpList.size()) {
                block13: {
                    ServiceComponentProp scp = (ServiceComponentProp)scpList.elementAt(i);
                    this.getLock();
                    if (scp.getState() <= 1) {
                        this.freeLock();
                    } else {
                        long start = 0L;
                        try {
                            try {
                                scp.setState(1);
                                if (Activator.PERF) {
                                    start = System.currentTimeMillis();
                                    Activator.log.info(NLS.bind((String)Messages.DISPOSING_COMPONENT, (Object)scp));
                                }
                                this.disposeInstances(scp, deactivateReason);
                            }
                            catch (Throwable t) {
                                Activator.log.error(NLS.bind((String)Messages.ERROR_DISPOSING_INSTANCES, (Object)scp), t);
                                resolver.componentDisposed(scp);
                                this.freeLock();
                                if (Activator.PERF) {
                                    start = System.currentTimeMillis() - start;
                                    Activator.log.info(NLS.bind((String)Messages.COMPONENT_DISPOSE_TIME, (Object)scp, (Object)Long.toString(start)));
                                }
                                break block13;
                            }
                        }
                        catch (Throwable throwable) {
                            resolver.componentDisposed(scp);
                            this.freeLock();
                            if (Activator.PERF) {
                                start = System.currentTimeMillis() - start;
                                Activator.log.info(NLS.bind((String)Messages.COMPONENT_DISPOSE_TIME, (Object)scp, (Object)Long.toString(start)));
                            }
                            throw throwable;
                        }
                        resolver.componentDisposed(scp);
                        this.freeLock();
                        if (Activator.PERF) {
                            start = System.currentTimeMillis() - start;
                            Activator.log.info(NLS.bind((String)Messages.COMPONENT_DISPOSE_TIME, (Object)scp, (Object)Long.toString(start)));
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void disposeInstances(ServiceComponentProp scp, int deactivateReason) {
        if (scp.isComponentFactory()) {
            if (Activator.DEBUG) {
                Activator.log.debug("InstanceProcess.disposeInstances(): disposing component factory " + scp.name, null);
            }
            ServiceRegistration reg = (ServiceRegistration)this.factoryRegistrations.remove(scp);
            try {
                if (reg != null) {
                    reg.unregister();
                }
            }
            catch (IllegalStateException illegalStateException) {
                Activator.log.warning(NLS.bind((String)Messages.FACTORY_REGISTRATION_ALREADY_DISPOSED, (Object)scp.name), null);
            }
        }
        ServiceComponent sc = scp.serviceComponent;
        if (sc.provides == null) {
            if (Activator.DEBUG) {
                Activator.log.debug("InstanceProcess.disposeInstances(): disposing non-provider component " + scp.name, null);
            }
            scp.dispose(deactivateReason);
        } else {
            if (Activator.DEBUG) {
                Activator.log.debug(NLS.bind((String)Messages.UNREGISTERING_COMPONENT, (Object)scp.name), null);
            }
            if (scp.registration != null) {
                try {
                    ServiceRegistration reg = scp.registration;
                    scp.setRegistration(null);
                    reg.unregister();
                }
                catch (IllegalStateException illegalStateException) {
                    Activator.log.warning(NLS.bind((String)Messages.REGISTRATION_ALREADY_DISPOSED, (Object)scp.name), null);
                }
            } else if (Activator.DEBUG) {
                Activator.log.debug(NLS.bind((String)Messages.CANNOT_FIND_REGISTRATION, (Object)scp.name), null);
            }
            scp.dispose(deactivateReason);
        }
    }

    private void registerComponentFactory(ServiceComponentProp scp) {
        if (this.factoryRegistrations.get(scp) != null) {
            return;
        }
        ComponentFactoryImpl factory = new ComponentFactoryImpl(scp);
        ServiceComponent sc = scp.serviceComponent;
        BundleContext bc = scp.bc;
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        properties.put("component.name", sc.name);
        properties.put("component.factory", sc.factory);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.component.ComponentFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceRegistration reg = bc.registerService(clazz.getName(), (Object)factory, properties);
        this.factoryRegistrations.put(scp, reg);
    }

    final void dynamicBind(Vector refList) {
        if (refList == null || refList.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < refList.size()) {
            Reference ref = (Reference)refList.elementAt(i);
            ServiceComponentProp scp = ref.scp;
            Vector instances = scp.instances;
            if (instances != null) {
                int j = 0;
                while (j < instances.size()) {
                    ComponentInstance compInstance = (ComponentInstance)instances.elementAt(j);
                    if (compInstance != null) {
                        try {
                            scp.bindReference(ref, compInstance);
                        }
                        catch (Exception exception) {}
                    }
                    ++j;
                }
            } else if (Activator.DEBUG) {
                Activator.log.debug(NLS.bind((String)Messages.NO_COMPONENT_INSTANCES, (Object)scp.name), null);
            }
            ++i;
        }
    }

    final void dynamicUnBind(Hashtable serviceTable) {
        try {
            if (serviceTable == null || serviceTable.isEmpty()) {
                return;
            }
            Enumeration e = serviceTable.keys();
            while (e.hasMoreElements()) {
                Reference ref = (Reference)e.nextElement();
                Hashtable serviceSubTable = (Hashtable)serviceTable.get(ref);
                Enumeration sub = serviceSubTable.keys();
                while (sub.hasMoreElements()) {
                    ServiceComponentProp scp = (ServiceComponentProp)sub.nextElement();
                    ServiceReference serviceReference = (ServiceReference)serviceSubTable.get(scp);
                    Vector instances = scp.instances;
                    int i = 0;
                    while (i < instances.size()) {
                        ComponentInstance compInstance = (ComponentInstance)instances.elementAt(i);
                        if (compInstance != null) {
                            try {
                                scp.unbindDynamicReference(ref, compInstance, serviceReference);
                            }
                            catch (Throwable t) {
                                Activator.log.error(NLS.bind((String)Messages.ERROR_UNBINDING_REFERENCE, (Object)ref.reference, (Object)compInstance.getInstance()), t);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Throwable e) {
            Activator.log.error(Messages.UNEXPECTED_ERROR, e);
        }
    }

    private void registerService(ServiceComponentProp scp, boolean factory, ComponentInstanceImpl ci) {
        ServiceRegistration reg = null;
        if (scp.registration != null) {
            return;
        }
        Object service = factory ? new FactoryReg(scp) : new ServiceReg(scp, ci);
        reg = scp.bc.registerService(scp.serviceComponent.provides, service, (Dictionary)scp.getPublicServiceProperties());
        if (Activator.DEBUG) {
            Activator.log.debug("InstanceProcess.registerService(): " + scp.name + " registered as " + (factory ? "*factory*" : "*service*"), null);
        }
        if (scp.getState() <= 1) {
            try {
                reg.unregister();
                if (Activator.DEBUG) {
                    Activator.log.debug("InstanceProcess.registerService(): " + NLS.bind((String)Messages.SERVICE_UNREGISTERED_BECAUSE_COMP_DISPOSED, (Object)scp.name), null);
                }
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            scp.setRegistration(reg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentInstanceImpl buildComponent(Bundle usingBundle, ServiceComponentProp scp, Object instance, boolean security) throws ComponentException {
        ServiceComponentProp serviceComponentProp;
        ComponentInstanceImpl componentInstanceImpl;
        Counter counter;
        if (Activator.DEBUG) {
            Activator.log.debug(NLS.bind((String)Messages.BUILDING_COMPONENT, (Object)scp.name), null);
        }
        this.getLock();
        Thread curThread = Thread.currentThread();
        ServiceComponentProp serviceComponentProp2 = scp;
        synchronized (serviceComponentProp2) {
            Thread theSCPThread = (Thread)buildingThreads.get(scp);
            if (theSCPThread != null && curThread != theSCPThread && !scp.isKindOfFactory()) {
                long start = System.currentTimeMillis();
                long timeToWait = waitTime;
                do {
                    try {
                        scp.wait(timeToWait);
                    }
                    catch (InterruptedException interruptedException) {}
                } while (buildingThreads.get(scp) != null && (timeToWait = (long)waitTime + start - System.currentTimeMillis()) > 0L);
                if (buildingThreads.get(scp) != null) {
                    this.freeLock();
                    if (!scp.instances.isEmpty()) {
                        Activator.log.warning(Messages.RETURNING_NOT_FULLY_ACTIVATED_INSTANCE, (Throwable)new Exception("Debug callstack"));
                        return (ComponentInstanceImpl)scp.instances.firstElement();
                    }
                    throw new RuntimeException(NLS.bind((String)Messages.INSTANCE_CREATION_TOOK_LONGER, (Object)scp, (Object)Integer.toString(waitTime)));
                }
            }
            buildingThreads.put(scp, curThread);
            counter = (Counter)stackCounts.get(curThread);
            if (counter == null) {
                counter = new Counter();
                stackCounts.put(curThread, counter);
            }
            ++counter.count;
        }
        long start = 0L;
        try {
            if (Activator.PERF) {
                start = System.currentTimeMillis();
                Activator.log.info(NLS.bind((String)Messages.BUILDING_COMPONENT_INSTANCE, (Object)scp));
            }
            ComponentInstanceImpl componentInstance = null;
            try {
                try {
                    componentInstance = scp.build(usingBundle, instance, security);
                }
                catch (ComponentException e) {
                    Activator.log.error(e.getMessage(), e.getCause());
                    throw e;
                }
                catch (Throwable t) {
                    Activator.log.error(NLS.bind((String)Messages.ERROR_BUILDING_COMPONENT_INSTANCE, (Object)scp.serviceComponent), t);
                    throw new ComponentException(NLS.bind((String)Messages.ERROR_BUILDING_COMPONENT_INSTANCE, (Object)scp.serviceComponent), t);
                }
            }
            finally {
                --counter.count;
                if (Activator.PERF) {
                    start = System.currentTimeMillis() - start;
                    Activator.log.info(NLS.bind((String)Messages.COMPONENT_INSTANCE_BUILT, (Object)scp, (Object)Long.toString(start)));
                }
            }
            if (counter.count == 0 && !this.delayedBindList.isEmpty()) {
                InstanceProcess.resolver.mgr.enqueueWork(resolver, 2, this.delayedBindList.clone(), security);
                this.delayedBindList.removeAllElements();
            }
            componentInstanceImpl = componentInstance;
            serviceComponentProp = scp;
        }
        catch (Throwable throwable) {
            ServiceComponentProp serviceComponentProp3 = scp;
            synchronized (serviceComponentProp3) {
                if (counter.count == 0) {
                    stackCounts.remove(curThread);
                }
                buildingThreads.remove(scp);
                scp.notify();
            }
            this.freeLock();
            throw throwable;
        }
        synchronized (serviceComponentProp) {
            if (counter.count == 0) {
                stackCounts.remove(curThread);
            }
            buildingThreads.remove(scp);
            scp.notify();
        }
        this.freeLock();
        return componentInstanceImpl;
    }

    public void modifyComponent(ServiceComponentProp scp, Dictionary newProps) throws ComponentException {
        if (Activator.DEBUG) {
            Activator.log.debug(NLS.bind((String)Messages.MODIFYING_COMPONENT, (Object)scp.name), null);
        }
        this.getLock();
        long start = 0L;
        try {
            if (Activator.PERF) {
                start = System.currentTimeMillis();
                Activator.log.info(NLS.bind((String)Messages.MODIFYING_COMPONENT, (Object)scp));
            }
            try {
                try {
                    scp.modify(newProps);
                }
                catch (ComponentException e) {
                    Activator.log.error(e.getMessage(), e.getCause());
                    throw e;
                }
                catch (Throwable t) {
                    Activator.log.error(NLS.bind((String)Messages.ERROR_MODIFYING_COMPONENT, (Object)scp.serviceComponent), t);
                    throw new ComponentException(NLS.bind((String)Messages.ERROR_MODIFYING_COMPONENT, (Object)scp.serviceComponent), t);
                }
            }
            finally {
                if (Activator.PERF) {
                    start = System.currentTimeMillis() - start;
                    Activator.log.info(NLS.bind((String)Messages.COMPONENT_MODIFIED_FOR, (Object)scp, (Object)Long.toString(start)));
                }
            }
        }
        finally {
            this.freeLock();
        }
    }

    public Object getService(Reference reference, ServiceReference serviceReference) {
        if (this.checkCanCauseCycle(reference, serviceReference)) {
            if (Activator.DEBUG) {
                Activator.log.debug(NLS.bind((String)Messages.CANNOT_GET_SERVICE_BECAUSEOF_CIRCULARITY, (Object)reference.reference.name, (Object)serviceReference), null);
            }
            return null;
        }
        return reference.scp.bc.getService(serviceReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCanCauseCycle(Reference reference, ServiceReference serviceReference) {
        int i;
        ServiceComponentProp consumerSCP = reference.scp;
        if (buildingThreads.isEmpty()) {
            return false;
        }
        String producerComponentName = (String)serviceReference.getProperty("component.name");
        if (producerComponentName == null) {
            return false;
        }
        if (consumerSCP.getDelayActivateSCPNames() == null || !consumerSCP.getDelayActivateSCPNames().contains(producerComponentName)) {
            return false;
        }
        ServiceComponentProp producerSCP = null;
        Object object = resolver.getSyncLock();
        synchronized (object) {
            i = 0;
            while (i < InstanceProcess.resolver.scpEnabled.size()) {
                ServiceComponentProp scp = (ServiceComponentProp)InstanceProcess.resolver.scpEnabled.elementAt(i);
                if (producerComponentName.equals(scp.serviceComponent.name)) {
                    producerSCP = scp;
                    break;
                }
                ++i;
            }
        }
        if (producerSCP != null) {
            if (producerSCP.serviceComponent.serviceFactory) {
                if (!producerSCP.instances.isEmpty()) {
                    Bundle bundle = consumerSCP.bc.getBundle();
                    i = 0;
                    while (i < producerSCP.instances.size()) {
                        ComponentInstanceImpl producerComponentInstance = (ComponentInstanceImpl)producerSCP.instances.elementAt(i);
                        if (producerComponentInstance.getComponentContext().getUsingBundle().equals(bundle)) {
                            return false;
                        }
                        ++i;
                    }
                }
            } else if (!producerSCP.instances.isEmpty()) {
                return false;
            }
        }
        if (reference.reference.bind != null && reference.policy == 1) {
            this.delayedBindList.addElement(reference);
        }
        return true;
    }

    class Counter {
        int count = 0;

        Counter() {
        }
    }
}

