/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.expression;

import ch.kuramo.javie.core.expression.ExpressionUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public abstract class Interpolation {
    public static final String[] METHOD_NAMES = new String[]{"linear", "ease", "easeIn", "easeOut"};
    private static final Interpolation LINEAR = new Interpolation(){

        public double interpolate(double t) {
            return t;
        }
    };
    private static final Interpolation EASE = new Interpolation(){

        public double interpolate(double t) {
            return t * t * (3.0 - 2.0 * t);
        }
    };
    private static final Interpolation EASE_IN = new Interpolation(){

        public double interpolate(double t) {
            return (t *= 0.75) * t * (3.0 - 2.0 * t) / 0.84375;
        }
    };
    private static final Interpolation EASE_OUT = new Interpolation(){

        public double interpolate(double t) {
            t = 0.75 * (t + 0.3333333333333333);
            return (t * t * (3.0 - 2.0 * t) - 0.15625) / 0.84375;
        }
    };

    public static Object linear(Context cx, Scriptable thisObj, Object[] args, Function funOb) {
        return LINEAR.interpolate(cx, thisObj, args, funOb);
    }

    public static Object ease(Context cx, Scriptable thisObj, Object[] args, Function funOb) {
        return EASE.interpolate(cx, thisObj, args, funOb);
    }

    public static Object easeIn(Context cx, Scriptable thisObj, Object[] args, Function funOb) {
        return EASE_IN.interpolate(cx, thisObj, args, funOb);
    }

    public static Object easeOut(Context cx, Scriptable thisObj, Object[] args, Function funOb) {
        return EASE_OUT.interpolate(cx, thisObj, args, funOb);
    }

    private Interpolation() {
    }

    protected abstract double interpolate(double var1);

    private Object interpolate(Context cx, Scriptable thisObj, Object[] args, Function funOb) {
        double[] dArray;
        double[] a1;
        double[] dArray2;
        Object o2;
        Object o1;
        double t;
        if (args.length == 5) {
            t = Context.toNumber((Object)args[0]);
            double tMin = Context.toNumber((Object)args[1]);
            double tMax = Context.toNumber((Object)args[2]);
            o1 = ExpressionUtils.toDoubleOrDoubleArray(args[3]);
            o2 = ExpressionUtils.toDoubleOrDoubleArray(args[4]);
            t = (t - tMin) / (tMax - tMin);
        } else if (args.length == 3) {
            t = Context.toNumber((Object)args[0]);
            o1 = ExpressionUtils.toDoubleOrDoubleArray(args[1]);
            o2 = ExpressionUtils.toDoubleOrDoubleArray(args[2]);
        } else {
            throw new IllegalArgumentException();
        }
        t = Math.min(Math.max(0.0, t), 1.0);
        t = this.interpolate(t);
        if (o1 instanceof Double && o2 instanceof Double) {
            double d1 = (Double)o1;
            double d2 = (Double)o2;
            return d1 + (d2 - d1) * t;
        }
        if (o1 instanceof Double) {
            double[] dArray3 = new double[1];
            dArray2 = dArray3;
            dArray3[0] = (Double)o1;
        } else {
            dArray2 = a1 = (double[])o1;
        }
        if (o2 instanceof Double) {
            double[] dArray4 = new double[1];
            dArray = dArray4;
            dArray4[0] = (Double)o2;
        } else {
            dArray = (double[])o2;
        }
        double[] a2 = dArray;
        double[] a = new double[Math.max(a1.length, a2.length)];
        int i = 0;
        while (i < a.length) {
            double d1 = i < a1.length ? a1[i] : 0.0;
            double d2 = i < a2.length ? a2[i] : 1.0;
            a[i] = d1 + (d2 - d1) * t;
            ++i;
        }
        return a;
    }

    /* synthetic */ Interpolation(Interpolation interpolation) {
        this();
    }
}

