/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.FrameDuration;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.MediaOptions;
import ch.kuramo.javie.core.MediaSource;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.SynchronousTaskThread;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AviSynthSource
implements MediaSource {
    private static final Logger logger = LoggerFactory.getLogger(AviSynthSource.class);
    private SynchronousTaskThread thread;
    private long envPointer;
    private long clipPointer;
    private VideoBounds bounds;
    private Time duration;
    private Time videoFrameDuration;
    private AudioFormat audioFormat;
    private boolean audioFloat;
    private Time audioDuration;
    private AudioMode audioMode;
    private AudioInputStream audioStream;
    private long audioStreamPosition;
    private final RenderContext context;
    private final IVideoRenderSupport vrSupport;
    private final AudioRenderSupport arSupport;
    private final IArrayPools arrayPools;
    private final Injector injector;

    static {
        System.loadLibrary("AviSynthSource");
    }

    @Inject
    public AviSynthSource(RenderContext context, IVideoRenderSupport vrSupport, AudioRenderSupport arSupport, IArrayPools arrayPools, Injector injector) {
        this.context = context;
        this.vrSupport = vrSupport;
        this.arSupport = arSupport;
        this.arrayPools = arrayPools;
        this.injector = injector;
    }

    public boolean initialize(File file) {
        if (!this.hasExtension(file, "avs")) {
            return false;
        }
        final byte[] filename = this.filenameToBytes(file.getAbsolutePath());
        SynchronousTaskThread thread = (SynchronousTaskThread)this.injector.getInstance(SynchronousTaskThread.class);
        thread.setName(String.valueOf(this.getClass().getSimpleName()) + ": " + file.getName());
        thread.start();
        this.thread = thread;
        thread.invoke(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() throws Exception {
                AviSynthSource.this.envPointer = AviSynthSource.this.createScriptEnvironment();
                if (AviSynthSource.this.envPointer == 0L) {
                    return;
                }
                long[] result = AviSynthSource.this.openAVS(AviSynthSource.this.envPointer, filename);
                if (result == null || result[0] == 0L) {
                    return;
                }
                AviSynthSource.this.clipPointer = result[0];
                if (result[1] > 0L) {
                    AviSynthSource.this.bounds = new VideoBounds((int)result[1], (int)result[2]);
                    AviSynthSource.this.videoFrameDuration = new Time(result[4], (int)result[3]);
                    AviSynthSource.this.duration = Time.fromFrameNumber((long)result[5], (Time)AviSynthSource.this.videoFrameDuration);
                }
                if (result[6] > 0L) {
                    AviSynthSource.this.audioFormat = new AudioFormat(result[6], (int)result[7] * 8, (int)result[8], true, false);
                    AviSynthSource.this.audioFloat = result[10] != 0L;
                    AviSynthSource.this.audioDuration = Time.fromFrameNumber((long)result[9], (Time)new Time(1L, (int)result[6]));
                    if (AviSynthSource.this.duration == null) {
                        AviSynthSource.this.duration = AviSynthSource.this.audioDuration;
                    }
                }
            }
        });
        if (this.isVideoAvailable() || this.isAudioAvailable()) {
            return true;
        }
        this.dispose();
        return false;
    }

    protected boolean hasExtension(File file, String extension) {
        String fileName;
        int lastDot;
        if (extension.length() > 0 && extension.charAt(0) == '.') {
            extension = extension.substring(1);
        }
        if ((lastDot = (fileName = file.getName()).lastIndexOf(46)) != -1) {
            return extension.toLowerCase().equals(fileName.substring(lastDot + 1).toLowerCase());
        }
        return false;
    }

    private byte[] filenameToBytes(String filename) {
        filename = String.valueOf(filename) + '\u0000';
        try {
            return filename.getBytes("Windows-31J");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                return filename.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                return filename.getBytes();
            }
        }
    }

    public void dispose() {
        this.closeAudioStream();
        if (this.thread != null) {
            this.thread.exit(new SynchronousTaskThread.TaskWithoutResult(){

                protected void runWithoutResult() throws Exception {
                    if (AviSynthSource.this.clipPointer != 0L) {
                        AviSynthSource.this.closeAVS(AviSynthSource.this.clipPointer);
                        AviSynthSource.this.clipPointer = 0L;
                    }
                    if (AviSynthSource.this.envPointer != 0L) {
                        AviSynthSource.this.deleteScriptEnvironment(AviSynthSource.this.envPointer);
                        AviSynthSource.this.envPointer = 0L;
                    }
                }
            });
        }
        this.bounds = null;
        this.duration = null;
        this.videoFrameDuration = null;
        this.audioFormat = null;
        this.audioDuration = null;
        this.audioMode = null;
    }

    public boolean isVideoAvailable() {
        return this.bounds != null;
    }

    public boolean isAudioAvailable() {
        return this.audioFormat != null;
    }

    public Time getDuration(MediaOptions options) {
        return this.duration;
    }

    public Time getVideoFrameDuration(MediaOptions options) {
        return this.videoFrameDuration;
    }

    public VideoBounds getVideoFrameBounds(MediaOptions options) {
        return this.bounds;
    }

    public IVideoBuffer getVideoFrame(Time mediaTime, MediaOptions options) {
        if (!this.isVideoAvailable()) {
            return null;
        }
        IVideoBuffer buffer = null;
        try {
            byte[] array;
            buffer = this.vrSupport.createVideoBuffer(this.bounds, ColorMode.RGBA8);
            if (mediaTime.timeValue < 0L || !mediaTime.before(this.getDuration(options))) {
                buffer.clear();
                IVideoBuffer result = buffer;
                buffer = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            final int frameNumber = (int)mediaTime.toFrameNumber(this.videoFrameDuration);
            boolean successful = this.thread.invoke(new SynchronousTaskThread.Task<Boolean>(array = (byte[])buffer.getArray()){
                private final /* synthetic */ byte[] val$array;
                {
                    this.val$array = byArray;
                }

                @Override
                public Boolean run() throws Exception {
                    boolean successful = AviSynthSource.this.getFrame(AviSynthSource.this.envPointer, AviSynthSource.this.clipPointer, frameNumber, this.val$array);
                    if (!successful) {
                        logger.error("getFrame failed.");
                    }
                    return successful;
                }
            });
            if (!successful) {
                return null;
            }
            IVideoBuffer iVideoBuffer = this.convertByResolutionAndOptions(buffer, options);
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private IVideoBuffer convertByResolutionAndOptions(IVideoBuffer srcBuffer, MediaOptions options) {
        Resolution resolution = this.context.getVideoResolution();
        final VideoBounds srcBounds = srcBuffer.getBounds();
        final VideoBounds dstBounds = resolution.scale(this.bounds);
        final float scale = (float)resolution.scale;
        final boolean flipVertical = options.isFlipVertical();
        final MediaOptions.AlphaType alphaType = options.getAlphaType();
        final Color colorMatte = options.getColorMatte();
        Runnable operation = new Runnable(){

            public void run() {
                GL2 gl = AviSynthSource.this.context.getGL().getGL2();
                GLU glu = AviSynthSource.this.context.getGLU();
                gl.glViewport(0, 0, dstBounds.width, dstBounds.height);
                gl.glMatrixMode(5889);
                gl.glLoadIdentity();
                if (flipVertical) {
                    glu.gluOrtho2D(0.0f, (float)dstBounds.width, 0.0f, (float)dstBounds.height);
                } else {
                    glu.gluOrtho2D(0.0f, (float)dstBounds.width, (float)dstBounds.height, 0.0f);
                }
                gl.glMatrixMode(5888);
                gl.glLoadIdentity();
                gl.glScalef(scale, scale, 1.0f);
                switch (alphaType) {
                    case IGNORE: {
                        gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
                        gl.glClear(16384);
                        gl.glEnable(3042);
                        gl.glBlendFuncSeparate(1, 0, 0, 1);
                        gl.glBlendEquation(32774);
                        break;
                    }
                    case STRAIGHT: {
                        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                        gl.glClear(16384);
                        gl.glEnable(3042);
                        gl.glBlendFuncSeparate(770, 0, 1, 0);
                        gl.glBlendEquation(32774);
                        break;
                    }
                    case PREMULTIPLIED: {
                        if (colorMatte.r == 0.0 && colorMatte.g == 0.0 && colorMatte.b == 0.0) {
                            gl.glDisable(3042);
                            break;
                        }
                        gl.glClearColor((float)colorMatte.r, (float)colorMatte.g, (float)colorMatte.b, 1.0f);
                        gl.glClear(16384);
                        gl.glEnable(3042);
                        gl.glBlendFuncSeparate(1, 771, 1, 0);
                        gl.glBlendEquation(32778);
                    }
                }
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                gl.glBegin(7);
                gl.glTexCoord2f(0.0f, 0.0f);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glTexCoord2f(1.0f, 0.0f);
                gl.glVertex2f((float)srcBounds.width, 0.0f);
                gl.glTexCoord2f(1.0f, 1.0f);
                gl.glVertex2f((float)srcBounds.width, (float)srcBounds.height);
                gl.glTexCoord2f(0.0f, 1.0f);
                gl.glVertex2f(0.0f, (float)srcBounds.height);
                gl.glEnd();
            }
        };
        int pushAttribs = 24577;
        IVideoBuffer buffer = null;
        try {
            buffer = this.vrSupport.createVideoBuffer(dstBounds);
            this.vrSupport.useFramebuffer(operation, pushAttribs, buffer, new IVideoBuffer[]{srcBuffer});
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    public synchronized IAudioBuffer getAudioChunk(Time mediaTime, MediaOptions options) {
        if (!this.isAudioAvailable()) {
            return null;
        }
        try {
            AudioMode audioMode = this.context.getAudioMode();
            long frameNumber = mediaTime.toFrameNumber(audioMode.sampleDuration);
            if (-frameNumber >= (long)this.context.getAudioFrameCount() || !mediaTime.before(this.getDuration(options))) {
                IAudioBuffer ab = this.arSupport.createAudioBuffer();
                this.arSupport.clear(ab);
                return ab;
            }
            if (audioMode != this.audioMode || (long)audioMode.frameSize * frameNumber != this.audioStreamPosition) {
                this.closeAudioStream();
            }
            if (this.audioStream == null) {
                this.audioStream = this.createAudioStream();
            }
            return this.readAudioData(frameNumber);
        }
        catch (IOException e) {
            throw new JavieRuntimeException(e);
        }
        catch (UnsupportedAudioFileException e) {
            throw new JavieRuntimeException(e);
        }
    }

    private AudioInputStream createAudioStream() throws IOException, UnsupportedAudioFileException {
        this.audioMode = this.context.getAudioMode();
        int bits = this.audioMode.sampleSize * 8;
        int ch = this.audioMode.channels;
        long length = this.audioDuration.toFrameNumber(new Time(1L, (int)this.audioFormat.getFrameRate()));
        AudioInputStream s1 = AudioSystem.getAudioInputStream(this.audioFormat, new AudioInputStream(new AviSynthAudioInputStream(this.audioFormat), this.audioFormat, length));
        AudioFormat f2 = new AudioFormat(s1.getFormat().getSampleRate(), bits, ch, true, false);
        AudioInputStream s2 = AudioSystem.getAudioInputStream(f2, s1);
        AudioFormat f3 = new AudioFormat(this.audioMode.sampleRate, bits, ch, true, false);
        return AudioSystem.getAudioInputStream(f3, s2);
    }

    private void closeAudioStream() {
        if (this.audioStream != null) {
            try {
                this.audioStream.close();
            }
            catch (IOException e) {
                logger.warn("failed to close AudioInputStream", (Throwable)e);
            }
            this.audioStream = null;
        }
        this.audioStreamPosition = 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IAudioBuffer readAudioData(long frameNumber) throws IOException {
        IAudioBuffer ab = this.arSupport.createAudioBuffer();
        AudioMode audioMode = ab.getAudioMode();
        Object data = ab.getData();
        int dataOffset = 0;
        int dataLength = ab.getDataLength();
        int lengthInBytes = dataLength * audioMode.sampleSize;
        if (this.audioStreamPosition == 0L) {
            if (frameNumber > 0L) {
                long skipped;
                long skip = (long)audioMode.frameSize * frameNumber;
                this.audioStreamPosition = skipped = this.audioStream.skip(skip / (long)audioMode.sampleRate * (long)audioMode.sampleRate);
                if ((skip -= skipped) > 0L) {
                    IArray array = this.arrayPools.getByteArray((int)skip);
                    try {
                        do {
                            if ((skipped = (long)this.audioStream.read((byte[])array.getArray(), 0, (int)skip)) == -1L) continue;
                            this.audioStreamPosition += skipped;
                            skip -= skipped;
                        } while (skipped != -1L && skip > 0L);
                    }
                    finally {
                        array.release();
                    }
                }
                if (skip != 0L) {
                    logger.warn(String.format("skip failed: frameNumber=%d, skip=%d", frameNumber, skip));
                    this.closeAudioStream();
                    this.arSupport.clear(ab);
                    return ab;
                }
            } else if (frameNumber < 0L) {
                this.arSupport.clear(ab, 0, (int)(-frameNumber));
                dataOffset = (int)(-frameNumber) * audioMode.channels;
                dataLength -= dataOffset;
                lengthInBytes -= dataOffset * audioMode.sampleSize;
            }
        }
        IArray array = this.arrayPools.getByteArray(lengthInBytes);
        try {
            int n;
            byte[] buffer = (byte[])array.getArray();
            int readBytes = 0;
            do {
                if ((n = this.audioStream.read(buffer, readBytes, lengthInBytes - readBytes)) == -1) {
                    Arrays.fill(buffer, readBytes, lengthInBytes, (byte)0);
                    break;
                }
                this.audioStreamPosition += (long)n;
            } while ((readBytes += n) < lengthInBytes);
            switch (audioMode.dataType) {
                case SHORT: {
                    ByteBuffer.wrap(buffer, 0, lengthInBytes).order(ByteOrder.nativeOrder()).asShortBuffer().get((short[])data, dataOffset, dataLength);
                    return ab;
                }
                case INT: {
                    ByteBuffer.wrap(buffer, 0, lengthInBytes).order(ByteOrder.nativeOrder()).asIntBuffer().get((int[])data, dataOffset, dataLength);
                    return ab;
                }
                case FLOAT: {
                    int i = dataOffset;
                    while (i < dataLength) {
                        int value = buffer[i * 4] & 0xFF | (buffer[i * 4 + 1] & 0xFF) << 8 | (buffer[i * 4 + 2] & 0xFF) << 16 | (buffer[i * 4 + 3] & 0xFF) << 24;
                        ((float[])data)[i] = (float)value / 2.1474836E9f;
                        ++i;
                    }
                    return ab;
                }
            }
            throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audioMode.dataType);
        }
        finally {
            array.release();
        }
    }

    public MediaOptions validateOptions(MediaOptions options) {
        MediaOptions.Option[] availableOptions = this.isVideoAvailable() ? new MediaOptions.Option[]{MediaOptions.Option.IGNORE_ALPHA, MediaOptions.Option.STRAIGHT_ALPHA, MediaOptions.Option.PREMULTIPLIED_ALPHA, MediaOptions.Option.FLIP_VERTICAL} : new MediaOptions.Option[]{};
        if (options == null) {
            options = new MediaOptions(availableOptions);
            if (this.isVideoAvailable()) {
                options.setAlphaType(MediaOptions.AlphaType.IGNORE);
            }
        } else {
            options = options.clone();
            options.setAvailableOptions(availableOptions);
        }
        return options;
    }

    private native long createScriptEnvironment();

    private native void deleteScriptEnvironment(long var1);

    private native long[] openAVS(long var1, byte[] var3);

    private native void closeAVS(long var1);

    private native boolean getFrame(long var1, long var3, int var5, byte[] var6);

    private native boolean getAudio(long var1, long var3, long var5, long var7, byte[] var9, int var10);

    private class AviSynthAudioInputStream
    extends InputStream {
        private final AudioFormat format;
        private long positionInBytes;

        private AviSynthAudioInputStream(AudioFormat format) {
            this.format = format;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            return this.read(b, 0, 0) != -1 ? b[0] : -1;
        }

        public int read(final byte[] b, final int off, int len) throws IOException {
            final int frameSize = this.format.getFrameSize();
            if (len % frameSize != 0) {
                throw new IOException("can't read the length bytes that is not multiples of frameSize");
            }
            Time frameDuration = AviSynthSource.this.isVideoAvailable() ? AviSynthSource.this.videoFrameDuration : FrameDuration.FPS_29_97;
            final long count1 = (int)Math.round((double)this.format.getSampleRate() * frameDuration.toSecond());
            final long start = this.positionInBytes / (long)frameSize;
            final long count = len / frameSize;
            boolean successful = AviSynthSource.this.thread.invoke(new SynchronousTaskThread.Task<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    long s = start;
                    long c = count;
                    int o = off;
                    while (c > 0L) {
                        long c2 = Math.min(count1, c);
                        boolean successful = AviSynthSource.this.getAudio(AviSynthSource.this.envPointer, AviSynthSource.this.clipPointer, s, c2, b, o);
                        if (!successful) {
                            logger.error("getAudio failed.");
                            return false;
                        }
                        s += c2;
                        c -= c2;
                        o = (int)((long)o + c2 * (long)frameSize);
                    }
                    return true;
                }
            });
            if (!successful) {
                throw new IOException("error");
            }
            if (AviSynthSource.this.audioFloat) {
                int i = off;
                while (i < len) {
                    int bits = b[i] & 0xFF | (b[i + 1] & 0xFF) << 8 | (b[i + 2] & 0xFF) << 16 | (b[i + 3] & 0xFF) << 24;
                    int intValue = (int)(Float.intBitsToFloat(bits) * 2.1474836E9f);
                    b[i] = (byte)(intValue & 0xFF);
                    b[i + 1] = (byte)(intValue >>> 8 & 0xFF);
                    b[i + 2] = (byte)(intValue >>> 16 & 0xFF);
                    b[i + 3] = (byte)(intValue >>> 24 & 0xFF);
                    i += 4;
                }
            }
            this.positionInBytes += (long)len;
            return len;
        }

        public long skip(long n) throws IOException {
            long actualSkip = 0L;
            if (n > 0L) {
                int frameSize = this.format.getFrameSize();
                actualSkip = n / (long)frameSize * (long)frameSize;
                this.positionInBytes += actualSkip;
            }
            return actualSkip;
        }
    }
}

