/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.Camera;
import ch.kuramo.javie.core.FrameDuration;
import ch.kuramo.javie.core.MediaOptions;
import ch.kuramo.javie.core.MediaSource;
import ch.kuramo.javie.core.internal.MacOSXOpenGLPixelFormat;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.QCIntegrationSupport;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.SynchronousTaskThread;
import com.google.inject.Inject;
import java.io.File;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL2;
import javax.media.opengl.GLContext;
import javax.media.opengl.glu.GLU;
import javax.vecmath.Matrix4d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QCCompositionSource
implements MediaSource {
    private static final Logger logger = LoggerFactory.getLogger(QCCompositionSource.class);
    private static final Time DEFAULT_DURATION = Time.fromFrameNumber((long)3600L, (Time)FrameDuration.FPS_59_94);
    private static final Time FRAME_DURATION = new Time(0L, 120000);
    private static final Size2i DEFAULT_SIZE = new Size2i(640, 480);
    private static final VideoBounds DEFAULT_BOUNDS = new VideoBounds(DEFAULT_SIZE);
    private GLContext glContext;
    private GLU glu;
    private int fboId;
    private long pointer;
    private final SynchronousTaskThread thread;
    private final GLGlobal glGlobal;
    private final RenderContext context;
    private final IVideoRenderSupport vrSupport;
    private final QCIntegrationSupport qciSupport;
    private static final float[] FLOAT0000 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};

    static {
        System.loadLibrary("QCCompositionSource");
    }

    @Inject
    public QCCompositionSource(SynchronousTaskThread thread, GLGlobal glGlobal, RenderContext context, IVideoRenderSupport vrSupport, QCIntegrationSupport qciSupport) {
        this.thread = thread;
        this.glGlobal = glGlobal;
        this.context = context;
        this.vrSupport = vrSupport;
        this.qciSupport = qciSupport;
    }

    public boolean initialize(final File file) {
        this.thread.start();
        this.thread.invoke(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() throws Exception {
                QCCompositionSource.this.initQCRenderer(file);
            }
        });
        if (this.pointer == 0L) {
            this.disposeQCRenderer();
            return false;
        }
        return true;
    }

    private void initQCRenderer(File file) {
        ReentrantLock lock = this.glGlobal.getGlobalLock();
        lock.lock();
        try {
            this.glContext = this.glGlobal.createContext();
            this.glContext.makeCurrent();
        }
        finally {
            lock.unlock();
        }
        this.glu = new GLU();
        GL2 gl = this.glContext.getGL().getGL2();
        int[] fboId_ = new int[1];
        gl.glGenBuffers(1, fboId_, 0);
        this.fboId = fboId_[0];
        gl.glBindFramebuffer(36160, this.fboId);
        long pixelFormat = MacOSXOpenGLPixelFormat.createPixelFormat(this.glContext);
        this.pointer = this.initQCRenderer(file.getAbsolutePath(), pixelFormat);
        MacOSXOpenGLPixelFormat.deletePixelFormat(pixelFormat);
        if (this.pointer != 0L) {
            this.thread.setName(String.valueOf(this.getClass().getSimpleName()) + ": " + file.getName());
        }
    }

    public void dispose() {
        this.disposeQCRenderer();
    }

    private void disposeQCRenderer() {
        this.thread.exit(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                if (QCCompositionSource.this.pointer != 0L) {
                    QCCompositionSource.this.disposeQCRenderer(QCCompositionSource.this.pointer);
                    QCCompositionSource.this.pointer = 0L;
                }
                if (QCCompositionSource.this.glContext != null) {
                    GL2 gl = QCCompositionSource.this.glContext.getGL().getGL2();
                    gl.glBindFramebuffer(36160, 0);
                    gl.glDeleteBuffers(1, new int[]{QCCompositionSource.this.fboId}, 0);
                    QCCompositionSource.this.fboId = 0;
                    ReentrantLock lock = QCCompositionSource.this.glGlobal.getGlobalLock();
                    lock.lock();
                    try {
                        QCCompositionSource.this.glContext.release();
                        QCCompositionSource.this.glGlobal.destroyContext(QCCompositionSource.this.glContext);
                    }
                    finally {
                        lock.unlock();
                    }
                    QCCompositionSource.this.glContext = null;
                    QCCompositionSource.this.glu = null;
                }
            }
        });
    }

    public Time getDuration(MediaOptions options) {
        if (options == null) {
            return DEFAULT_DURATION;
        }
        Time duration = options.getDuration();
        return duration != null ? duration : DEFAULT_DURATION;
    }

    public Time getVideoFrameDuration(MediaOptions options) {
        return FRAME_DURATION;
    }

    public VideoBounds getVideoFrameBounds(MediaOptions options) {
        if (options == null) {
            return DEFAULT_BOUNDS;
        }
        Size2i size = options.getSize();
        return size == null || size.equals((Object)DEFAULT_SIZE) ? DEFAULT_BOUNDS : new VideoBounds(size);
    }

    public IVideoBuffer getVideoFrame(Time mediaTime, MediaOptions options) {
        if (this.pointer == 0L) {
            return null;
        }
        VideoBounds bounds = this.context.getVideoResolution().scale(this.getVideoFrameBounds(options));
        IVideoBuffer buffer1 = null;
        try {
            buffer1 = this.vrSupport.createVideoBuffer(bounds);
            buffer1.clear();
            if (mediaTime.timeValue < 0L || !mediaTime.before(this.getDuration(options))) {
                IVideoBuffer result = buffer1;
                buffer1 = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            if (this.renderAtTime(buffer1, mediaTime)) {
                IVideoBuffer iVideoBuffer = this.flipVertical(buffer1);
                return iVideoBuffer;
            }
            return null;
        }
        finally {
            if (buffer1 != null) {
                buffer1.dispose();
            }
        }
    }

    private boolean renderAtTime(IVideoBuffer buffer, final Time mediaTime) {
        double[] mvMatrix;
        double[] prjMatrix;
        final boolean syncWithCamera = this.qciSupport.isSyncWithCamera();
        final Object[] inputKeyValues = this.qciSupport.getInputKeyValues();
        this.qciSupport.clear();
        if (syncWithCamera) {
            Camera camera = this.context.getCamera();
            prjMatrix = camera.getProjection3D();
            mvMatrix = camera.getModelView3D();
        } else {
            prjMatrix = null;
            mvMatrix = null;
        }
        final int texture = buffer.getTexture();
        final int width = buffer.getBounds().width;
        final int height = buffer.getBounds().height;
        final ColorMode colorMode = this.context.getColorMode();
        this.context.getGL().glFinish();
        return this.thread.invoke(new SynchronousTaskThread.Task<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                Boolean bl;
                GL2 gl;
                block6: {
                    gl = QCCompositionSource.this.glContext.getGL().getGL2();
                    int deptex = 0;
                    gl.glPushAttrib(262401);
                    try {
                        deptex = QCCompositionSource.this.createDepthTexture(gl, width, height, colorMode);
                        gl.glFramebufferTexture2D(36160, 36064, 3553, texture, 0);
                        gl.glFramebufferTexture2D(36160, 36096, 3553, deptex, 0);
                        gl.glDrawBuffer(36064);
                        gl.glClearDepth(1.0);
                        gl.glClear(256);
                        gl.glViewport(0, 0, width, height);
                        if (syncWithCamera) {
                            double[] qcPrjInvert = QCCompositionSource.this.calcInvertMatrixOfQuartzComposerProjection(gl, width, height);
                            gl.glMatrixMode(5889);
                            gl.glLoadMatrixd(prjMatrix, 0);
                            gl.glMultMatrixd(qcPrjInvert, 0);
                            double[] tsr = QCCompositionSource.this.extractTranslateScaleRotate(mvMatrix);
                            gl.glMatrixMode(5888);
                            gl.glLoadIdentity();
                            gl.glTranslated(tsr[0], -tsr[1], tsr[2]);
                            gl.glScaled(tsr[3], tsr[4], tsr[5]);
                            gl.glRotated(-Math.toDegrees(tsr[8]), 0.0, 0.0, 1.0);
                            gl.glRotated(Math.toDegrees(tsr[7]), 0.0, 1.0, 0.0);
                            gl.glRotated(-Math.toDegrees(tsr[6]), 1.0, 0.0, 0.0);
                            gl.glTranslated((double)width * 0.5, (double)(-height) * 0.5, 0.0);
                            gl.glScaled((double)width * 0.5, (double)width * 0.5, (double)width * 0.5);
                        } else {
                            gl.glMatrixMode(5889);
                            gl.glLoadIdentity();
                            gl.glMatrixMode(5888);
                            gl.glLoadIdentity();
                        }
                        boolean successful = QCCompositionSource.this.renderAtTime(QCCompositionSource.this.pointer, mediaTime.toSecond(), inputKeyValues);
                        if (!successful) {
                            logger.error("renderAtTime: failed");
                        }
                        gl.glFinish();
                        gl.glFramebufferTexture2D(36160, 36064, 3553, 0, 0);
                        gl.glFramebufferTexture2D(36160, 36096, 3553, 0, 0);
                        bl = successful;
                        if (deptex == 0) break block6;
                    }
                    catch (Throwable throwable) {
                        if (deptex != 0) {
                            gl.glDeleteTextures(1, new int[]{deptex}, 0);
                        }
                        gl.glPopAttrib();
                        throw throwable;
                    }
                    gl.glDeleteTextures(1, new int[]{deptex}, 0);
                }
                gl.glPopAttrib();
                return bl;
            }
        });
    }

    private int createDepthTexture(GL2 gl, int width, int height, ColorMode colorMode) {
        int internalFormat = colorMode == ColorMode.RGBA32_FLOAT ? 33191 : 6402;
        int[] texture = new int[1];
        int[] current = new int[1];
        gl.glGetIntegerv(32873, current, 0);
        try {
            gl.glGenTextures(1, texture, 0);
            gl.glBindTexture(3553, texture[0]);
            gl.glTexParameteri(3553, 10241, 9728);
            gl.glTexParameteri(3553, 10240, 9728);
            gl.glTexParameteri(3553, 10242, 33069);
            gl.glTexParameteri(3553, 10243, 33069);
            gl.glTexParameterfv(3553, 4100, FLOAT0000, 0);
            gl.glTexImage2D(3553, 0, internalFormat, Math.max(1, width), Math.max(1, height), 0, 6402, 5126, null);
            int result = texture[0];
            texture[0] = 0;
            int n = result;
            return n;
        }
        finally {
            gl.glBindTexture(3553, current[0]);
            if (texture[0] != 0) {
                gl.glDeleteTextures(1, texture, 0);
            }
        }
    }

    private double[] calcInvertMatrixOfQuartzComposerProjection(GL2 gl, double width, double height) {
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        double aspect = width / height;
        double fovx = Math.toRadians(60.0);
        double fovy = 2.0 * Math.atan(Math.tan(fovx / 2.0) / aspect);
        this.glu.gluPerspective(Math.toDegrees(fovy), aspect, 0.1, 100.0);
        gl.glTranslated(0.0, 0.0, -Math.sqrt(3.0));
        double[] invert = new double[16];
        gl.glGetDoublev(2983, invert, 0);
        Matrix4d m = new Matrix4d(invert);
        m.transpose();
        m.invert();
        invert[0] = m.m00;
        invert[1] = m.m10;
        invert[2] = m.m20;
        invert[3] = m.m30;
        invert[4] = m.m01;
        invert[5] = m.m11;
        invert[6] = m.m21;
        invert[7] = m.m31;
        invert[8] = m.m02;
        invert[9] = m.m12;
        invert[10] = m.m22;
        invert[11] = m.m32;
        invert[12] = m.m03;
        invert[13] = m.m13;
        invert[14] = m.m23;
        invert[15] = m.m33;
        return invert;
    }

    private double[] extractTranslateScaleRotate(double[] mvMatrix) {
        double rz;
        double ry;
        double rx;
        Matrix4d m = new Matrix4d(mvMatrix);
        m.transpose();
        m.mul(new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0));
        double tx = m.m03;
        double ty = m.m13;
        double tz = m.m23;
        double sx = Math.sqrt(m.m00 * m.m00 + m.m01 * m.m01 + m.m02 * m.m02);
        double sy = Math.sqrt(m.m10 * m.m10 + m.m11 * m.m11 + m.m12 * m.m12);
        double sz = Math.sqrt(m.m20 * m.m20 + m.m21 * m.m21 + m.m22 * m.m22);
        if (m.m20 == 1.0) {
            rx = 0.0;
            ry = -1.5707963267948966;
            rz = -Math.atan2(m.m01, m.m11);
        } else if (m.m20 == -1.0) {
            rx = 0.0;
            ry = 1.5707963267948966;
            rz = -Math.atan2(m.m01, m.m11);
        } else {
            rx = Math.atan2(m.m21, m.m22);
            ry = Math.asin(-m.m20);
            rz = Math.atan2(m.m10, m.m00);
        }
        return new double[]{tx, ty, tz, sx, sy, sz, rx, ry, rz};
    }

    private IVideoBuffer flipVertical(IVideoBuffer buffer) {
        final VideoBounds bounds = buffer.getBounds();
        Runnable operation = new Runnable(){

            public void run() {
                GL2 gl = QCCompositionSource.this.context.getGL().getGL2();
                GLU glu = QCCompositionSource.this.context.getGLU();
                gl.glViewport(0, 0, bounds.width, bounds.height);
                gl.glMatrixMode(5889);
                gl.glLoadIdentity();
                glu.gluOrtho2D(0.0f, (float)bounds.width, (float)bounds.height, 0.0f);
                gl.glMatrixMode(5888);
                gl.glLoadIdentity();
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                gl.glBegin(7);
                gl.glTexCoord2f(0.0f, 0.0f);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glTexCoord2f(1.0f, 0.0f);
                gl.glVertex2f((float)bounds.width, 0.0f);
                gl.glTexCoord2f(1.0f, 1.0f);
                gl.glVertex2f((float)bounds.width, (float)bounds.height);
                gl.glTexCoord2f(0.0f, 1.0f);
                gl.glVertex2f(0.0f, (float)bounds.height);
                gl.glEnd();
            }
        };
        int pushAttribs = 1;
        return this.vrSupport.useFramebuffer(operation, pushAttribs, null, new IVideoBuffer[]{buffer});
    }

    public boolean isVideoAvailable() {
        return true;
    }

    public boolean isAudioAvailable() {
        return false;
    }

    public IAudioBuffer getAudioChunk(Time mediaTime, MediaOptions options) {
        throw new UnsupportedOperationException("audio is not available");
    }

    public MediaOptions validateOptions(MediaOptions options) {
        MediaOptions.Option[] availableOptions = new MediaOptions.Option[]{MediaOptions.Option.DURATION, MediaOptions.Option.SIZE};
        if (options == null) {
            options = new MediaOptions(availableOptions);
        } else {
            options = options.clone();
            options.setAvailableOptions(availableOptions);
        }
        if (options.getDuration() == null) {
            options.setDuration(DEFAULT_DURATION);
        }
        if (options.getSize() == null) {
            options.setSize(DEFAULT_SIZE);
        }
        return options;
    }

    private native long initQCRenderer(String var1, long var2);

    private native void disposeQCRenderer(long var1);

    private native boolean renderAtTime(long var1, double var3, Object[] var5);
}

