/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.services.ITexture1DSupport;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.media.opengl.GL2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Texture1DSupportImpl
implements ITexture1DSupport {
    private static final float[] FLOAT0000 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private final RenderContext context;

    @Inject
    public Texture1DSupportImpl(RenderContext context) {
        this.context = context;
    }

    public int texture1DFromArray(IArray<float[]> array, int format, int internalFormat) {
        return this.texture1DFromArray((float[])array.getArray(), 0, array.getLength(), format, internalFormat, 9729, 33071);
    }

    public int texture1DFromArray(float[] array, int format, int internalFormat) {
        return this.texture1DFromArray(array, 0, array.length, format, internalFormat, 9729, 33071);
    }

    public int texture1DFromArray(IArray<float[]> array, int format, int internalFormat, int filter, int wrapMode) {
        return this.texture1DFromArray((float[])array.getArray(), 0, array.getLength(), format, internalFormat, filter, wrapMode);
    }

    public int texture1DFromArray(float[] array, int format, int internalFormat, int filter, int wrapMode) {
        return this.texture1DFromArray(array, 0, array.length, format, internalFormat, filter, wrapMode);
    }

    public int texture1DFromArray(float[] array, int offset, int length, int format, int internalFormat, int filter, int wrapMode) {
        int width;
        switch (format) {
            case 6406: {
                width = length;
                break;
            }
            case 6408: {
                width = length / 4;
                if (width * 4 == length) break;
                throw new IllegalArgumentException("length must be multiple of 4");
            }
            default: {
                throw new IllegalArgumentException("format must be GL_FLOAT or GL_RGBA");
            }
        }
        GL2 gl = this.context.getGL().getGL2();
        int[] texture = new int[1];
        int[] current = new int[1];
        gl.glGetIntegerv(32872, current, 0);
        try {
            gl.glGenTextures(1, texture, 0);
            gl.glBindTexture(3552, texture[0]);
            gl.glTexParameteri(3552, 10241, filter == 9728 ? 9728 : 9729);
            gl.glTexParameteri(3552, 10240, filter == 9728 ? 9728 : 9729);
            gl.glTexParameteri(3552, 10242, wrapMode);
            gl.glTexParameteri(3552, 10243, 33071);
            if (wrapMode == 33069) {
                gl.glTexParameterfv(3552, 4100, FLOAT0000, 0);
            }
            gl.glTexImage1D(3552, 0, internalFormat, width, 0, format, 5126, (Buffer)FloatBuffer.wrap(array, offset, length));
            if (filter == 9985 || filter == 9987) {
                gl.glTexParameteri(3552, 10241, filter);
                gl.glTexParameterf(3552, 34046, 16.0f);
                gl.glGenerateMipmap(3552);
            }
            int result = texture[0];
            texture[0] = 0;
            int n = result;
            return n;
        }
        finally {
            gl.glBindTexture(3552, current[0]);
            if (texture[0] != 0) {
                gl.glDeleteTextures(1, texture, 0);
            }
        }
    }
}

