/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.SaveUtil;
import ch.kuramo.javie.app.project.ProjectEvent;
import ch.kuramo.javie.app.project.ProjectEventHub;
import ch.kuramo.javie.app.project.ProjectListener;
import ch.kuramo.javie.app.project.ProjectManager;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SaveAction
extends Action
implements ProjectListener {
    private final IWorkbenchWindow window;

    public SaveAction(IWorkbenchWindow window) {
        super("\u4fdd\u5b58");
        this.window = window;
        this.setId("org.eclipse.ui.file.save");
        this.setActionDefinitionId("org.eclipse.ui.file.save");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVE_EDIT"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVE_EDIT_DISABLED"));
        ProjectEventHub.getHub().addProjectListener(this);
        final IWorkbench workbench = window.getWorkbench();
        workbench.addWindowListener(new IWindowListener(){

            public void windowClosed(IWorkbenchWindow window) {
                if (window == SaveAction.this.window) {
                    ProjectEventHub.getHub().removeProjectListener(SaveAction.this);
                    workbench.removeWindowListener((IWindowListener)this);
                }
            }

            public void windowOpened(IWorkbenchWindow window) {
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowActivated(IWorkbenchWindow window) {
            }
        });
    }

    public void run() {
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.window);
        if (pm != null) {
            SaveUtil.save(pm);
        }
    }

    public void handleProjectEvent(ProjectEvent event) {
        ProjectManager pm = event.getProjectManager();
        if (pm.getWorkbenchWindow() != this.window) {
            return;
        }
        switch (event.type) {
            case PROJECT_INITIALIZE: 
            case PROJECT_DISPOSE: 
            case DIRTY_CHANGE: {
                this.setEnabled(pm.isDirty());
            }
        }
    }
}

