/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ModifyLayerPropertyOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.core.Layer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayerPropertyElement<T>
extends Element {
    private static final int[] UNDERLINE_DASH = new int[]{2, 2};
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    private static final boolean WIN32 = SWT.getPlatform().equals("win32");
    protected final Layer layer;
    protected final String label;
    protected final String operationLabel;
    protected Rectangle valueArea;

    public LayerPropertyElement(Element parent, Layer layer, String label) {
        this(parent, layer, label, String.valueOf(label) + "\u3092\u5909\u66f4");
    }

    public LayerPropertyElement(Element parent, Layer layer, String label, String operationLabel) {
        super(parent);
        this.layer = layer;
        this.label = label;
        this.operationLabel = operationLabel;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public abstract String getProperty();

    @Override
    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.label;
            }
            case 1: {
                return " ";
            }
        }
        return null;
    }

    @Override
    public void paintColumn(Event event) {
        if (event.index == 1) {
            String valueStr = this.getValueString();
            GC gc = event.gc;
            int x = event.x + 5;
            int y = event.y;
            int height = ((TreeItem)event.item).getBounds((int)event.index).height;
            boolean focused = (event.detail & 2) != 0 && ((Control)event.widget).isFocusControl();
            gc.setForeground(gc.getDevice().getSystemColor(focused ? 1 : 10));
            Point extent = gc.textExtent(valueStr, 1);
            gc.drawString(valueStr, x, y += (height - extent.y) / 2, true);
            this.valueArea = new Rectangle(x, y, extent.x, extent.y);
            y += extent.y;
            gc.setLineDash(UNDERLINE_DASH);
            if (COCOA) {
                gc.drawLine(x, y - 1, x + extent.x, y - 1);
            } else if (WIN32) {
                gc.drawLine(x, y, x + extent.x - 2, y);
            } else {
                gc.drawLine(x, y, x + extent.x, y);
            }
        } else {
            super.paintColumn(event);
        }
    }

    @Override
    public void updateCursor(MouseEvent event, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                Cursor cursor = null;
                if (this.valueArea != null && this.valueArea.contains(event.x, event.y)) {
                    cursor = event.display.getSystemCursor(21);
                }
                this.viewer.getTree().setCursor(cursor);
                break;
            }
            default: {
                super.updateCursor(event, columnIndex);
            }
        }
    }

    @Override
    public void mouseDown(MouseEvent event, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                if (event.button != 1 || this.valueArea == null || !this.valueArea.contains(event.x, event.y)) break;
                this.mouseDownOnValueArea();
                break;
            }
            default: {
                super.mouseDown(event, columnIndex);
            }
        }
    }

    protected abstract String getValueString();

    protected abstract void mouseDownOnValueArea();

    protected T getValue() {
        return PropertyUtil.getProperty(this.layer, this.getProperty());
    }

    protected void setValue(T newValue) {
        ProjectManager pm = (ProjectManager)this.viewer.getData("PROJECT_MANAGER");
        pm.postOperation(new ModifyLayerPropertyOperation<T>(pm, this.layer, this.getProperty(), newValue, this.operationLabel));
    }
}

