/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.windows.wgl;

import com.jogamp.nativewindow.impl.windows.GDI;
import com.jogamp.nativewindow.impl.windows.PIXELFORMATDESCRIPTOR;
import com.jogamp.opengl.impl.windows.wgl.WGLExt;
import com.jogamp.opengl.impl.windows.wgl.WindowsPbufferWGLContext;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLContext;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLDrawable;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLDrawableFactory;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLGraphicsConfiguration;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.SurfaceChangeable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class WindowsPbufferWGLDrawable
extends WindowsWGLDrawable {
    private WGLExt cachedWGLExt;
    private long buffer;
    private int floatMode;

    public WindowsPbufferWGLDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, WindowsWGLDrawable windowsWGLDrawable, WindowsWGLContext windowsWGLContext) {
        super(gLDrawableFactory, nativeSurface, true);
        if (DEBUG) {
            System.out.println("Pbuffer config: " + this.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration());
        }
        this.createPbuffer(windowsWGLDrawable.getNativeSurface().getSurfaceHandle(), windowsWGLContext);
        if (DEBUG) {
            System.err.println("Created pbuffer " + this);
        }
    }

    protected void setRealizedImpl() {
        if (this.realized) {
            throw new GLException("Recreation via setRealized not supported.");
        }
        this.destroyImpl();
    }

    public GLContext createContext(GLContext gLContext) {
        return new WindowsPbufferWGLContext(this, gLContext);
    }

    protected void destroyImpl() {
        NativeSurface nativeSurface = this.getNativeSurface();
        if (0L != this.buffer) {
            WGLExt wGLExt = this.cachedWGLExt;
            if (nativeSurface.getSurfaceHandle() != 0L) {
                if (wGLExt.wglReleasePbufferDCARB(this.buffer, nativeSurface.getSurfaceHandle()) == 0) {
                    throw new GLException("Error releasing pbuffer device context: error code " + GDI.GetLastError());
                }
                ((SurfaceChangeable)nativeSurface).setSurfaceHandle(0L);
            }
            if (!wGLExt.wglDestroyPbufferARB(this.buffer)) {
                throw new GLException("Error destroying pbuffer: error code " + GDI.GetLastError());
            }
            this.buffer = 0L;
        }
    }

    public long getPbufferHandle() {
        return this.buffer;
    }

    public int getFloatingPointMode() {
        return this.floatMode;
    }

    protected void swapBuffersImpl() {
        if (DEBUG) {
            System.err.println("unhandled swapBuffersImpl() called for: " + this);
        }
    }

    private void createPbuffer(long l, WindowsWGLContext windowsWGLContext) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3 = new int[512];
        float[] fArray = new float[1];
        int[] nArray4 = new int[1];
        int n = 0;
        WGLExt wGLExt = windowsWGLContext.getWGLExt();
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)this.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)windowsWGLGraphicsConfiguration.getRequestedCapabilities();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        if (DEBUG) {
            System.out.println("Pbuffer parentHdc = " + WindowsPbufferWGLDrawable.toHexString(l));
            System.out.println("Pbuffer caps: " + gLCapabilitiesImmutable);
        }
        if (!WindowsWGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable, nArray3, windowsWGLContext, -1, true, nArray4)) {
            throw new GLException("Pbuffer-related extensions not supported");
        }
        this.floatMode = nArray4[0];
        boolean bl = gLCapabilitiesImmutable.getPbufferRenderToTexture();
        boolean bl2 = gLCapabilitiesImmutable.getPbufferRenderToTextureRectangle();
        boolean bl3 = gLCapabilitiesImmutable.getPbufferFloatingPointBuffers();
        boolean bl4 = false;
        if (bl3) {
            boolean bl5 = bl4 = this.floatMode == 2;
        }
        if (!wGLExt.wglChoosePixelFormatARB(l, nArray3, 0, fArray, 0, 256, nArray2 = new int[256], 0, nArray = new int[1], 0)) {
            throw new GLException("pbuffer creation error: wglChoosePixelFormat() failed");
        }
        int n2 = nArray[0];
        if (n2 <= 0) {
            throw new GLException("pbuffer creation error: Couldn't find a suitable pixel format");
        }
        boolean bl6 = windowsWGLContext.isExtensionAvailable("WGL_ARB_multisample");
        if (DEBUG) {
            System.err.println("" + n2 + " suitable pixel formats found");
            nArray3[0] = 8213;
            nArray3[1] = 8215;
            nArray3[2] = 8217;
            nArray3[3] = 8219;
            nArray3[4] = 8226;
            nArray3[5] = bl3 ? (bl4 ? 8211 : 8368) : 8213;
            nArray3[6] = bl6 ? 8257 : 8213;
            nArray3[7] = bl6 ? 8258 : 8213;
            nArray3[8] = 8237;
            int[] nArray5 = new int[9];
            for (int i = 0; i < n2; ++i) {
                if (!wGLExt.wglGetPixelFormatAttribivARB(l, nArray2[i], 0, 9, nArray3, 0, nArray5, 0)) {
                    throw new GLException("Error while querying pixel format " + nArray2[i] + "'s (index " + i + "'s) capabilities for debugging");
                }
                System.err.print("pixel format " + nArray2[i] + " (index " + i + "): ");
                System.err.print("r: " + nArray5[0]);
                System.err.print(" g: " + nArray5[1]);
                System.err.print(" b: " + nArray5[2]);
                System.err.print(" a: " + nArray5[3]);
                System.err.print(" depth: " + nArray5[4]);
                if (bl6) {
                    System.err.print(" multisample: " + nArray5[6]);
                }
                System.err.print(" samples: " + nArray5[7]);
                if (bl3) {
                    if (bl4) {
                        if (nArray5[5] == 8608) {
                            System.err.print(" [ati float]");
                        } else if (nArray5[5] != 8235) {
                            System.err.print(" [unknown pixel type " + nArray5[5] + "]");
                        }
                    } else if (nArray5[5] != 0) {
                        System.err.print(" [float]");
                    }
                }
                if (nArray5[8] != 0) {
                    System.err.print(" [pbuffer]");
                }
                System.err.println();
            }
        }
        long l2 = 0L;
        int n3 = -1;
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = nArray2[n3];
            n = 0;
            if (bl) {
                nArray3[n++] = 8306;
                nArray3[n++] = bl3 ? 8375 : 8310;
                nArray3[n++] = 8307;
                nArray3[n++] = bl2 ? 8354 : 8314;
                nArray3[n++] = 8308;
                nArray3[n++] = 0;
                nArray3[n++] = 8243;
                nArray3[n++] = 0;
            }
            nArray3[n++] = 0;
            l2 = wGLExt.wglCreatePbufferARB(l, n4, this.getWidth(), this.getHeight(), nArray3, 0);
            if (l2 != 0L) break;
        }
        if (l2 == 0L) {
            throw new GLException("pbuffer creation error: wglCreatePbuffer() failed: tried " + n2 + " pixel formats, last error was: " + WindowsPbufferWGLDrawable.wglGetLastError());
        }
        long l3 = wGLExt.wglGetPbufferDCARB(l2);
        if (l3 == 0L) {
            throw new GLException("pbuffer creation error: wglGetPbufferDC() failed");
        }
        NativeSurface nativeSurface = this.getNativeSurface();
        this.buffer = l2;
        ((SurfaceChangeable)nativeSurface).setSurfaceHandle(l3);
        this.cachedWGLExt = wGLExt;
        n = 0;
        nArray3[n++] = 8195;
        nArray3[n++] = 8213;
        nArray3[n++] = 8215;
        nArray3[n++] = 8217;
        nArray3[n++] = 8219;
        nArray3[n++] = 8226;
        nArray3[n++] = 8227;
        nArray3[n++] = 8209;
        nArray3[n++] = 8210;
        nArray3[n++] = 8222;
        nArray3[n++] = 8223;
        nArray3[n++] = 8224;
        nArray3[n++] = 8225;
        nArray3[n++] = bl3 ? (bl4 ? 8211 : 8368) : 8213;
        nArray3[n++] = bl6 ? 8257 : 8213;
        nArray3[n++] = bl6 ? 8258 : 8213;
        nArray3[n++] = 8237;
        int[] nArray6 = new int[n];
        if (wGLExt.wglGetPixelFormatAttribivARB(l, nArray2[n3], 0, n, nArray3, 0, nArray6, 0)) {
            GLCapabilitiesImmutable gLCapabilitiesImmutable2 = WindowsWGLGraphicsConfiguration.AttribList2GLCapabilities(gLProfile, nArray3, n, nArray6, false, true);
            if (null == gLCapabilitiesImmutable2 || gLCapabilitiesImmutable2.isOnscreen() || !gLCapabilitiesImmutable2.isPBuffer()) {
                throw new GLException("Error: Selected Onscreen Caps for PBuffer: " + gLCapabilitiesImmutable2);
            }
            PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor();
            if (GDI.DescribePixelFormat((long)l, (int)nArray2[n3], (int)pIXELFORMATDESCRIPTOR.size(), (PIXELFORMATDESCRIPTOR)pIXELFORMATDESCRIPTOR) == 0 && DEBUG) {
                System.err.println("Unable to describe pixel format (Continue: true) " + n3 + "/" + n2 + " pfdID " + nArray2[n3] + ":\n\t" + gLCapabilitiesImmutable2);
            }
            windowsWGLGraphicsConfiguration.setCapsPFD(gLCapabilitiesImmutable2, pIXELFORMATDESCRIPTOR, nArray2[n3], true);
        } else {
            PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor();
            if (GDI.DescribePixelFormat((long)l, (int)nArray2[n3], (int)pIXELFORMATDESCRIPTOR.size(), (PIXELFORMATDESCRIPTOR)pIXELFORMATDESCRIPTOR) == 0) {
                throw new GLException("Unable to describe pixel format " + nArray2[n3]);
            }
            GLCapabilitiesImmutable gLCapabilitiesImmutable3 = WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(gLProfile, pIXELFORMATDESCRIPTOR, false, true);
            if (gLCapabilitiesImmutable3.isOnscreen()) {
                throw new GLException("Error: Selected Onscreen Caps for PBuffer: " + gLCapabilitiesImmutable3 + "\n\t" + gLCapabilitiesImmutable3);
            }
            windowsWGLGraphicsConfiguration.setCapsPFD(gLCapabilitiesImmutable3, pIXELFORMATDESCRIPTOR, nArray2[n3], false);
        }
        nArray6 = new int[1];
        wGLExt.wglQueryPbufferARB(this.buffer, 8244, nArray6, 0);
        int n5 = nArray6[0];
        wGLExt.wglQueryPbufferARB(this.buffer, 8245, nArray6, 0);
        int n6 = nArray6[0];
        ((SurfaceChangeable)nativeSurface).setSize(n5, n6);
    }

    private static String wglGetLastError() {
        return WindowsWGLDrawableFactory.wglGetLastError();
    }
}

