/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.x11.glx;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.nativewindow.impl.x11.X11Util;
import com.jogamp.nativewindow.impl.x11.XVisualInfo;
import com.jogamp.opengl.impl.Debug;
import com.jogamp.opengl.impl.GLGraphicsConfigurationFactoryImpl;
import com.jogamp.opengl.impl.x11.glx.GLX;
import com.jogamp.opengl.impl.x11.glx.GLXUtil;
import com.jogamp.opengl.impl.x11.glx.X11GLXGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.x11.X11GraphicsDevice;
import javax.media.nativewindow.x11.X11GraphicsScreen;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class X11GLXGraphicsConfigurationFactory
extends GLGraphicsConfigurationFactoryImpl {
    protected static final boolean DEBUG = Debug.debug("GraphicsConfiguration");

    X11GLXGraphicsConfigurationFactory() {
        GraphicsConfigurationFactory.registerFactory((Class)X11GraphicsDevice.class, (GraphicsConfigurationFactory)this);
    }

    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        if (!(abstractGraphicsScreen instanceof X11GraphicsScreen)) {
            throw new IllegalArgumentException("Only X11GraphicsScreen are allowed here");
        }
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - chosen");
        }
        if (!(capabilitiesImmutable2 instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - requested");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        return X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)capabilitiesImmutable, (GLCapabilitiesImmutable)capabilitiesImmutable2, (GLCapabilitiesChooser)capabilitiesChooser, (X11GraphicsScreen)abstractGraphicsScreen);
    }

    static X11GLXGraphicsConfiguration chooseGraphicsConfigurationStatic(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, X11GraphicsScreen x11GraphicsScreen) {
        if (x11GraphicsScreen == null) {
            throw new IllegalArgumentException("AbstractGraphicsScreen is null");
        }
        if (gLCapabilitiesImmutable == null) {
            gLCapabilitiesImmutable = new GLCapabilities(null);
        }
        if (!gLCapabilitiesImmutable.isOnscreen() && gLCapabilitiesImmutable.getDoubleBuffered()) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setDoubleBuffered(false);
            gLCapabilitiesImmutable = gLCapabilities;
        }
        boolean bl = gLCapabilitiesImmutable.isPBuffer();
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationFBConfig(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, x11GraphicsScreen);
        if (null == x11GLXGraphicsConfiguration) {
            if (bl) {
                throw new GLException("Error: Couldn't create X11GLXGraphicsConfiguration based on FBConfig for " + gLCapabilitiesImmutable);
            }
            x11GLXGraphicsConfiguration = X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationXVisual(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, x11GraphicsScreen);
        }
        if (null == x11GLXGraphicsConfiguration) {
            throw new GLException("Error: Couldn't create X11GLXGraphicsConfiguration based on FBConfig and XVisual for " + gLCapabilitiesImmutable);
        }
        if (DEBUG) {
            System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationStatic(" + x11GraphicsScreen + "," + gLCapabilitiesImmutable + "): " + x11GLXGraphicsConfiguration);
        }
        return x11GLXGraphicsConfiguration;
    }

    static X11GLXGraphicsConfiguration fetchGraphicsConfigurationFBConfig(X11GraphicsScreen x11GraphicsScreen, int n, GLProfile gLProfile) {
        int n2;
        long l;
        AbstractGraphicsDevice abstractGraphicsDevice = x11GraphicsScreen.getDevice();
        long l2 = abstractGraphicsDevice.getHandle();
        if (!X11GLXGraphicsConfiguration.GLXFBConfigValid(l2, l = X11GLXGraphicsConfiguration.glXFBConfigID2FBConfig(l2, n2 = x11GraphicsScreen.getIndex(), n))) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: Failed - GLX FBConfig invalid: (" + x11GraphicsScreen + "," + X11GLXGraphicsConfigurationFactory.toHexString(n) + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString(l));
            }
            return null;
        }
        XVisualInfo xVisualInfo = GLX.glXGetVisualFromFBConfig(l2, l);
        if (xVisualInfo == null) {
            System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: Failed glXGetVisualFromFBConfig (" + x11GraphicsScreen + ", " + X11GLXGraphicsConfigurationFactory.toHexString(l) + ")");
            return null;
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(gLProfile, l2, l, true, true, true, GLXUtil.isMultisampleAvailable(l2));
        return new X11GLXGraphicsConfiguration(x11GraphicsScreen, gLCapabilitiesImmutable, gLCapabilitiesImmutable, new DefaultGLCapabilitiesChooser(), xVisualInfo, l, n);
    }

    private static X11GLXGraphicsConfiguration chooseGraphicsConfigurationFBConfig(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, X11GraphicsScreen x11GraphicsScreen) {
        int n;
        int[] nArray;
        boolean bl;
        int[] nArray2;
        int n2;
        long l = -1L;
        int n3 = -1;
        int n4 = -1;
        CapabilitiesImmutable[] capabilitiesImmutableArray = null;
        PointerBuffer pointerBuffer = null;
        XVisualInfo xVisualInfo = null;
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        boolean bl2 = gLCapabilitiesImmutable.isOnscreen();
        boolean bl3 = gLCapabilitiesImmutable.isPBuffer();
        AbstractGraphicsDevice abstractGraphicsDevice = x11GraphicsScreen.getDevice();
        long l2 = abstractGraphicsDevice.getHandle();
        pointerBuffer = GLX.glXChooseFBConfig(l2, n2 = x11GraphicsScreen.getIndex(), nArray2 = X11GLXGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable, true, bl = GLXUtil.isMultisampleAvailable(l2), l2, n2), 0, nArray = new int[]{-1}, 0);
        if (pointerBuffer != null && pointerBuffer.limit() > 0) {
            capabilitiesImmutableArray = new GLCapabilitiesImmutable[pointerBuffer.limit()];
            for (n = 0; n < pointerBuffer.limit(); ++n) {
                if (!X11GLXGraphicsConfiguration.GLXFBConfigValid(l2, pointerBuffer.get(n))) {
                    if (!DEBUG) continue;
                    System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: FBConfig invalid (1): (" + x11GraphicsScreen + "," + gLCapabilitiesImmutable + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString(pointerBuffer.get(n)));
                    continue;
                }
                capabilitiesImmutableArray[n] = X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(gLProfile, l2, pointerBuffer.get(n), false, bl2, bl3, bl);
            }
            if (capabilitiesImmutableArray[0] != null) {
                l = pointerBuffer.get(0);
                n3 = 0;
                if (DEBUG) {
                    System.err.println("!!! glXChooseFBConfig recommended fbcfg " + X11GLXGraphicsConfigurationFactory.toHexString(l) + ", idx " + n3);
                    System.err.println("!!! user  caps " + gLCapabilitiesImmutable);
                    System.err.println("!!! fbcfg caps " + capabilitiesImmutableArray[n3]);
                }
            } else if (DEBUG) {
                System.err.println("!!! glXChooseFBConfig no caps for recommended fbcfg " + X11GLXGraphicsConfigurationFactory.toHexString(l));
                System.err.println("!!! user  caps " + gLCapabilitiesImmutable);
            }
        }
        if (null == capabilitiesImmutableArray) {
            pointerBuffer = GLX.glXChooseFBConfig(l2, n2, null, 0, nArray, 0);
            if (pointerBuffer == null || pointerBuffer.limit() <= 0) {
                if (DEBUG) {
                    System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: Failed glXChooseFBConfig (" + x11GraphicsScreen + "," + gLCapabilitiesImmutable + "): " + pointerBuffer + ", " + nArray[0]);
                }
                return null;
            }
            capabilitiesImmutableArray = new GLCapabilitiesImmutable[pointerBuffer.limit()];
            for (n = 0; n < pointerBuffer.limit(); ++n) {
                if (!X11GLXGraphicsConfiguration.GLXFBConfigValid(l2, pointerBuffer.get(n))) {
                    if (!DEBUG) continue;
                    System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: FBConfig invalid (2): (" + x11GraphicsScreen + "): fbcfg: " + X11GLXGraphicsConfigurationFactory.toHexString(pointerBuffer.get(n)));
                    continue;
                }
                capabilitiesImmutableArray[n] = X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(gLProfile, l2, pointerBuffer.get(n), false, bl2, bl3, bl);
            }
        }
        if (0 > (n = X11GLXGraphicsConfigurationFactory.chooseCapabilities(gLCapabilitiesChooser, gLCapabilitiesImmutable, capabilitiesImmutableArray, n3))) {
            if (DEBUG) {
                Thread.dumpStack();
            }
            return null;
        }
        n4 = X11GLXGraphicsConfiguration.glXFBConfig2FBConfigID(l2, pointerBuffer.get(n));
        xVisualInfo = GLX.glXGetVisualFromFBConfig(l2, pointerBuffer.get(n));
        if (xVisualInfo == null) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.chooseGraphicsConfigurationFBConfig: Failed glXGetVisualFromFBConfig (" + x11GraphicsScreen + ", " + pointerBuffer.get(n) + " (Continue: " + (false == capabilitiesImmutableArray[n].isOnscreen()) + "):\n\t" + capabilitiesImmutableArray[n]);
            }
            if (capabilitiesImmutableArray[n].isOnscreen()) {
                return null;
            }
        }
        return new X11GLXGraphicsConfiguration(x11GraphicsScreen, (GLCapabilitiesImmutable)capabilitiesImmutableArray[n], gLCapabilitiesImmutable2, gLCapabilitiesChooser, xVisualInfo, pointerBuffer.get(n), n4);
    }

    private static X11GLXGraphicsConfiguration chooseGraphicsConfigurationXVisual(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, X11GraphicsScreen x11GraphicsScreen) {
        int n;
        if (gLCapabilitiesChooser == null) {
            gLCapabilitiesChooser = new DefaultGLCapabilitiesChooser();
        }
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        boolean bl = gLCapabilitiesImmutable.isOnscreen();
        CapabilitiesImmutable[] capabilitiesImmutableArray = null;
        int n2 = -1;
        XVisualInfo xVisualInfo = null;
        AbstractGraphicsDevice abstractGraphicsDevice = x11GraphicsScreen.getDevice();
        long l = abstractGraphicsDevice.getHandle();
        int n3 = x11GraphicsScreen.getIndex();
        boolean bl2 = GLXUtil.isMultisampleAvailable(l);
        int[] nArray = X11GLXGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable, false, bl2, l, n3);
        XVisualInfo[] xVisualInfoArray = null;
        XVisualInfo xVisualInfo2 = GLX.glXChooseVisual(l, n3, nArray, 0);
        if (DEBUG) {
            System.err.print("!!! glXChooseVisual recommended ");
            if (xVisualInfo2 == null) {
                System.err.println("null visual");
            } else {
                System.err.println("visual id " + X11GLXGraphicsConfigurationFactory.toHexString(xVisualInfo2.getVisualid()));
            }
        }
        int[] nArray2 = new int[1];
        XVisualInfo xVisualInfo3 = XVisualInfo.create();
        xVisualInfo3.setScreen(n3);
        xVisualInfoArray = X11Util.XGetVisualInfo((long)l, (long)2L, (XVisualInfo)xVisualInfo3, (int[])nArray2, (int)0);
        if (xVisualInfoArray == null || xVisualInfoArray.length < 1) {
            throw new GLException("Error while enumerating available XVisualInfos");
        }
        capabilitiesImmutableArray = new GLCapabilitiesImmutable[xVisualInfoArray.length];
        for (n = 0; n < xVisualInfoArray.length; ++n) {
            capabilitiesImmutableArray[n] = X11GLXGraphicsConfiguration.XVisualInfo2GLCapabilities(gLProfile, l, xVisualInfoArray[n], bl, false, bl2);
            if (xVisualInfo2 == null || xVisualInfo2.getVisualid() != xVisualInfoArray[n].getVisualid()) continue;
            n2 = n;
        }
        n = X11GLXGraphicsConfigurationFactory.chooseCapabilities(gLCapabilitiesChooser, gLCapabilitiesImmutable, capabilitiesImmutableArray, n2);
        if (0 > n) {
            if (DEBUG) {
                Thread.dumpStack();
            }
            return null;
        }
        xVisualInfo = XVisualInfo.create((XVisualInfo)xVisualInfoArray[n]);
        return new X11GLXGraphicsConfiguration(x11GraphicsScreen, (GLCapabilitiesImmutable)capabilitiesImmutableArray[n], gLCapabilitiesImmutable2, gLCapabilitiesChooser, xVisualInfo, 0L, -1);
    }

    static String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }
}

