/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.glsl;

import java.io.PrintStream;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class ShaderUtil {
    public static String getShaderInfoLog(GL gL, int n) {
        return ShaderUtil.getImpl(gL).getShaderInfoLog(gL, n);
    }

    public static String getProgramInfoLog(GL gL, int n) {
        return ShaderUtil.getImpl(gL).getProgramInfoLog(gL, n);
    }

    public static boolean isShaderStatusValid(GL gL, int n, int n2) {
        return ShaderUtil.getImpl(gL).isShaderStatusValid(gL, n, n2);
    }

    public static boolean isShaderStatusValid(GL gL, int n, int n2, PrintStream printStream) {
        return ShaderUtil.getImpl(gL).isShaderStatusValid(gL, n, n2, printStream);
    }

    public static boolean isShaderStatusValid(GL gL, IntBuffer intBuffer, int n) {
        return ShaderUtil.getImpl(gL).isShaderStatusValid(gL, intBuffer, n);
    }

    public static boolean isShaderStatusValid(GL gL, IntBuffer intBuffer, int n, PrintStream printStream) {
        return ShaderUtil.getImpl(gL).isShaderStatusValid(gL, intBuffer, n, printStream);
    }

    public static boolean isProgramStatusValid(GL gL, int n, int n2) {
        return ShaderUtil.getImpl(gL).isProgramStatusValid(gL, n, n2);
    }

    public static boolean isProgramValid(GL gL, int n) {
        return ShaderUtil.getImpl(gL).isProgramValid(gL, n);
    }

    public static boolean isProgramValid(GL gL, int n, PrintStream printStream) {
        return ShaderUtil.getImpl(gL).isProgramValid(gL, n, printStream);
    }

    public static void createShader(GL gL, int n, IntBuffer intBuffer) {
        ShaderUtil.getImpl(gL).createShader(gL, n, intBuffer);
    }

    public static Set getShaderBinaryFormats(GL gL) {
        return ShaderUtil.getImpl(gL).getShaderBinaryFormats(gL);
    }

    public static boolean isShaderCompilerAvailable(GL gL) {
        return ShaderUtil.getImpl(gL).isShaderCompilerAvailable(gL);
    }

    public static void shaderSource(GL gL, int n, String[] stringArray) {
        ShaderUtil.getImpl(gL).shaderSource(gL, n, stringArray);
    }

    public static void shaderSource(GL gL, IntBuffer intBuffer, String[][] stringArray) {
        ShaderUtil.getImpl(gL).shaderSource(gL, intBuffer, stringArray);
    }

    public static void shaderBinary(GL gL, IntBuffer intBuffer, int n, Buffer buffer) {
        ShaderUtil.getImpl(gL).shaderBinary(gL, intBuffer, n, buffer);
    }

    public static void compileShader(GL gL, IntBuffer intBuffer) {
        ShaderUtil.getImpl(gL).compileShader(gL, intBuffer);
    }

    public static void attachShader(GL gL, int n, IntBuffer intBuffer) {
        ShaderUtil.getImpl(gL).attachShader(gL, n, intBuffer);
    }

    public static void detachShader(GL gL, int n, IntBuffer intBuffer) {
        ShaderUtil.getImpl(gL).detachShader(gL, n, intBuffer);
    }

    public static void deleteShader(GL gL, IntBuffer intBuffer) {
        ShaderUtil.getImpl(gL).deleteShader(gL, intBuffer);
    }

    public static boolean createAndLoadShader(GL gL, IntBuffer intBuffer, int n, int n2, Buffer buffer, PrintStream printStream) {
        return ShaderUtil.getImpl(gL).createAndLoadShader(gL, intBuffer, n, n2, buffer, printStream);
    }

    public static boolean createAndCompileShader(GL gL, IntBuffer intBuffer, int n, String[][] stringArray, PrintStream printStream) {
        return ShaderUtil.getImpl(gL).createAndCompileShader(gL, intBuffer, n, stringArray, printStream);
    }

    private static Impl getImpl(GL gL) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        GLContext gLContext = gL2ES2.getContext();
        Impl impl = (Impl)gLContext.getAttachedObject(ShaderUtil.class.getName());
        if (impl == null) {
            impl = new GL2ES2Impl();
            gLContext.putAttachedObject(ShaderUtil.class.getName(), (Object)impl);
        }
        return impl;
    }

    static class GL2ES2Impl
    extends Impl {
        private Boolean shaderCompilerAvailable = null;
        private Set shaderBinaryFormats = null;

        GL2ES2Impl() {
        }

        public String getShaderInfoLog(GL gL, int n) {
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            int[] nArray = new int[1];
            gL2ES2.glGetShaderiv(n, 35716, nArray, 0);
            if (nArray[0] == 0) {
                return "(no info log)";
            }
            int[] nArray2 = new int[1];
            byte[] byArray = new byte[nArray[0]];
            gL2ES2.glGetShaderInfoLog(n, nArray[0], nArray2, 0, byArray, 0);
            return new String(byArray, 0, nArray2[0]);
        }

        public String getProgramInfoLog(GL gL, int n) {
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            int[] nArray = new int[1];
            gL2ES2.glGetProgramiv(n, 35716, nArray, 0);
            if (nArray[0] == 0) {
                return "(no info log)";
            }
            int[] nArray2 = new int[1];
            byte[] byArray = new byte[nArray[0]];
            gL2ES2.glGetProgramInfoLog(n, nArray[0], nArray2, 0, byArray, 0);
            return new String(byArray, 0, nArray2[0]);
        }

        public boolean isShaderStatusValid(GL gL, int n, int n2) {
            return this.isShaderStatusValid(gL, n, n2, null);
        }

        public boolean isShaderStatusValid(GL gL, int n, int n2, PrintStream printStream) {
            boolean bl;
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            int[] nArray = new int[1];
            gL2ES2.glGetShaderiv(n, n2, nArray, 0);
            boolean bl2 = bl = nArray[0] == 1;
            if (!bl && null != printStream) {
                printStream.println("Shader status invalid: " + this.getShaderInfoLog(gL2ES2, n));
            }
            return bl;
        }

        public boolean isShaderStatusValid(GL gL, IntBuffer intBuffer, int n) {
            return this.isShaderStatusValid(gL, intBuffer, n, null);
        }

        public boolean isShaderStatusValid(GL gL, IntBuffer intBuffer, int n, PrintStream printStream) {
            boolean bl = true;
            for (int i = intBuffer.position(); i < intBuffer.limit(); ++i) {
                bl = this.isShaderStatusValid(gL, intBuffer.get(i), n, printStream) && bl;
            }
            return bl;
        }

        public boolean isProgramStatusValid(GL gL, int n, int n2) {
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            int[] nArray = new int[1];
            gL2ES2.glGetProgramiv(n, n2, nArray, 0);
            return nArray[0] == 1;
        }

        public boolean isProgramValid(GL gL, int n) {
            return this.isProgramValid(gL, n, null);
        }

        public boolean isProgramValid(GL gL, int n, PrintStream printStream) {
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            int[] nArray = new int[1];
            if (!gL2ES2.glIsProgram(n)) {
                if (null != printStream) {
                    printStream.println("Program name invalid: " + n);
                }
                return false;
            }
            if (!this.isProgramStatusValid(gL2ES2, n, 35714)) {
                if (null != printStream) {
                    printStream.println("Program link failed: " + n + "\n\t" + this.getProgramInfoLog(gL2ES2, n));
                }
                return false;
            }
            if (!gL2ES2.isGLES2() || this.isShaderCompilerAvailable(gL2ES2)) {
                gL2ES2.glValidateProgram(n);
                if (!this.isProgramStatusValid(gL2ES2, n, 35715)) {
                    if (null != printStream) {
                        printStream.println("Program validation failed: " + n + "\n\t" + this.getProgramInfoLog(gL2ES2, n));
                    }
                    return false;
                }
            }
            return true;
        }

        public void createShader(GL gL, int n, IntBuffer intBuffer) {
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            for (int i = intBuffer.position(); i < intBuffer.limit(); ++i) {
                intBuffer.put(i, gL2ES2.glCreateShader(n));
            }
        }

        public Set getShaderBinaryFormats(GL gL) {
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            if (null == this.shaderBinaryFormats) {
                if (gL2ES2.getContext() != GLContext.getCurrent()) {
                    return new HashSet(0);
                }
                int[] nArray = new int[1];
                this.shaderBinaryFormats = new HashSet();
                if (gL2ES2.isGLES2()) {
                    gL2ES2.glGetIntegerv(36345, nArray, 0);
                    int n = nArray[0];
                    if (n > 0) {
                        int[] nArray2 = new int[n];
                        gL2ES2.glGetIntegerv(36344, nArray2, 0);
                        for (int i = 0; i < n; ++i) {
                            this.shaderBinaryFormats.add(new Integer(nArray2[i]));
                        }
                    }
                }
            }
            return this.shaderBinaryFormats;
        }

        public boolean isShaderCompilerAvailable(GL gL) {
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            if (null == this.shaderCompilerAvailable) {
                if (gL2ES2.getContext() != GLContext.getCurrent()) {
                    return false;
                }
                Set set = this.getShaderBinaryFormats(gL2ES2);
                if (gL2ES2.isGLES2()) {
                    boolean bl;
                    byte[] byArray = new byte[1];
                    gL2ES2.glGetBooleanv(36346, byArray, 0);
                    boolean bl2 = bl = byArray[0] != 0;
                    if (!bl && set.size() == 0) {
                        bl = true;
                    }
                    this.shaderCompilerAvailable = new Boolean(bl);
                } else if (gL2ES2.isGL2ES2()) {
                    this.shaderCompilerAvailable = new Boolean(true);
                } else {
                    throw new GLException("Invalid OpenGL profile");
                }
            }
            return this.shaderCompilerAvailable;
        }

        public void shaderSource(GL gL, int n, String[] stringArray) {
            int n2;
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            if (!this.isShaderCompilerAvailable(gL)) {
                throw new GLException("No compiler is available");
            }
            int n3 = n2 = null != stringArray ? stringArray.length : 0;
            if (n2 == 0) {
                throw new GLException("No sources specified");
            }
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = stringArray[i].length();
            }
            gL2ES2.glShaderSource(n, n2, stringArray, nArray, 0);
        }

        public void shaderSource(GL gL, IntBuffer intBuffer, String[][] stringArray) {
            int n;
            int n2 = null != stringArray ? stringArray.length : 0;
            int n3 = n = null != intBuffer ? intBuffer.remaining() : 0;
            if (n <= 0 || n2 <= 0 || n != n2) {
                throw new GLException("Invalid number of shaders and/or sources: shaders=" + n + ", sources=" + n2);
            }
            for (int i = 0; i < n2; ++i) {
                this.shaderSource(gL, intBuffer.get(intBuffer.position() + i), stringArray[i]);
            }
        }

        public void shaderBinary(GL gL, IntBuffer intBuffer, int n, Buffer buffer) {
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            if (this.getShaderBinaryFormats(gL2ES2).size() <= 0) {
                throw new GLException("No binary formats are supported");
            }
            int n2 = intBuffer.remaining();
            if (n2 <= 0) {
                throw new GLException("No shaders specified");
            }
            if (null == buffer) {
                throw new GLException("Null shader binary");
            }
            int n3 = buffer.remaining();
            if (0 >= n3) {
                throw new GLException("Empty shader binary (remaining == 0)");
            }
            gL2ES2.glShaderBinary(n2, intBuffer, n, buffer, n3);
        }

        public void compileShader(GL gL, IntBuffer intBuffer) {
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            for (int i = intBuffer.position(); i < intBuffer.limit(); ++i) {
                gL2ES2.glCompileShader(intBuffer.get(i));
            }
        }

        public void attachShader(GL gL, int n, IntBuffer intBuffer) {
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            for (int i = intBuffer.position(); i < intBuffer.limit(); ++i) {
                gL2ES2.glAttachShader(n, intBuffer.get(i));
            }
        }

        public void detachShader(GL gL, int n, IntBuffer intBuffer) {
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            for (int i = intBuffer.position(); i < intBuffer.limit(); ++i) {
                gL2ES2.glDetachShader(n, intBuffer.get(i));
            }
        }

        public void deleteShader(GL gL, IntBuffer intBuffer) {
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            for (int i = intBuffer.position(); i < intBuffer.limit(); ++i) {
                gL2ES2.glDeleteShader(intBuffer.get(i));
            }
        }

        public boolean createAndLoadShader(GL gL, IntBuffer intBuffer, int n, int n2, Buffer buffer, PrintStream printStream) {
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            int n3 = gL2ES2.glGetError();
            if (n3 != 0 && null != printStream) {
                printStream.println("createAndLoadShader: Pre GL Error: 0x" + Integer.toHexString(n3));
            }
            this.createShader(gL2ES2, n, intBuffer);
            n3 = gL2ES2.glGetError();
            if (n3 != 0) {
                throw new GLException("createAndLoadShader: CreateShader failed, GL Error: 0x" + Integer.toHexString(n3));
            }
            this.shaderBinary(gL2ES2, intBuffer, n2, buffer);
            n3 = gL2ES2.glGetError();
            if (n3 != 0 && null != printStream) {
                printStream.println("createAndLoadShader: ShaderBinary failed, GL Error: 0x" + Integer.toHexString(n3));
            }
            return n3 == 0;
        }

        public boolean createAndCompileShader(GL gL, IntBuffer intBuffer, int n, String[][] stringArray, PrintStream printStream) {
            GL2ES2 gL2ES2 = gL.getGL2ES2();
            int n2 = gL2ES2.glGetError();
            if (n2 != 0 && null != printStream) {
                printStream.println("createAndCompileShader: Pre GL Error: 0x" + Integer.toHexString(n2));
            }
            this.createShader(gL2ES2, n, intBuffer);
            n2 = gL2ES2.glGetError();
            if (n2 != 0) {
                throw new GLException("createAndCompileShader: CreateShader failed, GL Error: 0x" + Integer.toHexString(n2));
            }
            this.shaderSource((GL)gL2ES2, intBuffer, stringArray);
            n2 = gL2ES2.glGetError();
            if (n2 != 0) {
                throw new GLException("createAndCompileShader: ShaderSource failed, GL Error: 0x" + Integer.toHexString(n2));
            }
            this.compileShader(gL2ES2, intBuffer);
            n2 = gL2ES2.glGetError();
            if (n2 != 0 && null != printStream) {
                printStream.println("createAndCompileShader: CompileShader failed, GL Error: 0x" + Integer.toHexString(n2));
            }
            return this.isShaderStatusValid((GL)gL2ES2, intBuffer, 35713, printStream) && n2 == 0;
        }
    }

    static abstract class Impl {
        Impl() {
        }

        public abstract String getShaderInfoLog(GL var1, int var2);

        public abstract String getProgramInfoLog(GL var1, int var2);

        public abstract boolean isShaderStatusValid(GL var1, int var2, int var3);

        public abstract boolean isShaderStatusValid(GL var1, int var2, int var3, PrintStream var4);

        public abstract boolean isShaderStatusValid(GL var1, IntBuffer var2, int var3);

        public abstract boolean isShaderStatusValid(GL var1, IntBuffer var2, int var3, PrintStream var4);

        public abstract boolean isProgramStatusValid(GL var1, int var2, int var3);

        public abstract boolean isProgramValid(GL var1, int var2);

        public abstract boolean isProgramValid(GL var1, int var2, PrintStream var3);

        public abstract void createShader(GL var1, int var2, IntBuffer var3);

        public abstract Set getShaderBinaryFormats(GL var1);

        public abstract boolean isShaderCompilerAvailable(GL var1);

        public abstract void shaderSource(GL var1, int var2, String[] var3);

        public abstract void shaderSource(GL var1, IntBuffer var2, String[][] var3);

        public abstract void shaderBinary(GL var1, IntBuffer var2, int var3, Buffer var4);

        public abstract void compileShader(GL var1, IntBuffer var2);

        public abstract void attachShader(GL var1, int var2, IntBuffer var3);

        public abstract void detachShader(GL var1, int var2, IntBuffer var3);

        public abstract void deleteShader(GL var1, IntBuffer var2);

        public abstract boolean createAndLoadShader(GL var1, IntBuffer var2, int var3, int var4, Buffer var5, PrintStream var6);

        public abstract boolean createAndCompileShader(GL var1, IntBuffer var2, int var3, String[][] var4, PrintStream var5);
    }
}

