/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.reconciler.dropins;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Activator;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerHelper;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.DefaultPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IUProfilePropertyQuery;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitPropertyOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.PropertyOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ProfileSynchronizer {
    private static final String RECONCILER_APPLICATION_ID = "org.eclipse.equinox.p2.reconciler.application";
    private static final String TIMESTAMPS_FILE_PREFIX = "timestamps";
    private static final String PROFILE_TIMESTAMP = "PROFILE";
    private static final String NO_TIMESTAMP = "-1";
    private static final String PROP_FROM_DROPINS = "org.eclipse.equinox.p2.reconciler.dropins";
    private static final String CACHE_EXTENSIONS = "org.eclipse.equinox.p2.cache.extensions";
    private static final String PIPE = "|";
    private static final String EXPLANATION = "org.eclipse.equinox.p2.director.explain";
    final IProfile profile;
    final Map repositoryMap;
    private Properties timestamps;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public ProfileSynchronizer(IProfile profile, Collection repositories) {
        this.profile = profile;
        this.repositoryMap = new HashMap();
        Iterator it = repositories.iterator();
        while (it.hasNext()) {
            IMetadataRepository repository = (IMetadataRepository)it.next();
            this.repositoryMap.put(repository.getLocation().toString(), repository);
        }
    }

    public IStatus synchronize(IProgressMonitor monitor) {
        this.readTimestamps();
        if (this.isUpToDate()) {
            return Status.OK_STATUS;
        }
        ProvisioningContext context = this.getContext();
        context.setProperty(EXPLANATION, Boolean.FALSE.toString());
        ProfileChangeRequest request = this.createProfileChangeRequest(context);
        String updatedCacheExtensions = this.synchronizeCacheExtensions();
        if (request == null) {
            if (updatedCacheExtensions != null) {
                PropertyOperand operand = new PropertyOperand(CACHE_EXTENSIONS, null, (Object)updatedCacheExtensions);
                IStatus engineResult = this.executeOperands(new Operand[]{operand}, context, null);
                if (engineResult.getSeverity() != 4 && engineResult.getSeverity() != 8) {
                    this.writeTimestamps();
                }
                return engineResult;
            }
            return Status.OK_STATUS;
        }
        if (updatedCacheExtensions != null) {
            request.setProfileProperty(CACHE_EXTENSIONS, (Object)updatedCacheExtensions);
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            ProvisioningPlan plan = this.createProvisioningPlan(request, context, (IProgressMonitor)sub.newChild(50));
            IStatus status = plan.getStatus();
            if (status.getSeverity() == 4 || status.getSeverity() == 8) {
                IStatus iStatus = status;
                return iStatus;
            }
            Operand[] operands = plan.getOperands();
            if (operands.length == 0 || this.containsOnlyInstallableUnitPropertyOperandAdditions(operands)) {
                this.writeTimestamps();
                IStatus iStatus = status;
                return iStatus;
            }
            IStatus engineResult = this.executePlan(plan, context, (IProgressMonitor)sub.newChild(50));
            if (engineResult.getSeverity() == 4 || engineResult.getSeverity() == 8) {
                IStatus iStatus = engineResult;
                return iStatus;
            }
            this.writeTimestamps();
            IStatus iStatus = this.applyConfiguration(false);
            return iStatus;
        }
        finally {
            sub.done();
        }
    }

    private boolean containsOnlyInstallableUnitPropertyOperandAdditions(Operand[] operands) {
        int i = 0;
        while (i < operands.length) {
            if (!(operands[i] instanceof InstallableUnitPropertyOperand)) {
                return false;
            }
            InstallableUnitPropertyOperand iuPropertyOperand = (InstallableUnitPropertyOperand)operands[i];
            if (iuPropertyOperand.first() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void writeTimestamps() {
        this.timestamps.clear();
        this.timestamps.put(PROFILE_TIMESTAMP, Long.toString(this.profile.getTimestamp()));
        Iterator it = this.repositoryMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            IMetadataRepository repository = (IMetadataRepository)entry.getValue();
            Map props = repository.getProperties();
            String timestamp = null;
            if (props != null) {
                timestamp = (String)props.get("p2.timestamp");
            }
            if (timestamp == null) {
                timestamp = NO_TIMESTAMP;
            }
            this.timestamps.put(entry.getKey(), timestamp);
        }
        try {
            File file = Activator.getContext().getDataFile(TIMESTAMPS_FILE_PREFIX + this.profile.getProfileId().hashCode());
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            try {
                this.timestamps.store(os, "Timestamps for " + this.profile.getProfileId());
            }
            finally {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
    }

    private boolean isUpToDate() {
        if ("true".equals(Activator.getContext().getProperty("osgi.checkConfiguration"))) {
            return false;
        }
        String lastKnownProfileTimeStamp = (String)this.timestamps.remove(PROFILE_TIMESTAMP);
        if (lastKnownProfileTimeStamp == null) {
            return false;
        }
        if (!lastKnownProfileTimeStamp.equals(Long.toString(this.profile.getTimestamp()))) {
            return false;
        }
        Iterator it = this.repositoryMap.entrySet().iterator();
        while (it.hasNext()) {
            String lastKnownTimestamp;
            Map.Entry entry = it.next();
            IMetadataRepository repository = (IMetadataRepository)entry.getValue();
            Map props = repository.getProperties();
            String currentTimestamp = null;
            if (props != null) {
                currentTimestamp = (String)props.get("p2.timestamp");
            }
            if (currentTimestamp == null) {
                currentTimestamp = NO_TIMESTAMP;
            }
            if ((lastKnownTimestamp = (String)this.timestamps.remove(entry.getKey())) == null) {
                return false;
            }
            if (lastKnownTimestamp.equals(currentTimestamp)) continue;
            return false;
        }
        return this.timestamps.size() == 0;
    }

    private void readTimestamps() {
        File file = Activator.getContext().getDataFile(TIMESTAMPS_FILE_PREFIX + this.profile.getProfileId().hashCode());
        this.timestamps = new Properties();
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            try {
                this.timestamps.load(is);
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
    }

    private ProvisioningContext getContext() {
        ArrayList<URI> repoURLs = new ArrayList<URI>();
        Iterator iterator = this.repositoryMap.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                repoURLs.add(new URI((String)iterator.next()));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        ProvisioningContext result = new ProvisioningContext(repoURLs.toArray(new URI[repoURLs.size()]));
        result.setArtifactRepositories(new URI[0]);
        return result;
    }

    private String synchronizeCacheExtensions() {
        ArrayList<String> currentExtensions = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        ArrayList repositories = new ArrayList(this.repositoryMap.keySet());
        final String OSGiInstallArea = String.valueOf(Activator.getOSGiInstallArea().toExternalForm()) + ".eclipseextension";
        Collections.sort(repositories, new Comparator(){

            public int compare(Object left, Object right) {
                if (OSGiInstallArea.equals(left)) {
                    return -1;
                }
                if (OSGiInstallArea.equals(right)) {
                    return 1;
                }
                return ((String)left).compareTo((String)right);
            }
        });
        Iterator it = repositories.iterator();
        while (it.hasNext()) {
            String repositoryId = (String)it.next();
            try {
                IArtifactRepository repository = Activator.loadArtifactRepository(new URI(repositoryId), null);
                if (!(repository instanceof IFileArtifactRepository)) continue;
                currentExtensions.add(this.escapePipe(repositoryId));
                buffer.append(repositoryId);
                if (!it.hasNext()) continue;
                buffer.append(PIPE);
            }
            catch (ProvisionException provisionException) {
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        String currentExtensionsProperty = buffer.length() == 0 ? null : buffer.toString();
        ArrayList<String> previousExtensions = new ArrayList<String>();
        String previousExtensionsProperty = this.profile.getProperty(CACHE_EXTENSIONS);
        if (previousExtensionsProperty != null) {
            StringTokenizer tokenizer = new StringTokenizer(previousExtensionsProperty, PIPE);
            while (tokenizer.hasMoreTokens()) {
                previousExtensions.add(tokenizer.nextToken());
            }
        }
        if (previousExtensions.size() == currentExtensions.size() && previousExtensions.containsAll(currentExtensions)) {
            return null;
        }
        return currentExtensionsProperty;
    }

    private String escapePipe(String location) {
        int pipeIndex;
        String result = location;
        while ((pipeIndex = result.indexOf(44)) != -1) {
            result = String.valueOf(result.substring(0, pipeIndex)) + "%7C" + result.substring(pipeIndex + 1);
        }
        return result;
    }

    public ProfileChangeRequest createProfileChangeRequest(ProvisioningContext context) {
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        boolean resolve = Boolean.valueOf(this.profile.getProperty("org.eclipse.equinox.p2.resolve"));
        if (resolve) {
            request.removeProfileProperty("org.eclipse.equinox.p2.resolve");
        }
        ArrayList<IInstallableUnit> toAdd = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> toRemove = new ArrayList<IInstallableUnit>();
        boolean foundIUsToAdd = false;
        HashSet profileIUs = new HashSet(this.profile.query((Query)InstallableUnitQuery.ANY, new Collector(), null).toCollection());
        HashSet availableProfileIUs = new HashSet(this.profile.available((Query)InstallableUnitQuery.ANY, new Collector(), null).toCollection());
        Collector allIUs = this.getAllIUsFromRepos();
        Iterator iter = allIUs.iterator();
        while (iter.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iter.next();
            if (profileIUs.contains(iu)) continue;
            if (Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.type.group")).booleanValue()) {
                request.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.root", (Object)Boolean.TRUE.toString());
            }
            request.setInstallableUnitProfileProperty(iu, PROP_FROM_DROPINS, (Object)Boolean.TRUE.toString());
            request.setInstallableUnitInclusionRules(iu, PlannerHelper.createOptionalInclusionRule((IInstallableUnit)iu));
            request.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.lock", (Object)Integer.toString(1));
            toAdd.add(iu);
            if (foundIUsToAdd || availableProfileIUs.contains(iu)) continue;
            foundIUsToAdd = true;
        }
        Collector dropinIUs = this.profile.query((Query)new IUProfilePropertyQuery(this.profile, PROP_FROM_DROPINS, Boolean.toString(true)), new Collector(), null);
        HashSet all = new HashSet(allIUs.toCollection());
        Iterator iter2 = dropinIUs.iterator();
        while (iter2.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iter2.next();
            if ("STRICT".equals(this.profile.getInstallableUnitProperty(iu, "org.eclipse.equinox.p2.internal.inclusion.rules"))) {
                request.removeInstallableUnitProfileProperty(iu, PROP_FROM_DROPINS);
                request.removeInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.lock");
                continue;
            }
            if (all.contains(iu)) {
                toAdd.remove(iu);
                continue;
            }
            toRemove.add(iu);
        }
        if (!foundIUsToAdd && toRemove.isEmpty() && !resolve) {
            if (Tracing.DEBUG_RECONCILER) {
                Tracing.debug((String)"[reconciler] Nothing to do.");
            }
            return null;
        }
        context.setExtraIUs(toAdd);
        request.addInstallableUnits(toAdd.toArray(new IInstallableUnit[toAdd.size()]));
        request.removeInstallableUnits(toRemove.toArray(new IInstallableUnit[toRemove.size()]));
        this.debug(request);
        return request;
    }

    private void debug(ProfileChangeRequest request) {
        if (!Tracing.DEBUG_RECONCILER) {
            return;
        }
        IInstallableUnit[] toAdd = request.getAddedInstallableUnits();
        if (toAdd == null || toAdd.length == 0) {
            Tracing.debug((String)"[reconciler] No installable units to add.");
        } else {
            int i = 0;
            while (i < toAdd.length) {
                Tracing.debug((String)("[reconciler] Adding IU: " + toAdd[i].getId() + ' ' + toAdd[i].getVersion()));
                ++i;
            }
        }
        Map propsToAdd = request.getInstallableUnitProfilePropertiesToAdd();
        if (propsToAdd == null || propsToAdd.isEmpty()) {
            Tracing.debug((String)"[reconciler] No IU properties to add.");
        } else {
            Iterator iter = propsToAdd.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                Tracing.debug((String)("[reconciler] Adding IU property: " + key + "->" + propsToAdd.get(key)));
            }
        }
        IInstallableUnit[] toRemove = request.getRemovedInstallableUnits();
        if (toRemove == null || toRemove.length == 0) {
            Tracing.debug((String)"[reconciler] No installable units to remove.");
        } else {
            int i = 0;
            while (i < toRemove.length) {
                Tracing.debug((String)("[reconciler] Removing IU: " + toRemove[i].getId() + ' ' + toRemove[i].getVersion()));
                ++i;
            }
        }
        Map propsToRemove = request.getInstallableUnitProfilePropertiesToRemove();
        if (propsToRemove == null || propsToRemove.isEmpty()) {
            Tracing.debug((String)"[reconciler] No IU properties to remove.");
        } else {
            Iterator iter = propsToRemove.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                Tracing.debug((String)("[reconciler] Removing IU property: " + key + "->" + propsToRemove.get(key)));
            }
        }
    }

    private Collector getAllIUsFromRepos() {
        Collector allRepos = new Collector();
        Iterator it = this.repositoryMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            IMetadataRepository repository = (IMetadataRepository)entry.getValue();
            repository.query((Query)InstallableUnitQuery.ANY, allRepos, null).iterator();
        }
        return allRepos;
    }

    private ProvisioningPlan createProvisioningPlan(ProfileChangeRequest request, ProvisioningContext provisioningContext, IProgressMonitor monitor) {
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IPlanner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference reference = context.getServiceReference(clazz.getName());
        IPlanner planner = (IPlanner)context.getService(reference);
        try {
            ProvisioningPlan provisioningPlan = planner.getProvisioningPlan(request, provisioningContext, monitor);
            return provisioningPlan;
        }
        finally {
            context.ungetService(reference);
        }
    }

    private IStatus executeOperands(Operand[] operands, ProvisioningContext provisioningContext, IProgressMonitor monitor) {
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference reference = context.getServiceReference(clazz.getName());
        IEngine engine = (IEngine)context.getService(reference);
        try {
            PhaseSet phaseSet = DefaultPhaseSet.createDefaultPhaseSet((int)(DefaultPhaseSet.PHASE_COLLECT | DefaultPhaseSet.PHASE_CHECK_TRUST));
            IStatus iStatus = engine.perform(this.profile, phaseSet, operands, provisioningContext, monitor);
            return iStatus;
        }
        finally {
            context.ungetService(reference);
        }
    }

    private IStatus executePlan(ProvisioningPlan plan, ProvisioningContext provisioningContext, IProgressMonitor monitor) {
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference reference = context.getServiceReference(clazz.getName());
        IEngine engine = (IEngine)context.getService(reference);
        try {
            PhaseSet phaseSet = DefaultPhaseSet.createDefaultPhaseSet((int)(DefaultPhaseSet.PHASE_COLLECT | DefaultPhaseSet.PHASE_CHECK_TRUST));
            if (plan.getInstallerPlan() != null) {
                IStatus installerPlanStatus = engine.perform(this.profile, phaseSet, plan.getInstallerPlan().getOperands(), provisioningContext, monitor);
                if (!installerPlanStatus.isOK()) {
                    IStatus iStatus = installerPlanStatus;
                    return iStatus;
                }
                this.applyConfiguration(true);
            }
            IStatus iStatus = engine.perform(this.profile, phaseSet, plan.getOperands(), provisioningContext, monitor);
            return iStatus;
        }
        finally {
            context.ungetService(reference);
        }
    }

    private IStatus applyConfiguration(boolean isInstaller) {
        if (!isInstaller && ProfileSynchronizer.isReconciliationApplicationRunning()) {
            return Status.OK_STATUS;
        }
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.configurator.Configurator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference reference = context.getServiceReference(clazz.getName());
        Configurator configurator = (Configurator)context.getService(reference);
        try {
            try {
                configurator.applyConfiguration();
            }
            catch (IOException e) {
                Status status = new Status(4, PROP_FROM_DROPINS, "Unexpected failure applying configuration", (Throwable)e);
                context.ungetService(reference);
                return status;
            }
        }
        finally {
            context.ungetService(reference);
        }
        return Status.OK_STATUS;
    }

    static boolean isReconciliationApplicationRunning() {
        EnvironmentInfo info;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return false;
        }
        String[] args = info.getCommandLineArgs();
        if (args == null) {
            return false;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i] != null && RECONCILER_APPLICATION_ID.equals(args[i].trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

