/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.audio.windows.waveout;

import com.jogamp.audio.windows.waveout.SoundBuffer;
import com.jogamp.audio.windows.waveout.Vec3f;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Track {
    private static final int BUFFER_SIZE = 32768;
    static final int BYTES_PER_SAMPLE = 2;
    static final boolean NEEDS_BYTE_SWAP = true;
    private SoundBuffer activeBuffer;
    private int samplePosition;
    private int totalSamples;
    private int samplesRead;
    private SoundBuffer fillingBuffer;
    private InputStream input;
    private File file;
    private boolean playing;
    private boolean looping;
    private volatile Vec3f position = new Vec3f();
    private float leftGain;
    private float rightGain;

    Track(File file) throws IOException {
        if (!file.getName().endsWith(".rawsound")) {
            throw new IOException("Unsupported file format (currently supports only raw sounds)");
        }
        this.file = file;
        this.openInput();
        this.activeBuffer = new SoundBuffer(32768, 2, true);
        this.fillingBuffer = new SoundBuffer(32768, 2, true);
        this.fill();
        this.swapBuffers();
    }

    private void openInput() throws IOException {
        this.input = new BufferedInputStream(new FileInputStream(this.file));
        this.totalSamples = (int)this.file.length() / 2;
    }

    public File getFile() {
        return this.file;
    }

    public synchronized void play() {
        if (this.input == null) {
            try {
                this.openInput();
                this.fill();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }
        this.playing = true;
    }

    public synchronized boolean isPlaying() {
        return this.playing;
    }

    public synchronized void setLooping(boolean bl) {
        this.looping = bl;
    }

    public synchronized boolean isLooping() {
        return this.looping;
    }

    public void setPosition(float f, float f2, float f3) {
        this.position = new Vec3f(f, f2, f3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void fill() throws IOException {
        if (this.input == null) {
            return;
        }
        SoundBuffer soundBuffer = this.fillingBuffer;
        if (!soundBuffer.empty()) {
            return;
        }
        soundBuffer.fill(this.input);
        if (soundBuffer.empty()) {
            InputStream inputStream = null;
            Track track = this;
            synchronized (track) {
                inputStream = this.input;
                this.input = null;
            }
            inputStream.close();
            if (this.isLooping()) {
                this.openInput();
                this.fill();
            }
        }
    }

    void setLeftGain(float f) {
        this.leftGain = f;
    }

    float getLeftGain() {
        return this.leftGain;
    }

    void setRightGain(float f) {
        this.rightGain = f;
    }

    float getRightGain() {
        return this.rightGain;
    }

    Vec3f getPosition() {
        return this.position;
    }

    boolean hasNextSample() {
        return !this.activeBuffer.empty() && this.samplePosition < this.activeBuffer.numSamples();
    }

    float nextSample() {
        float f = this.activeBuffer.getSample(this.samplePosition++);
        ++this.samplesRead;
        if (!this.hasNextSample()) {
            this.swapBuffers();
            this.samplePosition = 0;
            if (this.done()) {
                this.playing = false;
            }
        }
        return f;
    }

    synchronized void swapBuffers() {
        SoundBuffer soundBuffer = this.activeBuffer;
        this.activeBuffer = this.fillingBuffer;
        this.fillingBuffer = soundBuffer;
        this.fillingBuffer.empty(true);
    }

    boolean done() {
        return this.samplesRead == this.totalSamples && !this.looping;
    }
}

