/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.opengl.ant;

import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.util.JavaEnvUtils;

public class StaticGLGenTask
extends Task {
    private static final String GL_GEN = "com.jogamp.gluegen.opengl.BuildStaticGLInfo";
    private CommandlineJava glgenCommandline;
    private String packageName;
    private String outputDirectory;
    private FileSet headerSet = new FileSet();

    public StaticGLGenTask() {
        this.glgenCommandline = new CommandlineJava();
        this.glgenCommandline.setVm(JavaEnvUtils.getJreExecutable((String)"java"));
        this.glgenCommandline.setClassname(GL_GEN);
    }

    public void setPackage(String string) {
        this.log("Setting package name to: " + string, 3);
        this.packageName = string;
    }

    public void setOutputDir(String string) {
        this.log("Setting output directory to: " + string, 3);
        this.outputDirectory = string;
    }

    public PatternSet.NameEntry createHeader() {
        return this.headerSet.createInclude();
    }

    public PatternSet.NameEntry createHeadersFile() {
        return this.headerSet.createIncludesFile();
    }

    public void setHeaders(String string) {
        this.headerSet.setIncludes(string);
    }

    public Path createClasspath() {
        return this.glgenCommandline.createClasspath(this.project).createPath();
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        this.addAttributes();
        this.log(this.glgenCommandline.describeCommand(), 3);
        int n = this.execute(this.glgenCommandline.getCommandline());
        if (n == 1) {
            throw new BuildException("BuildStaticGLInfo returned: " + n, this.location);
        }
    }

    private void validateAttributes() throws BuildException {
        if (!this.isValid(this.packageName)) {
            throw new BuildException("Invalid package name: " + this.packageName);
        }
        if (!this.isValid(this.outputDirectory)) {
            throw new BuildException("Invalid output directory name: " + this.outputDirectory);
        }
    }

    private boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        return string.trim().length() >= 1;
    }

    private void addAttributes() {
        this.glgenCommandline.createArgument().setValue(this.packageName);
        this.glgenCommandline.createArgument().setValue(this.outputDirectory);
        this.headerSet.setDir(this.getProject().getBaseDir());
        DirectoryScanner directoryScanner = this.headerSet.getDirectoryScanner(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            this.glgenCommandline.createArgument().setValue(stringArray[i]);
        }
    }

    private int execute(String[] stringArray) throws BuildException {
        Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), null);
        execute.setAntRun(this.project);
        execute.setCommandline(stringArray);
        execute.setWorkingDirectory(this.project.getBaseDir());
        try {
            return execute.execute();
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException, this.location);
        }
    }
}

