/*
 * Copyright (c) 2010,2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.api;

/**
 * 品質スイッチの状態を表す列挙型定数です。
 * いくつかの処理において品質と速度のトレードオフを決定するのに使用されます。
 * エフェクトを実装する場合、品質スイッチの状態によって処理内容を変えることができます。
 * <p>
 * 品質スイッチの影響を受ける処理の例:
 * <ul>
 * <li>レイヤーをトランスフォームする際の補間方法</li>
 * <li>テキストアニメータのブラーの品質</li>
 * </ul>
 * </p>
 * 
 * @since 0.5.1
 */
public enum Quality {

	/**
	 * ドラフト品質。
	 * 品質を落として処理速度を優先します。
	 * レイヤーのトランスフォームは補間無しで処理されます。
	 */
	DRAFT,

	/**
	 * 通常品質。
	 * 品質と速度のバランスが取れた処理を行います。
	 * レイヤーのトランスフォームはバイリニア補間で処理されます。
	 */
	NORMAL,

	/**
	 * 最高品質。
	 * 品質を優先して処理を行います。処理速度は低下します。
	 * レイヤーのトランスフォームはトリリニア補間で処理されます。
	 */
	BEST

}
