/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;

import ch.kuramo.javie.core.JavieRuntimeException;

public class DragSourceEnhancement {

	public static void patch() {
		String platform = SWT.getPlatform();

		if (platform.equals("cocoa")) {
			cocoa();
		}
	}

	private static void cocoa() {
		try {
			ClassLoader loader = DND.class.getClassLoader();

			ClassPool pool = new ClassPool();
			pool.appendClassPath(new LoaderClassPath(loader));
			CtClass targetClass = pool.get("org.eclipse.swt.dnd.DragSource");

			CtClass imageClass = pool.get("org.eclipse.swt.graphics.Image");
			targetClass.addField(new CtField(imageClass, "emptyImage", targetClass));

			for (CtConstructor cstr : targetClass.getDeclaredConstructors()) {
				if (cstr.callsSuper()) {
					String src
							 = "org.eclipse.swt.graphics.PaletteData palette = new org.eclipse.swt.graphics.PaletteData("
							 + "		new org.eclipse.swt.graphics.RGB[] {"
							 + "				new org.eclipse.swt.graphics.RGB(0, 0, 0),"
							 + "				new org.eclipse.swt.graphics.RGB(255, 255, 255)"
							 + "		});"
							 + "org.eclipse.swt.graphics.ImageData imageData = new org.eclipse.swt.graphics.ImageData(1, 1, 1, palette, 1, new byte[1]);"
							 + "imageData.transparentPixel = 0;"
							 + "emptyImage = new org.eclipse.swt.graphics.Image(getDisplay(), imageData);";

					cstr.insertAfter(src);
				}
			}

			CtMethod onDispose = targetClass.getDeclaredMethod("onDispose");
			onDispose.insertAfter("if (emptyImage != null) { emptyImage.dispose(); emptyImage = null; }");

			CtMethod dragOutlineViewStart = targetClass.getDeclaredMethod("dragOutlineViewStart");
			dragOutlineViewStart.instrument(new ExprEditor() {
				public void edit(MethodCall m) throws CannotCompileException {
					if (m.getClassName().equals("org.eclipse.swt.dnd.DragSource") && m.getMethodName().equals("startDrag")) {
						String src
								 = "$_ = $proceed($$);"
								 + "if ($_ == null) {"
								 + "	dragImageFromListener = emptyImage;"
								 + "	dragOffset = new org.eclipse.swt.graphics.Point(0, 0);"
								 + "}";

						m.replace(src);
					}
				}
			});

			targetClass.toClass(loader, null);

		} catch (NotFoundException e) {
			throw new JavieRuntimeException(e);
		} catch (CannotCompileException e) {
			throw new JavieRuntimeException(e);
		}
	}

}
