/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

import ch.kuramo.javie.app.CommandIds;
import ch.kuramo.javie.app.SaveUtil;
import ch.kuramo.javie.app.project.ProjectEvent;
import ch.kuramo.javie.app.project.ProjectEventHub;
import ch.kuramo.javie.app.project.ProjectListener;
import ch.kuramo.javie.app.project.ProjectManager;

public class SaveAction extends Action implements ProjectListener {

	private final IWorkbenchWindow window;

	public SaveAction(IWorkbenchWindow window) {
		super("保存");
		this.window = window;

		setId(CommandIds.SAVE);
		setActionDefinitionId(CommandIds.SAVE);

		setImageDescriptor(PlatformUI.getWorkbench().getSharedImages()
				.getImageDescriptor(ISharedImages.IMG_ETOOL_SAVE_EDIT));
		setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages()
				.getImageDescriptor(ISharedImages.IMG_ETOOL_SAVE_EDIT_DISABLED));


		ProjectEventHub.getHub().addProjectListener(this);

		final IWorkbench workbench = window.getWorkbench();
		workbench.addWindowListener(new IWindowListener() {
			public void windowClosed(IWorkbenchWindow window) {
				if (window == SaveAction.this.window) {
					ProjectEventHub.getHub().removeProjectListener(SaveAction.this);
					workbench.removeWindowListener(this);
				}
			}
			public void windowOpened(IWorkbenchWindow window) { }
			public void windowDeactivated(IWorkbenchWindow window) { }
			public void windowActivated(IWorkbenchWindow window) { }
		});
	}

	public void run() {
		ProjectManager pm = ProjectManager.forWorkbenchWindow(window);
		if (pm != null) {
			SaveUtil.save(pm);
		}
	}

	public void handleProjectEvent(ProjectEvent event) {
		ProjectManager pm = event.getProjectManager();
		if (pm.getWorkbenchWindow() != window) {
			return;
		}

		switch (event.type) {
			case PROJECT_INITIALIZE:
			case PROJECT_DISPOSE:
			case DIRTY_CHANGE:
				setEnabled(pm.isDirty());
				break;
		}
	}

}
