/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.player;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;

import ch.kuramo.javie.app.ImageUtil;

public class PlayerZoomAction extends Action implements IMenuCreator {

	private static final double[] ZOOMS_IN_PERCENT = new double[] {
		/*1.5, 3.1, 6.25,*/ 12.5, 25, 33.3, 50, 100, 200, 400/*, 800, 1600, 3200*/
	};


	private final MediaPlayer mediaPlayer;

	private Menu menu;


	public PlayerZoomAction(MediaPlayer mediaPlayer) {
		super("拡大率");
		this.mediaPlayer = mediaPlayer;

		setImageDescriptor(ImageUtil.getPlayerZoomIcon());
		setMenuCreator(this);
		setEnabled(mediaPlayer.hasVideo());
	}

	public void dispose() {
		disposeMenu();
	}

	private void disposeMenu() {
		if (menu != null) {
			menu.dispose();
			menu = null;
		}
	}

	public Menu getMenu(Control parent) {
		disposeMenu();

		if (!isEnabled()) {
			return null;
		}

		menu = new Menu(parent);


		addAction(menu, 0);
		new MenuItem(menu, SWT.SEPARATOR);

		for (double percent : ZOOMS_IN_PERCENT) {
			addAction(menu, percent);
		}

		return menu;
	}

	public Menu getMenu(Menu parent) {
		return null;
	}

	private void addAction(Menu parent, double percent) {
		String text = (percent == 0) ? "全体表示" :
				(percent == (int)percent) ? String.valueOf((int)percent) + " %" :
											String.valueOf(percent) + " %";

		final double zoom = percent / 100;

		Action action = new Action(text, IAction.AS_RADIO_BUTTON) {
			public void run() {
				mediaPlayer.setVideoZoom(zoom);
			}
		};

		action.setChecked(zoom == mediaPlayer.getVideoZoom());

		ActionContributionItem item = new ActionContributionItem(action);
		item.fill(parent, -1);
	}

	public void runWithEvent(Event event) {
		if (event.widget instanceof ToolItem) {
			ToolItem toolItem = (ToolItem) event.widget;
			Control control = toolItem.getParent();
			Menu menu = getMenu(control);

			Rectangle bounds = toolItem.getBounds();
			Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
			menu.setLocation(control.toDisplay(topLeft));
			menu.setVisible(true);
		}
	}

}
