/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.project;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;

public class ModifyLayerExpressionOperation extends ProjectOperation {

	private final String _compId;

	private final String _layerId;

	private final String _property;

	private final String _oldExpr;

	private final String _newExpr;


	public ModifyLayerExpressionOperation(
			ProjectManager projectManager, Layer layer, String property, String expression) {

		super(projectManager, "エクスプレッションの変更");

		LayerComposition comp = projectManager.checkLayer(layer);

		AnimatableValue<?> avalue = PropertyUtil.getProperty(layer, property);
		String old = avalue.getExpression();

		if (expression != null) {
			expression = expression.trim();
			if (expression.length() == 0) {
				expression = null;
			}
		}

		_noEffect = (expression != null && expression.equals(old)) || (expression == null && old == null);

		_compId = comp.getId();
		_layerId = layer.getId();
		_property = property;
		_oldExpr = old;
		_newExpr = expression;

		if (_oldExpr == null) {
			setLabel("エクスプレッションの追加");
		} else if (_newExpr == null) {
			setLabel("エクスプレッションの削除");
		}
	}

	String getLayerId() {
		return _layerId;
	}

	String getProperty() {
		return _property;
	}

	@Override
	protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info,
			Project project, ProjectManager pm) throws ExecutionException {

		modifyExpression(_newExpr, project, pm);
		return Status.OK_STATUS;
	}

	@Override
	protected IStatus undo(IProgressMonitor monitor, IAdaptable info,
			Project project, ProjectManager pm) throws ExecutionException {

		modifyExpression(_oldExpr, project, pm);
		return Status.OK_STATUS;
	}

	private void modifyExpression(String expression, Project project, ProjectManager pm) {
		LayerComposition comp = project.getComposition(_compId);
		Layer layer = comp.getLayer(_layerId);

		AnimatableValue<?> avalue = PropertyUtil.getProperty(layer, _property);
		avalue.setExpression(expression);

		if (pm != null) {
			pm.fireLayerExpressionChange(layer, _property);
		}
	}

}
