/*
 * Copyright (c) 2009-2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;

import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.AnimatableString;

public class AnimatableStringElementDelegate extends AnimatableValueElementDelegate<String> {

	private static final String EDITOR_KEY = "AnimatableStringElementDelegate.TextCellEditor";


	public AnimatableStringElementDelegate(
			AnimatableValueElement element, String name, AnimatableString avalue) {

		super(element, name, avalue);
	}

	protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
		drawValue(gc, x, y, height, focused, (valueToDraw.length() > 0) ? valueToDraw : "      ");
	}

	protected boolean canDragGestureEdit() {
		return false;
	}

	protected String dragGesture(double dx, double dy) {
		throw new UnsupportedOperationException("drag gesture edit is not supported");
	}

	protected boolean isInPlaceEditorActive() {
		// FIXME TextCellEditorがアクティブな時は true を返すべき。
		return false;
	}

	public boolean canEdit(int columnIndex) {
		if (columnIndex == LayerCompositionView.VALUE_COL) {
			return canInPlaceEdit;
		}
		return false;
	}

	public CellEditor getCellEditor(int columnIndex) {
		if (columnIndex == LayerCompositionView.VALUE_COL) {
			TextCellEditor editor = (TextCellEditor) element.viewer.getData(EDITOR_KEY);
			if (editor == null) {
				editor = new TextCellEditor(element.viewer.getTree(), SWT.SINGLE | SWT.BORDER);
				Control control = editor.getControl();
				control.setBackground(control.getDisplay().getSystemColor(SWT.COLOR_WHITE));
				element.viewer.setData(EDITOR_KEY, editor);
			}
			return editor;
		}
		return null;
	}

	public Object getCellEditorValue(int columnIndex) {
		if (columnIndex == LayerCompositionView.VALUE_COL) {
			return valueWithoutExpr;
		}
		return null;
	}

	public void setCellEditorValue(int columnIndex, Object value) {
		if (columnIndex == LayerCompositionView.VALUE_COL) {
			modifyValue((String) value);
		}
	}

}
