/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.core.TAWigglySelector;

public class TAWigglySelectorElement extends TASelectorElement<TAWigglySelector> {

	private Element[] children;


	public TAWigglySelectorElement(TextAnimatorElement parent, TAWigglySelector selector) {
		super(parent, selector);
	}

	@Override
	public boolean hasChildren() {
		return true;
	}

	@Override
	public Element[] getChildren() {
		if (children == null) {
			children = new Element[] {
					createPropertyElement("mode", "モード"),
					createPropertyElement("maxAmount", "最大量", "%"),
					createPropertyElement("minAmount", "最小量", "%"),
					createEnumPropertyElement("base", "基準"),
					createPropertyElement("wigglesPerSecond", "ウィグル/秒"),
					createPropertyElement("correlation", "相関性", "%"),
					createAngleElement("temporalPhase", "時間的フェーズ", "°"),
					createAngleElement("spatialPhase", "空間的フェーズ", "°"),
					createPropertyElement("lockDimensions", "次元を固定"),
					createPropertyElement("randomSeed", "ランダムシード")
			};
		}
		return children;
	}

}
