/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.wizards;

import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbenchPage;

import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.project.ModifyLayerCompSettingsOperation;
import ch.kuramo.javie.app.project.NewLayerCompositionOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.app.views.MediaPlayerView;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.LayerComposition;

public class CompositionWizard extends Wizard {

	private static CompositionSettings _defaultSettings = new CompositionSettings();


	private final ProjectManager _projectManager;

	private final Folder _parent;

	private final CompositionItem _compItem;

	private CompositionWizardPage _page;


	public CompositionWizard(ProjectManager projectManager, Folder parent) {
		super();
		_projectManager = projectManager;
		_parent = parent;
		_compItem = null;
		setWindowTitle("新規コンポジション");
	}

	public CompositionWizard(ProjectManager projectManager, CompositionItem compItem) {
		super();
		_projectManager = projectManager;
		_parent = null;
		_compItem = compItem;
		setWindowTitle("コンポジション設定");
	}

	public void addPages() {
		if (_compItem == null) {
			CompositionSettings settings = _defaultSettings.clone();
			settings.name = _projectManager.getUnusedItemName("コンポ");
			settings.frameDurationPreserved = false;

			_page = new CompositionWizardPage(settings, true);

		} else {
			CompositionSettings settings = new CompositionSettings();
			settings.name = _compItem.getName();

			LayerComposition comp = (LayerComposition) _compItem.getComposition();
			settings.size = comp.getSize();
			settings.frameDuration = comp.getFrameDuration();
			settings.duration = comp.getDuration();
			settings.colorMode = comp.getColorMode();
			settings.frameDurationPreserved = comp.isFrameDurationPreserved();
			settings.motionBlurShutterAngle = comp.getMotionBlurShutterAngle();
			settings.motionBlurShutterPhase = comp.getMotionBlurShutterPhase();
			settings.motionBlurSamples = comp.getMotionBlurSamples();

			_page = new CompositionWizardPage(settings, false);
		}

		addPage(_page);
	}

	public boolean performFinish() {
		CompositionSettings settings = _page.getResult();
		if (settings == null) {
			return false;
		}

		IWorkbenchPage page = _projectManager.getWorkbenchWindow().getActivePage();

		if (_compItem == null) {
			NewLayerCompositionOperation op = new NewLayerCompositionOperation(
					_projectManager, _parent, settings.name, settings.colorMode, settings.size,
					settings.frameDuration, settings.duration, settings.frameDurationPreserved,
					settings.motionBlurShutterAngle, settings.motionBlurShutterPhase, settings.motionBlurSamples);

			_projectManager.postOperation(op);

			String compItemId = op.getCompositionItemId();
			UIUtil.showView(page, LayerCompositionView.ID, compItemId, IWorkbenchPage.VIEW_ACTIVATE);
			UIUtil.showView(page, MediaPlayerView.ID, compItemId, IWorkbenchPage.VIEW_VISIBLE);

		} else {
			ModifyLayerCompSettingsOperation op = new ModifyLayerCompSettingsOperation(
					_projectManager, _compItem, settings.name, settings.colorMode, settings.size,
					settings.frameDuration, settings.duration, settings.frameDurationPreserved,
					settings.motionBlurShutterAngle, settings.motionBlurShutterPhase, settings.motionBlurSamples);

			_projectManager.postOperation(op);
		}

		_defaultSettings = settings;
		return true;
	}

}
