/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie2mmd;

import org.eclipse.jface.wizard.Wizard;

import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.core.output.Javie2MMDOutput;

public class Javie2MMDWizard extends Wizard {

	private final Javie2MMDWizardPage page;

	private final Javie2MMDOutput output;


	public Javie2MMDWizard(Size2i compSize, Javie2MMDOutput output) {
		super();
		this.page = new Javie2MMDWizardPage(compSize, output.getFile());
		this.output = output;

		setWindowTitle("書き出し - MMDカメラデータ");
	}

	public void addPages() {
		addPage(page);
	}

	public boolean performFinish() {
		page.saveDefaults();

		output.setFile(page.getFile());
		output.setBatch(false);
		output.setScale(page.getScale());
		output.setOffset(page.getOffset());
		return true;
	}

}
