/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal;

import java.util.List;

import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.annotations.ProjectElement;

@ProjectElement("project")
public class ProjectImpl implements Project {

	private String _id;

	private List<Item> _items;

	private List<Composition> _compositions;


	public ProjectImpl() {
		super();
	}

	public void initialize() {
		_id = Util.randomId();
		_items = Util.newList();
		_compositions = Util.newList();
	}

	public String getId() {
		return _id;
	}

	public void setId(String id) {
		_id = id;
	}

	public List<Item> getItems() {
		return _items;
	}

	public void setItems(List<Item> items) {
		_items = items;
	}

	public List<Composition> getCompositions() {
		return _compositions;
	}

	public void setCompositions(List<Composition> compositions) {
		_compositions = compositions;
	}

	public <T extends Item> T getItem(String id) {
		for (Item i : _items) {
			if (i.getId().equals(id)) {
				@SuppressWarnings("unchecked")
				T t = (T) i;
				return t;
			}
		}
		return null;
	}

	public <T extends Composition> T getComposition(String id) {
		for (Composition c : _compositions) {
			if (c.getId().equals(id)) {
				@SuppressWarnings("unchecked")
				T t = (T) c;
				return t;
			}
		}
		return null;
	}

	public void afterDecode() throws ProjectDecodeException {
		for (Item i : _items) {
			i.afterDecode(this);
		}

		for (Composition c : _compositions) {
			c.afterDecode(this);
		}
	}

}
