/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;

import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectDescriptor;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.PropertyDescriptor;

@SuppressWarnings("serial")
public class UnknownEffect extends HashMap<String, Object> implements Effect {

	private final EffectDescriptor _descriptor = new EffectDescriptor() {
		public boolean isUnknown()										{ return true; }
		public String getType()											{ throw new UnsupportedOperationException(); }
		public Class<Effect> getEffectClass()							{ throw new UnsupportedOperationException(); }
		public Class<?> getExpressionInterface()						{ throw new UnsupportedOperationException(); }
		public String getCategory()										{ throw new UnsupportedOperationException(); }
		public String getLabel()										{ return getName(); }
		public List<PropertyDescriptor> getPropertyDescriptors()		{ return Collections.emptyList(); }
		public PropertyDescriptor getPropertyDescriptor(String name)	{ return null; }
	};

	public EffectDescriptor getEffectDescriptor() {
		return _descriptor;
	}

	public boolean isEnabled() {
		Boolean enabled = (Boolean) get("enabled");
		return (enabled != null) ? enabled : false;
	}

	public void setEnabled(boolean enabled) {
		put("enabled", enabled);
	}

	public String getName() {
		return (String) get("name");
	}

	public void setName(String name) {
		put("name", name);
	}

	public void afterDecode(Project p) throws ProjectDecodeException {
		// nothing to do
	}

	public void prepareExpression(ExpressionScope scope) {
		// TODO nothing to do?
		//scope.putExpressionElement("thisEffect", this);
	}

	public Object createExpressionElement(CoreContext context) {
		// TODO 返すものはObjectでいいのか？
		return new Object();
	}

}
