/*
 * Copyright (c) 2009-2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.services;

import org.mozilla.javascript.ContextFactory;

import ch.kuramo.javie.api.services.IAccumulationSupport;
import ch.kuramo.javie.api.services.IAlphaChannelSupport;
import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IAudioEffectContext;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IConvolutionSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.ITexture1DSupport;
import ch.kuramo.javie.api.services.IVBOCache;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.internal.services.AccumulationSupportImpl;
import ch.kuramo.javie.core.internal.services.AlphaChannelSupportImpl;
import ch.kuramo.javie.core.internal.services.AnimatableValueCollectorImpl;
import ch.kuramo.javie.core.internal.services.AntiAliasSupportProxy;
import ch.kuramo.javie.core.internal.services.ArrayPoolsImpl;
import ch.kuramo.javie.core.internal.services.AudioEffectContextProxy;
import ch.kuramo.javie.core.internal.services.AudioEffectPipelineImpl;
import ch.kuramo.javie.core.internal.services.AudioRenderSupportImpl;
import ch.kuramo.javie.core.internal.services.BlendSupportImpl;
import ch.kuramo.javie.core.internal.services.BlurSupportImpl;
import ch.kuramo.javie.core.internal.services.ConvolutionSupportImpl;
import ch.kuramo.javie.core.internal.services.EffectRegistryImpl;
import ch.kuramo.javie.core.internal.services.FontListImpl;
import ch.kuramo.javie.core.internal.services.FontManagerProxy;
import ch.kuramo.javie.core.internal.services.GLGlobalImpl;
import ch.kuramo.javie.core.internal.services.MediaSourceFactoryImpl;
import ch.kuramo.javie.core.internal.services.ProjectDecoderImpl;
import ch.kuramo.javie.core.internal.services.ProjectElementFactoryImpl;
import ch.kuramo.javie.core.internal.services.ProjectEncoderImpl;
import ch.kuramo.javie.core.internal.services.RenderContextProxy;
import ch.kuramo.javie.core.internal.services.ShaderRegistryImpl;
import ch.kuramo.javie.core.internal.services.SynchronousTaskThreadImpl;
import ch.kuramo.javie.core.internal.services.Texture1DSupportImpl;
import ch.kuramo.javie.core.internal.services.VBOCacheProxy;
import ch.kuramo.javie.core.internal.services.VideoEffectContextProxy;
import ch.kuramo.javie.core.internal.services.VideoEffectPipelineImpl;
import ch.kuramo.javie.core.internal.services.VideoRenderSupportImpl;
import ch.kuramo.javie.core.internal.services.VideoRenderSupportImplOld;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;

public class JavieCoreModule extends AbstractModule {

	@Override
	protected void configure() {

		// singlton

		bind(ProjectElementFactory.class)
				.to(ProjectElementFactoryImpl.class)
				.in(Scopes.SINGLETON);

		bind(ProjectEncoder.class)
				.to(ProjectEncoderImpl.class)
				.in(Scopes.SINGLETON);

		bind(ProjectDecoder.class)
				.to(ProjectDecoderImpl.class)
				.in(Scopes.SINGLETON);

		bind(MediaSourceFactory.class)
				.to(MediaSourceFactoryImpl.class)
				.in(Scopes.SINGLETON);

		bind(GLGlobal.class)
				.to(GLGlobalImpl.class)
				.in(Scopes.SINGLETON);

		bind(EffectRegistry.class)
				.to(EffectRegistryImpl.class)
				.in(Scopes.SINGLETON);

		ShaderRegistryImpl shaderRegistry = new ShaderRegistryImpl();

		bind(ShaderRegistry.class)
				.toInstance(shaderRegistry);

		bind(IShaderRegistry.class)
				.toInstance(shaderRegistry);

		bind(RenderContext.class)
				.to(RenderContextProxy.class)
				.in(Scopes.SINGLETON);

		bind(VideoRenderSupport.class)
				.to(VideoRenderSupportImplOld.class)
				.in(Scopes.SINGLETON);

		bind(IVideoRenderSupport.class)
				.to(VideoRenderSupportImpl.class)
				.in(Scopes.SINGLETON);

		bind(VideoEffectPipeline.class)
				.to(VideoEffectPipelineImpl.class)
				.in(Scopes.SINGLETON);

		VideoEffectContextProxy veContext = new VideoEffectContextProxy();

		bind(IVideoEffectContext.class)
				.toInstance(veContext);

		bind(QCIntegrationSupport.class)
				.toInstance(veContext);

		bind(AudioRenderSupport.class)
				.to(AudioRenderSupportImpl.class)
				.in(Scopes.SINGLETON);

		bind(AudioEffectPipeline.class)
				.to(AudioEffectPipelineImpl.class)
				.in(Scopes.SINGLETON);

		bind(IAudioEffectContext.class)
				.to(AudioEffectContextProxy.class)
				.in(Scopes.SINGLETON);

		bind(IAntiAliasSupport.class)
				.to(AntiAliasSupportProxy.class)
				.in(Scopes.SINGLETON);

		bind(IConvolutionSupport.class)
				.to(ConvolutionSupportImpl.class)
				.in(Scopes.SINGLETON);

		bind(IBlurSupport.class)
				.to(BlurSupportImpl.class)
				.in(Scopes.SINGLETON);

		bind(IAlphaChannelSupport.class)
				.to(AlphaChannelSupportImpl.class)
				.in(Scopes.SINGLETON);

		bind(IAccumulationSupport.class)
				.to(AccumulationSupportImpl.class)
				.in(Scopes.SINGLETON);

		bind(ITexture1DSupport.class)
				.to(Texture1DSupportImpl.class)
				.in(Scopes.SINGLETON);

		bind(FontList.class)
				.to(FontListImpl.class)
				.in(Scopes.SINGLETON);

		bind(FontManager.class)
				.to(FontManagerProxy.class)
				.in(Scopes.SINGLETON);

		bind(IArrayPools.class)
				.to(ArrayPoolsImpl.class)
				.in(Scopes.SINGLETON);

		bind(IVBOCache.class)
				.to(VBOCacheProxy.class)
				.in(Scopes.SINGLETON);

		bind(ContextFactory.class)
				.toInstance(new ContextFactory());


		// non-singleton

		bind(SynchronousTaskThread.class)
				.to(SynchronousTaskThreadImpl.class);

		bind(AnimatableValueCollector.class)
				.to(AnimatableValueCollectorImpl.class);

		bind(IBlendSupport.class)
				.to(BlendSupportImpl.class);
	}

}
