/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.lang.reflect.Field;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

class ControlCharRenderer {
    private Color fLFColor;
    private Color fFWSColor;
    private Color fTABColor;
    private Color fEOFColor;
    private boolean fLFValid;
    private boolean fFWSValid;
    private boolean fTABValid;
    private boolean fEOFValid;
    private StyledText fStyledText;
    private String fLineDelimiter;
    private boolean fValid;
    private static Properties fSetting;
    static /* synthetic */ Class class$0;

    ControlCharRenderer(Device device, StyledText styledText) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if ((fSetting == null || fSetting.size() == 0) && (fSetting = (Properties)((Properties)(object4 = System.getProperties())).get("jeex.swt.ccs")) == null) {
            fSetting = new Properties();
        }
        if ((object3 = (Vector<StyledText>)((Properties)(object4 = System.getProperties())).get("jeex.swt.ccs.list")) == null) {
            object3 = new Vector<StyledText>();
            ((Properties)object4).put("jeex.swt.ccs.list", object3);
        }
        Vector<StyledText> vector = object3;
        synchronized (vector) {
            object2 = object3.toArray();
        }
        int n = 0;
        while (n < ((Object[])object2).length) {
            object = (StyledText)object2[n];
            if (((Control)object).isDisposed()) {
                object3.remove(object);
            }
            ++n;
        }
        if (!object3.contains(styledText)) {
            object3.add(styledText);
        }
        this.fLFColor = object4 = device.getSystemColor(15);
        this.fFWSColor = object4;
        this.fTABColor = object4;
        this.fEOFColor = object4;
        object3 = fSetting.getProperty("jeex.all.color");
        if (object3 != null) {
            this.fLFColor = object2 = device.getSystemColor(this.getColorId((String)object3));
            this.fFWSColor = object2;
            this.fTABColor = object2;
            this.fEOFColor = object2;
        }
        if ((object2 = fSetting.getProperty("jeex.lf.color")) != null) {
            this.fLFColor = device.getSystemColor(this.getColorId((String)object2));
        }
        if ((string7 = fSetting.getProperty("jeex.fws.color")) != null) {
            this.fFWSColor = device.getSystemColor(this.getColorId(string7));
        }
        if ((object = fSetting.getProperty("jeex.tab.color")) != null) {
            this.fTABColor = device.getSystemColor(this.getColorId((String)object));
        }
        if ((string6 = fSetting.getProperty("jeex.eof.color")) != null) {
            this.fEOFColor = device.getSystemColor(this.getColorId(string6));
        }
        if ((string5 = fSetting.getProperty("jeex.all.enable")) != null) {
            boolean bl;
            string4 = fSetting.getProperty("jeex.all.enable");
            this.fLFValid = bl = Boolean.valueOf(string4).booleanValue();
            this.fFWSValid = bl;
            this.fTABValid = bl;
            this.fEOFValid = bl;
        }
        if ((string4 = fSetting.getProperty("jeex.lf.enable")) != null) {
            this.fLFValid = Boolean.valueOf(string4);
        }
        if ((string3 = fSetting.getProperty("jeex.fws.enable")) != null) {
            this.fFWSValid = Boolean.valueOf(string3);
        }
        if ((string2 = fSetting.getProperty("jeex.tab.enable")) != null) {
            this.fTABValid = Boolean.valueOf(string2);
        }
        if ((string = fSetting.getProperty("jeex.eof.enable")) != null) {
            this.fEOFValid = Boolean.valueOf(string);
        }
        this.fValid = true;
    }

    private int getColorId(String string) {
        try {
            if (string == null) {
                return 15;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.SWT");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field field = clazz.getField(string);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.swt.SWT");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return field.getInt(clazz2);
        }
        catch (Exception exception) {
            return 15;
        }
    }

    ControlCharRenderer() {
        this.fValid = false;
    }

    void setLineInfo(StyledText styledText, String string, int n) {
        String string2;
        StyledTextContent styledTextContent = styledText.getContent();
        int n2 = styledTextContent.getOffsetAtLine(n);
        int n3 = styledTextContent.getOffsetAtLine(n + 1);
        String string3 = styledTextContent.getTextRange(n2, n3 - n2);
        this.fLineDelimiter = string2 = string3.substring(string.length());
        this.fStyledText = styledText;
    }

    void drawLineBreak(int n, int n2, GC gC) {
        if (!this.fValid) {
            return;
        }
        if (this.fLineDelimiter == null) {
            if (this.fEOFValid) {
                Color color = gC.getForeground();
                gC.setForeground(this.fEOFColor);
                gC.drawString("[EOF]", n, n2, true);
                gC.setForeground(color);
                color.dispose();
            }
        } else if (this.fLFValid) {
            Color color = gC.getForeground();
            gC.setForeground(this.fLFColor);
            int n3 = this.fStyledText.getLineHeight();
            int n4 = n3 / 5;
            int n5 = n + n3 / 4;
            int n6 = n2 + n4;
            int n7 = n2 + n3 - n4;
            gC.drawLine(n5, n6, n5, n7);
            gC.drawLine(n5 + n4, n7 - n4, n5, n7);
            gC.drawLine(n5 - n4, n7 - n4, n5, n7);
            gC.setForeground(color);
            color.dispose();
        }
    }

    void drawTab(int n, int n2, GC gC) {
        if (!this.fValid) {
            return;
        }
        if (this.fTABValid) {
            Color color = gC.getForeground();
            gC.setForeground(this.fTABColor);
            gC.drawString("^", n, n2, true);
            gC.setForeground(color);
            color.dispose();
        }
    }

    void drawFullWidthSpace(int n, int n2, GC gC) {
        if (!this.fValid) {
            return;
        }
        if (this.fFWSValid) {
            Color color = gC.getForeground();
            Point point = gC.stringExtent(String.valueOf('\u3000'));
            int n3 = point.y / 5;
            int n4 = n + n3 - 1;
            int n5 = n2 + n3 - 1;
            int n6 = n + point.x - n3;
            int n7 = n2 + point.y - n3;
            gC.setForeground(this.fFWSColor);
            gC.drawLine(n4, n5, n6, n5);
            gC.drawLine(n6, n5, n6, n7);
            gC.drawLine(n4, n5, n4, n7);
            gC.drawLine(n4, n7, n6, n7);
            gC.setForeground(color);
            color.dispose();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.fLFColor.dispose();
        this.fFWSColor.dispose();
        this.fTABColor.dispose();
        this.fEOFColor.dispose();
    }

    void dispose() {
        this.fLFColor.dispose();
        this.fFWSColor.dispose();
        this.fTABColor.dispose();
        this.fEOFColor.dispose();
    }
}

