/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.ControlCharRenderer;
import org.eclipse.swt.custom.DefaultContent;
import org.eclipse.swt.custom.DefaultLineStyler;
import org.eclipse.swt.custom.DisplayRenderer;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.PrintRenderer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledTextBidi;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextListener;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.custom.WrappedContent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class StyledText
extends Canvas {
    static final char TAB = '\t';
    static final String PlatformLineDelimiter = System.getProperty("line.separator");
    static final int BIDI_CARET_WIDTH = 4;
    static final int XINSET = 3;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int ExtendedModify = 3000;
    static final int LineGetBackground = 3001;
    static final int LineGetStyle = 3002;
    static final int TextChanging = 3003;
    static final int TextSet = 3004;
    static final int VerifyKey = 3005;
    static final int TextChanged = 3006;
    static final int LineGetSegments = 3007;
    Color selectionBackground;
    Color selectionForeground;
    StyledTextContent logicalContent;
    StyledTextContent content;
    DisplayRenderer renderer;
    TextChangeListener textChangeListener;
    DefaultLineStyler defaultLineStyler;
    LineCache lineCache;
    boolean userLineStyle = false;
    boolean userLineBackground = false;
    int verticalScrollOffset = 0;
    int horizontalScrollOffset = 0;
    int topIndex = 0;
    int topOffset = 0;
    int clientAreaHeight = 0;
    int clientAreaWidth = 0;
    int lineHeight;
    int tabLength = 4;
    int lineEndSpaceWidth;
    int leftMargin = 1;
    int topMargin = 1;
    int rightMargin = 2;
    int bottomMargin = 2;
    Cursor ibeamCursor;
    int columnX;
    int caretOffset = 0;
    Point selection = new Point(0, 0);
    int selectionAnchor;
    Point doubleClickSelection;
    boolean editable = true;
    boolean wordWrap = false;
    boolean doubleClickEnabled = true;
    boolean overwrite = false;
    int textLimit = -1;
    Hashtable keyActionMap = new Hashtable();
    Color background = null;
    Color foreground = null;
    Clipboard clipboard;
    boolean mouseDoubleClick = false;
    int autoScrollDirection = 0;
    int lastTextChangeStart;
    int lastTextChangeNewLineCount;
    int lastTextChangeNewCharCount;
    int lastTextChangeReplaceLineCount;
    int lastTextChangeReplaceCharCount;
    boolean isBidi;
    boolean isMirrored;
    boolean bidiColoring = false;
    Image leftCaretBitmap = null;
    Image rightCaretBitmap = null;
    int caretDirection = 0;
    PaletteData caretPalette = null;
    int lastCaretDirection = 0;
    boolean isCarbon;

    public StyledText(Composite composite, int n) {
        super(composite, StyledText.checkStyle(n | 0x100000 | 0x40000));
        Object object;
        super.setForeground(this.getForeground());
        super.setBackground(this.getBackground());
        Display display = this.getDisplay();
        this.isMirrored = (super.getStyle() & 0x8000000) != 0;
        boolean bl = this.isBidi = StyledTextBidi.isBidiPlatform() || this.isMirrored;
        if ((n & 8) != 0) {
            this.setEditable(false);
        }
        if ((n & 0x800) == 0 || (n & 4) == 0) {
            this.bottomMargin = 0;
            this.rightMargin = 0;
            this.topMargin = 0;
            this.leftMargin = 0;
        }
        this.clipboard = new Clipboard(display);
        this.installDefaultContent();
        this.initializeRenderer();
        if ((n & 0x40) != 0) {
            this.setWordWrap(true);
        } else {
            this.lineCache = new ContentWidthCache(this, this.content.getLineCount());
        }
        if (!this.isBidi()) {
            object = new Caret(this, 0);
            ((Caret)object).setSize(1, ((Caret)object).getSize().y);
        } else {
            this.createCaretBitmaps();
            if (this.isMirrored) {
                BidiUtil.setKeyboardLanguage(1);
            }
            new Caret(this, 0);
            this.setBidiCaretDirection();
            object = new Runnable(){

                public void run() {
                    StyledText.this.setBidiCaretLocation(null);
                }
            };
            StyledTextBidi.addLanguageListener(this, (Runnable)object);
        }
        object = SWT.getPlatform();
        this.isCarbon = "carbon".equals(object);
        this.calculateScrollBars();
        this.createKeyBindings();
        this.ibeamCursor = new Cursor(display, 19);
        this.setCursor(this.ibeamCursor);
        this.installListeners();
        this.installDefaultLineStyler();
    }

    public void addExtendedModifyListener(ExtendedModifyListener extendedModifyListener) {
        this.checkWidget();
        if (extendedModifyListener == null) {
            SWT.error(4);
        }
        StyledTextListener styledTextListener = new StyledTextListener(extendedModifyListener);
        this.addListener(3000, styledTextListener);
    }

    public void setKeyBinding(int n, int n2) {
        this.checkWidget();
        int n3 = n & 0x100FFFF;
        int n4 = n & SWT.MODIFIER_MASK;
        char c = (char)n3;
        if (Character.isLetter(c)) {
            char c2 = Character.toUpperCase(c);
            int n5 = c2 | n4;
            if (n2 == 0) {
                this.keyActionMap.remove(new Integer(n5));
            } else {
                this.keyActionMap.put(new Integer(n5), new Integer(n2));
            }
            c2 = Character.toLowerCase(c);
            n5 = c2 | n4;
            if (n2 == 0) {
                this.keyActionMap.remove(new Integer(n5));
            } else {
                this.keyActionMap.put(new Integer(n5), new Integer(n2));
            }
        } else if (n2 == 0) {
            this.keyActionMap.remove(new Integer(n));
        } else {
            this.keyActionMap.put(new Integer(n), new Integer(n2));
        }
    }

    public void addBidiSegmentListener(BidiSegmentListener bidiSegmentListener) {
        this.checkWidget();
        if (bidiSegmentListener == null) {
            SWT.error(4);
        }
        StyledTextListener styledTextListener = new StyledTextListener(bidiSegmentListener);
        this.addListener(3007, styledTextListener);
    }

    public void addLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
        this.checkWidget();
        if (lineBackgroundListener == null) {
            SWT.error(4);
        }
        if (!this.userLineBackground) {
            this.removeLineBackgroundListener(this.defaultLineStyler);
            this.defaultLineStyler.setLineBackground(0, this.logicalContent.getLineCount(), null);
            this.userLineBackground = true;
        }
        StyledTextListener styledTextListener = new StyledTextListener(lineBackgroundListener);
        this.addListener(3001, styledTextListener);
    }

    public void addLineStyleListener(LineStyleListener lineStyleListener) {
        this.checkWidget();
        if (lineStyleListener == null) {
            SWT.error(4);
        }
        if (!this.userLineStyle) {
            this.removeLineStyleListener(this.defaultLineStyler);
            this.defaultLineStyler.setStyleRange(null);
            this.userLineStyle = true;
        }
        StyledTextListener styledTextListener = new StyledTextListener(lineStyleListener);
        this.addListener(3002, styledTextListener);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
    }

    public void addVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        this.checkWidget();
        if (verifyKeyListener == null) {
            SWT.error(4);
        }
        StyledTextListener styledTextListener = new StyledTextListener(verifyKeyListener);
        this.addListener(3005, styledTextListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int n = Math.max(this.getCharCount(), 0);
        this.replaceTextRange(n, 0, string);
    }

    void calculateContentWidth() {
        if (this.lineHeight != 0) {
            this.lineCache = this.getLineCache(this.content);
            this.lineCache.calculate(this.topIndex, this.getPartialBottomIndex() - this.topIndex + 1);
        }
    }

    void calculateScrollBars() {
        ScrollBar scrollBar = this.getHorizontalBar();
        ScrollBar scrollBar2 = this.getVerticalBar();
        this.setScrollBars();
        if (scrollBar2 != null) {
            scrollBar2.setIncrement(this.getVerticalIncrement());
        }
        if (scrollBar != null) {
            scrollBar.setIncrement(this.getHorizontalIncrement());
        }
    }

    void calculateTopIndex() {
        int n = this.topIndex;
        int n2 = this.getVerticalIncrement();
        int n3 = this.getClientArea().height;
        if (n2 == 0) {
            return;
        }
        this.topIndex = Compatibility.ceil(this.verticalScrollOffset, n2);
        if (this.topIndex > 0) {
            if (n3 > 0) {
                int n4 = this.verticalScrollOffset + n3;
                int n5 = this.topIndex * n2;
                int n6 = n4 - n5;
                if (n6 < n2) {
                    --this.topIndex;
                }
            } else if (this.topIndex >= this.content.getLineCount()) {
                this.topIndex = this.content.getLineCount() - 1;
            }
        }
        if (this.topIndex != n) {
            this.topOffset = this.content.getOffsetAtLine(this.topIndex);
            this.lineCache.calculate(this.topIndex, this.getPartialBottomIndex() - this.topIndex + 1);
            this.setHorizontalScrollBar();
        }
    }

    static int checkStyle(int n) {
        n = (n & 4) != 0 ? (n &= 0xFFFFFCFF) : (n |= 2);
        return n;
    }

    void claimBottomFreeSpace() {
        int n = Math.max(0, this.content.getLineCount() * this.lineHeight - this.getClientArea().height);
        if (n < this.verticalScrollOffset) {
            this.setVerticalScrollOffset(n, true);
        }
    }

    void claimRightFreeSpace() {
        int n = Math.max(0, this.lineCache.getWidth() - (this.getClientArea().width - this.leftMargin - this.rightMargin));
        if (n < this.horizontalScrollOffset) {
            this.scrollHorizontalBar(n - this.horizontalScrollOffset);
        }
    }

    void clearMargin(GC gC, Color color, Rectangle rectangle, int n) {
        if (n + this.topMargin <= 0) {
            return;
        }
        gC.setBackground(color);
        gC.fillRectangle(0, 0, rectangle.width, this.topMargin);
        gC.fillRectangle(0, 0, this.leftMargin, n + this.topMargin);
        gC.fillRectangle(0, rectangle.height - this.bottomMargin, rectangle.width, this.bottomMargin);
        gC.fillRectangle(rectangle.width - this.rightMargin, 0, this.rightMargin, n + this.topMargin);
    }

    void clearSelection(boolean bl) {
        int n = this.selection.x;
        int n2 = this.selection.y;
        int n3 = this.content.getCharCount();
        this.resetSelection();
        if (n2 - n > 0) {
            int n4 = Math.min(n, n3);
            int n5 = Math.min(n2, n3);
            if (n5 - n4 > 0) {
                this.internalRedrawRange(n4, n5 - n4, true);
            }
            if (bl) {
                this.sendSelectionEvent();
            }
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        boolean bl2 = (this.getStyle() & 4) != 0;
        int n3 = bl2 ? 1 : this.content.getLineCount();
        int n4 = n != -1 ? n : 64;
        if (this.wordWrap) {
            if (((WrappedContent)this.content).getVisualLineCount() != 0) {
                if (n == -1) {
                    n4 = this.lineCache.getWidth();
                } else {
                    ((WrappedContent)this.content).wrapLines(n4);
                    this.setCaretLocation();
                }
                if (!bl2) {
                    n3 = this.content.getLineCount();
                }
            } else if (!bl2) {
                ((WrappedContent)this.content).wrapLines(n4);
                this.setCaretLocation();
                n3 = this.content.getLineCount();
            }
        } else if (n == -1) {
            int n5 = Math.min(n3, this.getDisplay().getBounds().height / this.lineHeight);
            this.lineCache.calculate(0, n5);
            n4 = this.lineCache.getWidth() + this.leftMargin + this.rightMargin;
        }
        int n6 = n2 != -1 ? n2 : n3 * this.lineHeight + this.topMargin + this.bottomMargin;
        if (n4 == 0) {
            n4 = 64;
        }
        if (n6 == 0) {
            n6 = bl2 ? this.lineHeight : 64;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n4, n6);
        return new Point(rectangle.width, rectangle.height);
    }

    public void copy() {
        block3: {
            this.checkWidget();
            int n = this.selection.y - this.selection.x;
            if (n > 0) {
                try {
                    this.setClipboardContent(this.selection.x, n);
                }
                catch (SWTError sWTError) {
                    if (sWTError.code == 2002) break block3;
                    throw sWTError;
                }
            }
        }
    }

    String getModelDelimitedText(String string) {
        String string2 = this.getLineDelimiter();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        while (n4 < n) {
            if (n2 != -1) {
                n2 = string.indexOf(13, n4);
            }
            if (n3 != -1) {
                n3 = string.indexOf(10, n4);
            }
            if (n3 == -1 && n2 == -1) break;
            if (n2 < n3 && n2 != -1 || n3 == -1) {
                stringBuffer.append(string.substring(n4, n2));
                n4 = n3 == n2 + 1 ? n3 + 1 : n2 + 1;
            } else {
                stringBuffer.append(string.substring(n4, n3));
                n4 = n3 + 1;
            }
            if (this.isSingleLine()) break;
            stringBuffer.append(string2);
        }
        if (!(n4 >= n || this.isSingleLine() && stringBuffer.length() != 0)) {
            stringBuffer.append(string.substring(n4));
        }
        return stringBuffer.toString();
    }

    void createKeyBindings() {
        this.setKeyBinding(0x1000001, 0x1000001);
        this.setKeyBinding(0x1000002, 0x1000002);
        this.setKeyBinding(0x1000007, 0x1000007);
        this.setKeyBinding(0x1000008, 0x1000008);
        this.setKeyBinding(0x1000005, 0x1000005);
        this.setKeyBinding(0x1000006, 0x1000006);
        this.setKeyBinding(0x1000007 | SWT.MOD1, 17039367);
        this.setKeyBinding(0x1000008 | SWT.MOD1, 17039368);
        this.setKeyBinding(0x1000005 | SWT.MOD1, 17039365);
        this.setKeyBinding(0x1000006 | SWT.MOD1, 17039366);
        if (this.isMirrored()) {
            this.setKeyBinding(0x1000003, 0x1000004);
            this.setKeyBinding(0x1000004, 0x1000003);
            this.setKeyBinding(0x1000003 | SWT.MOD1, 0x1040004);
            this.setKeyBinding(0x1000004 | SWT.MOD1, 17039363);
        } else {
            this.setKeyBinding(0x1000003, 0x1000003);
            this.setKeyBinding(0x1000004, 0x1000004);
            this.setKeyBinding(0x1000003 | SWT.MOD1, 17039363);
            this.setKeyBinding(0x1000004 | SWT.MOD1, 0x1040004);
        }
        this.setKeyBinding(0x1000001 | SWT.MOD2, 0x1020001);
        this.setKeyBinding(0x1000002 | SWT.MOD2, 0x1020002);
        this.setKeyBinding(0x1000007 | SWT.MOD2, 16908295);
        this.setKeyBinding(0x1000008 | SWT.MOD2, 16908296);
        this.setKeyBinding(0x1000005 | SWT.MOD2, 16908293);
        this.setKeyBinding(0x1000006 | SWT.MOD2, 16908294);
        this.setKeyBinding(0x1000007 | SWT.MOD1 | SWT.MOD2, 17170439);
        this.setKeyBinding(0x1000008 | SWT.MOD1 | SWT.MOD2, 17170440);
        this.setKeyBinding(0x1000005 | SWT.MOD1 | SWT.MOD2, 17170437);
        this.setKeyBinding(0x1000006 | SWT.MOD1 | SWT.MOD2, 0x1060006);
        if (this.isMirrored()) {
            this.setKeyBinding(0x1000003 | SWT.MOD2, 16908292);
            this.setKeyBinding(0x1000004 | SWT.MOD2, 16908291);
            this.setKeyBinding(0x1000003 | SWT.MOD1 | SWT.MOD2, 17170436);
            this.setKeyBinding(0x1000004 | SWT.MOD1 | SWT.MOD2, 17170435);
        } else {
            this.setKeyBinding(0x1000003 | SWT.MOD2, 16908291);
            this.setKeyBinding(0x1000004 | SWT.MOD2, 16908292);
            this.setKeyBinding(0x1000003 | SWT.MOD1 | SWT.MOD2, 17170435);
            this.setKeyBinding(0x1000004 | SWT.MOD1 | SWT.MOD2, 17170436);
        }
        this.setKeyBinding(0x58 | SWT.MOD1, 131199);
        this.setKeyBinding(0x43 | SWT.MOD1, 17039369);
        this.setKeyBinding(0x56 | SWT.MOD1, 16908297);
        this.setKeyBinding(0x7F | SWT.MOD2, 131199);
        this.setKeyBinding(0x1000009 | SWT.MOD1, 17039369);
        this.setKeyBinding(0x1000009 | SWT.MOD2, 16908297);
        this.setKeyBinding(8 | SWT.MOD2, 8);
        this.setKeyBinding(8, 8);
        this.setKeyBinding(127, 127);
        this.setKeyBinding(8 | SWT.MOD1, 262152);
        this.setKeyBinding(0x7F | SWT.MOD1, 262271);
        this.setKeyBinding(0x1000009, 0x1000009);
    }

    void createCaretBitmaps() {
        int n = 4;
        int n2 = this.isMirrored() ? 0x4000000 : 0x2000000;
        Display display = this.getDisplay();
        if (this.caretPalette == null) {
            this.caretPalette = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
        }
        if (this.leftCaretBitmap != null) {
            this.leftCaretBitmap.dispose();
        }
        ImageData imageData = new ImageData(n, this.lineHeight, 1, this.caretPalette);
        this.leftCaretBitmap = new Image((Device)display, imageData);
        GC gC = new GC(this.leftCaretBitmap, n2);
        gC.setForeground(display.getSystemColor(1));
        gC.drawLine(0, 0, 0, this.lineHeight);
        gC.drawLine(0, 0, n - 1, 0);
        gC.drawLine(0, 1, 1, 1);
        gC.dispose();
        if (this.rightCaretBitmap != null) {
            this.rightCaretBitmap.dispose();
        }
        this.rightCaretBitmap = new Image((Device)display, imageData);
        gC = new GC(this.rightCaretBitmap, n2);
        gC.setForeground(display.getSystemColor(1));
        gC.drawLine(n - 1, 0, n - 1, this.lineHeight);
        gC.drawLine(0, 0, n - 1, 0);
        gC.drawLine(n - 1, 1, 1, 1);
        gC.dispose();
    }

    public void cut() {
        this.checkWidget();
        int n = this.selection.y - this.selection.x;
        if (n > 0) {
            try {
                this.setClipboardContent(this.selection.x, n);
            }
            catch (SWTError sWTError) {
                if (sWTError.code != 2002) {
                    throw sWTError;
                }
                return;
            }
            this.doDelete();
        }
    }

    void doAutoScroll(Event event) {
        Rectangle rectangle = this.getClientArea();
        if (event.y > rectangle.height) {
            this.doAutoScroll(1024);
        } else if (event.y < 0) {
            this.doAutoScroll(128);
        } else if (event.x < this.leftMargin && !this.wordWrap) {
            this.doAutoScroll(0x1000003);
        } else if (event.x > rectangle.width - this.leftMargin - this.rightMargin && !this.wordWrap) {
            this.doAutoScroll(0x1000004);
        } else {
            this.endAutoScroll();
        }
    }

    void doAutoScroll(int n) {
        Runnable runnable = null;
        if (this.autoScrollDirection == n) {
            return;
        }
        final Display display = this.getDisplay();
        if (n == 128) {
            runnable = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 128) {
                        StyledText.this.doSelectionLineUp();
                        display.timerExec(5, this);
                    }
                }
            };
        } else if (n == 1024) {
            runnable = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 1024) {
                        StyledText.this.doSelectionLineDown();
                        display.timerExec(5, this);
                    }
                }
            };
        } else if (n == 0x1000004) {
            runnable = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 0x1000004) {
                        StyledText.this.doVisualNext();
                        StyledText.this.setMouseWordSelectionAnchor();
                        StyledText.this.doMouseSelection();
                        display.timerExec(5, this);
                    }
                }
            };
        } else if (n == 0x1000003) {
            runnable = new Runnable(){

                public void run() {
                    if (StyledText.this.autoScrollDirection == 0x1000003) {
                        StyledText.this.doVisualPrevious();
                        StyledText.this.setMouseWordSelectionAnchor();
                        StyledText.this.doMouseSelection();
                        display.timerExec(5, this);
                    }
                }
            };
        }
        if (runnable != null) {
            this.autoScrollDirection = n;
            display.timerExec(5, runnable);
        }
    }

    void doBackspace() {
        Event event = new Event();
        event.text = "";
        if (this.selection.x != this.selection.y) {
            event.start = this.selection.x;
            event.end = this.selection.y;
            this.sendKeyEvent(event);
        } else if (this.caretOffset > 0) {
            int n = this.content.getLineAtOffset(this.caretOffset);
            int n2 = this.content.getOffsetAtLine(n);
            if (this.caretOffset == n2) {
                n2 = this.content.getOffsetAtLine(n - 1);
                event.start = n2 + this.content.getLine(n - 1).length();
                event.end = this.caretOffset;
            } else {
                event.start = this.caretOffset - 1;
                event.end = this.caretOffset;
            }
            this.sendKeyEvent(event);
        }
    }

    void doContent(char c) {
        if (this.textLimit > 0 && this.content.getCharCount() - (this.selection.y - this.selection.x) >= this.textLimit) {
            return;
        }
        Event event = new Event();
        event.start = this.selection.x;
        event.end = this.selection.y;
        if (c == '\r' || c == '\n') {
            if (!this.isSingleLine()) {
                event.text = this.getLineDelimiter();
            }
        } else if (this.selection.x == this.selection.y && this.overwrite && c != '\t') {
            String string;
            int n = this.content.getLineAtOffset(event.end);
            int n2 = this.content.getOffsetAtLine(n);
            if (event.end < n2 + (string = this.content.getLine(n)).length()) {
                ++event.end;
            }
            event.text = new String(new char[]{c});
        } else {
            event.text = new String(new char[]{c});
        }
        if (event.text != null) {
            this.sendKeyEvent(event);
        }
    }

    void doContentEnd() {
        if (this.isSingleLine()) {
            this.doLineEnd();
        } else {
            int n = this.content.getCharCount();
            if (this.caretOffset < n) {
                this.caretOffset = n;
                this.showCaret();
            }
        }
    }

    void doContentStart() {
        if (this.caretOffset > 0) {
            this.caretOffset = 0;
            this.showCaret();
        }
    }

    void doCursorPrevious() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.x;
            int n = this.getCaretLine();
            this.showCaret(n);
        } else {
            this.doSelectionCursorPrevious();
        }
    }

    void doCursorNext() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.y;
            int n = this.getCaretLine();
            this.showCaret(n);
        } else {
            this.doSelectionCursorNext();
        }
    }

    void doDelete() {
        Event event = new Event();
        event.text = "";
        if (this.selection.x != this.selection.y) {
            event.start = this.selection.x;
            event.end = this.selection.y;
            this.sendKeyEvent(event);
        } else if (this.caretOffset < this.content.getCharCount()) {
            int n;
            int n2 = this.content.getLineAtOffset(this.caretOffset);
            int n3 = this.content.getOffsetAtLine(n2);
            if (this.caretOffset == n3 + (n = this.content.getLine(n2).length())) {
                event.start = this.caretOffset;
                event.end = this.content.getOffsetAtLine(n2 + 1);
            } else {
                event.start = this.caretOffset;
                event.end = this.caretOffset + 1;
            }
            this.sendKeyEvent(event);
        }
    }

    void doDeleteWordNext() {
        if (this.selection.x != this.selection.y) {
            this.doDelete();
        } else {
            Event event = new Event();
            event.text = "";
            event.start = this.caretOffset;
            event.end = this.getWordEnd(this.caretOffset);
            this.sendKeyEvent(event);
        }
    }

    void doDeleteWordPrevious() {
        if (this.selection.x != this.selection.y) {
            this.doBackspace();
        } else {
            Event event = new Event();
            event.text = "";
            event.start = this.getWordStart(this.caretOffset);
            event.end = this.caretOffset;
            this.sendKeyEvent(event);
        }
    }

    int doLineDown() {
        if (this.isSingleLine()) {
            return 0;
        }
        int n = this.getCaretLine();
        if (n < this.content.getLineCount() - 1) {
            ++n;
            if (this.isBidi()) {
                int[] nArray = this.getBidiOffsetAtMouseLocation(this.columnX, n);
                this.caretOffset = nArray[0];
                this.lastCaretDirection = nArray[1];
            } else {
                this.caretOffset = this.getOffsetAtMouseLocation(this.columnX, n);
            }
        }
        return n;
    }

    void doLineEnd() {
        int n;
        int n2 = this.getCaretLine();
        int n3 = this.content.getOffsetAtLine(n2);
        int n4 = n3 + (n = this.content.getLine(n2).length());
        if (this.caretOffset < n4) {
            this.caretOffset = n4;
            this.showCaret();
        }
    }

    void doLineStart() {
        int n = this.getCaretLine();
        int n2 = this.content.getOffsetAtLine(n);
        if (this.caretOffset > n2) {
            this.caretOffset = n2;
            this.showCaret(n);
        }
    }

    int doLineUp() {
        int n = this.getCaretLine();
        if (n > 0) {
            --n;
            if (this.isBidi()) {
                int[] nArray = this.getBidiOffsetAtMouseLocation(this.columnX, n);
                this.caretOffset = nArray[0];
                this.lastCaretDirection = nArray[1];
            } else {
                this.caretOffset = this.getOffsetAtMouseLocation(this.columnX, n);
            }
        }
        return n;
    }

    void doMouseLocationChange(int n, int n2, boolean bl) {
        int n3;
        int n4 = (n2 + this.verticalScrollOffset) / this.lineHeight;
        int n5 = this.content.getLineCount();
        int n6 = this.lastCaretDirection;
        if (n4 > n5 - 1) {
            n4 = n5 - 1;
        }
        if (n4 < 0 || this.isSingleLine() && n4 > 0) {
            return;
        }
        if (this.isBidi()) {
            int[] nArray = this.getBidiOffsetAtMouseLocation(n, n4);
            n3 = nArray[0];
            n6 = nArray[1];
        } else {
            n3 = this.getOffsetAtMouseLocation(n, n4);
        }
        if (this.mouseDoubleClick) {
            n3 = this.doMouseWordSelect(n, n3, n4);
        }
        int n7 = this.content.getLineAtOffset(n3);
        if (n2 >= 0 && n2 < this.getClientArea().height && (n >= 0 && n < this.getClientArea().width || n7 != this.content.getLineAtOffset(this.caretOffset)) && n3 != this.caretOffset) {
            this.lastCaretDirection = n6;
            this.caretOffset = n3;
            if (bl) {
                this.doMouseSelection();
            }
            this.showCaret();
        }
        if (!bl) {
            this.lastCaretDirection = n6;
            this.clearSelection(true);
        }
    }

    void doMouseSelection() {
        if (this.caretOffset <= this.selection.x || this.caretOffset > this.selection.x && this.caretOffset < this.selection.y && this.selectionAnchor == this.selection.x) {
            this.doSelection(0x1000003);
        } else {
            this.doSelection(0x1000004);
        }
    }

    int doMouseWordSelect(int n, int n2, int n3) {
        int n4;
        if (n2 < this.selectionAnchor && this.selectionAnchor == this.selection.x) {
            this.selectionAnchor = this.doubleClickSelection.y;
        } else if (n2 > this.selectionAnchor && this.selectionAnchor == this.selection.y) {
            this.selectionAnchor = this.doubleClickSelection.x;
        }
        if (n >= 0 && n < this.getClientArea().width && this.content.getLineAtOffset(n4 = this.caretOffset == this.selection.x ? this.getWordStart(n2) : this.getWordEndNoSpaces(n2)) == n3) {
            n2 = n4;
        }
        return n2;
    }

    void doPageDown(boolean bl) {
        int n = this.content.getLineCount();
        int n2 = this.columnX;
        if (this.isSingleLine()) {
            return;
        }
        int n3 = this.getCaretLine();
        if (n3 < n - 1) {
            int n4;
            int n5 = n * this.getVerticalIncrement();
            int n6 = this.getClientArea().height;
            int n7 = Math.min(n - n3 - 1, this.getLineCountWhole());
            n7 = Math.max(1, n7);
            n3 += n7;
            if (this.isBidi()) {
                int[] nArray = this.getBidiOffsetAtMouseLocation(this.columnX, n3);
                this.caretOffset = nArray[0];
                this.lastCaretDirection = nArray[1];
            } else {
                this.caretOffset = this.getOffsetAtMouseLocation(this.columnX, n3);
            }
            if (bl) {
                this.doSelection(0x1000004);
            }
            if ((n4 = this.verticalScrollOffset + n7 * this.getVerticalIncrement()) + n6 > n5) {
                n4 = n5 - n6;
            }
            if (n4 > this.verticalScrollOffset) {
                this.setVerticalScrollOffset(n4, true);
            }
        }
        this.showCaret(n3);
        this.columnX = n2;
    }

    void doPageEnd() {
        if (this.isSingleLine()) {
            this.doLineEnd();
        } else {
            int n = this.getBottomIndex();
            int n2 = this.content.getOffsetAtLine(n) + this.content.getLine(n).length();
            if (this.caretOffset < n2) {
                this.caretOffset = n2;
                this.showCaret();
            }
        }
    }

    void doPageStart() {
        int n = this.content.getOffsetAtLine(this.topIndex);
        if (this.caretOffset > n) {
            this.caretOffset = n;
            this.showCaret(this.topIndex);
        }
    }

    void doPageUp() {
        int n = this.columnX;
        int n2 = this.getCaretLine();
        if (n2 > 0) {
            int n3 = Math.max(1, Math.min(n2, this.getLineCountWhole()));
            n2 -= n3;
            if (this.isBidi()) {
                int[] nArray = this.getBidiOffsetAtMouseLocation(this.columnX, n2);
                this.caretOffset = nArray[0];
                this.lastCaretDirection = nArray[1];
            } else {
                this.caretOffset = this.getOffsetAtMouseLocation(this.columnX, n2);
            }
            int n4 = Math.max(0, this.verticalScrollOffset - n3 * this.getVerticalIncrement());
            if (n4 < this.verticalScrollOffset) {
                this.setVerticalScrollOffset(n4, true);
            }
        }
        this.showCaret(n2);
        this.columnX = n;
    }

    void doSelection(int n) {
        int n2 = -1;
        int n3 = -1;
        if (this.selectionAnchor == -1) {
            this.selectionAnchor = this.selection.x;
        }
        if (n == 0x1000003) {
            if (this.caretOffset < this.selection.x) {
                n3 = this.selection.x;
                n2 = this.selection.x = this.caretOffset;
                if (this.selection.y != this.selectionAnchor) {
                    n3 = this.selection.y;
                    this.selection.y = this.selectionAnchor;
                }
            } else if (this.selectionAnchor == this.selection.x && this.caretOffset < this.selection.y) {
                n3 = this.selection.y;
                n2 = this.selection.y = this.caretOffset;
            }
        } else if (this.caretOffset > this.selection.y) {
            n2 = this.selection.y;
            n3 = this.selection.y = this.caretOffset;
            if (this.selection.x != this.selectionAnchor) {
                n2 = this.selection.x;
                this.selection.x = this.selectionAnchor;
            }
        } else if (this.selectionAnchor == this.selection.y && this.caretOffset > this.selection.x) {
            n2 = this.selection.x;
            n3 = this.selection.x = this.caretOffset;
        }
        if (n2 != -1 && n3 != -1) {
            this.internalRedrawRange(n2, n3 - n2, true);
            this.sendSelectionEvent();
        }
    }

    void doSelectionCursorNext() {
        int n = this.getCaretLine();
        int n2 = this.content.getOffsetAtLine(n);
        int n3 = this.caretOffset - n2;
        if (n3 < this.content.getLine(n).length()) {
            this.lastCaretDirection = 0x1000004;
            ++this.caretOffset;
            this.showCaret();
        } else if (n < this.content.getLineCount() - 1 && !this.isSingleLine()) {
            this.caretOffset = this.content.getOffsetAtLine(++n);
            this.showCaret(n);
        }
    }

    void doSelectionCursorPrevious() {
        int n = this.getCaretLine();
        int n2 = this.content.getOffsetAtLine(n);
        int n3 = this.caretOffset - n2;
        if (n3 > 0) {
            this.lastCaretDirection = 0x1000003;
            --this.caretOffset;
            this.showCaret(n);
        } else if (n > 0) {
            n2 = this.content.getOffsetAtLine(--n);
            this.caretOffset = n2 + this.content.getLine(n).length();
            this.showCaret();
        }
    }

    void doSelectionLineDown() {
        if (this.isSingleLine()) {
            return;
        }
        int n = this.getCaretLine();
        int n2 = this.content.getOffsetAtLine(n);
        int n3 = this.columnX = this.getXAtOffset(this.content.getLine(n), n, this.caretOffset - n2);
        if (n == this.content.getLineCount() - 1) {
            this.caretOffset = this.content.getCharCount();
        } else {
            n = this.doLineDown();
        }
        this.setMouseWordSelectionAnchor();
        this.doSelection(0x1000004);
        this.showCaret(n);
        this.columnX = n3;
    }

    void doSelectionLineUp() {
        int n = this.getCaretLine();
        int n2 = this.content.getOffsetAtLine(n);
        int n3 = this.columnX = this.getXAtOffset(this.content.getLine(n), n, this.caretOffset - n2);
        if (n == 0) {
            this.caretOffset = 0;
        } else {
            n = this.doLineUp();
        }
        this.setMouseWordSelectionAnchor();
        this.showCaret(n);
        this.doSelection(0x1000003);
        this.columnX = n3;
    }

    void doSelectionPageDown() {
        int n = this.getCaretLine();
        int n2 = this.content.getOffsetAtLine(n);
        int n3 = this.columnX = this.getXAtOffset(this.content.getLine(n), n, this.caretOffset - n2);
        this.doPageDown(true);
        this.columnX = n3;
    }

    void doSelectionPageUp() {
        int n = this.getCaretLine();
        int n2 = this.content.getOffsetAtLine(n);
        int n3 = this.columnX = this.getXAtOffset(this.content.getLine(n), n, this.caretOffset - n2);
        this.doPageUp();
        this.columnX = n3;
    }

    void doSelectionWordNext() {
        int n = this.getWordEnd(this.caretOffset);
        if (!this.isSingleLine() || this.content.getLineAtOffset(this.caretOffset) == this.content.getLineAtOffset(n)) {
            this.lastCaretDirection = 0x1000004;
            this.caretOffset = n;
            this.showCaret();
        }
    }

    void doSelectionWordPrevious() {
        this.lastCaretDirection = 0x1000003;
        this.caretOffset = this.getWordStart(this.caretOffset);
        int n = this.content.getLineAtOffset(this.caretOffset);
        if (this.wordWrap && n < this.content.getLineCount() - 1 && this.caretOffset == this.content.getOffsetAtLine(n + 1)) {
            ++n;
        }
        this.showCaret(n);
    }

    void doVisualPrevious() {
        int n = this.content.getLineAtOffset(this.caretOffset);
        int n2 = this.content.getOffsetAtLine(n);
        int n3 = this.caretOffset - n2;
        if (this.isBidi()) {
            if (this.columnX <= 3 && this.horizontalScrollOffset == 0) {
                return;
            }
            String string = this.content.getLine(n);
            int n4 = string.length();
            GC gC = this.getGC();
            StyledTextBidi styledTextBidi = this.getStyledTextBidi(string, n2, gC);
            int n5 = -1;
            if (n3 == n4) {
                n5 = styledTextBidi.getVisualOffset(n3 - 1);
            } else if (n3 < n4) {
                n5 = styledTextBidi.getVisualOffset(n3);
            }
            if (n5 != -1) {
                if (n5 > 0) {
                    n3 = styledTextBidi.getLogicalOffset(--n5);
                } else if (n5 == 0) {
                    boolean bl = this.isMirrored();
                    if (bl && !styledTextBidi.isRightToLeft(n3) || !bl && styledTextBidi.isRightToLeft(n3)) {
                        ++n3;
                    }
                    if (n3 > 0 && n3 < n4) {
                        if (bl) {
                            boolean bl2;
                            boolean bl3 = bl2 = styledTextBidi.isRightToLeft(n3) && !styledTextBidi.isRightToLeft(n3 - 1);
                            if (bl2) {
                                this.lastCaretDirection = 0x1000004;
                            }
                        } else {
                            boolean bl4;
                            boolean bl5 = bl4 = !styledTextBidi.isRightToLeft(n3) && styledTextBidi.isRightToLeft(n3 - 1);
                            if (styledTextBidi.isLatinNumber(n3) && styledTextBidi.isRightToLeftInput(n3 - 1)) {
                                this.lastCaretDirection = 0x1000003;
                            } else if (bl4) {
                                this.lastCaretDirection = 0x1000004;
                            }
                        }
                    }
                }
                this.caretOffset = n2 + n3;
                this.showCaret();
            }
            if (styledTextBidi.getTextPosition(n3, 0x1000004) == 3) {
                this.scrollHorizontalBar(-this.horizontalScrollOffset);
            }
            gC.dispose();
        } else if (n3 > 0) {
            --this.caretOffset;
            this.showCaret();
        }
    }

    void doVisualNext() {
        int n = this.content.getLineAtOffset(this.caretOffset);
        int n2 = this.content.getOffsetAtLine(n);
        int n3 = this.caretOffset - n2;
        String string = this.content.getLine(n);
        int n4 = string.length();
        if (this.isBidi()) {
            GC gC = this.getGC();
            StyledTextBidi styledTextBidi = this.getStyledTextBidi(string, n2, gC);
            int n5 = Math.max(styledTextBidi.getTextWidth(), 3);
            if (styledTextBidi.getTextPosition(n3, this.lastCaretDirection) == n5) {
                gC.dispose();
                return;
            }
            int n6 = -1;
            if (n3 == n4) {
                n6 = styledTextBidi.getVisualOffset(n3 - 1);
            } else if (n3 < n4) {
                n6 = styledTextBidi.getVisualOffset(n3);
            }
            if (n6 != -1) {
                if ((n3 = styledTextBidi.getLogicalOffset(++n6)) > 0 && n3 < n4) {
                    boolean bl = this.isMirrored();
                    if (bl) {
                        boolean bl2;
                        boolean bl3 = bl2 = !styledTextBidi.isRightToLeft(n3) && styledTextBidi.isRightToLeft(n3 - 1);
                        if (bl2) {
                            this.lastCaretDirection = 0x1000003;
                        }
                    } else {
                        boolean bl4;
                        boolean bl5 = bl4 = styledTextBidi.isRightToLeft(n3) && !styledTextBidi.isRightToLeft(n3 - 1);
                        if (styledTextBidi.isRightToLeftInput(n3) && styledTextBidi.isLatinNumber(n3 - 1)) {
                            this.lastCaretDirection = 0x1000004;
                        } else if (bl4) {
                            this.lastCaretDirection = 0x1000003;
                        }
                    }
                }
                this.caretOffset = n2 + n3;
                this.showCaret();
            }
            gC.dispose();
        } else if (n3 < n4) {
            ++this.caretOffset;
            this.showCaret();
        }
    }

    void doWordNext() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.y;
            int n = this.getCaretLine();
            this.showCaret(n);
        } else {
            this.doSelectionWordNext();
        }
    }

    void doWordPrevious() {
        if (this.selection.y - this.selection.x > 0) {
            this.caretOffset = this.selection.x;
            int n = this.getCaretLine();
            this.showCaret(n);
        } else {
            this.doSelectionWordPrevious();
        }
    }

    void draw(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            this.redraw(n + this.leftMargin, n2 + this.topMargin, n3, n4, true);
        } else {
            int n5 = (n2 + this.verticalScrollOffset) / this.lineHeight;
            int n6 = n2 + n4;
            int n7 = (n5 - this.topIndex) * this.lineHeight;
            int n8 = this.topIndex * this.lineHeight - this.verticalScrollOffset;
            int n9 = n7 + n8 + this.topMargin;
            int n10 = this.content.getLineCount();
            Color color = this.getBackground();
            Color color2 = this.getForeground();
            GC gC = this.getGC();
            if (this.isSingleLine()) {
                n10 = 1;
                if (n5 > 1) {
                    n5 = 1;
                }
            }
            int n11 = n5;
            while (n9 < n6 && n11 < n10) {
                String string = this.content.getLine(n11);
                ControlCharRenderer controlCharRenderer = new ControlCharRenderer(this.getDisplay(), this);
                if (n11 < n10 - 1) {
                    controlCharRenderer.setLineInfo(this, string, n11);
                }
                this.renderer.drawLine(string, n11, n9, gC, color, color2, bl, controlCharRenderer);
                controlCharRenderer.dispose();
                ++n11;
                n9 += this.lineHeight;
            }
            gC.dispose();
        }
    }

    void endAutoScroll() {
        this.autoScrollDirection = 0;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.background == null) {
            return this.getDisplay().getSystemColor(25);
        }
        return this.background;
    }

    public boolean getBidiColoring() {
        this.checkWidget();
        return this.bidiColoring;
    }

    int[] getBidiOffsetAtMouseLocation(int n, int n2) {
        String string = this.content.getLine(n2);
        int n3 = this.content.getOffsetAtLine(n2);
        GC gC = this.getGC();
        StyledTextBidi styledTextBidi = this.getStyledTextBidi(string, n3, gC);
        int[] nArray = styledTextBidi.getCaretOffsetAndDirectionAtX(n + this.horizontalScrollOffset - this.leftMargin);
        gC.dispose();
        return new int[]{n3 + nArray[0], nArray[1]};
    }

    int getBidiTextPosition(String string, int n, StyledTextBidi styledTextBidi) {
        if (n > string.length()) {
            return 0;
        }
        return styledTextBidi.getTextPosition(n, this.lastCaretDirection);
    }

    int getBottomIndex() {
        int n = 1;
        if (this.lineHeight != 0) {
            int n2 = this.topIndex * this.lineHeight - this.verticalScrollOffset;
            n = (this.getClientArea().height - n2) / this.lineHeight;
        }
        return Math.min(this.content.getLineCount() - 1, this.topIndex + Math.max(0, n - 1));
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.caretOffset;
    }

    int getCaretOffsetAtX(String string, int n, int n2) {
        int n3 = 0;
        GC gC = this.getGC();
        StyleRange[] styleRangeArray = null;
        StyledTextEvent styledTextEvent = this.renderer.getLineStyleData(n, string);
        n2 += this.horizontalScrollOffset;
        if (styledTextEvent != null) {
            styleRangeArray = this.renderer.filterLineStyles(styledTextEvent.styles);
        }
        int n4 = -1;
        int n5 = string.length();
        while (n5 - n4 > 1) {
            int n6;
            n3 = (n5 + n4) / 2;
            int n7 = this.renderer.getTextPosition(string, n, n3, styleRangeArray, gC) + this.leftMargin;
            if (n2 <= n7 + (n6 = this.renderer.getTextPosition(string, n, n3 + 1, styleRangeArray, gC) + this.leftMargin - n7) / 2) {
                n5 = n3;
                continue;
            }
            n4 = n3;
        }
        n3 = n5;
        gC.dispose();
        return n3;
    }

    int getCaretWidth() {
        Caret caret = this.getCaret();
        if (caret == null) {
            return 0;
        }
        return caret.getSize().x;
    }

    public StyledTextContent getContent() {
        this.checkWidget();
        return this.logicalContent;
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClickEnabled;
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.editable;
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            return this.getDisplay().getSystemColor(24);
        }
        return this.foreground;
    }

    GC getGC() {
        this.renderer.setCurrentFontStyle(0);
        return new GC(this);
    }

    int getHorizontalIncrement() {
        GC gC = this.getGC();
        int n = gC.getFontMetrics().getAverageCharWidth();
        gC.dispose();
        return n;
    }

    public int getHorizontalIndex() {
        this.checkWidget();
        return this.horizontalScrollOffset / this.getHorizontalIncrement();
    }

    public int getHorizontalPixel() {
        this.checkWidget();
        return this.horizontalScrollOffset;
    }

    public int getKeyBinding(int n) {
        this.checkWidget();
        Integer n2 = (Integer)this.keyActionMap.get(new Integer(n));
        int n3 = n2 == null ? 0 : n2;
        return n3;
    }

    public int getCharCount() {
        this.checkWidget();
        return this.content.getCharCount();
    }

    public Color getLineBackground(int n) {
        this.checkWidget();
        Color color = null;
        if (n < 0 || n > this.logicalContent.getLineCount()) {
            SWT.error(5);
        }
        if (!this.userLineBackground) {
            color = this.defaultLineStyler.getLineBackground(n);
        }
        return color;
    }

    StyledTextEvent getLineBackgroundData(int n, String string) {
        return this.sendLineEvent(3001, n, string);
    }

    public int getLineCount() {
        this.checkWidget();
        return this.getLineAtOffset(this.getCharCount()) + 1;
    }

    int getLineCountWhole() {
        int n = this.lineHeight != 0 ? this.getClientArea().height / this.lineHeight : 1;
        return n;
    }

    public int getLineAtOffset(int n) {
        this.checkWidget();
        if (n < 0 || n > this.getCharCount()) {
            SWT.error(6);
        }
        return this.logicalContent.getLineAtOffset(n);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return this.content.getLineDelimiter();
    }

    StyledTextEvent sendLineEvent(int n, int n2, String string) {
        StyledTextEvent styledTextEvent = null;
        if (this.isListening(n)) {
            styledTextEvent = new StyledTextEvent(this.logicalContent);
            if (this.wordWrap) {
                int n3 = this.logicalContent.getLineAtOffset(n2);
                styledTextEvent.detail = this.logicalContent.getOffsetAtLine(n3);
                styledTextEvent.text = this.logicalContent.getLine(n3);
            } else {
                styledTextEvent.detail = n2;
                styledTextEvent.text = string;
            }
            this.notifyListeners(n, styledTextEvent);
        }
        return styledTextEvent;
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.lineHeight;
    }

    LineCache getLineCache(StyledTextContent styledTextContent) {
        LineCache lineCache = this.wordWrap ? new WordWrapCache(this, (WrappedContent)styledTextContent) : new ContentWidthCache(this, styledTextContent.getLineCount());
        return lineCache;
    }

    StyledTextEvent getLineStyleData(int n, String string) {
        return this.sendLineEvent(3002, n, string);
    }

    public Point getLocationAtOffset(int n) {
        this.checkWidget();
        if (n < 0 || n > this.getCharCount()) {
            SWT.error(6);
        }
        int n2 = this.content.getLineAtOffset(n);
        int n3 = this.content.getOffsetAtLine(n2);
        String string = this.content.getLine(n2);
        int n4 = this.getXAtOffset(string, n2, n - n3);
        int n5 = n2 * this.lineHeight - this.verticalScrollOffset;
        return new Point(n4, n5);
    }

    public int getOffsetAtLine(int n) {
        this.checkWidget();
        if (n < 0 || n > 0 && n >= this.logicalContent.getLineCount()) {
            SWT.error(6);
        }
        return this.logicalContent.getOffsetAtLine(n);
    }

    public int getOffsetAtLocation(Point point) {
        int n;
        String string;
        int n2;
        int n3;
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        if (point.y + this.verticalScrollOffset < 0 || point.x + this.horizontalScrollOffset < 0) {
            SWT.error(5);
        }
        if ((n3 = (this.getTopPixel() + point.y) / this.lineHeight) >= this.content.getLineCount()) {
            SWT.error(5);
        }
        if ((n2 = this.getOffsetAtX(string = this.content.getLine(n3), n = this.content.getOffsetAtLine(n3), point.x)) == -1) {
            SWT.error(5);
        }
        return n + n2;
    }

    int getOffsetAtMouseLocation(int n, int n2) {
        String string = this.content.getLine(n2);
        int n3 = this.content.getOffsetAtLine(n2);
        int n4 = this.getCaretOffsetAtX(string, n3, n);
        return n3 + n4;
    }

    int getOffsetAtX(String string, int n, int n2) {
        int n3;
        GC gC = this.getGC();
        n2 += this.horizontalScrollOffset - this.leftMargin;
        if (this.isBidi()) {
            StyledTextBidi styledTextBidi = this.getStyledTextBidi(string, n, gC);
            n3 = styledTextBidi.getOffsetAtX(n2);
        } else {
            StyleRange[] styleRangeArray = null;
            StyledTextEvent styledTextEvent = this.renderer.getLineStyleData(n, string);
            if (styledTextEvent != null) {
                styleRangeArray = this.renderer.filterLineStyles(styledTextEvent.styles);
            }
            int n4 = -1;
            int n5 = string.length();
            while (n5 - n4 > 1) {
                n3 = (n5 + n4) / 2;
                if (n2 < this.renderer.getTextPosition(string, n, n3 + 1, styleRangeArray, gC)) {
                    n5 = n3;
                    continue;
                }
                if (n5 == string.length() && n5 - n3 == 1) {
                    n5 = -1;
                    continue;
                }
                n4 = n3;
            }
            n3 = n5;
        }
        gC.dispose();
        return n3;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.isMirrored() ? 0x4000000 : 0x2000000;
    }

    int getPartialBottomIndex() {
        int n = Compatibility.ceil(this.getClientArea().height, this.lineHeight);
        return Math.min(this.content.getLineCount(), this.topIndex + n) - 1;
    }

    String getPlatformDelimitedText(TextWriter textWriter) {
        int n = textWriter.getStart() + textWriter.getCharCount();
        int n2 = this.logicalContent.getLineAtOffset(textWriter.getStart());
        int n3 = this.logicalContent.getLineAtOffset(n);
        String string = this.logicalContent.getLine(n3);
        int n4 = this.logicalContent.getOffsetAtLine(n3);
        int n5 = n2;
        while (n5 <= n3) {
            textWriter.writeLine(this.logicalContent.getLine(n5), this.logicalContent.getOffsetAtLine(n5));
            if (n5 < n3) {
                textWriter.writeLineDelimiter(PlatformLineDelimiter);
            }
            ++n5;
        }
        if (n > n4 + string.length()) {
            textWriter.writeLineDelimiter(PlatformLineDelimiter);
        }
        textWriter.close();
        return textWriter.toString();
    }

    public Point getSelection() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y);
    }

    public Point getSelectionRange() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y - this.selection.x);
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        if (this.selectionBackground == null) {
            return this.getDisplay().getSystemColor(26);
        }
        return this.selectionBackground;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.getSelectionRange().y;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        if (this.selectionForeground == null) {
            return this.getDisplay().getSystemColor(27);
        }
        return this.selectionForeground;
    }

    public String getSelectionText() {
        this.checkWidget();
        return this.content.getTextRange(this.selection.x, this.selection.y - this.selection.x);
    }

    public int getStyle() {
        int n = super.getStyle();
        n &= 0xF1FFFFFF;
        n = this.isMirrored() ? (n |= 0xC000000) : (n |= 0x2000000);
        return n;
    }

    int[] getBidiSegments(int n, String string) {
        int[] nArray;
        if (!this.isListening(3007)) {
            return this.getBidiSegmentsCompatibility(string, n);
        }
        StyledTextEvent styledTextEvent = this.sendLineEvent(3007, n, string);
        int n2 = string.length();
        if (styledTextEvent == null || styledTextEvent.segments == null || styledTextEvent.segments.length == 0) {
            int[] nArray2 = new int[2];
            nArray2[1] = n2;
            nArray = nArray2;
        } else {
            int n3 = styledTextEvent.segments.length;
            if (styledTextEvent.segments[0] != 0) {
                SWT.error(5);
            }
            int n4 = 1;
            while (n4 < n3) {
                if (styledTextEvent.segments[n4] <= styledTextEvent.segments[n4 - 1] || styledTextEvent.segments[n4] > n2) {
                    SWT.error(5);
                }
                ++n4;
            }
            if (styledTextEvent.segments[n3 - 1] != n2) {
                nArray = new int[n3 + 1];
                System.arraycopy(styledTextEvent.segments, 0, nArray, 0, n3);
                nArray[n3] = n2;
            } else {
                nArray = styledTextEvent.segments;
            }
        }
        return nArray;
    }

    int[] getBidiSegmentsCompatibility(String string, int n) {
        StyleRange[] styleRangeArray = new StyleRange[]{};
        int n2 = string.length();
        if (!this.bidiColoring) {
            int[] nArray = new int[2];
            nArray[1] = n2;
            return nArray;
        }
        StyledTextEvent styledTextEvent = this.renderer.getLineStyleData(n, string);
        if (styledTextEvent != null) {
            styleRangeArray = styledTextEvent.styles;
        }
        if (styleRangeArray.length == 0) {
            int[] nArray = new int[2];
            nArray[1] = n2;
            return nArray;
        }
        int n3 = 0;
        int n4 = 1;
        while (n3 < styleRangeArray.length && styleRangeArray[n3].start == 0 && styleRangeArray[n3].length == n2) {
            ++n3;
        }
        int[] nArray = new int[(styleRangeArray.length - n3) * 2 + 2];
        int n5 = n3;
        while (n5 < styleRangeArray.length) {
            StyleRange styleRange = styleRangeArray[n5];
            int n6 = Math.max(styleRange.start - n, 0);
            int n7 = Math.max(styleRange.start + styleRange.length - n, n6);
            n7 = Math.min(n7, string.length());
            if (n5 > 0 && n4 > 1 && (n6 >= nArray[n4 - 2] && n6 <= nArray[n4 - 1] || n7 >= nArray[n4 - 2] && n7 <= nArray[n4 - 1]) && styleRange.similarTo(styleRangeArray[n5 - 1])) {
                nArray[n4 - 2] = Math.min(nArray[n4 - 2], n6);
                nArray[n4 - 1] = Math.max(nArray[n4 - 1], n7);
            } else {
                if (n6 > nArray[n4 - 1]) {
                    nArray[n4] = n6;
                    ++n4;
                }
                nArray[n4] = n7;
                ++n4;
            }
            ++n5;
        }
        if (n2 > nArray[n4 - 1]) {
            nArray[n4] = n2;
            ++n4;
        }
        if (n4 == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        return nArray2;
    }

    public StyleRange getStyleRangeAtOffset(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.getCharCount()) {
            SWT.error(5);
        }
        if (!this.userLineStyle) {
            return this.defaultLineStyler.getStyleRangeAtOffset(n);
        }
        return null;
    }

    public StyleRange[] getStyleRanges() {
        this.checkWidget();
        StyleRange[] styleRangeArray = !this.userLineStyle ? this.defaultLineStyler.getStyleRanges() : new StyleRange[]{};
        return styleRangeArray;
    }

    StyledTextBidi getStyledTextBidi(String string, int n, GC gC) {
        return this.getStyledTextBidi(string, n, gC, null);
    }

    StyledTextBidi getStyledTextBidi(String string, int n, GC gC, StyleRange[] styleRangeArray) {
        return this.renderer.getStyledTextBidi(string, n, gC, styleRangeArray);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabLength;
    }

    public String getText() {
        this.checkWidget();
        return this.content.getTextRange(0, this.getCharCount());
    }

    public String getText(int n, int n2) {
        this.checkWidget();
        int n3 = this.getCharCount();
        if (n < 0 || n >= n3 || n2 < 0 || n2 >= n3 || n > n2) {
            SWT.error(6);
        }
        return this.content.getTextRange(n, n2 - n + 1);
    }

    public String getTextRange(int n, int n2) {
        this.checkWidget();
        int n3 = this.getCharCount();
        int n4 = n + n2;
        if (n > n4 || n < 0 || n4 > n3) {
            SWT.error(6);
        }
        return this.content.getTextRange(n, n2);
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    int getTextPosition(String string, int n, int n2, GC gC) {
        int n3;
        int n4 = this.content.getOffsetAtLine(n);
        int n5 = string.length();
        if (n5 == 0 || n2 > n5) {
            return 0;
        }
        if (this.isBidi()) {
            StyledTextBidi styledTextBidi = this.getStyledTextBidi(string, n4, gC, null);
            n3 = this.getBidiTextPosition(string, n2, styledTextBidi);
        } else {
            StyledTextEvent styledTextEvent = this.renderer.getLineStyleData(n4, string);
            StyleRange[] styleRangeArray = null;
            if (styledTextEvent != null) {
                styleRangeArray = this.renderer.filterLineStyles(styledTextEvent.styles);
            }
            n3 = this.renderer.getTextPosition(string, n4, n2, styleRangeArray, gC);
        }
        return n3;
    }

    public int getTopIndex() {
        this.checkWidget();
        int n = this.topIndex;
        if (this.wordWrap) {
            int n2 = this.content.getOffsetAtLine(this.topIndex);
            n = this.logicalContent.getLineAtOffset(n2);
        }
        return n;
    }

    public int getTopPixel() {
        this.checkWidget();
        return this.verticalScrollOffset;
    }

    int getVerticalIncrement() {
        return this.lineHeight;
    }

    int getCaretLine() {
        int n = this.content.getLineAtOffset(this.caretOffset);
        int n2 = 0;
        if (this.isBidi()) {
            n2 = 3;
        }
        if (this.wordWrap && this.columnX <= n2 && n < this.content.getLineCount() - 1 && this.caretOffset == this.content.getOffsetAtLine(n + 1)) {
            ++n;
        }
        return n;
    }

    int getWordEnd(int n) {
        int n2 = this.logicalContent.getLineAtOffset(n);
        int n3 = this.logicalContent.getOffsetAtLine(n2);
        String string = this.logicalContent.getLine(n2);
        int n4 = string.length();
        if (n >= this.getCharCount()) {
            return n;
        }
        if (n == n3 + n4) {
            n = this.logicalContent.getOffsetAtLine(++n2);
        } else {
            char c = string.charAt(n -= n3);
            boolean bl = Compatibility.isLetterOrDigit(c);
            while (n < n4 - 1 && Compatibility.isLetterOrDigit(c) == bl) {
                c = string.charAt(++n);
            }
            while (n < n4 - 1 && Compatibility.isSpaceChar(c)) {
                c = string.charAt(++n);
            }
            if (n == n4 - 1 && (Compatibility.isLetterOrDigit(c) == bl || Compatibility.isSpaceChar(c))) {
                ++n;
            }
            n += n3;
        }
        return n;
    }

    int getWordEndNoSpaces(int n) {
        int n2 = this.logicalContent.getLineAtOffset(n);
        int n3 = this.logicalContent.getOffsetAtLine(n2);
        String string = this.logicalContent.getLine(n2);
        int n4 = string.length();
        if (n >= this.getCharCount()) {
            return n;
        }
        if (n == n3 + n4) {
            n = this.logicalContent.getOffsetAtLine(++n2);
        } else {
            char c = string.charAt(n -= n3);
            boolean bl = Compatibility.isLetterOrDigit(c);
            while (n < n4 - 1 && Compatibility.isLetterOrDigit(c) == bl && !Compatibility.isSpaceChar(c)) {
                c = string.charAt(++n);
            }
            if (n == n4 - 1 && Compatibility.isLetterOrDigit(c) == bl && !Compatibility.isSpaceChar(c)) {
                ++n;
            }
            n += n3;
        }
        return n;
    }

    int getWordStart(int n) {
        int n2 = this.logicalContent.getLineAtOffset(n);
        int n3 = this.logicalContent.getOffsetAtLine(n2);
        String string = this.logicalContent.getLine(n2);
        if (n <= 0) {
            return n;
        }
        if (n == n3) {
            string = this.logicalContent.getLine(--n2);
            n = this.logicalContent.getOffsetAtLine(n2) + string.length();
        } else {
            char c;
            n -= n3;
            do {
                c = string.charAt(--n);
            } while (n > 0 && Compatibility.isSpaceChar(c));
            boolean bl = Compatibility.isLetterOrDigit(c);
            while (n > 0 && Compatibility.isLetterOrDigit(c) == bl && !Compatibility.isSpaceChar(c)) {
                c = string.charAt(--n);
            }
            if (n > 0 || Compatibility.isLetterOrDigit(c) != bl) {
                ++n;
            }
            n += n3;
        }
        return n;
    }

    public boolean getWordWrap() {
        this.checkWidget();
        return this.wordWrap;
    }

    int getXAtOffset(String string, int n, int n2) {
        int n3;
        if (n2 == 0 && !this.isBidi()) {
            n3 = this.leftMargin;
        } else {
            GC gC = this.getGC();
            n3 = this.getTextPosition(string, n, Math.min(string.length(), n2), gC) + this.leftMargin;
            gC.dispose();
            if (n2 > string.length()) {
                n3 += this.lineEndSpaceWidth;
            }
        }
        return n3 - this.horizontalScrollOffset;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        Point point = this.getSelectionRange();
        this.replaceTextRange(point.x, point.y, string);
    }

    void installDefaultContent() {
        this.textChangeListener = new TextChangeListener(){

            public void textChanging(TextChangingEvent textChangingEvent) {
                StyledText.this.handleTextChanging(textChangingEvent);
            }

            public void textChanged(TextChangedEvent textChangedEvent) {
                StyledText.this.handleTextChanged(textChangedEvent);
            }

            public void textSet(TextChangedEvent textChangedEvent) {
                StyledText.this.handleTextSet(textChangedEvent);
            }
        };
        this.logicalContent = this.content = new DefaultContent();
        this.content.addTextChangeListener(this.textChangeListener);
    }

    void installDefaultLineStyler() {
        this.defaultLineStyler = new DefaultLineStyler(this.logicalContent);
        StyledTextListener styledTextListener = new StyledTextListener(this.defaultLineStyler);
        if (!this.userLineStyle) {
            this.addListener(3002, styledTextListener);
        }
        if (!this.userLineBackground) {
            this.addListener(3001, styledTextListener);
        }
    }

    void installListeners() {
        ScrollBar scrollBar = this.getVerticalBar();
        ScrollBar scrollBar2 = this.getHorizontalBar();
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handleDispose();
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handleKeyDown(event);
            }
        });
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handleMouseDown(event);
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handleMouseUp(event);
            }
        });
        this.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handleMouseDoubleClick(event);
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handleMouseMove(event);
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handlePaint(event);
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handleResize(event);
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                StyledText.this.handleTraverse(event);
            }
        });
        if (scrollBar != null) {
            scrollBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StyledText.this.handleVerticalScroll(event);
                }
            });
        }
        if (scrollBar2 != null) {
            scrollBar2.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StyledText.this.handleHorizontalScroll(event);
                }
            });
        }
    }

    StyledTextContent internalGetContent() {
        return this.content;
    }

    int internalGetHorizontalPixel() {
        return this.horizontalScrollOffset;
    }

    LineCache internalGetLineCache() {
        return this.lineCache;
    }

    Point internalGetSelection() {
        return this.selection;
    }

    boolean internalGetWordWrap() {
        return this.wordWrap;
    }

    void internalRedraw() {
        super.redraw();
    }

    void internalRedrawRange(int n, int n2, boolean bl) {
        int n3;
        int n4 = n + n2;
        int n5 = this.content.getLineAtOffset(n);
        int n6 = this.content.getLineAtOffset(n4);
        int n7 = this.getPartialBottomIndex();
        int n8 = this.verticalScrollOffset / this.lineHeight;
        if (n5 > n7 || n6 < n8) {
            return;
        }
        if (n8 > n5) {
            n5 = n8;
            n3 = 0;
        } else {
            n3 = n - this.content.getOffsetAtLine(n5);
        }
        if (n7 + 1 < n6) {
            n6 = n7 + 1;
            n4 = this.content.getOffsetAtLine(n6);
        }
        if (this.isBidi()) {
            this.redrawBidiLines(n5, n3, n6, n4, bl);
        } else {
            this.redrawLines(n5, n3, n6, n4, bl);
        }
        if (n6 - n5 > 1) {
            Rectangle rectangle = this.getClientArea();
            int n9 = n6 * this.lineHeight - this.verticalScrollOffset;
            int n10 = (n5 + 1) * this.lineHeight - this.verticalScrollOffset;
            this.draw(0, n10, rectangle.width, n9 - n10, bl);
        }
    }

    String getRtf() {
        this.checkWidget();
        RTFWriter rTFWriter = new RTFWriter(0, this.getCharCount());
        return this.getPlatformDelimitedText(rTFWriter);
    }

    void handleDispose() {
        this.clipboard.dispose();
        this.ibeamCursor.dispose();
        if (this.renderer != null) {
            this.renderer.dispose();
            this.renderer = null;
        }
        if (this.content != null) {
            this.content.removeTextChangeListener(this.textChangeListener);
        }
        if (this.leftCaretBitmap != null) {
            this.leftCaretBitmap.dispose();
            this.leftCaretBitmap = null;
        }
        if (this.rightCaretBitmap != null) {
            this.rightCaretBitmap.dispose();
            this.rightCaretBitmap = null;
        }
        if (this.isBidi()) {
            StyledTextBidi.removeLanguageListener(this);
        }
    }

    void handleHorizontalScroll(Event event) {
        int n = this.getHorizontalBar().getSelection() - this.horizontalScrollOffset;
        this.scrollHorizontal(n);
    }

    void handleKey(Event event) {
        int n;
        int n2;
        if (event.keyCode != 0) {
            n2 = this.getKeyBinding(event.keyCode | event.stateMask);
        } else {
            n2 = this.getKeyBinding(event.character | event.stateMask);
            if (n2 == 0 && (event.stateMask & 0x40000) != 0 && event.character >= '\u0000' && event.character <= '\u001f') {
                n = event.character + 64;
                n2 = this.getKeyBinding(n | event.stateMask);
            }
        }
        if (n2 == 0) {
            n = 0;
            if (this.isCarbon) {
                n = (event.stateMask ^ 0x400000) == 0 || (event.stateMask ^ 0x420000) == 0 ? 1 : 0;
            } else {
                int n3 = n = (event.stateMask ^ 0x10000) == 0 || (event.stateMask ^ 0x40000) == 0 || (event.stateMask ^ 0x30000) == 0 || (event.stateMask ^ 0x60000) == 0 ? 1 : 0;
            }
            if (n == 0 && event.character > '\u001f' && event.character != '\u007f' || event.character == '\r' || event.character == '\n' || event.character == '\t') {
                this.doContent(event.character);
            }
        } else {
            this.invokeAction(n2);
        }
    }

    void handleKeyDown(Event event) {
        Event event2 = new Event();
        event2.character = event.character;
        event2.keyCode = event.keyCode;
        event2.stateMask = event.stateMask;
        event2.doit = true;
        this.notifyListeners(3005, event2);
        if (event2.doit) {
            this.handleKey(event);
        }
    }

    void handleMouseDoubleClick(Event event) {
        if (event.button != 1 || !this.doubleClickEnabled) {
            return;
        }
        event.y -= this.topMargin;
        this.mouseDoubleClick = true;
        this.caretOffset = this.getWordStart(this.caretOffset);
        this.resetSelection();
        this.caretOffset = this.getWordEndNoSpaces(this.caretOffset);
        this.showCaret();
        this.doMouseSelection();
        this.doubleClickSelection = new Point(this.selection.x, this.selection.y);
    }

    void handleMouseDown(Event event) {
        if (event.button != 1 || this.isCarbon && (event.stateMask & SWT.MOD4) != 0) {
            return;
        }
        boolean bl = (event.stateMask & SWT.MOD2) != 0;
        this.mouseDoubleClick = false;
        event.y -= this.topMargin;
        this.doMouseLocationChange(event.x, event.y, bl);
    }

    void handleMouseMove(Event event) {
        if ((event.stateMask & 0x80000) == 0) {
            return;
        }
        event.y -= this.topMargin;
        this.doMouseLocationChange(event.x, event.y, true);
        this.doAutoScroll(event);
    }

    void handleMouseUp(Event event) {
        event.y -= this.topMargin;
        this.endAutoScroll();
    }

    void handlePaint(Event event) {
        int n = Math.max(0, (event.y - this.topMargin + this.verticalScrollOffset) / this.lineHeight);
        int n2 = (n - this.topIndex) * this.lineHeight;
        int n3 = this.topIndex * this.lineHeight - this.verticalScrollOffset;
        int n4 = n2 + n3 + this.topMargin;
        int n5 = event.y + event.height - n4;
        Rectangle rectangle = this.getClientArea();
        if (rectangle.width == 0 || event.height == 0) {
            return;
        }
        this.performPaint(event.gc, n, n4, n5);
    }

    void handleResize(Event event) {
        int n = this.clientAreaHeight;
        int n2 = this.clientAreaWidth;
        this.clientAreaHeight = this.getClientArea().height;
        this.clientAreaWidth = this.getClientArea().width;
        if (this.wordWrap) {
            if (n2 != this.clientAreaWidth) {
                this.wordWrapResize(n2);
            }
        } else if (this.clientAreaHeight > n) {
            int n3 = this.content.getLineCount();
            int n4 = this.topIndex + n / this.lineHeight;
            int n5 = Compatibility.ceil(this.clientAreaHeight - n, this.lineHeight);
            n4 = Math.min(n4, n3);
            n5 = Math.min(n5, n3 - n4);
            this.lineCache.calculate(n4, n5);
        }
        this.setScrollBars();
        this.claimBottomFreeSpace();
        this.claimRightFreeSpace();
        if (n != this.clientAreaHeight) {
            this.calculateTopIndex();
        }
    }

    void handleTextChanged(TextChangedEvent textChangedEvent) {
        this.lineCache.textChanged(this.lastTextChangeStart, this.lastTextChangeNewLineCount, this.lastTextChangeReplaceLineCount, this.lastTextChangeNewCharCount, this.lastTextChangeReplaceCharCount);
        this.setScrollBars();
        this.updateSelection(this.lastTextChangeStart, this.lastTextChangeReplaceCharCount, this.lastTextChangeNewCharCount);
        if (this.lastTextChangeReplaceLineCount > 0) {
            this.claimBottomFreeSpace();
        }
        if (this.lastTextChangeReplaceCharCount > 0) {
            this.claimRightFreeSpace();
        }
        if (this.lastTextChangeNewLineCount == 0 && this.lastTextChangeReplaceLineCount == 0) {
            int n = this.content.getLineAtOffset(this.lastTextChangeStart);
            int n2 = n * this.lineHeight - this.verticalScrollOffset + this.topMargin;
            GC gC = this.getGC();
            Caret caret = this.getCaret();
            boolean bl = false;
            if (caret != null) {
                bl = caret.getVisible();
                caret.setVisible(false);
            }
            this.performPaint(gC, n, n2, this.lineHeight);
            if (caret != null) {
                caret.setVisible(bl);
            }
            gC.dispose();
        }
    }

    void handleTextChanging(TextChangingEvent textChangingEvent) {
        int n;
        boolean bl;
        boolean bl2 = bl = textChangingEvent.replaceLineCount > 0 || textChangingEvent.newLineCount > 0;
        if (textChangingEvent.replaceCharCount < 0) {
            textChangingEvent.start += textChangingEvent.replaceCharCount;
            textChangingEvent.replaceCharCount *= -1;
        }
        this.lastTextChangeStart = textChangingEvent.start;
        this.lastTextChangeNewLineCount = textChangingEvent.newLineCount;
        this.lastTextChangeNewCharCount = textChangingEvent.newCharCount;
        this.lastTextChangeReplaceLineCount = textChangingEvent.replaceLineCount;
        this.lastTextChangeReplaceCharCount = textChangingEvent.replaceCharCount;
        int n2 = this.content.getLineAtOffset(textChangingEvent.start);
        int n3 = n2 * this.lineHeight - this.verticalScrollOffset + this.topMargin;
        if (bl) {
            this.redrawMultiLineChange(n3, textChangingEvent.newLineCount, textChangingEvent.replaceLineCount);
        }
        if (this.defaultLineStyler != null) {
            this.defaultLineStyler.textChanging(textChangingEvent);
        }
        if (this.caretOffset > (n = this.content.getCharCount() - textChangingEvent.replaceCharCount + textChangingEvent.newCharCount)) {
            this.caretOffset = n;
        }
    }

    void handleTextSet(TextChangedEvent textChangedEvent) {
        this.reset();
    }

    void handleTraverse(Event event) {
        boolean bl;
        int n = this.getStyle();
        boolean bl2 = bl = (n & 2) != 0 && !this.editable || this.isSingleLine();
        if ((event.detail == 16 || event.detail == 4) && bl) {
            event.doit = true;
        }
    }

    void handleVerticalScroll(Event event) {
        this.setVerticalScrollOffset(this.getVerticalBar().getSelection(), false);
    }

    void initializeRenderer() {
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        this.renderer = new DisplayRenderer(this.getDisplay(), this.getFont(), this.isBidi(), this.leftMargin, this, this.tabLength);
        this.lineHeight = this.renderer.getLineHeight();
        this.lineEndSpaceWidth = this.renderer.getLineEndSpaceWidth();
    }

    public void invokeAction(int n) {
        this.checkWidget();
        switch (n) {
            case 0x1000001: {
                int n2 = this.doLineUp();
                int n3 = this.columnX;
                this.showCaret(n2);
                this.columnX = n3;
                this.clearSelection(true);
                break;
            }
            case 0x1000002: {
                int n4 = this.doLineDown();
                int n5 = this.columnX;
                this.showCaret(n4);
                this.columnX = n5;
                this.clearSelection(true);
                break;
            }
            case 0x1000007: {
                this.doLineStart();
                this.clearSelection(true);
                break;
            }
            case 0x1000008: {
                this.doLineEnd();
                this.clearSelection(true);
                break;
            }
            case 0x1000003: {
                this.doCursorPrevious();
                this.clearSelection(true);
                break;
            }
            case 0x1000004: {
                this.doCursorNext();
                this.clearSelection(true);
                break;
            }
            case 0x1000005: {
                this.doPageUp();
                this.clearSelection(true);
                break;
            }
            case 0x1000006: {
                this.doPageDown(false);
                this.clearSelection(true);
                break;
            }
            case 17039363: {
                this.doWordPrevious();
                this.clearSelection(true);
                break;
            }
            case 0x1040004: {
                this.doWordNext();
                this.clearSelection(true);
                break;
            }
            case 17039367: {
                this.doContentStart();
                this.clearSelection(true);
                break;
            }
            case 17039368: {
                this.doContentEnd();
                this.clearSelection(true);
                break;
            }
            case 17039365: {
                this.doPageStart();
                this.clearSelection(true);
                break;
            }
            case 17039366: {
                this.doPageEnd();
                this.clearSelection(true);
                break;
            }
            case 0x1020001: {
                this.doSelectionLineUp();
                break;
            }
            case 0x1020002: {
                this.doSelectionLineDown();
                break;
            }
            case 16908295: {
                this.doLineStart();
                this.doSelection(0x1000003);
                break;
            }
            case 16908296: {
                this.doLineEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 16908291: {
                this.doSelectionCursorPrevious();
                this.doSelection(0x1000003);
                break;
            }
            case 16908292: {
                this.doSelectionCursorNext();
                this.doSelection(0x1000004);
                break;
            }
            case 16908293: {
                this.doSelectionPageUp();
                this.doSelection(0x1000003);
                break;
            }
            case 16908294: {
                this.doSelectionPageDown();
                break;
            }
            case 17170435: {
                this.doSelectionWordPrevious();
                this.doSelection(0x1000003);
                break;
            }
            case 17170436: {
                this.doSelectionWordNext();
                this.doSelection(0x1000004);
                break;
            }
            case 17170439: {
                this.doContentStart();
                this.doSelection(0x1000003);
                break;
            }
            case 17170440: {
                this.doContentEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 17170437: {
                this.doPageStart();
                this.doSelection(0x1000003);
                break;
            }
            case 0x1060006: {
                this.doPageEnd();
                this.doSelection(0x1000004);
                break;
            }
            case 131199: {
                this.cut();
                break;
            }
            case 17039369: {
                this.copy();
                break;
            }
            case 16908297: {
                this.paste();
                break;
            }
            case 8: {
                this.doBackspace();
                break;
            }
            case 127: {
                this.doDelete();
                break;
            }
            case 262152: {
                this.doDeleteWordPrevious();
                break;
            }
            case 262271: {
                this.doDeleteWordNext();
                break;
            }
            case 0x1000009: {
                this.overwrite = !this.overwrite;
            }
        }
    }

    boolean isBidi() {
        return this.isBidi;
    }

    boolean isLineDelimiter(int n) {
        int n2 = this.content.getLineAtOffset(n);
        int n3 = this.content.getOffsetAtLine(n2);
        int n4 = n - n3;
        return n4 > this.content.getLine(n2).length();
    }

    boolean isMirrored() {
        return this.isMirrored;
    }

    boolean isAreaVisible(int n, int n2) {
        int n3 = this.getPartialBottomIndex();
        int n4 = this.verticalScrollOffset / this.lineHeight;
        boolean bl = n > n3 || n2 < n4;
        return !bl;
    }

    boolean isRedrawFirstLine(StyleRange[] styleRangeArray, int n, int n2) {
        int n3 = n2 + this.content.getLine(n).length();
        int n4 = 0;
        while (n4 < styleRangeArray.length) {
            StyleRange styleRange = styleRangeArray[n4];
            if (styleRange.start < n3) {
                int n5 = styleRange.start + styleRange.length;
                if (this.isStyleChanging(styleRange, styleRange.start, Math.min(n5, n3))) {
                    return true;
                }
            } else {
                return false;
            }
            ++n4;
        }
        return false;
    }

    boolean isRedrawLastLine(StyleRange[] styleRangeArray, int n, int n2) {
        int n3 = styleRangeArray.length - 1;
        while (n3 >= 0) {
            StyleRange styleRange = styleRangeArray[n3];
            int n4 = styleRange.start + styleRange.length;
            if (n4 < n2) break;
            if (this.isStyleChanging(styleRange, Math.max(styleRange.start, n2), n4)) {
                return true;
            }
            --n3;
        }
        return false;
    }

    boolean isSingleLine() {
        return (this.getStyle() & 4) != 0;
    }

    boolean isStyleChanging(StyleRange styleRange, int n, int n2) {
        this.checkWidget();
        StyleRange[] styleRangeArray = this.defaultLineStyler.getStyleRangesFor(n, n2 - n);
        if (styleRangeArray == null) {
            return styleRange.fontStyle != 0;
        }
        int n3 = 0;
        while (n3 < styleRangeArray.length) {
            StyleRange styleRange2 = styleRangeArray[n3];
            if (styleRange2.fontStyle != styleRange.fontStyle) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    void modifyContent(Event event, boolean bl) {
        event.doit = true;
        this.notifyListeners(25, event);
        if (event.doit) {
            StyledTextEvent styledTextEvent = null;
            int n = event.end - event.start;
            boolean bl2 = n == 1 && event.text.length() == 0;
            boolean bl3 = event.start < this.caretOffset;
            boolean bl4 = false;
            if (bl && this.isBidi() && bl2) {
                int n2 = this.content.getLineAtOffset(this.caretOffset);
                int n3 = this.content.getOffsetAtLine(n2);
                int n4 = this.caretOffset - n3;
                String string = this.content.getLine(n2);
                GC gC = this.getGC();
                StyledTextBidi styledTextBidi = new StyledTextBidi(gC, string, this.getBidiSegments(n3, string));
                if (bl3) {
                    if (n4 > 0) {
                        bl4 = n4 < string.length() && (styledTextBidi.isRightToLeft(n4) != styledTextBidi.isRightToLeft(n4 - 1) || styledTextBidi.isLocalNumber(n4) != styledTextBidi.isLocalNumber(n4 - 1));
                        styledTextBidi.setKeyboardLanguage(n4 - 1);
                    }
                } else if (n4 < string.length()) {
                    bl4 = n4 > 0 && (styledTextBidi.isRightToLeft(n4) != styledTextBidi.isRightToLeft(n4 - 1) || styledTextBidi.isLocalNumber(n4) != styledTextBidi.isLocalNumber(n4 - 1));
                    styledTextBidi.setKeyboardLanguage(n4);
                }
                gC.dispose();
            }
            if (this.isListening(3000)) {
                styledTextEvent = new StyledTextEvent(this.logicalContent);
                styledTextEvent.start = event.start;
                styledTextEvent.end = event.start + event.text.length();
                styledTextEvent.text = this.content.getTextRange(event.start, n);
            }
            this.content.replaceTextRange(event.start, n, event.text);
            if (bl) {
                this.internalSetSelection(event.start + event.text.length(), 0, true);
                if (this.isBidi()) {
                    if (bl2) {
                        this.updateBidiDirection(bl3, bl4);
                    } else {
                        this.lastCaretDirection = 0x1000004;
                    }
                    this.showBidiCaret();
                } else {
                    this.showCaret();
                }
            }
            this.notifyListeners(24, event);
            if (this.isListening(3000)) {
                this.notifyListeners(3000, styledTextEvent);
            }
        }
    }

    public void paste() {
        this.checkWidget();
        TextTransfer textTransfer = TextTransfer.getInstance();
        String string = (String)this.clipboard.getContents(textTransfer);
        if (string != null && string.length() > 0) {
            Event event = new Event();
            event.start = this.selection.x;
            event.end = this.selection.y;
            event.text = this.getModelDelimitedText(string);
            this.sendKeyEvent(event);
        }
    }

    void performPaint(GC gC, int n, int n2, int n3) {
        Rectangle rectangle = this.getClientArea();
        Color color = this.getBackground();
        if (rectangle.width == 0) {
            return;
        }
        if (n3 > 0) {
            int n4;
            Color color2 = this.getForeground();
            int n5 = this.content.getLineCount();
            int n6 = 0;
            int n7 = n4 = this.isMirrored() ? 0x4000000 : 0x2000000;
            if (this.isSingleLine()) {
                n5 = 1;
                if (n > 1) {
                    n = 1;
                }
            }
            Image image = new Image((Device)this.getDisplay(), rectangle.width, n3);
            GC gC2 = new GC(image, n4);
            gC2.setFont(this.getFont());
            this.renderer.setCurrentFontStyle(0);
            gC2.setForeground(color2);
            gC2.setBackground(color);
            int n8 = n;
            while (n6 < n3 && n8 < n5) {
                String string = this.content.getLine(n8);
                ControlCharRenderer controlCharRenderer = new ControlCharRenderer(this.getDisplay(), this);
                if (n8 < n5 - 1) {
                    controlCharRenderer.setLineInfo(this, string, n8);
                }
                this.renderer.drawLine(string, n8, n6, gC2, color, color2, true, controlCharRenderer);
                controlCharRenderer.dispose();
                ++n8;
                n6 += this.lineHeight;
            }
            if (n6 < n3) {
                gC2.setBackground(color);
                gC2.setForeground(color);
                gC2.fillRectangle(0, n6, rectangle.width, n3 - n6);
            }
            gC.drawImage(image, 0, n2);
            gC2.dispose();
            image.dispose();
        }
        this.clearMargin(gC, color, rectangle, n3);
    }

    public void print() {
        this.checkWidget();
        Printer printer = new Printer();
        StyledTextPrintOptions styledTextPrintOptions = new StyledTextPrintOptions();
        styledTextPrintOptions.printTextForeground = true;
        styledTextPrintOptions.printTextBackground = true;
        styledTextPrintOptions.printTextFontStyle = true;
        styledTextPrintOptions.printLineBackground = true;
        new Printing(this, printer, styledTextPrintOptions).run();
        printer.dispose();
    }

    public Runnable print(Printer printer) {
        StyledTextPrintOptions styledTextPrintOptions = new StyledTextPrintOptions();
        this.checkWidget();
        styledTextPrintOptions.printTextForeground = true;
        styledTextPrintOptions.printTextBackground = true;
        styledTextPrintOptions.printTextFontStyle = true;
        styledTextPrintOptions.printLineBackground = true;
        if (printer == null) {
            SWT.error(4);
        }
        return this.print(printer, styledTextPrintOptions);
    }

    public Runnable print(Printer printer, StyledTextPrintOptions styledTextPrintOptions) {
        this.checkWidget();
        if (printer == null || styledTextPrintOptions == null) {
            SWT.error(4);
        }
        return new Printing(this, printer, styledTextPrintOptions);
    }

    public void redraw() {
        super.redraw();
        int n = this.getPartialBottomIndex() - this.topIndex + 1;
        this.lineCache.redrawReset(this.topIndex, n, true);
        this.lineCache.calculate(this.topIndex, n);
        this.setHorizontalScrollBar();
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        super.redraw(n, n2, n3, n4, bl);
        if (n4 > 0) {
            int n5 = this.content.getLineCount();
            int n6 = (this.getTopPixel() + n2) / this.lineHeight;
            int n7 = n6 + Compatibility.ceil(n4, this.lineHeight);
            n6 = Math.min(n6, n5);
            int n8 = Math.min(n7, n5) - n6;
            this.lineCache.reset(n6, n8, true);
            n8 = this.getPartialBottomIndex() - this.topIndex + 1;
            this.lineCache.calculate(this.topIndex, n8);
            this.setHorizontalScrollBar();
        }
    }

    void redrawBidiLines(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        int n7 = n3 - n + 1;
        int n8 = n * this.lineHeight - this.verticalScrollOffset;
        int n9 = this.content.getOffsetAtLine(n);
        String string = this.content.getLine(n);
        GC gC = this.getGC();
        StyledTextBidi styledTextBidi = this.getStyledTextBidi(string, n9, gC);
        styledTextBidi.redrawRange(this, n2, Math.min(string.length(), n4) - n2, this.leftMargin - this.horizontalScrollOffset, n8 + this.topMargin, this.lineHeight);
        if (n3 > n && bl) {
            n6 = styledTextBidi.getTextWidth();
            if (n6 == this.leftMargin) {
                n6 += 3;
            }
            n5 = (this.getStyle() & 0x10000) != 0 ? this.getClientArea().width - (n6 -= this.horizontalScrollOffset) : this.lineEndSpaceWidth;
            this.draw(n6, n8, n5, this.lineHeight, bl);
        }
        if (n7 > 1 && (n6 = n4 - (n5 = this.content.getOffsetAtLine(n3))) > 0) {
            string = this.content.getLine(n3);
            n8 = n3 * this.lineHeight - this.verticalScrollOffset;
            styledTextBidi = this.getStyledTextBidi(string, n5, gC);
            styledTextBidi.redrawRange(this, 0, n6, this.leftMargin - this.horizontalScrollOffset, n8 + this.topMargin, this.lineHeight);
        }
        gC.dispose();
    }

    void redrawLine(int n, int n2) {
        int n3 = 0;
        if (n2 > 0) {
            String string = this.content.getLine(n);
            n3 = this.getXAtOffset(string, n, n2);
        }
        int n4 = n * this.lineHeight - this.verticalScrollOffset;
        super.redraw(n3 + this.leftMargin, n4 + this.topMargin, this.getClientArea().width, this.lineHeight, true);
    }

    void redrawLines(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        boolean bl2;
        String string = this.content.getLine(n);
        int n6 = n3 - n + 1;
        int n7 = this.getXAtOffset(string, n, n2) - this.leftMargin;
        int n8 = n * this.lineHeight - this.verticalScrollOffset;
        int n9 = this.content.getOffsetAtLine(n);
        boolean bl3 = bl2 = (this.getStyle() & 0x10000) != 0 && n3 > n;
        if (bl && n4 - n9 >= string.length()) {
            bl2 = true;
        }
        int n10 = bl2 ? this.getClientArea().width - this.leftMargin : this.getXAtOffset(string, n, n4 - n9) - this.leftMargin;
        this.draw(n7, n8, n10 - n7, this.lineHeight, bl);
        if (n6 > 1 && (n5 = n4 - this.content.getOffsetAtLine(n3)) > 0) {
            string = this.content.getLine(n3);
            if (bl && n5 >= string.length()) {
                bl2 = true;
            }
            n10 = bl2 ? this.getClientArea().width - this.leftMargin : this.getXAtOffset(string, n3, n5) - this.leftMargin;
            n8 = n3 * this.lineHeight - this.verticalScrollOffset;
            this.draw(0, n8, n10, this.lineHeight, bl);
        }
    }

    void redrawMultiLineChange(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        Rectangle rectangle = this.getClientArea();
        int n8 = n2 - n3;
        if (n8 > 0) {
            n7 = Math.max(0, n + this.lineHeight);
            n6 = n7 + n8 * this.lineHeight;
        } else {
            n6 = Math.max(0, n + this.lineHeight);
            n7 = n6 - n8 * this.lineHeight;
        }
        this.scroll(0, n6, 0, n7, rectangle.width, rectangle.height, true);
        if (n + this.lineHeight > 0 && n <= rectangle.height) {
            super.redraw(0, n, rectangle.width, this.lineHeight, true);
        }
        if (n2 > 0 && (n5 = n + this.lineHeight) + (n4 = n2 * this.lineHeight) > 0 && n5 <= rectangle.height) {
            super.redraw(0, n5, rectangle.width, n4, true);
        }
    }

    public void redrawRange(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = n + n2;
        int n4 = this.content.getCharCount();
        if (n > n3 || n < 0 || n3 > n4) {
            SWT.error(6);
        }
        int n5 = this.content.getLineAtOffset(n);
        int n6 = this.content.getLineAtOffset(n3);
        this.lineCache.reset(n5, n6 - n5 + 1, true);
        this.internalRedrawRange(n, n2, bl);
    }

    public void removeBidiSegmentListener(BidiSegmentListener bidiSegmentListener) {
        this.checkWidget();
        if (bidiSegmentListener == null) {
            SWT.error(4);
        }
        this.removeListener(3007, bidiSegmentListener);
    }

    public void removeExtendedModifyListener(ExtendedModifyListener extendedModifyListener) {
        this.checkWidget();
        if (extendedModifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(3000, extendedModifyListener);
    }

    public void removeLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
        this.checkWidget();
        if (lineBackgroundListener == null) {
            SWT.error(4);
        }
        this.removeListener(3001, lineBackgroundListener);
        if (!this.isListening(3001) && this.userLineBackground) {
            StyledTextListener styledTextListener = new StyledTextListener(this.defaultLineStyler);
            this.addListener(3001, styledTextListener);
            this.userLineBackground = false;
        }
    }

    public void removeLineStyleListener(LineStyleListener lineStyleListener) {
        this.checkWidget();
        if (lineStyleListener == null) {
            SWT.error(4);
        }
        this.removeListener(3002, lineStyleListener);
        if (!this.isListening(3002) && this.userLineStyle) {
            StyledTextListener styledTextListener = new StyledTextListener(this.defaultLineStyler);
            this.addListener(3002, styledTextListener);
            this.userLineStyle = false;
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            SWT.error(4);
        }
        this.removeListener(25, verifyListener);
    }

    public void removeVerifyKeyListener(VerifyKeyListener verifyKeyListener) {
        if (verifyKeyListener == null) {
            SWT.error(4);
        }
        this.removeListener(3005, verifyKeyListener);
    }

    public void replaceStyleRanges(int n, int n2, StyleRange[] styleRangeArray) {
        int n3;
        int n4;
        boolean bl;
        this.checkWidget();
        if (this.userLineStyle) {
            return;
        }
        if (styleRangeArray == null) {
            SWT.error(4);
        }
        if (styleRangeArray.length == 0) {
            this.setStyleRange(new StyleRange(n, n2, null, null));
            return;
        }
        int n5 = n + n2;
        if (n > n5 || n < 0 || n5 > this.getCharCount()) {
            SWT.error(6);
        }
        if (!(bl = this.isAreaVisible(n4 = this.content.getLineAtOffset(n), n3 = this.content.getLineAtOffset(n5)))) {
            this.defaultLineStyler.replaceStyleRanges(n, n2, styleRangeArray);
            this.lineCache.reset(n4, n3 - n4 + 1, true);
        } else {
            boolean bl2 = false;
            boolean bl3 = false;
            int n6 = this.content.getOffsetAtLine(n4);
            if (this.isBidi()) {
                bl2 = true;
                bl3 = true;
            } else {
                int n7 = n6 + this.content.getLine(n4).length();
                bl2 = this.isRedrawFirstLine(styleRangeArray, n4, n6);
                StyleRange styleRange = new StyleRange(n6, n7 - n6, null, null);
                boolean bl4 = bl2 = bl2 || this.isRedrawFirstLine(new StyleRange[]{styleRange}, n4, n6);
                if (n3 != n4) {
                    int n8 = this.content.getOffsetAtLine(n3);
                    int n9 = n8 + this.content.getLine(n3).length();
                    bl3 = this.isRedrawLastLine(styleRangeArray, n3, n8);
                    styleRange = new StyleRange(n8, n9 - n8, null, null);
                    bl3 = bl3 || this.isRedrawLastLine(new StyleRange[]{styleRange}, n3, n8);
                }
            }
            this.defaultLineStyler.replaceStyleRanges(n, n2, styleRangeArray);
            this.lineCache.reset(n4, n3 - n4 + 1, true);
            this.internalRedrawRange(n, n2, true);
            if (bl2) {
                this.redrawLine(n4, n - n6);
            }
            if (bl3) {
                this.redrawLine(n3, 0);
            }
        }
        this.setCaretLocation();
    }

    public void replaceTextRange(int n, int n2, String string) {
        this.checkWidget();
        int n3 = this.getCharCount();
        int n4 = n + n2;
        Event event = new Event();
        if (n > n4 || n < 0 || n4 > n3) {
            SWT.error(6);
        }
        if (string == null) {
            SWT.error(4);
        }
        event.start = n;
        event.end = n4;
        event.text = string;
        this.modifyContent(event, false);
    }

    void reset() {
        ScrollBar scrollBar = this.getVerticalBar();
        ScrollBar scrollBar2 = this.getHorizontalBar();
        this.caretOffset = 0;
        this.topIndex = 0;
        this.topOffset = 0;
        this.verticalScrollOffset = 0;
        this.horizontalScrollOffset = 0;
        this.resetSelection();
        if (this.defaultLineStyler != null) {
            this.removeLineBackgroundListener(this.defaultLineStyler);
            this.removeLineStyleListener(this.defaultLineStyler);
            this.installDefaultLineStyler();
        }
        this.calculateContentWidth();
        if (scrollBar != null) {
            scrollBar.setSelection(0);
        }
        if (scrollBar2 != null) {
            scrollBar2.setSelection(0);
        }
        this.setScrollBars();
        this.setCaretLocation();
        super.redraw();
    }

    void resetSelection() {
        this.selection.x = this.selection.y = this.caretOffset;
        this.selectionAnchor = -1;
    }

    void scrollHorizontal(int n) {
        if (n == 0) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        if (n > 0) {
            int n2 = this.leftMargin + n;
            int n3 = rectangle.width - n2 - this.rightMargin;
            int n4 = rectangle.height - this.topMargin - this.bottomMargin;
            this.scroll(this.leftMargin, this.topMargin, n2, this.topMargin, n3, n4, true);
            if (n2 > n3) {
                super.redraw(this.leftMargin + n3, this.topMargin, n - n3, n4, true);
            }
        } else {
            int n5 = this.leftMargin - n;
            int n6 = rectangle.width - n5 - this.rightMargin;
            int n7 = rectangle.height - this.topMargin - this.bottomMargin;
            this.scroll(n5, this.topMargin, this.leftMargin, this.topMargin, n6, n7, true);
            if (n5 > n6) {
                super.redraw(this.leftMargin + n6, this.topMargin, -n - n6, n7, true);
            }
        }
        this.horizontalScrollOffset += n;
        this.setCaretLocation();
    }

    boolean scrollHorizontalBar(int n) {
        if (n == 0) {
            return false;
        }
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar != null) {
            scrollBar.setSelection(this.horizontalScrollOffset + n);
        }
        this.scrollHorizontal(n);
        return true;
    }

    public void selectAll() {
        this.checkWidget();
        this.setSelection(new Point(0, Math.max(this.getCharCount(), 0)));
    }

    void sendKeyEvent(Event event) {
        if (!this.editable) {
            return;
        }
        this.modifyContent(event, true);
    }

    void sendSelectionEvent() {
        Event event = new Event();
        event.x = this.selection.x;
        event.y = this.selection.y;
        this.notifyListeners(13, event);
    }

    public void setWordWrap(boolean bl) {
        this.checkWidget();
        if (bl != this.wordWrap) {
            ScrollBar scrollBar = this.getHorizontalBar();
            this.wordWrap = bl;
            if (this.wordWrap) {
                this.logicalContent = this.content;
                this.content = new WrappedContent(this.renderer, this.logicalContent);
            } else {
                this.content = this.logicalContent;
            }
            this.calculateContentWidth();
            this.horizontalScrollOffset = 0;
            if (scrollBar != null) {
                scrollBar.setVisible(!this.wordWrap);
            }
            this.setScrollBars();
            this.setCaretLocation();
            super.redraw();
        }
    }

    void showBidiCaret() {
        int n = this.content.getLineAtOffset(this.caretOffset);
        int n2 = this.content.getOffsetAtLine(n);
        int n3 = this.caretOffset - n2;
        String string = this.content.getLine(n);
        int n4 = 0;
        boolean bl = false;
        GC gC = this.getGC();
        StyledTextBidi styledTextBidi = this.getStyledTextBidi(string, n2, gC);
        n4 = this.getBidiTextPosition(string, n3, styledTextBidi) + this.leftMargin;
        if (n3 > string.length()) {
            n4 += this.lineEndSpaceWidth;
        }
        if (!(bl = this.showLocation(n4 -= this.horizontalScrollOffset, n))) {
            this.setBidiCaretLocation(styledTextBidi);
        }
        gC.dispose();
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        super.setCaret(caret);
        if (caret != null) {
            if (!this.isBidi()) {
                caret.setSize(caret.getSize().x, this.lineHeight);
            }
            this.setCaretLocation();
            if (this.isBidi()) {
                this.setBidiKeyboardLanguage();
            }
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        super.setBackground(color);
        this.background = color;
        this.redraw();
    }

    void setBidiCaretDirection() {
        Caret caret = this.getCaret();
        int n = StyledTextBidi.getKeyboardLanguageDirection();
        if (caret == null || n == this.caretDirection) {
            return;
        }
        this.caretDirection = n;
        if (n == -1) {
            caret.setImage(null);
            caret.setSize(caret.getSize().x, this.lineHeight);
        } else if (this.caretDirection == 16384) {
            caret.setImage(this.leftCaretBitmap);
        } else if (this.caretDirection == 131072) {
            caret.setImage(this.rightCaretBitmap);
        }
    }

    void setBidiCaretLocation(StyledTextBidi styledTextBidi) {
        int n = this.getCaretLine();
        this.setBidiCaretLocation(styledTextBidi, n);
    }

    void setBidiCaretLocation(StyledTextBidi styledTextBidi, int n) {
        Caret caret = this.getCaret();
        String string = this.content.getLine(n);
        int n2 = this.content.getOffsetAtLine(n);
        int n3 = this.caretOffset - n2;
        GC gC = null;
        boolean bl = this.isMirrored();
        if (styledTextBidi == null) {
            gC = this.getGC();
            styledTextBidi = this.getStyledTextBidi(string, n2, gC);
        }
        this.columnX = this.lastCaretDirection == 0 ? styledTextBidi.getTextPosition(n3) + this.leftMargin - this.horizontalScrollOffset : styledTextBidi.getTextPosition(n3, this.lastCaretDirection) + this.leftMargin - this.horizontalScrollOffset;
        int n4 = StyledTextBidi.getKeyboardLanguageDirection();
        if (n4 == 131072 && !bl || n4 == 16384 && bl) {
            this.columnX -= this.getCaretWidth() - 1;
        }
        if (caret != null) {
            this.setBidiCaretDirection();
            caret.setLocation(this.columnX, n * this.lineHeight - this.verticalScrollOffset + this.topMargin);
        }
        if (gC != null) {
            gC.dispose();
        }
    }

    public void setBidiColoring(boolean bl) {
        this.checkWidget();
        this.bidiColoring = bl;
    }

    void setBidiKeyboardLanguage() {
        int n = this.getCaretLine();
        int n2 = this.content.getOffsetAtLine(n);
        int n3 = this.caretOffset - n2;
        String string = this.content.getLine(n);
        GC gC = this.getGC();
        int n4 = string.length();
        StyledTextBidi styledTextBidi = new StyledTextBidi(gC, string, this.getBidiSegments(n2, string));
        if (n3 == 0) {
            styledTextBidi.setKeyboardLanguage(n3);
        } else if (n3 >= n4) {
            n3 = Math.min(n3, n4 - 1);
            styledTextBidi.setKeyboardLanguage(n3);
        } else if (this.lastCaretDirection == 0x1000004) {
            styledTextBidi.setKeyboardLanguage(n3 - 1);
        } else {
            styledTextBidi.setKeyboardLanguage(n3);
        }
        gC.dispose();
    }

    void setCaretLocation(int n, int n2) {
        if (this.isBidi()) {
            this.setBidiCaretLocation(null, n2);
        } else {
            Caret caret = this.getCaret();
            this.columnX = n;
            if (caret != null) {
                caret.setLocation(n, n2 * this.lineHeight - this.verticalScrollOffset + this.topMargin);
            }
        }
    }

    void setCaretLocation() {
        if (this.isBidi()) {
            this.setBidiCaretLocation(null);
        } else {
            Caret caret = this.getCaret();
            int n = this.getCaretLine();
            int n2 = this.content.getOffsetAtLine(n);
            this.columnX = this.getXAtOffset(this.content.getLine(n), n, this.caretOffset - n2);
            if (caret != null) {
                caret.setLocation(this.columnX, n * this.lineHeight - this.verticalScrollOffset + this.topMargin);
            }
        }
    }

    public void setCaretOffset(int n) {
        this.checkWidget();
        int n2 = this.getCharCount();
        if (n2 > 0 && n != this.caretOffset) {
            if (n < 0) {
                this.caretOffset = 0;
            } else if (n > n2) {
                this.caretOffset = n2;
            } else {
                if (this.isLineDelimiter(n)) {
                    SWT.error(5);
                }
                this.caretOffset = n;
            }
            this.clearSelection(false);
        }
        this.setCaretLocation();
        if (this.isBidi()) {
            this.setBidiKeyboardLanguage();
        }
    }

    void setClipboardContent(int n, int n2) throws SWTError {
        RTFTransfer rTFTransfer = RTFTransfer.getInstance();
        TextTransfer textTransfer = TextTransfer.getInstance();
        RTFWriter rTFWriter = new RTFWriter(n, n2);
        TextWriter textWriter = new TextWriter(n, n2);
        String string = this.getPlatformDelimitedText(rTFWriter);
        String string2 = this.getPlatformDelimitedText(textWriter);
        this.clipboard.setContents(new String[]{string, string2}, new Transfer[]{rTFTransfer, textTransfer});
    }

    public void setContent(StyledTextContent styledTextContent) {
        this.checkWidget();
        if (styledTextContent == null) {
            SWT.error(4);
        }
        if (this.content != null) {
            this.content.removeTextChangeListener(this.textChangeListener);
        }
        this.logicalContent = styledTextContent;
        this.content = this.wordWrap ? new WrappedContent(this.renderer, this.logicalContent) : this.logicalContent;
        this.content.addTextChangeListener(this.textChangeListener);
        this.reset();
    }

    public void setCursor(Cursor cursor) {
        if (cursor == null) {
            super.setCursor(this.ibeamCursor);
        } else {
            super.setCursor(cursor);
        }
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.checkWidget();
        this.doubleClickEnabled = bl;
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.editable = bl;
    }

    public void setFont(Font font) {
        this.checkWidget();
        int n = this.lineHeight;
        super.setFont(font);
        this.initializeRenderer();
        if (this.lineHeight != n) {
            this.setVerticalScrollOffset(this.verticalScrollOffset * this.lineHeight / n, true);
            this.claimBottomFreeSpace();
        }
        this.calculateContentWidth();
        this.calculateScrollBars();
        if (this.isBidi()) {
            this.caretDirection = 0;
            this.createCaretBitmaps();
            this.setBidiCaretDirection();
        } else {
            Caret caret = this.getCaret();
            if (caret != null) {
                caret.setSize(caret.getSize().x, this.lineHeight);
            }
        }
        this.setCaretLocation();
        super.redraw();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        super.setForeground(color);
        this.foreground = color;
        this.redraw();
    }

    public void setHorizontalIndex(int n) {
        int n2;
        this.checkWidget();
        int n3 = this.getClientArea().width;
        if (this.getCharCount() == 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n3 > 0 && (n *= this.getHorizontalIncrement()) > (n2 = this.lineCache.getWidth()) - n3) {
            n = Math.max(0, n2 - n3);
        }
        this.scrollHorizontalBar(n - this.horizontalScrollOffset);
    }

    public void setHorizontalPixel(int n) {
        int n2;
        this.checkWidget();
        int n3 = this.getClientArea().width;
        if (this.getCharCount() == 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n3 > 0 && n > (n2 = this.lineCache.getWidth()) - n3) {
            n = Math.max(0, n2 - n3);
        }
        this.scrollHorizontalBar(n - this.horizontalScrollOffset);
    }

    void setHorizontalScrollBar() {
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar != null && scrollBar.getVisible()) {
            Rectangle rectangle = this.getClientArea();
            if (rectangle.width < this.lineCache.getWidth()) {
                scrollBar.setValues(scrollBar.getSelection(), scrollBar.getMinimum(), this.lineCache.getWidth(), rectangle.width - this.leftMargin - this.rightMargin, scrollBar.getIncrement(), rectangle.width - this.leftMargin - this.rightMargin);
            } else if (scrollBar.getThumb() != 1 || scrollBar.getMaximum() != 1) {
                scrollBar.setValues(scrollBar.getSelection(), scrollBar.getMinimum(), 1, 1, scrollBar.getIncrement(), 1);
            }
        }
    }

    public void setLineBackground(int n, int n2, Color color) {
        this.checkWidget();
        int n3 = this.getPartialBottomIndex();
        if (this.userLineBackground) {
            return;
        }
        if (n < 0 || n + n2 > this.logicalContent.getLineCount()) {
            SWT.error(5);
        }
        this.defaultLineStyler.setLineBackground(n, n2, color);
        if (n > n3 || n + n2 - 1 < this.topIndex) {
            return;
        }
        if (n < this.topIndex) {
            n2 -= this.topIndex - n;
            n = this.topIndex;
        }
        if (n + n2 - 1 > n3) {
            n2 = n3 - n + 1;
        }
        super.redraw(this.leftMargin, (n -= this.topIndex) * this.lineHeight + this.topMargin, this.getClientArea().width - this.leftMargin - this.rightMargin, n2 * this.lineHeight, true);
    }

    void setMouseWordSelectionAnchor() {
        if (!this.mouseDoubleClick) {
            return;
        }
        if (this.caretOffset < this.doubleClickSelection.x) {
            this.selectionAnchor = this.doubleClickSelection.y;
        } else if (this.caretOffset > this.doubleClickSelection.y) {
            this.selectionAnchor = this.doubleClickSelection.x;
        }
    }

    public void setOrientation(int n) {
        if ((n & 0x6000000) == 0) {
            return;
        }
        if ((n & 0x4000000) != 0 && (n & 0x2000000) != 0) {
            return;
        }
        if ((n & 0x4000000) != 0 && this.isMirrored()) {
            return;
        }
        if ((n & 0x2000000) != 0 && !this.isMirrored()) {
            return;
        }
        if (!StyledTextBidi.setOrientation(this, n)) {
            return;
        }
        this.isMirrored = (n & 0x4000000) != 0;
        this.isBidi = StyledTextBidi.isBidiPlatform() || this.isMirrored();
        this.initializeRenderer();
        if (this.isBidi()) {
            this.caretDirection = 0;
            this.createCaretBitmaps();
            this.setBidiCaretDirection();
        }
        this.setCaretLocation();
        this.keyActionMap.clear();
        this.createKeyBindings();
        super.redraw();
    }

    void setScrollBars() {
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar != null) {
            Rectangle rectangle = this.getClientArea();
            int n = this.content.getLineCount() * this.getVerticalIncrement();
            if (rectangle.height < n) {
                scrollBar.setValues(scrollBar.getSelection(), scrollBar.getMinimum(), n, rectangle.height, scrollBar.getIncrement(), rectangle.height);
            } else if (scrollBar.getThumb() != 1 || scrollBar.getMaximum() != 1) {
                scrollBar.setValues(scrollBar.getSelection(), scrollBar.getMinimum(), 1, 1, scrollBar.getIncrement(), 1);
            }
        }
        this.setHorizontalScrollBar();
    }

    public void setSelection(int n) {
        this.setSelection(n, n);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setSelectionBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.selectionBackground = color;
        this.redraw();
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        this.selectionForeground = color;
        this.redraw();
    }

    public void setSelection(int n, int n2) {
        this.setSelectionRange(n, n2 - n);
        this.showSelection();
    }

    public void setSelectionRange(int n, int n2) {
        this.checkWidget();
        int n3 = this.getCharCount();
        int n4 = n + n2;
        if (n < 0 || n4 < 0 || n > n3 || n4 > n3) {
            SWT.error(6);
        }
        if (this.isLineDelimiter(n) || this.isLineDelimiter(n4)) {
            SWT.error(5);
        }
        this.internalSetSelection(n, n2, false);
        this.setCaretLocation();
        if (this.isBidi()) {
            this.setBidiKeyboardLanguage();
        }
    }

    void internalSetSelection(int n, int n2, boolean bl) {
        int n3 = n + n2;
        if (n > n3) {
            int n4 = n3;
            n3 = n;
            n = n4;
        }
        if (this.selection.x != n || this.selection.y != n3 || n2 > 0 && this.selectionAnchor != this.selection.x || n2 < 0 && this.selectionAnchor != this.selection.y) {
            this.clearSelection(bl);
            if (n2 < 0) {
                this.selectionAnchor = this.selection.y = n3;
                this.caretOffset = this.selection.x = n;
            } else {
                this.selectionAnchor = this.selection.x = n;
                this.caretOffset = this.selection.y = n3;
            }
            this.internalRedrawRange(this.selection.x, this.selection.y - this.selection.x, true);
        }
    }

    public void setStyleRange(StyleRange styleRange) {
        this.checkWidget();
        if (this.userLineStyle) {
            return;
        }
        if (styleRange != null && styleRange.start + styleRange.length > this.content.getCharCount()) {
            SWT.error(6);
        }
        if (styleRange != null) {
            int n;
            boolean bl = false;
            boolean bl2 = false;
            int n2 = this.content.getLineAtOffset(styleRange.start);
            boolean bl3 = this.isAreaVisible(n2, n = this.content.getLineAtOffset(styleRange.start + styleRange.length));
            if (!bl3) {
                this.defaultLineStyler.setStyleRange(styleRange);
                this.lineCache.reset(n2, n - n2 + 1, true);
            } else {
                int n3 = this.content.getOffsetAtLine(n2);
                int n4 = this.content.getOffsetAtLine(n);
                if (this.isBidi()) {
                    if (n2 != n) {
                        bl = true;
                    }
                    bl2 = true;
                } else {
                    bl = this.isRedrawFirstLine(new StyleRange[]{styleRange}, n2, n3);
                    if (n != n2) {
                        bl2 = this.isRedrawLastLine(new StyleRange[]{styleRange}, n, n4);
                    }
                }
                this.defaultLineStyler.setStyleRange(styleRange);
                this.lineCache.reset(n2, n - n2 + 1, true);
                this.internalRedrawRange(styleRange.start, styleRange.length, true);
                if (bl) {
                    this.redrawLine(n2, styleRange.start - n3);
                }
                if (bl2) {
                    this.redrawLine(n, 0);
                }
            }
        } else {
            this.defaultLineStyler.setStyleRange(styleRange);
            this.lineCache.reset(0, this.content.getLineCount(), false);
            this.redraw();
        }
        this.setCaretLocation();
    }

    public void setStyleRanges(StyleRange[] styleRangeArray) {
        this.checkWidget();
        if (this.userLineStyle) {
            return;
        }
        if (styleRangeArray == null) {
            SWT.error(4);
        }
        if (styleRangeArray.length != 0) {
            StyleRange styleRange = styleRangeArray[styleRangeArray.length - 1];
            int n = styleRange.start + styleRange.length;
            int n2 = this.content.getLineAtOffset(styleRangeArray[0].start);
            if (n > this.content.getCharCount()) {
                SWT.error(6);
            }
            int n3 = this.content.getLineAtOffset(n);
            this.lineCache.reset(n2, n3 - n2 + 1, true);
        } else {
            this.lineCache.reset(0, this.content.getLineCount(), false);
        }
        this.defaultLineStyler.setStyleRanges(styleRangeArray);
        this.redraw();
        this.setCaretLocation();
    }

    public void setTabs(int n) {
        this.checkWidget();
        this.tabLength = n;
        this.renderer.setTabLength(this.tabLength);
        if (this.caretOffset > 0) {
            this.caretOffset = 0;
            if (this.isBidi()) {
                this.showBidiCaret();
            } else {
                this.showCaret();
            }
            this.clearSelection(false);
        }
        this.lineCache.reset(0, this.content.getLineCount(), false);
        this.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        Event event = new Event();
        if (string == null) {
            SWT.error(4);
        }
        event.start = 0;
        event.end = this.getCharCount();
        event.text = string;
        event.doit = true;
        this.notifyListeners(25, event);
        if (event.doit) {
            StyledTextEvent styledTextEvent = null;
            if (this.isListening(3000)) {
                styledTextEvent = new StyledTextEvent(this.logicalContent);
                styledTextEvent.start = event.start;
                styledTextEvent.end = event.start + event.text.length();
                styledTextEvent.text = this.content.getTextRange(event.start, event.end - event.start);
            }
            this.content.setText(event.text);
            this.notifyListeners(24, event);
            if (styledTextEvent != null) {
                this.notifyListeners(3000, styledTextEvent);
            }
        }
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            SWT.error(7);
        }
        this.textLimit = n;
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        int n2 = this.logicalContent.getLineCount();
        int n3 = Math.max(1, Math.min(n2, this.getLineCountWhole()));
        if (this.getCharCount() == 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        } else if (n > n2 - n3) {
            n = n2 - n3;
        }
        if (this.wordWrap) {
            int n4 = this.logicalContent.getOffsetAtLine(n);
            n = this.content.getLineAtOffset(n4);
        }
        this.setVerticalScrollOffset(n * this.getVerticalIncrement(), true);
    }

    public void setTopPixel(int n) {
        this.checkWidget();
        int n2 = this.content.getLineCount();
        int n3 = this.getClientArea().height;
        int n4 = Math.max(0, n2 * this.getVerticalIncrement() - n3);
        if (this.getCharCount() == 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        } else if (n > n4) {
            n = n4;
        }
        this.setVerticalScrollOffset(n, true);
    }

    boolean setVerticalScrollOffset(int n, boolean bl) {
        ScrollBar scrollBar = this.getVerticalBar();
        if (n == this.verticalScrollOffset) {
            return false;
        }
        if (scrollBar != null && bl) {
            scrollBar.setSelection(n);
        }
        Rectangle rectangle = this.getClientArea();
        this.scroll(0, 0, 0, n - this.verticalScrollOffset, rectangle.width, rectangle.height, true);
        this.verticalScrollOffset = n;
        this.calculateTopIndex();
        this.setCaretLocation();
        return true;
    }

    boolean showLocation(int n, int n2) {
        int n3 = this.getClientArea().width - this.leftMargin - this.rightMargin;
        int n4 = this.getVerticalIncrement();
        int n5 = n3 / 4;
        boolean bl = false;
        if (n < this.leftMargin) {
            n = Math.max(this.horizontalScrollOffset * -1, n - n5);
            bl = this.scrollHorizontalBar(n);
        } else if (n >= n3) {
            n = Math.min(this.lineCache.getWidth() - this.horizontalScrollOffset, n + n5);
            bl = this.scrollHorizontalBar(n - n3);
        }
        if (n2 < this.topIndex) {
            bl = this.setVerticalScrollOffset(n2 * n4, true);
        } else if (n2 > this.getBottomIndex()) {
            bl = this.setVerticalScrollOffset((n2 + 1) * n4 - this.getClientArea().height, true);
        }
        return bl;
    }

    void showCaret() {
        int n = this.content.getLineAtOffset(this.caretOffset);
        this.showCaret(n);
    }

    void showCaret(int n) {
        int n2;
        int n3 = this.content.getOffsetAtLine(n);
        String string = this.content.getLine(n);
        int n4 = this.caretOffset - n3;
        int n5 = this.getXAtOffset(string, n, n4);
        boolean bl = this.showLocation(n5, n);
        boolean bl2 = false;
        Caret caret = this.getCaret();
        if (this.wordWrap && caret != null && ((n2 = caret.getLocation().y) + this.verticalScrollOffset) / this.getVerticalIncrement() - 1 != n) {
            bl2 = true;
        }
        if (!bl || bl2) {
            this.setCaretLocation(n5, n);
        }
        if (this.isBidi()) {
            this.setBidiKeyboardLanguage();
        }
    }

    void showOffset(int n) {
        int n2 = this.content.getLineAtOffset(n);
        int n3 = this.content.getOffsetAtLine(n2);
        int n4 = n - n3;
        String string = this.content.getLine(n2);
        int n5 = this.getXAtOffset(string, n2, n4);
        this.showLocation(n5, n2);
    }

    public void showSelection() {
        boolean bl;
        int n;
        int n2;
        boolean bl2;
        this.checkWidget();
        boolean bl3 = bl2 = this.caretOffset == this.selection.x;
        if (bl2) {
            n2 = this.selection.y;
            n = this.selection.x;
        } else {
            n2 = this.selection.x;
            n = this.selection.y;
        }
        int n3 = this.content.getLineAtOffset(n2);
        int n4 = n2 - this.content.getOffsetAtLine(n3);
        int n5 = this.getXAtOffset(this.content.getLine(n3), n3, n4);
        int n6 = this.content.getLineAtOffset(n);
        n4 = n - this.content.getOffsetAtLine(n6);
        int n7 = this.getXAtOffset(this.content.getLine(n6), n6, n4);
        int n8 = this.getClientArea().width;
        if (bl2) {
            bl = n5 - n7 <= n8;
        } else {
            boolean bl4 = bl = n7 - n5 <= n8;
        }
        if (bl) {
            this.showLocation(n5, n3);
            n7 = this.getXAtOffset(this.content.getLine(n6), n6, n4);
            this.showLocation(n7, n6);
        } else {
            this.showLocation(n7, n6);
        }
    }

    void updateBidiDirection(boolean bl, boolean bl2) {
        this.lastCaretDirection = bl2 ? (bl ? 0x1000004 : 0x1000003) : (bl ? 0x1000003 : 0x1000004);
    }

    void updateSelection(int n, int n2, int n3) {
        if (this.selection.y <= n) {
            return;
        }
        if (this.selection.x < n) {
            this.internalRedrawRange(this.selection.x, n - this.selection.x, true);
        }
        if (this.selection.y > n + n2 && this.selection.x < n + n2) {
            int n4 = n3 - n2;
            int n5 = n + n3;
            this.internalRedrawRange(n5, this.selection.y + n4 - n5, true);
        }
        if (this.selection.y > n && this.selection.x < n + n2) {
            this.internalSetSelection(n + n3, 0, true);
            this.setCaretLocation();
        } else {
            this.internalSetSelection(this.selection.x + n3 - n2, this.selection.y - this.selection.x, true);
            this.setCaretLocation();
        }
    }

    void wordWrapResize(int n) {
        WrappedContent wrappedContent = (WrappedContent)this.content;
        if (n != 0 && this.clientAreaWidth > n && wrappedContent.getLineCount() == this.logicalContent.getLineCount()) {
            return;
        }
        wrappedContent.wrapLines();
        int n2 = this.content.getLineAtOffset(this.topOffset);
        if (n2 < this.content.getLineCount() - 1 && this.topOffset == this.content.getOffsetAtLine(n2 + 1)) {
            ++n2;
        }
        if (n2 != this.topIndex) {
            ScrollBar scrollBar = this.getVerticalBar();
            this.verticalScrollOffset += (n2 - this.topIndex) * this.getVerticalIncrement();
            if (this.verticalScrollOffset < 0) {
                this.verticalScrollOffset = 0;
            }
            this.topIndex = n2;
            this.topOffset = this.content.getOffsetAtLine(this.topIndex);
            if (scrollBar != null) {
                scrollBar.setSelection(this.verticalScrollOffset);
            }
        }
        this.setCaretLocation();
        super.redraw();
    }

    class Printing
    implements Runnable {
        static final int LEFT = 0;
        static final int CENTER = 1;
        static final int RIGHT = 2;
        Printer printer;
        PrintRenderer renderer;
        StyledTextPrintOptions printOptions;
        StyledTextContent printerContent;
        Rectangle clientArea;
        Font printerFont;
        FontData displayFontData;
        Hashtable printerColors;
        Hashtable lineBackgrounds = new Hashtable();
        Hashtable lineStyles = new Hashtable();
        Hashtable bidiSegments = new Hashtable();
        GC gc;
        int pageWidth;
        int startPage;
        int endPage;
        int pageSize;
        int startLine;
        int endLine;
        boolean singleLine;
        Point selection = null;

        Printing(StyledText styledText2, Printer printer, StyledTextPrintOptions styledTextPrintOptions) {
            PrinterData printerData = printer.getPrinterData();
            this.printer = printer;
            this.printOptions = styledTextPrintOptions;
            this.singleLine = styledText2.isSingleLine();
            this.startPage = 1;
            this.endPage = Integer.MAX_VALUE;
            if (printerData.scope == 1) {
                this.startPage = printerData.startPage;
                this.endPage = printerData.endPage;
                if (this.endPage < this.startPage) {
                    int n = this.endPage;
                    this.endPage = this.startPage;
                    this.startPage = n;
                }
            }
            if (printerData.scope == 2) {
                this.selection = styledText2.getSelectionRange();
            }
            this.displayFontData = StyledText.this.getFont().getFontData()[0];
            this.copyContent(styledText2.getContent());
            this.cacheLineData(this.printerContent);
        }

        void cacheBidiSegments(int n, String string) {
            int[] nArray = StyledText.this.getBidiSegments(n, string);
            if (nArray != null) {
                this.bidiSegments.put(new Integer(n), nArray);
            }
        }

        void cacheLineBackground(int n, String string) {
            StyledTextEvent styledTextEvent = StyledText.this.getLineBackgroundData(n, string);
            if (styledTextEvent != null) {
                this.lineBackgrounds.put(new Integer(n), styledTextEvent);
            }
        }

        void cacheLineData(StyledTextContent styledTextContent) {
            int n = 0;
            while (n < styledTextContent.getLineCount()) {
                int n2 = styledTextContent.getOffsetAtLine(n);
                String string = styledTextContent.getLine(n);
                if (this.printOptions.printLineBackground) {
                    this.cacheLineBackground(n2, string);
                }
                if (this.printOptions.printTextBackground || this.printOptions.printTextForeground || this.printOptions.printTextFontStyle) {
                    this.cacheLineStyle(n2, string);
                }
                if (StyledText.this.isBidi()) {
                    this.cacheBidiSegments(n2, string);
                }
                ++n;
            }
        }

        void cacheLineStyle(int n, String string) {
            StyledTextEvent styledTextEvent = StyledText.this.getLineStyleData(n, string);
            if (styledTextEvent != null) {
                StyleRange[] styleRangeArray = styledTextEvent.styles;
                int n2 = 0;
                while (n2 < styleRangeArray.length) {
                    StyleRange styleRange = null;
                    if (!this.printOptions.printTextBackground && styleRangeArray[n2].background != null) {
                        styleRange = (StyleRange)styleRangeArray[n2].clone();
                        styleRange.background = null;
                    }
                    if (!this.printOptions.printTextForeground && styleRangeArray[n2].foreground != null) {
                        if (styleRange == null) {
                            styleRange = (StyleRange)styleRangeArray[n2].clone();
                        }
                        styleRange.foreground = null;
                    }
                    if (!this.printOptions.printTextFontStyle && styleRangeArray[n2].fontStyle != 0) {
                        if (styleRange == null) {
                            styleRange = (StyleRange)styleRangeArray[n2].clone();
                        }
                        styleRange.fontStyle = 0;
                    }
                    if (styleRange != null) {
                        styleRangeArray[n2] = styleRange;
                    }
                    ++n2;
                }
                this.lineStyles.put(new Integer(n), styledTextEvent);
            }
        }

        void copyContent(StyledTextContent styledTextContent) {
            int n = 0;
            this.printerContent = new DefaultContent();
            int n2 = 0;
            while (n2 < styledTextContent.getLineCount()) {
                int n3 = n2 < styledTextContent.getLineCount() - 1 ? styledTextContent.getOffsetAtLine(n2 + 1) : styledTextContent.getCharCount();
                this.printerContent.replaceTextRange(n, 0, styledTextContent.getTextRange(n, n3 - n));
                n = n3;
                ++n2;
            }
        }

        void createPrinterColors() {
            StyledTextEvent styledTextEvent;
            Enumeration enumeration = this.lineBackgrounds.elements();
            this.printerColors = new Hashtable();
            while (enumeration.hasMoreElements()) {
                styledTextEvent = (StyledTextEvent)enumeration.nextElement();
                styledTextEvent.lineBackground = this.getPrinterColor(styledTextEvent.lineBackground);
            }
            enumeration = this.lineStyles.elements();
            while (enumeration.hasMoreElements()) {
                styledTextEvent = (StyledTextEvent)enumeration.nextElement();
                int n = 0;
                while (n < styledTextEvent.styles.length) {
                    StyleRange styleRange = styledTextEvent.styles[n];
                    Color color = this.getPrinterColor(styleRange.background);
                    Color color2 = this.getPrinterColor(styleRange.foreground);
                    if (color != styleRange.background || color2 != styleRange.foreground) {
                        styleRange = (StyleRange)styleRange.clone();
                        styleRange.background = color;
                        styleRange.foreground = color2;
                        styledTextEvent.styles[n] = styleRange;
                    }
                    ++n;
                }
            }
        }

        void dispose() {
            if (this.printerColors != null) {
                Enumeration enumeration = this.printerColors.elements();
                while (enumeration.hasMoreElements()) {
                    Color color = (Color)enumeration.nextElement();
                    color.dispose();
                }
                this.printerColors = null;
            }
            if (this.gc != null) {
                this.gc.dispose();
                this.gc = null;
            }
            if (this.printerFont != null) {
                this.printerFont.dispose();
                this.printerFont = null;
            }
            if (this.renderer != null) {
                this.renderer.dispose();
                this.renderer = null;
            }
        }

        void endPage(int n) {
            this.printDecoration(n, false);
            this.printer.endPage();
        }

        void initializeRenderer() {
            Rectangle rectangle = this.printer.computeTrim(0, 0, 0, 0);
            Point point = this.printer.getDPI();
            this.printerFont = new Font(this.printer, this.displayFontData.getName(), this.displayFontData.getHeight(), 0);
            this.clientArea = this.printer.getClientArea();
            this.pageWidth = this.clientArea.width;
            this.clientArea.x = point.x + rectangle.x;
            this.clientArea.y = point.y + rectangle.y;
            this.clientArea.width -= this.clientArea.x + rectangle.width;
            this.clientArea.height -= this.clientArea.y + rectangle.height;
            this.gc = new GC(this.printer);
            this.gc.setFont(this.printerFont);
            this.renderer = new PrintRenderer(this.printer, this.printerFont, StyledText.this.isBidi(), this.gc, this.printerContent, this.lineBackgrounds, this.lineStyles, this.bidiSegments, StyledText.this.tabLength, this.clientArea);
            if (this.printOptions.header != null) {
                int n = this.renderer.getLineHeight();
                this.clientArea.y += n * 2;
                this.clientArea.height -= n * 2;
            }
            if (this.printOptions.footer != null) {
                this.clientArea.height -= this.renderer.getLineHeight() * 2;
            }
            this.pageSize = this.clientArea.height / this.renderer.getLineHeight();
            StyledTextContent styledTextContent = this.renderer.getContent();
            this.startLine = 0;
            this.endLine = styledTextContent.getLineCount() - 1;
            PrinterData printerData = this.printer.getPrinterData();
            if (printerData.scope == 1) {
                this.startLine = (this.startPage - 1) * this.pageSize;
            } else if (printerData.scope == 2) {
                this.startLine = styledTextContent.getLineAtOffset(this.selection.x);
                this.endLine = this.selection.y > 0 ? styledTextContent.getLineAtOffset(this.selection.x + this.selection.y - 1) : this.startLine - 1;
            }
        }

        Color getPrinterColor(Color color) {
            Color color2 = null;
            if (color != null && (color2 = (Color)this.printerColors.get(color)) == null) {
                color2 = new Color(this.printer, color.getRGB());
                this.printerColors.put(color, color2);
            }
            return color2;
        }

        void print() {
            StyledTextContent styledTextContent = this.renderer.getContent();
            Color color = this.gc.getBackground();
            Color color2 = this.gc.getForeground();
            int n = this.renderer.getLineHeight();
            int n2 = styledTextContent.getLineCount();
            int n3 = this.clientArea.y;
            int n4 = this.startPage;
            if (this.singleLine) {
                n2 = 1;
            }
            int n5 = this.startLine;
            while (n5 <= this.endLine && n4 <= this.endPage) {
                String string = styledTextContent.getLine(n5);
                if (n3 == this.clientArea.y) {
                    this.startPage(n4);
                }
                ControlCharRenderer controlCharRenderer = new ControlCharRenderer();
                this.renderer.drawLine(string, n5, n3, this.gc, color, color2, true, controlCharRenderer);
                if (n3 + n * 2 > this.clientArea.y + this.clientArea.height) {
                    this.endPage(n4);
                    n3 = this.clientArea.y - n;
                    if (++n4 > this.endPage || n5 == n2 - 1) break;
                }
                ++n5;
                n3 += n;
            }
            if (n3 > this.clientArea.y && n3 <= this.clientArea.y + this.clientArea.height) {
                this.endPage(n4);
            }
        }

        void printDecoration(int n, boolean bl) {
            int n2 = 0;
            String string = bl ? this.printOptions.header : this.printOptions.footer;
            if (string == null) {
                return;
            }
            int n3 = 0;
            while (n3 < 3) {
                String string2;
                int n4 = string.indexOf("\t", n2);
                if (n4 == -1) {
                    string2 = string.substring(n2);
                    this.printDecorationSegment(string2, n3, n, bl);
                    break;
                }
                string2 = string.substring(n2, n4);
                this.printDecorationSegment(string2, n3, n, bl);
                n2 = n4 + "\t".length();
                ++n3;
            }
        }

        void printDecorationSegment(String string, int n, int n2, boolean bl) {
            int n3;
            int n4 = string.indexOf("<page>");
            if (n4 != -1) {
                n3 = "<page>".length();
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.replace(n4, n4 + n3, new Integer(n2).toString());
                string = stringBuffer.toString();
            }
            if (string.length() > 0) {
                int n5 = 0;
                StyledTextBidi styledTextBidi = null;
                if (StyledText.this.isBidi()) {
                    int[] nArray = new int[2];
                    nArray[1] = string.length();
                    styledTextBidi = new StyledTextBidi(this.gc, StyledText.this.tabLength, string, null, null, nArray);
                    n3 = styledTextBidi.getTextWidth();
                } else {
                    n3 = this.gc.textExtent((String)string).x;
                }
                int n6 = bl ? this.clientArea.y - this.renderer.getLineHeight() * 2 : this.clientArea.y + this.clientArea.height + this.renderer.getLineHeight();
                if (n == 0) {
                    n5 = this.clientArea.x;
                } else if (n == 1) {
                    n5 = (this.pageWidth - n3) / 2;
                } else if (n == 2) {
                    n5 = this.clientArea.x + this.clientArea.width - n3;
                }
                if (styledTextBidi != null) {
                    styledTextBidi.drawBidiText(0, string.length(), n5, n6);
                } else {
                    this.gc.drawString(string, n5, n6, true);
                }
            }
        }

        public void run() {
            String string = this.printOptions.jobName;
            if (string == null) {
                string = "Printing";
            }
            if (this.printer.startJob(string)) {
                this.createPrinterColors();
                this.initializeRenderer();
                this.print();
                this.dispose();
                this.printer.endJob();
            }
        }

        void startPage(int n) {
            this.printer.startPage();
            this.printDecoration(n, true);
        }
    }

    class RTFWriter
    extends TextWriter {
        final int DEFAULT_FOREGROUND = 0;
        final int DEFAULT_BACKGROUND = 1;
        Vector colorTable = new Vector();
        boolean WriteUnicode;

        public RTFWriter(int n, int n2) {
            super(n, n2);
            this.colorTable.addElement(StyledText.this.getForeground());
            this.colorTable.addElement(StyledText.this.getBackground());
            this.setUnicode();
        }

        public void close() {
            if (!this.isClosed()) {
                this.writeHeader();
                this.write("\n}}\u0000");
                super.close();
            }
        }

        int getColorIndex(Color color, int n) {
            int n2;
            if (color == null) {
                n2 = n;
            } else {
                n2 = this.colorTable.indexOf(color);
                if (n2 == -1) {
                    n2 = this.colorTable.size();
                    this.colorTable.addElement(color);
                }
            }
            return n2;
        }

        void setUnicode() {
            int n;
            String string = System.getProperty("os.name").toLowerCase();
            String string2 = System.getProperty("os.version");
            int n2 = 0;
            if (string.startsWith("windows nt") && string2 != null && (n = string2.indexOf(46)) != -1) {
                string2 = string2.substring(0, n);
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.WriteUnicode = string != null && !string.startsWith("windows 95") && !string.startsWith("windows 98") && !string.startsWith("windows me") && (!string.startsWith("windows nt") || n2 > 4);
        }

        void write(String string, int n, int n2) {
            int n3 = n;
            while (n3 < n2) {
                char c = string.charAt(n3);
                if (c > '\u00ff' && this.WriteUnicode) {
                    if (n3 > n) {
                        this.write(string.substring(n, n3));
                    }
                    this.write("\\u");
                    this.write(Integer.toString((short)c));
                    this.write(' ');
                    n = n3 + 1;
                } else if (c == '}' || c == '{' || c == '\\') {
                    if (n3 > n) {
                        this.write(string.substring(n, n3));
                    }
                    this.write('\\');
                    this.write(c);
                    n = n3 + 1;
                }
                ++n3;
            }
            if (n < n2) {
                this.write(string.substring(n, n2));
            }
        }

        void writeHeader() {
            StringBuffer stringBuffer = new StringBuffer();
            FontData fontData = StyledText.this.getFont().getFontData()[0];
            stringBuffer.append("{\\rtf1\\ansi");
            String string = System.getProperty("file.encoding").toLowerCase();
            if (string.startsWith("cp") || string.startsWith("ms")) {
                string = string.substring(2, string.length());
                stringBuffer.append("\\ansicpg");
                stringBuffer.append(string);
            }
            stringBuffer.append("\\uc0\\deff0{\\fonttbl{\\f0\\fnil ");
            stringBuffer.append(fontData.getName());
            stringBuffer.append(";}}\n{\\colortbl");
            int n = 0;
            while (n < this.colorTable.size()) {
                Color color = (Color)this.colorTable.elementAt(n);
                stringBuffer.append("\\red");
                stringBuffer.append(color.getRed());
                stringBuffer.append("\\green");
                stringBuffer.append(color.getGreen());
                stringBuffer.append("\\blue");
                stringBuffer.append(color.getBlue());
                stringBuffer.append(";");
                ++n;
            }
            stringBuffer.append("}\n{\\f0\\fs");
            stringBuffer.append(fontData.getHeight() * 2);
            stringBuffer.append(" ");
            this.write(stringBuffer.toString(), 0);
        }

        public void writeLine(String string, int n) {
            StyledTextEvent styledTextEvent;
            StyleRange[] styleRangeArray = new StyleRange[]{};
            Color color = null;
            if (this.isClosed()) {
                SWT.error(39);
            }
            if ((styledTextEvent = StyledText.this.renderer.getLineStyleData(n, string)) != null) {
                styleRangeArray = styledTextEvent.styles;
            }
            if ((styledTextEvent = StyledText.this.renderer.getLineBackgroundData(n, string)) != null) {
                color = styledTextEvent.lineBackground;
            }
            if (color == null) {
                color = StyledText.this.getBackground();
            }
            this.writeStyledLine(string, n, styleRangeArray, color);
        }

        public void writeLineDelimiter(String string) {
            if (this.isClosed()) {
                SWT.error(39);
            }
            this.write(string, 0, string.length());
            this.write("\\par ");
        }

        void writeStyledLine(String string, int n, StyleRange[] styleRangeArray, Color color) {
            int n2 = string.length();
            int n3 = this.getStart();
            int n4 = n3 + super.getCharCount();
            int n5 = Math.min(n2, n4 - n);
            int n6 = n3 - n;
            if (n6 >= string.length()) {
                return;
            }
            int n7 = n6 > 0 ? n6 : 0;
            if (color != null) {
                this.write("{\\highlight");
                this.write(this.getColorIndex(color, 1));
                this.write(" ");
            }
            int n8 = 0;
            while (n8 < styleRangeArray.length) {
                StyleRange styleRange = styleRangeArray[n8];
                int n9 = styleRange.start - n;
                int n10 = n9 + styleRange.length;
                if (n10 >= n6) {
                    if (n9 >= n5) break;
                    if (n7 < n9) {
                        this.write(string, n7, n9);
                        n7 = n9;
                    }
                    int n11 = this.getColorIndex(styleRange.background, 1);
                    this.write("{\\cf");
                    this.write(this.getColorIndex(styleRange.foreground, 0));
                    if (n11 != 1) {
                        this.write("\\highlight");
                        this.write(n11);
                    }
                    if (styleRange.fontStyle == 1) {
                        this.write("\\b");
                    }
                    this.write(" ");
                    int n12 = Math.min(n10, n5);
                    n12 = Math.max(n12, n7);
                    this.write(string, n7, n12);
                    if (styleRange.fontStyle == 1) {
                        this.write("\\b0");
                    }
                    this.write("}");
                    n7 = n12;
                }
                ++n8;
            }
            if (n7 < n5) {
                this.write(string, n7, n5);
            }
            if (color != null) {
                this.write("}");
            }
        }
    }

    class TextWriter {
        private StringBuffer buffer;
        private int startOffset;
        private int endOffset;
        private boolean isClosed = false;

        public TextWriter(int n, int n2) {
            this.buffer = new StringBuffer(n2);
            this.startOffset = n;
            this.endOffset = n + n2;
        }

        public void close() {
            if (!this.isClosed) {
                this.isClosed = true;
            }
        }

        public int getCharCount() {
            return this.endOffset - this.startOffset;
        }

        public int getStart() {
            return this.startOffset;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public String toString() {
            return this.buffer.toString();
        }

        void write(String string) {
            this.buffer.append(string);
        }

        void write(String string, int n) {
            if (n < 0 || n > this.buffer.length()) {
                return;
            }
            this.buffer.insert(n, string);
        }

        void write(int n) {
            this.buffer.append(n);
        }

        void write(char c) {
            this.buffer.append(c);
        }

        public void writeLine(String string, int n) {
            int n2;
            int n3 = string.length();
            int n4 = this.startOffset - n;
            if (this.isClosed) {
                SWT.error(39);
            }
            if (n4 >= n3) {
                return;
            }
            int n5 = n4 > 0 ? n4 : 0;
            if (n5 < (n2 = Math.min(n3, this.endOffset - n))) {
                this.write(string.substring(n5, n2));
            }
        }

        public void writeLineDelimiter(String string) {
            if (this.isClosed) {
                SWT.error(39);
            }
            this.write(string);
        }
    }

    interface LineCache {
        public void calculate(int var1, int var2);

        public int getWidth();

        public void redrawReset(int var1, int var2, boolean var3);

        public void reset(int var1, int var2, boolean var3);

        public void textChanged(int var1, int var2, int var3, int var4, int var5);
    }

    class ContentWidthCache
    implements LineCache {
        StyledText parent;
        int[] lineWidth;
        int lineCount;
        int maxWidth;
        int maxWidthLineIndex;

        public ContentWidthCache(StyledText styledText2, int n) {
            this.lineCount = n;
            this.parent = styledText2;
            this.lineWidth = new int[n];
            this.reset(0, n, false);
        }

        public void calculate(int n, int n2) {
            GC gC = null;
            int n3 = 0;
            int n4 = n + n2;
            int n5 = n;
            while (n5 < n4) {
                if (this.lineWidth[n5] == -1) {
                    String string = StyledText.this.content.getLine(n5);
                    int n6 = StyledText.this.content.getOffsetAtLine(n5);
                    if (gC == null) {
                        gC = this.parent.getGC();
                        n3 = StyledText.this.getCaretWidth();
                    }
                    this.lineWidth[n5] = this.contentWidth(string, n6, gC) + n3;
                }
                if (this.lineWidth[n5] > this.maxWidth) {
                    this.maxWidth = this.lineWidth[n5];
                    this.maxWidthLineIndex = n5;
                }
                ++n5;
            }
            if (gC != null) {
                gC.dispose();
            }
        }

        void calculateVisible(int n, int n2) {
            int n3 = this.parent.getTopIndex();
            int n4 = Math.min(StyledText.this.getPartialBottomIndex(), n + n2);
            n = Math.max(n, n3);
            this.calculate(n, n4 - n + 1);
        }

        int contentWidth(String string, int n, GC gC) {
            int n2;
            if (StyledText.this.isBidi()) {
                StyledTextBidi styledTextBidi = StyledText.this.getStyledTextBidi(string, n, gC);
                n2 = styledTextBidi.getTextWidth();
            } else {
                StyledTextEvent styledTextEvent = StyledText.this.renderer.getLineStyleData(n, string);
                StyleRange[] styleRangeArray = null;
                if (styledTextEvent != null) {
                    styleRangeArray = StyledText.this.renderer.filterLineStyles(styledTextEvent.styles);
                }
                n2 = StyledText.this.renderer.getTextWidth(string, n, 0, string.length(), styleRangeArray, 0, gC);
            }
            return n2 + StyledText.this.leftMargin;
        }

        void expandLines(int n) {
            int n2 = this.lineWidth.length;
            if (n2 - this.lineCount >= n) {
                return;
            }
            int[] nArray = new int[Math.max(n2 * 2, n2 + n)];
            System.arraycopy(this.lineWidth, 0, nArray, 0, n2);
            this.lineWidth = nArray;
            this.reset(n2, this.lineWidth.length - n2, false);
        }

        public int getWidth() {
            return this.maxWidth;
        }

        void linesChanged(int n, int n2) {
            boolean bl;
            boolean bl2 = bl = n2 > 0;
            if (n2 == 0) {
                return;
            }
            if (bl) {
                this.expandLines(n2);
                int n3 = this.lineCount - 1;
                while (n3 >= n) {
                    this.lineWidth[n3 + n2] = this.lineWidth[n3];
                    --n3;
                }
                n3 = n + 1;
                while (n3 <= n + n2 && n3 < this.lineWidth.length) {
                    this.lineWidth[n3] = -1;
                    ++n3;
                }
                if (this.maxWidthLineIndex >= n) {
                    this.maxWidthLineIndex += n2;
                }
            } else {
                int n4 = n - n2;
                while (n4 < this.lineCount) {
                    this.lineWidth[n4 + n2] = this.lineWidth[n4];
                    ++n4;
                }
                if (this.maxWidthLineIndex > n && this.maxWidthLineIndex <= n - n2) {
                    this.maxWidth = 0;
                    this.maxWidthLineIndex = -1;
                } else if (this.maxWidthLineIndex >= n - n2) {
                    this.maxWidthLineIndex += n2;
                }
            }
            this.lineCount += n2;
        }

        public void redrawReset(int n, int n2, boolean bl) {
            this.reset(n, n2, bl);
        }

        public void reset(int n, int n2, boolean bl) {
            int n3 = n + n2;
            if (n < 0 || n3 > this.lineWidth.length) {
                return;
            }
            int n4 = n;
            while (n4 < n3) {
                this.lineWidth[n4] = -1;
                ++n4;
            }
            if (this.maxWidthLineIndex >= n && this.maxWidthLineIndex < n3) {
                this.maxWidth = 0;
                this.maxWidthLineIndex = -1;
                if (bl) {
                    n4 = 0;
                    while (n4 < n2) {
                        if (this.lineWidth[n4] > this.maxWidth) {
                            this.maxWidth = this.lineWidth[n4];
                            this.maxWidthLineIndex = n4;
                        }
                        ++n4;
                    }
                }
            }
        }

        public void textChanged(int n, int n2, int n3, int n4, int n5) {
            boolean bl;
            int n6 = this.parent.getLineAtOffset(n);
            boolean bl2 = bl = this.maxWidthLineIndex > n6 && this.maxWidthLineIndex <= n6 + n3;
            if (n6 == 0 && n3 == this.lineCount) {
                this.lineCount = n2;
                this.lineWidth = new int[this.lineCount];
                this.reset(0, this.lineCount, false);
                this.maxWidth = 0;
            } else {
                this.linesChanged(n6, -n3);
                this.linesChanged(n6, n2);
                this.lineWidth[n6] = -1;
            }
            this.calculateVisible(n6, n2);
            if (bl || this.maxWidthLineIndex != -1 && this.lineWidth[this.maxWidthLineIndex] < this.maxWidth) {
                this.maxWidth = 0;
                int n7 = 0;
                while (n7 < this.lineCount) {
                    if (this.lineWidth[n7] > this.maxWidth) {
                        this.maxWidth = this.lineWidth[n7];
                        this.maxWidthLineIndex = n7;
                    }
                    ++n7;
                }
            }
        }
    }

    class WordWrapCache
    implements LineCache {
        StyledText parent;
        WrappedContent visualContent;

        public WordWrapCache(StyledText styledText2, WrappedContent wrappedContent) {
            this.parent = styledText2;
            this.visualContent = wrappedContent;
            this.visualContent.wrapLines();
        }

        public void calculate(int n, int n2) {
        }

        public int getWidth() {
            return this.parent.getClientArea().width;
        }

        public void redrawReset(int n, int n2, boolean bl) {
            if (n2 == this.visualContent.getLineCount()) {
                this.visualContent.wrapLines();
            } else {
                this.visualContent.reset(n, n2);
            }
        }

        public void reset(int n, int n2, boolean bl) {
            int n3 = StyledText.this.getPartialBottomIndex() - StyledText.this.topIndex + 1;
            int[] nArray = new int[n3];
            int n4 = 0;
            while (n4 < n3) {
                nArray[n4] = this.visualContent.getOffsetAtLine(n4 + StyledText.this.topIndex);
                ++n4;
            }
            this.redrawReset(n, n2, bl);
            if (StyledText.this.getPartialBottomIndex() - StyledText.this.topIndex + 1 != n3) {
                this.parent.internalRedraw();
            } else {
                n4 = 0;
                while (n4 < n3) {
                    if (this.visualContent.getOffsetAtLine(n4 + StyledText.this.topIndex) != nArray[n4]) {
                        this.parent.internalRedraw();
                        break;
                    }
                    ++n4;
                }
            }
        }

        public void textChanged(int n, int n2, int n3, int n4, int n5) {
            int n6 = this.visualContent.getLineAtOffset(n);
            this.visualContent.textChanged(n, n2, n3, n4, n5);
            if (n6 <= StyledText.this.getPartialBottomIndex()) {
                this.parent.internalRedraw();
            }
        }
    }
}

