/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.swt.ccs.preferences;

import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import jp.sourceforge.jeextension.common.plugin.DefaultPreferencePage;
import jp.sourceforge.jeextension.swt.ccs.SWTCCSPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;

public class SWTCCSPreferencePage
extends DefaultPreferencePage {
    private static final String[] COLOR_ITEMS = new String[]{"COLOR_WHITE", "COLOR_BLACK", "COLOR_RED", "COLOR_DARK_RED", "COLOR_GREEN", "COLOR_DARK_GREEN", "COLOR_YELLOW", "COLOR_DARK_YELLOW", "COLOR_BLUE", "COLOR_DARK_BLUE", "COLOR_MAGENTA", "COLOR_DARK_MAGENTA", "COLOR_CYAN", "COLOR_DARK_CYAN", "COLOR_GRAY", "COLOR_DARK_GRAY"};
    private static final String COLOR_ALL = "jeex.all.color";
    private static final String COLOR_LNB = "jeex.lf.color";
    private static final String COLOR_EOF = "jeex.eof.color";
    private static final String COLOR_TAB = "jeex.tab.color";
    private static final String COLOR_FWS = "jeex.fws.color";
    private static final String ENABLE_ALL = "jeex.all.enable";
    private static final String ENABLE_LNB = "jeex.lf.enable";
    private static final String ENABLE_EOF = "jeex.eof.enable";
    private static final String ENABLE_TAB = "jeex.tab.enable";
    private static final String ENABLE_FWS = "jeex.fws.enable";
    public static final String[] PROPERTY_KEYS = new String[]{"jeex.all.color", "jeex.eof.color", "jeex.fws.color", "jeex.lf.color", "jeex.tab.color", "jeex.all.enable", "jeex.eof.enable", "jeex.fws.enable", "jeex.lf.enable", "jeex.tab.enable"};
    private Button fBtnEOF;
    private Button fBtnFWS;
    private Button fBtnLNB;
    private Button fBtnTAB;
    private Combo fCmbEOF;
    private Combo fCmbFWS;
    private Combo fCmbLNB;
    private Combo fCmbTAB;
    private static Properties fSetting = SWTCCSPlugin.getProperties();

    public SWTCCSPreferencePage() {
        this.setPreferenceStore(SWTCCSPlugin.getDefault().getPreferenceStore());
        this.setDescription(this.getMessage("pref.desc"));
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        this.fBtnLNB = new Button(container, 32);
        this.fBtnLNB.setText(this.getMessage("pref.linebreak"));
        this.fBtnLNB.addListener(13, (Listener)this);
        Label labelLB = new Label(container, 0);
        labelLB.setText(this.getMessage("pref.color"));
        this.fCmbLNB = new Combo(container, 8);
        this.fCmbLNB.setItems(COLOR_ITEMS);
        this.fBtnTAB = new Button(container, 32);
        this.fBtnTAB.setText(this.getMessage("pref.tab"));
        this.fBtnTAB.addListener(13, (Listener)this);
        Label labelTAB = new Label(container, 0);
        labelTAB.setText(this.getMessage("pref.color"));
        this.fCmbTAB = new Combo(container, 8);
        this.fCmbTAB.setItems(COLOR_ITEMS);
        this.fBtnEOF = new Button(container, 32);
        this.fBtnEOF.setText(this.getMessage("pref.eof"));
        this.fBtnEOF.addListener(13, (Listener)this);
        Label labelEOF = new Label(container, 0);
        labelEOF.setText(this.getMessage("pref.color"));
        this.fCmbEOF = new Combo(container, 8);
        this.fCmbEOF.setItems(COLOR_ITEMS);
        this.fBtnFWS = new Button(container, 32);
        this.fBtnFWS.setText(this.getMessage("pref.fws"));
        this.fBtnFWS.addListener(13, (Listener)this);
        Label labelFWS = new Label(container, 0);
        labelFWS.setText(this.getMessage("pref.color"));
        this.fCmbFWS = new Combo(container, 8);
        this.fCmbFWS.setItems(COLOR_ITEMS);
        return container;
    }

    private int getComboIndex(String str) {
        int i = 0;
        while (i < COLOR_ITEMS.length) {
            if (COLOR_ITEMS[i].equals(str)) {
                return i;
            }
            ++i;
        }
        return 14;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.fBtnFWS) {
            this.fCmbFWS.setEnabled(this.fBtnFWS.getSelection());
        }
        if (event.widget == this.fBtnTAB) {
            this.fCmbTAB.setEnabled(this.fBtnTAB.getSelection());
        }
        if (event.widget == this.fBtnEOF) {
            this.fCmbEOF.setEnabled(this.fBtnEOF.getSelection());
        }
        if (event.widget == this.fBtnLNB) {
            this.fCmbLNB.setEnabled(this.fBtnLNB.getSelection());
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void performColor() {
        String s1 = this.fCmbFWS.getItem(this.fCmbFWS.getSelectionIndex());
        String s2 = this.fCmbTAB.getItem(this.fCmbTAB.getSelectionIndex());
        String s3 = this.fCmbEOF.getItem(this.fCmbEOF.getSelectionIndex());
        String s4 = this.fCmbLNB.getItem(this.fCmbLNB.getSelectionIndex());
        if (s2.equals(s1) && s3.equals(s1) && s4.equals(s1)) {
            fSetting.setProperty(COLOR_ALL, s1);
            fSetting.remove(COLOR_FWS);
            fSetting.remove(COLOR_TAB);
            fSetting.remove(COLOR_EOF);
            fSetting.remove(COLOR_LNB);
        } else {
            fSetting.remove(COLOR_ALL);
            fSetting.setProperty(COLOR_FWS, s1);
            fSetting.setProperty(COLOR_TAB, s2);
            fSetting.setProperty(COLOR_EOF, s3);
            fSetting.setProperty(COLOR_LNB, s4);
        }
        boolean b1 = this.fBtnFWS.getSelection();
        boolean b2 = this.fBtnTAB.getSelection();
        boolean b3 = this.fBtnEOF.getSelection();
        boolean b4 = this.fBtnLNB.getSelection();
        if (!(b1 || b2 || b3 || b4)) {
            fSetting.remove(COLOR_ALL);
            fSetting.remove(COLOR_FWS);
            fSetting.remove(COLOR_TAB);
            fSetting.remove(COLOR_EOF);
            fSetting.remove(COLOR_LNB);
        }
    }

    private void performEnable() {
        boolean b1 = this.fBtnFWS.getSelection();
        boolean b2 = this.fBtnTAB.getSelection();
        boolean b3 = this.fBtnEOF.getSelection();
        boolean b4 = this.fBtnLNB.getSelection();
        if (b1 && b2 && b3 && b4) {
            fSetting.setProperty(ENABLE_ALL, "true");
            fSetting.remove(ENABLE_FWS);
            fSetting.remove(ENABLE_TAB);
            fSetting.remove(ENABLE_EOF);
            fSetting.remove(ENABLE_LNB);
        } else if (!(b1 || b2 || b3 || b4)) {
            fSetting.remove(ENABLE_ALL);
            fSetting.remove(ENABLE_FWS);
            fSetting.remove(ENABLE_TAB);
            fSetting.remove(ENABLE_EOF);
            fSetting.remove(ENABLE_LNB);
        } else {
            fSetting.remove(ENABLE_ALL);
            fSetting.setProperty(ENABLE_FWS, String.valueOf(b1));
            fSetting.setProperty(ENABLE_TAB, String.valueOf(b2));
            fSetting.setProperty(ENABLE_EOF, String.valueOf(b3));
            fSetting.setProperty(ENABLE_LNB, String.valueOf(b4));
        }
    }

    public boolean performOk() {
        Object[] obj2;
        StyledText widget;
        Object[] obj1;
        this.performEnable();
        this.performColor();
        System.getProperties().put("jeex.swt.ccs", fSetting);
        Properties setting = SWTCCSPlugin.getProperties();
        IPreferenceStore store = this.getPreferenceStore();
        Iterator<Object> iterator1 = setting.keySet().iterator();
        while (iterator1.hasNext()) {
            String key = (String)iterator1.next();
            String val = setting.getProperty(key);
            store.setValue(key, val);
        }
        StyledText list = (StyledText)System.getProperties().get("jeex.swt.ccs.list");
        if (list == null) {
            list = new Vector();
            System.getProperties().put("jeex.swt.ccs.map", list);
        }
        StyledText styledText = list;
        synchronized (styledText) {
            obj1 = list.toArray();
        }
        int i = 0;
        while (i < obj1.length) {
            widget = (StyledText)obj1[i];
            if (widget.isDisposed()) {
                list.remove(widget);
            }
            ++i;
        }
        widget = list;
        synchronized (widget) {
            obj2 = list.toArray();
        }
        int i2 = 0;
        while (i2 < obj2.length) {
            StyledText widget2 = (StyledText)obj2[i2];
            widget2.redraw();
            ++i2;
        }
        return super.performOk();
    }

    public void setVisible(boolean visible) {
        String allColor;
        String eofEnable;
        String tabEnable;
        String fwsEnable;
        String lfEnable;
        String allEnable = fSetting.getProperty(ENABLE_ALL);
        if (allEnable != null) {
            boolean enable = Boolean.valueOf(allEnable);
            this.fBtnFWS.setSelection(enable);
            this.fBtnTAB.setSelection(enable);
            this.fBtnEOF.setSelection(enable);
            this.fBtnLNB.setSelection(enable);
        }
        if ((lfEnable = fSetting.getProperty(ENABLE_LNB)) != null) {
            this.fBtnLNB.setSelection(Boolean.valueOf(lfEnable).booleanValue());
        }
        if ((fwsEnable = fSetting.getProperty(ENABLE_FWS)) != null) {
            this.fBtnFWS.setSelection(Boolean.valueOf(fwsEnable).booleanValue());
        }
        if ((tabEnable = fSetting.getProperty(ENABLE_TAB)) != null) {
            this.fBtnTAB.setSelection(Boolean.valueOf(tabEnable).booleanValue());
        }
        if ((eofEnable = fSetting.getProperty(ENABLE_EOF)) != null) {
            this.fBtnEOF.setSelection(Boolean.valueOf(eofEnable).booleanValue());
        }
        if ((allColor = fSetting.getProperty(COLOR_ALL)) != null) {
            int i = this.getComboIndex(allColor);
            this.fCmbFWS.select(i);
            this.fCmbTAB.select(i);
            this.fCmbEOF.select(i);
            this.fCmbLNB.select(i);
        }
        String lnbColor = fSetting.getProperty(COLOR_LNB);
        this.fCmbLNB.select(this.getComboIndex(lnbColor));
        String fwsColor = fSetting.getProperty(COLOR_FWS);
        this.fCmbFWS.select(this.getComboIndex(fwsColor));
        String tabColor = fSetting.getProperty(COLOR_TAB);
        this.fCmbTAB.select(this.getComboIndex(tabColor));
        String eofColor = fSetting.getProperty(COLOR_EOF);
        this.fCmbEOF.select(this.getComboIndex(eofColor));
        this.fCmbFWS.setEnabled(this.fBtnFWS.getSelection());
        this.fCmbTAB.setEnabled(this.fBtnTAB.getSelection());
        this.fCmbEOF.setEnabled(this.fBtnEOF.getSelection());
        this.fCmbLNB.setEnabled(this.fBtnLNB.getSelection());
        super.setVisible(visible);
    }
}

