/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.swt.ccs/src/jp/sourceforge/jeextension/swt/ccs/SWTCCSPlugin.java,v 1.1 2005/01/17 08:48:20 kohnosuke Exp $
 * $Revision: 1.1 $
 * $Date: 2005/01/17 08:48:20 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.swt.ccs;

import java.util.Properties;

import jp.sourceforge.jeextension.swt.ccs.preferences.SWTCCSPreferencePage;

import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.preference.IPreferenceStore;


/**
 * SWTStyledTextSettingPlugin.
 */
public class SWTCCSPlugin extends AbstractUIPlugin implements IStartup {
    
    /** */
    private static SWTCCSPlugin fPlugin;
    
    /**
     * properties for ControlCharRenderer.
     */
    private static Properties fSetting = new Properties();
    
    /**
     * The constructor.
     */
    public SWTCCSPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        fPlugin = this;
    }
    
    /**
     * @see org.eclipse.ui.IStartup#earlyStartup()
     */
    public void earlyStartup() {
        String[] keys = SWTCCSPreferencePage.PROPERTY_KEYS;
        IPreferenceStore store = getPreferenceStore();
        for (int i = 0; i < keys.length; i++) {
            String val = store.getString(keys[i]);
            if (val != null) {
                fSetting.setProperty(keys[i], val);
            }
        }
        System.getProperties().put("jeex.swt.ccs", fSetting);
    }
    
    /**
     * Returns Properties for ControlCharRenderer.
     * @return  Properties for ControlCharRenderer
     */
    public static Properties getProperties() {
        return fSetting;
    }
    
    public static SWTCCSPlugin getDefault() {
        return fPlugin;
    }
}
