using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;
using Junk_XNA.Parts;
using DebugSample;
using System.Diagnostics;

namespace JF_Particle
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        #region  ЂɂXNA񂩂̃pN
        // fobO}l[W[
        DebugManager debugManager;

        // fobOR}hUI
        DebugCommandUI debugCommandUI;

        // FPSJE^[
        FpsCounter fpsCounter;

        // ^C[[
        TimeRuler timerRuler;

        // fobOR}heXgpW
        Vector2 debugPos = new Vector2(100, 100);

        // ^C[[eXgp̃XgbvEHb`
        Stopwatch stopwatch = new Stopwatch();


        #endregion

        #region ϐ錾
        /// <summary>xɕ`悳̍ől Billfx̒́@MAX_SHADER_INSTANCE_COUNT@ƓɂKv</summary>
        public const int instanseMax = 50;
        
        /// <summary>p[eBN̍ő吔</summary>
        public const int PatricleMax =3000;

        /// <summary>J̈ʒu</summary>
        Vector3 viewPosition = new Vector3(0, 0, -300);

        /// <summary>_iĂʒuj</summary>
        Vector3 viewingPos = new Vector3(0, 0, 00);

        //Rc`ɕKvȗ̃AB
        Matrix View;
        Matrix Projection;
        float aspectRatio;


        /// <summary>݂̃p[eBN̎gp</summary>
        private int particleUsing ;


        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        //F`NX
        public static clsMaterials clsMTs = new clsMaterials();

        /// <summary>`ςݗNX</summary>
        public static Randoms randoms = new Randoms();

        /// <summary>p[eBNXg</summary>
        public Particle[] particles = new Particle[PatricleMax];

        /// <summary>ZxpeNX`</summary>
        protected Texture2D AddBilltexture;

        /// <summary>\p̔wi</summary>
        Texture2D backB;

        /// <summary>r{[h`̃CƂĎg钸_obt@</summary>
        VertexBuffer MainVertexBuffer;
        /// <summary>r{[h̃CfbNXobt@ </summary>
        IndexBuffer indexBuffer;
        /// <summary>r{[h̒_f[^i </summary>
        VertexElementIndex[] vertices = new VertexElementIndex[4 * instanseMax];
        /// <summary>ȂɂH </summary>
        VertexDeclaration BillVD;

        /// <summary>HLSLo͗p}gNX</summary>
        Matrix[] OutHlslMX = new Matrix[instanseMax];


        /// <summary>r{[hGtFNgpGtFNg</summary>
        protected Effect BillEf;

        /// <summary>ڕWƂp[eBNBL[ł̂͂</summary>
        private int tgtUgingCount;

        /// <summary>
        /// `ptHg1@ʏp
        /// </summary>
        public static SpriteFont font_14 = null;

        /// <summary>fobO̕`ʒu</summary>
        Vector2 strPos = new Vector2(50, 50);

        /// <summary>wi\pGAwRectangle</summary>
        Rectangle strBackRec = new Rectangle(48, 48, 400, 20);

        /// <summary>wi\pF</summary>
        Color strBackCol = new Color(0, 0, 0, 128);

        String DebugStr = "now Particle:{0}s Drawing, Draw Call:{1}";
        #endregion

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here

            #region ЂɂXNA񂩂̃pN
            // fobO}l[W[̏ƒǉ
            debugManager = new DebugManager(this);
            Components.Add(debugManager);

            // fobO}R}hUȈƒǉ
            debugCommandUI = new DebugCommandUI(this);

            // fobOR}hUIŏʂɕ\ׂDrawOrderύX
            debugCommandUI.DrawOrder = 100;

            Components.Add(debugCommandUI);

            // FPSJE^[̏ƒǉ
            fpsCounter = new FpsCounter(this);
            Components.Add(fpsCounter);

            // ^C[[̏ƒǉ
            timerRuler = new TimeRuler(this);
            Components.Add(timerRuler);
            #endregion

            base.Initialize();

            //p[eBN̏
            tgtUgingCount = 100;
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            // TODO: use this.Content to load your game content here

            //eNX`ǂݍ
            AddBilltexture = Content.Load<Texture2D>("efe13");

            //GtFNgǂݍ
            BillEf = Content.Load<Effect>("Billfx");

            #region _̍쐬

            try
            {

                //_쐬
                for (int i = 0; i < instanseMax; i++)
                {
                    //
                    vertices[4 * i + 0].texcode = new Vector2(0, 0);
                    vertices[4 * i + 0].Position = new Vector3(-1f, 1f, 0);
                    vertices[4 * i + 0].Index = i;
                    //E
                    vertices[4 * i + 1].texcode = new Vector2(0.125f, 0);
                    vertices[4 * i + 1].Position = new Vector3(1f, 1f, 0);
                    vertices[4 * i + 1].Index = i;
                    //
                    vertices[4 * i + 2].texcode = new Vector2(0, 1);
                    vertices[4 * i + 2].Position = new Vector3(-1f, -1f, 0);
                    vertices[4 * i + 2].Index = i;
                    //E
                    vertices[4 * i + 3].texcode = new Vector2(0.125f,1);
                    vertices[4 * i + 3].Position = new Vector3(1f, -1f, 0);
                    vertices[4 * i + 3].Index = i;
                }

                MainVertexBuffer = new VertexBuffer(
                    GraphicsDevice,
                    VertexElementIndex.SizeInBytes * vertices.Length, BufferUsage.None);

                MainVertexBuffer.SetData<VertexElementIndex>(vertices);

                BillVD = new VertexDeclaration(
                    GraphicsDevice,
                    VertexElementIndex.VertexElements
                    );

                //_ԏԂ { 0, 1, 2,@Ɓ@ 1, 3, 2 } ŁAQ̂Rp`邱ƂɂȂ
                ushort[] Ib  = new ushort[instanseMax * 6];
                for (int i = 0; i < instanseMax; i++)
                {
                    Ib[6 * i + 0] = (ushort)(0 + i * 4);
                    Ib[6 * i + 1] = (ushort)(1 + i * 4);
                    Ib[6 * i + 2] = (ushort)(2 + i * 4);
                    Ib[6 * i + 3] = (ushort)(1 + i * 4);
                    Ib[6 * i + 4] = (ushort)(3 + i * 4);
                    Ib[6 * i + 5] = (ushort)(2 + i * 4);
                }

                indexBuffer = new IndexBuffer(
                    GraphicsDevice,
                   sizeof(ushort) * Ib.Length,
                    BufferUsage.None,
                    IndexElementSize.SixteenBits
                    );

                indexBuffer.SetData<ushort>(Ib);
            }
            catch (Exception e)
            {
                this.Exit();
            }

            #endregion

            //p[eBN
            for (int i = 0; i < PatricleMax; i++)
            {
                particles[i] = new Particle();
                particles[i].Init();
            }
            particleUsing = 0;
            //_̐ݒ
            ushort FixedDrawingWidth = 1280; 
            ushort FixedDrawingHeight = 720;

            graphics.PreferredBackBufferWidth = FixedDrawingWidth;
            graphics.PreferredBackBufferHeight = FixedDrawingHeight;
            //Œ`EBhEۂ̕\ɓĂ͂߂Ă̂Ǝv
            graphics.ApplyChanges();

            aspectRatio = (float)FixedDrawingWidth / (float)FixedDrawingHeight;
            View = Matrix.CreateLookAt(viewPosition, viewingPos, Vector3.Up);
            Projection = Matrix.CreatePerspectiveFieldOfView(MathHelper.Pi / 4, aspectRatio, 10f, 9999f);

            //GtFNg̏
            BillEf.Parameters["View"].SetValue(View);
            BillEf.Parameters["Projection"].SetValue(Projection);
            BillEf.CommitChanges();

            //tHg
            font_14 = Content.Load<SpriteFont>("fontM");
            //tHgwip̍h
            backB = Content.Load<Texture2D>("b");

            fpsCounter.Visible = true;
            timerRuler.Visible = true;
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            // ^C[[Ƀt[Jn`
            timerRuler.StartFrame();

            // XVԁA"Update"̑Jn
            timerRuler.BeginMark("Update", Color.Blue);

            // ^C[[ɍXV\邽߂̋󃋁[v
            stopwatch.Reset();
            stopwatch.Start();
            while (stopwatch.ElapsedMilliseconds < 2)
                ;

            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            // TODO: Add your update logic here

            //L[{[h擾
            if (Keyboard.GetState().IsKeyDown(Keys.Up)) tgtUgingCount += 10;
            if (Keyboard.GetState().IsKeyDown(Keys.Down)) tgtUgingCount -= 10;

            tgtUgingCount += (int)(Vector2.Multiply(GamePad.GetState(PlayerIndex.One).ThumbSticks.Left, 10).Y);

            //p[eBNڕW
            tgtUgingCount = (int)MathHelper.Clamp(tgtUgingCount, 0, PatricleMax);
            
            //p[eBN̍XV
            for (int i = 0; i < particleUsing;)
            {
                if (!particles[i].Update())
                {
                    //鏈Bp[eBNƁAԍŌɗLɂȂĂp[eBN
                    Particle temp = particles[i];
                    particles[i] = particles[--particleUsing];
                    particles[particleUsing] = temp;
                }
                else
                {
                    //܂ȂƔfꂽꍇAi ͉Z
                    i++;
                }
            }

            //p[eBNڕWɓ͂ĂȂAVKɉZ
            int k = tgtUgingCount -particleUsing;
            for (int i = 0; i < k; i++)
            {
                AddingParticle();
            }

            base.Update(gameTime);

            // XVԁA"Update"̑I
            timerRuler.EndMark("Update");
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            // `ԁA"Draw"̑Jn
            timerRuler.BeginMark("Draw", Color.Yellow);

            // TODO: Add your drawing code here

            //ZxŎw
            GraphicsDevice.RenderState.AlphaBlendEnable = true;
            GraphicsDevice.RenderState.SourceBlend = Blend.SourceAlpha;
            GraphicsDevice.RenderState.AlphaSourceBlend = Blend.SourceAlpha;
            GraphicsDevice.RenderState.DestinationBlend = Blend.One;
            GraphicsDevice.RenderState.AlphaDestinationBlend = Blend.One;

            GraphicsDevice.RenderState.DepthBufferWriteEnable = false;


            //_OtBbNfoCXɑ
            GraphicsDevice.Vertices[0].SetSource( MainVertexBuffer,  0, VertexElementIndex.SizeInBytes);
            GraphicsDevice.Indices = indexBuffer;
            GraphicsDevice.VertexDeclaration = BillVD;


            BillEf.Begin();
            BillEf.CurrentTechnique.Passes[0].Begin();

            BillEf.Parameters["MyTexture"].SetValue(AddBilltexture);

            //ꂪAuDrawIndexedPrimitivesvŕ`悷鐔B
            int mxCount = 0;

            //DrawR[
            int DrawCallCount = 0;

            //`惋[vJn
            for (int i = 0; i < particleUsing; i++)
            {
                if (particles[i].ViewFLG)
                {
                    particles[i].GetHLSL_OutMX_Bill(ref OutHlslMX[mxCount]);

                    mxCount++;
                }
                                
                if (mxCount == instanseMax || i == particleUsing - 1)
                {
                    if (mxCount == 0) break;

                    BillEf.Parameters["View"].SetValue(View);
                    //BillEf.Parameters["Projection"].SetValue(Game1.CurrentScreen.MainP_Vals[viewP].camera.Projection);
                    BillEf.Parameters["World"].SetValue(OutHlslMX);
                    BillEf.CommitChanges();

                    GraphicsDevice.DrawIndexedPrimitives(
                                                            PrimitiveType.TriangleList,
                                                            0, 0,
                                                            4 * mxCount,
                                                            0,
                                                            mxCount * 2
                    );

                    DrawCallCount++;

                    mxCount = 0;

                }
            }

            BillEf.CurrentTechnique.Passes[0].End();
            BillEf.End();

            //݂̃p[eBN̕\
            spriteBatch.Begin();
            spriteBatch.Draw(backB, strBackRec, strBackCol);
            spriteBatch.DrawString(font_14, String.Format(DebugStr,particleUsing.ToString(), DrawCallCount.ToString()), strPos, Color.White);
            spriteBatch.End();

            base.Draw(gameTime);

            // `ԁA"Draw"̑I
            timerRuler.EndMark("Draw");

        }

        /// <summary>
        /// p[eBNǉ
        /// </summary>
        public void AddingParticle()
        {
            if (particleUsing < PatricleMax)
            {
                particles[particleUsing].Init();
                particles[particleUsing].ON = true;
                particles[particleUsing].Efe_type = (ushort)cEnBillbdEfeID.bom_1;

                //ʒuȂǂ̃_
                particles[particleUsing].SetPOS(randoms.GetRand(460) - 230.0f, randoms.GetRand(260) - 130.0f, randoms.GetRand(300));

                particles[particleUsing].Siz = 10f + randoms.GetRand100() * 0.05f;
                particles[particleUsing].SizFactor = randoms.GetRand100() * 0.01f;
                particles[particleUsing].TimeFactor_B = 0.1f + randoms.GetRand100() * 0.01f;

                particles[particleUsing].MatType = (byte)(randoms.GetRand((byte)MaterialType.maxvalue));
                particleUsing++;
            }
        }



    }
}
