﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using JF_Particle;


namespace Junk_XNA.Parts
{

    public struct Particle
    {
        private Vector3 tmpV3;

        /// <summary>
        /// 圧縮構造体。
        ///     m11,m12,m13 ...Vect3,XYZ Pos,
        ///     m21,m22,m23 ...Vect3 XYZ Vect,
        ///     m31,m32,m33 ...Vect3 XYZ siz3D,
        ///     m41,m42,m43 ...Vect3 XYZ sizFactor3D,
        ///     m14 ...float power,
        ///     m24 ...float siz,
        ///     m34  ...float sizFactor,
        /// </summary>
        public Matrix PosVectSizAndFact;

        /// <summary>
        /// その他格納値１・
        ///     m11,m12,m13 ...Vect3,XYZ Rol ,
        ///     m14...float movedf,
        ///     m21,m22...float Rol_x, Rol_y,
        ///                                             旧：m31,m32...float LastKakuX,LastKakuY,
        ///     m21,m22,m23 ...Vect3 XYZ OldVect,
        ///     m41,m42...float AdduvPosX,AdduvPosY,
        ///     m23...float movedF,
        ///     m24...float reng,
        ///     m14...float alphaSub,
        ///     m43...float Hitradius
        /// </summary>
        public Matrix RolandETC1;

        //public Vector4 DefColor;

        #region その他変数

        /// <summary>実際に存在するかどうかのフラグ</summary>
        private bool On;
        /// <summary>当たり判定フラグ</summary>
        private bool HitOn;
        /// <summary>表示フラグ</summary>
        private bool ViewFlg;

        /// <summary>時間１</summary>
        private uint TimeA;
        /// <summary>時間２</summary>
        private float TimeB;
        /// <summary>時間２への加算係数</summary>
        private float timeFactor_B;


        /// <summary>エフェクトの種類 </summary>
        private ushort efe_type;
        /// <summary>画像指定ID </summary>
        private ushort imageId;
        /// <summary>画像指定ID(オブジェクトエフェクト用のモデル指定) </summary>
        private ushort imageId2;


        /// <summary>マテリアル種別</summary>
        private byte matType;


        /// <summary>
        /// 配列番号
        /// </summary>
        public ushort indexID;

        /// <summary>地面とのチェックカウンタ</summary>
        public int checkCounter;

        /// <summary>出現時のフレーム数</summary>
        public long FastFrame;

        float f1, f2;

        /// <summary>終末弾道フラグ</summary>
        public bool TerminalFlg;

        #region セッタ

        /// <summary>
        /// HLSLに出力されるMatrix
        /// m11,m12,m13 ...Vect3,XYZ Pos,
        /// m21,m22,m23 ...Vect3 XYZ Rol(別の統合Matrixから取得),
        /// m31,m32,m33 ...Vect3 XYZ siz3D,
        /// m41,m42,m43,m44 ...Vect4 Colors,
        /// m14...AddUVPos_X,
        /// m24...AddUVPos_Y
        /// m34...Siz2D
        /// </summary>
        public void GetHLSL_OutMX( ref Matrix refMx)
        {
            float tgtIndex = 0;
           

            refMx = PosVectSizAndFact;

            refMx.M14 = AdduvPosX;
            refMx.M24 = AdduvPosY;
            refMx.M34 = tgtIndex;

            refMx.M21 = RolandETC1.M11;
            refMx.M22 = RolandETC1.M12;
            refMx.M23 = RolandETC1.M13;


            /*
            if (MatType == (byte)MaterialType.notSet || MatType == (byte)MaterialType.kemuri || MatType == (byte)MaterialType.emb_st1)
            {
                refMx.M41 = Game1.clsMTs.getMaterial(matType).X;
                refMx.M42 = Game1.clsMTs.getMaterial(matType).Y;
                refMx.M43 = Game1.clsMTs.getMaterial(matType).Z;
                refMx.M44 = Game1.clsMTs.getMaterial(matType).W * AlphaSub;
            }
            else
            */
            {
                refMx.M41 = Game1.clsMTs.getMaterial(matType).X * AlphaSub;
                refMx.M42 = Game1.clsMTs.getMaterial(matType).Y * AlphaSub;
                refMx.M43 = Game1.clsMTs.getMaterial(matType).Z * AlphaSub;

                refMx.M44 = 1;
            }
            
        }


        /// <summary>
        /// HLSLに出力されるMatrix　ビルボード用
        /// m11,m12,m13 ...Vect3,XYZ Pos,
        /// m21,m22,m23 ...Vect3 XYZ Rol(別の統合Matrixから取得),
        /// m31,m32,m33 ...Vect3 XYZ siz3D,
        /// m41,m42,m43,m44 ...Vect4 Colors,
        /// m14...AddUVPos_X,
        /// m24...AddUVPos_Y
        /// m34...Siz2D
        /// </summary>
        public void GetHLSL_OutMX_Bill( ref Matrix refMx)
        {

            refMx = PosVectSizAndFact;

            refMx.M14 = AdduvPosX;
            refMx.M24 = AdduvPosY;
            refMx.M34 = PosVectSizAndFact.M24;

            /*
            if (MatType == (byte)MaterialType.notSet || MatType == (byte)MaterialType.kemuri || MatType == (byte)MaterialType.emb_st1)
            {
                refMx.M41 = Game1.clsMTs.getMaterial(matType).X;
                refMx.M42 = Game1.clsMTs.getMaterial(matType).Y;
                refMx.M43 = Game1.clsMTs.getMaterial(matType).Z;
                refMx.M44 = Game1.clsMTs.getMaterial(matType).W * AlphaSub;
            
            else
            */
            {
                refMx.M41 = Game1.clsMTs.getMaterial(matType).X * AlphaSub;
                refMx.M42 = Game1.clsMTs.getMaterial(matType).Y * AlphaSub;
                refMx.M43 = Game1.clsMTs.getMaterial(matType).Z * AlphaSub;

                refMx.M44 = 1;

            }
                      
        }

        /// <summary>
        /// PosにVectを足す
        /// </summary>
        public void AddPosVect()
        {
            //ps.Pos = ps.Pos + ps.VECT;
            PosVectSizAndFact.M11 += PosVectSizAndFact.M21;
            PosVectSizAndFact.M12 += PosVectSizAndFact.M22;
            PosVectSizAndFact.M13 += PosVectSizAndFact.M23;
        }

        public Vector3 POS
        {
            get { //return new Vector3(PosVectSizAndFact.M11,PosVectSizAndFact.M12,PosVectSizAndFact.M13); 
                tmpV3.X = PosVectSizAndFact.M11;
                tmpV3.Y = PosVectSizAndFact.M12;
                tmpV3.Z = PosVectSizAndFact.M13;
                return tmpV3;
            }
            set
            {
                PosVectSizAndFact.M11 = value.X;
                PosVectSizAndFact.M12 = value.Y;
                PosVectSizAndFact.M13 = value.Z;
            }
        }

        public void SetPOS(float fx, float fy, float fz)
        {
            PosVectSizAndFact.M11 = fx;
            PosVectSizAndFact.M12 = fy;
            PosVectSizAndFact.M13 = fz;
        }

        public Vector3 VECT
        {
            get { //return new Vector3(PosVectSizAndFact.M21, PosVectSizAndFact.M22, PosVectSizAndFact.M23); 
                tmpV3.X = PosVectSizAndFact.M21;
                tmpV3.Y = PosVectSizAndFact.M22;
                tmpV3.Z = PosVectSizAndFact.M23;
                return tmpV3;           
            }
            
            set
            {
                PosVectSizAndFact.M21 = value.X;
                PosVectSizAndFact.M22 = value.Y;
                PosVectSizAndFact.M23 = value.Z;
            }
        }

        
        public void SetVECT(float fx, float fy, float fz)
        {
            PosVectSizAndFact.M21 = fx;
            PosVectSizAndFact.M22 = fy;
            PosVectSizAndFact.M23 = fz;
        }
        

        public bool ON
        {
            set { On = value; }
            get { return On; }
        }
        public bool HitON
        {
            set { HitOn = value; }
            get { return HitOn; }
        }
        public bool ViewFLG
        {
            set { ViewFlg = value; }
            get { return ViewFlg; }
        }
        public uint Time_A
        {
            set { TimeA = value; }
            get { return TimeA; }
        }
        public float Time_B
        {
            set { TimeB = value; }
            get { return TimeB; }
        }
        public float TimeFactor_B
        {
            set { timeFactor_B = value; }
            get { return timeFactor_B; }
        }
        public float Siz
        {
            get { return PosVectSizAndFact.M24; }
            set
            {
                PosVectSizAndFact.M24 = value;
            }
        }
        public Vector3 Siz3D
        {
            get { //return new Vector3(PosVectSizAndFact.M31, PosVectSizAndFact.M32, PosVectSizAndFact.M33); 
                tmpV3.X = PosVectSizAndFact.M31;
                tmpV3.Y = PosVectSizAndFact.M32;
                tmpV3.Z = PosVectSizAndFact.M33;
                return tmpV3;
            }
            set
            {
                PosVectSizAndFact.M31 = value.X;
                PosVectSizAndFact.M32 = value.Y;
                PosVectSizAndFact.M33 = value.Z;
            }
        }

        
        public void SetSiz3D(float fx, float fy, float fz)
        {
            PosVectSizAndFact.M31 = fx;
            PosVectSizAndFact.M32 = fy;
            PosVectSizAndFact.M33 = fz;
        }
        
        /// <summary>毎フレームのサイズの加算値。 0ならサイズをキープ</summary>
        public float SizFactor
        {
            get { return PosVectSizAndFact.M34; }
            set
            {
                PosVectSizAndFact.M34 = value;
            }
        }
        /// <summary>毎フレームのサイズの加算値。 0ならサイズをキープ</summary>
        public Vector3 SizFactor3D
        {
            get { //return new Vector3(PosVectSizAndFact.M41, PosVectSizAndFact.M42, PosVectSizAndFact.M43);
                tmpV3.X = PosVectSizAndFact.M41;
                tmpV3.Y = PosVectSizAndFact.M42;
                tmpV3.Z = PosVectSizAndFact.M43;
                return tmpV3;
            }
            set
            {
                PosVectSizAndFact.M41 = value.X;
                PosVectSizAndFact.M42 = value.Y;
                PosVectSizAndFact.M43 = value.Z;
            }

        }

        public void SetSizFactor3D(float fx, float fy, float fz)
        {
            PosVectSizAndFact.M41 = fx;
            PosVectSizAndFact.M42 = fy;
            PosVectSizAndFact.M43 = fz;
        }

        /// <summary>動き強度係数。この数がVectに掛けられ、移動する。0なら移動しない </summary>
        public float Power
        {
            get { return PosVectSizAndFact.M14; }
            set
            {
                PosVectSizAndFact.M14 = value;
            }
        }

        /// <summary>
        /// エフェクトの種類指定
        /// </summary>
        public ushort Efe_type
        {
            get { return efe_type; }
            set { efe_type = value; }
        }
        /// <summary>画像指定ID </summary>
        public ushort Image_ID
        {
            get { return imageId; }
            set { imageId = value; }
        }
        /// <summary>画像指定ID(オブジェクトエフェクト用のモデル指定) </summary>
        public ushort Image_ID2
        {
            get { return imageId2; }
            set { imageId2 = value; }
        }
        public float MovedF
        {
            get { return movedf; }
            set { movedf = value; }
        }

        public byte MatType
        {
            get { return matType; }
            set { matType = value; }
        }
 
        public Vector3 ROL
        {
            get { //return new Vector3(RolandETC1.M11, RolandETC1.M12, RolandETC1.M13);
                tmpV3.X = RolandETC1.M11;
                tmpV3.Y = RolandETC1.M12;
                tmpV3.Z = RolandETC1.M13;
                return tmpV3;
            }
            set
            {
                RolandETC1.M11 = value.X;
                RolandETC1.M12 = value.Y;
                RolandETC1.M13 = value.Z;
            }
        }

        public void SetRol(float rx, float ry, float rz)
        {
            RolandETC1.M11 = rx;
            RolandETC1.M12 = ry;
            RolandETC1.M13 = rz;
        }

        /// <summary>どれだけ移動したか(Bulletで使用）</summary>
        public float movedf
        {
            get { return RolandETC1.M23; }
            set { RolandETC1.M23 = value; }
        }
        /// <summary>透明度に掛けられる数。1=マテリアルの透明度そのまま、0＝非表示</summary>
        public float AlphaSub
        {
            get { return RolandETC1.M14; }
            set { RolandETC1.M14 = value; }
        }
        /// <summary>射程距離（弾丸で使用 </summary>
        public float Reng
        {
            get { return RolandETC1.M24; }
            set { RolandETC1.M24 = value; }
        }
        /// <summary>軸の回転角度X </summary>
        public float RolX
        {
            get { return RolandETC1.M21; }
            set { RolandETC1.M21 = value; }
        }
        /// <summary>軸の回転角度Y </summary>
        public float RolY
        {
            get { return RolandETC1.M22; }
            set { RolandETC1.M22 = value; }
        }
        /// <summary>当たり判定・半径</summary>
        public float HitRadius
        {
            get { return RolandETC1.M43; }
            set { RolandETC1.M43 = value; }
        }
        /*
        /// <summary>最後に適用した角度：X</summary>
        public float LastKakuX
        {
            get { return RolandETC1.M31; }
            set { RolandETC1.M31 = value; }
        }
        /// <summary>最後に適用した角度：Y</summary>
        public float LastKakuY
        {
            get { return RolandETC1.M32; }
            set { RolandETC1.M32 = value; }
        }
        */

        /// <summary>
        /// 変更前の旧ベクトル
        /// </summary>
        public Vector3 OldVect
        {
            get
            {
                tmpV3.X = RolandETC1.M31;
                tmpV3.Y = RolandETC1.M32;
                tmpV3.Z = RolandETC1.M33;
                return tmpV3;
            }
            set { RolandETC1.M31 = value.X; RolandETC1.M32 = value.Y; RolandETC1.M33 = value.Z; }
        }

        /// <summary>UV加算値X</summary>
        public float AdduvPosX
        {
            get { return RolandETC1.M41; }
            set { RolandETC1.M41 = value; }
        }
        /// <summary>UV加算値Y</summary>
        public float AdduvPosY
        {
            get { return RolandETC1.M42; }
            set { RolandETC1.M42 = value; }
        }

        #endregion
        
        #endregion

        /// <summary>
        /// newの代わりに初期化する。指定忘れが多いやつ、特に変動系だけ
        /// </summary>
        public void Init()
        {

            VECT = Vector3.Zero;
            SizFactor = 0;
            SizFactor3D = Vector3.Zero;
            TerminalFlg = false;
            AlphaSub = 1;
            ViewFlg = false;
            On = false;
            Time_A = 0;
            TimeB = 0;
            timeFactor_B = 1;
        }

        /// <summary>
        /// 画像指定、及び消滅判定をしたParticleを返す
        /// </summary>
        /// <param name="efe_ID"></param>
        /// <returns></returns>
        public void SetEfeImgs()
        {
            ViewFlg = true;
            On = true;
            switch (Efe_type)
            {
                #region 炸裂１
                case (ushort)cEnBillbdEfeID.bom_1:
                    AdduvPosY = 0;
                    switch ((int)Time_B)
                    {
                        case 0:
                        case 1:
                        case 2: 
                            AdduvPosX = 0;
                            break;
                        case 3: 
                            AdduvPosX = 0.125f;
                            break;
                        case 4:
                            AdduvPosX = 0.250f;
                            break;
                        case 5: 
                            AdduvPosX = 0.375f;
                            break;
                        case 6: 
                            AdduvPosX = 0.50f;
                            break;
                        case 7: 
                            AdduvPosX = 0.625f;
                            break;
                        case 8: 
                            AdduvPosX = 0.750f;
                            break;
                        case 9: 
                            AdduvPosX = 0.875f;
                            break;

                        default: ON = false; ViewFLG = false; break;
                    }
                    break;
                #endregion

            }

        }

        /// <summary>
        /// パーティクルを更新する。
        /// 時間情報、次に表示するポジションを設定し、
        /// 表示が終わり「消える」判定ならば、On=False になる。
        /// </summary>
        /// <returns></returns>
        public bool Update()
        {
            Time_A++;
            Time_B += TimeFactor_B;
            Siz += SizFactor;
            SetEfeImgs();
            return On;
        }

    }

}