#region Using Xe[gg

using System;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

#endregion

namespace DebugSample
{
    /// <summary>
    /// CAEg̃ACgʒu
    /// </summary>
    [Flags]
    public enum Alignment
    {
        // CAEgȂ
        None = 0,

        // ̃CAEgQ
        // 
        Left = 1,
        // E
        Right = 2,
        // 
        HorizontalCenter = 4,

        // ̃CAEgQ
        // 㑤
        Top = 8,
        // 
        Bottom = 16,
        // 
        VerticalCenter = 32,

        // 
        TopLeft = Top | Left,
        // E
        TopRight = Top | Right,
        // 㑤A
        TopCenter = Top | HorizontalCenter,

        // 
        BottomLeft = Bottom | Left,
        // E
        BottomRight = Bottom | Right,
        // A
        BottomCenter = Bottom | HorizontalCenter,

        // A
        CenterLeft = VerticalCenter | Left,
        // AE
        CenterRight = VerticalCenter | Right,
        // 
        Center = VerticalCenter | HorizontalCenter
    }

    /// <summary>
    /// Z[tGAɑΉCAEg\
    /// </summary>
    /// <remarks>
    /// WindowsAXbox 360̗vbgtH[œ삷Q[͗lXȉ𑜓xA
    /// AXyNgɑΉKvBXbox 360œ삷Q[
    /// ^CgZ[tGAɂΉKvB
    /// 
    /// ̍\̂ł́ACAEgΏۗ̈(NCAgGA)ƁA
    /// Z[tGÄێAligmentƐ̃}[Wl
    /// w肵`zuB
    /// zű`Z[tGAOɂꍇ̓Z[tGAɍĔzuB
    /// 
    /// }[W̓NCAgGÅŎB
    /// 
    /// gp:
    /// 
    /// Place( region, 0.1f, 0.2f, Aligment.TopLeft );
    /// 
    /// NCAgGA̍[10%A[20%̕regionzu
    /// 
    /// 
    /// Place( region, 0.3f, 0.4f, Aligment.BottomRight );
    /// 
    /// NCAgGẢE[30%A[40%̕regionzu
    /// 
    /// 
    /// NCAgGAƃZ[tGAʁXɎwł̂ŁA
    /// ʕɂAZ[tGAɃ^CgZ[tGAw肵A
    /// NCAgGAɕʂ̗̈w肷邱ƂŁACAEg
    /// ʕ̈x[XōsA^CgZ[tGAɐzu邱Ƃ
    /// łB
    /// 
    /// 
    /// Z[tGAɂĂ͈ȉURLQ
    /// http://blogs.msdn.com/ito/archive/2008/11/21/safearea-sample.aspx
    ///     /// </remarks>
    public struct Layout
    {
        #region tB[h

        /// <summary>
        /// NCAgGA̎擾Ɛݒ
        /// </summary>
        public Rectangle ClientArea;

        /// <summary>
        /// Z[tGA̎擾Ɛݒ
        /// </summary>
        public Rectangle SafeArea;

        #endregion

        #region 

        /// <summary>
        /// NCAgGAƃZ[tGAʁXɎw肵ď
        /// </summary>
        /// <param name="client">NCAgGA</param>
        /// <param name="safeArea">Z[tGA</param>
        public Layout( Rectangle clientArea, Rectangle safeArea )
        {
            ClientArea = clientArea;
            SafeArea = safeArea;
        }

        /// <summary>
        /// NCAgGÂ݂w肵ď
        /// Z[tGA̓NCAgGAƓTCYɂȂ
        /// </summary>
        /// <param name="client">NCAgGA</param>
        public Layout( Rectangle clientArea )
            : this( clientArea, clientArea )
        {
        }

        /// <summary>
        /// Viewportw肵ď
        /// Z[tGAViewport.TitleSafeAreaɂȂ
        /// </summary>
        /// <param name="viewport">r[|[g</param>
        public Layout( Viewport viewport )
        {
            ClientArea = new Rectangle( (int)viewport.X, (int)viewport.Y,
                                        (int)viewport.Width, (int)viewport.Height );
            SafeArea = viewport.TitleSafeArea;
        }

        #endregion

        /// <summary>
        /// w肵TCY`̃CAEg
        /// </summary>
        /// <param name="region">zu`</param>
        /// <param name="horizontalMargin">̃}[W</param>
        /// <param name="verticalMargine">̃}[W</param>
        /// <param name="alignment">ACg</param>
        /// <returns>zuꂽ`</returns>
        public Vector2 Place( Vector2 size, float horizontalMargin,
                                            float verticalMargine, Alignment alignment )
        {
            Rectangle rc = new Rectangle( 0, 0, (int)size.X, (int)size.Y );
            rc = Place( rc, horizontalMargin, verticalMargine, alignment );
            return new Vector2( rc.X, rc.Y );
        }

        /// <summary>
        /// w肵`̃CAEg
        /// </summary>
        /// <param name="region">zu`</param>
        /// <param name="horizontalMargin">̃}[W</param>
        /// <param name="verticalMargine">̃}[W</param>
        /// <param name="alignment">ACg</param>
        /// <returns>zuꂽ`</returns>
        public Rectangle Place( Rectangle region, float horizontalMargin,
                                            float verticalMargine, Alignment alignment )
        {
            // ̃CAEg
            if ( ( alignment & Alignment.Left ) != 0 )
            {
                region.X = ClientArea.X + (int)( ClientArea.Width * horizontalMargin );
            }
            else if ( ( alignment & Alignment.Right ) != 0 )
            {
                region.X = ClientArea.X +
                            (int)( ClientArea.Width * ( 1.0f - horizontalMargin ) ) -
                            region.Width;
            }
            else if ( ( alignment & Alignment.HorizontalCenter ) != 0 )
            {
                region.X = ClientArea.X + ( ClientArea.Width - region.Width ) / 2 +
                            (int)( horizontalMargin * ClientArea.Width );
            }
            else
            {
                // CAEgȂ
            }

            // ̃CAEg
            if ( ( alignment & Alignment.Top ) != 0 )
            {
                region.Y = ClientArea.Y + (int)( ClientArea.Height * verticalMargine );
            }
            else if ( ( alignment & Alignment.Bottom ) != 0 )
            {
                region.Y = ClientArea.Y +
                            (int)( ClientArea.Height * ( 1.0f - verticalMargine ) ) -
                            region.Height;
            }
            else if ( ( alignment & Alignment.VerticalCenter ) != 0 )
            {
                region.Y = ClientArea.Y + ( ClientArea.Height - region.Height ) / 2 +
                            (int)( verticalMargine * ClientArea.Height );
            }
            else
            {
                // CAEgȂ
            }

            // CAEg̈Z[tGAɂ邩m߂
            if ( region.Left < SafeArea.Left )
                region.X = SafeArea.Left;

            if ( region.Right > SafeArea.Right )
                region.X = SafeArea.Right - region.Width;

            if ( region.Top < SafeArea.Top )
                region.Y = SafeArea.Top;

            if ( region.Bottom > SafeArea.Bottom )
                region.Y = SafeArea.Bottom - region.Height;

            return region;
        }

    }
}